const simpleInterpolate = (str, variables) => {
    if (!variables || typeof str !== 'string') return str;
    return str.replace(/\{(\w+)\}/g, (match, key) => {
        return variables.hasOwnProperty(key) ? variables[key] : match;
    });
};

// --- English Translations (Default) ---
const en = {
    background: {
        contextMenu: {
            openUrl: 'Open Link in SealSkin',
            openFile: 'Open Link Target as File in SealSkin',
            sendMedia: 'Send Media to SealSkin',
            searchText: 'Search for "%s" in SealSkin',
            sendDownload: 'Send Next Download to SealSkin'
        }
    },
    common: {
        actions: 'Actions',
        active: 'Active',
        cancel: 'Cancel',
        manage: 'Manage',
        delete: 'Delete',
        edit: 'Edit',
        save: 'Save',
        none: 'none',
        error: 'Error',
        na: 'N/A',
        of: 'of',
        status: 'Status',
        username: 'Username',
        group: 'Group',
        groups: 'Groups',
        publicKey: 'Public Key',
        name: 'Name',
        source: 'Source',
        imageVersion: 'Image Version',
        language: 'Language',
        storage: 'Storage',
        gpu: 'GPU',
        version: 'Version',
        checked: 'Checked',
        never: 'Never',
        stop: 'Stop',
        reopen: 'Re-open',
        sendFile: 'Send File',
        share: 'Share',
        search: 'Search',
        refresh: 'Refresh',
        close: 'Close',
        copy: 'Copy',
        open: "Open",
        copyUrl: 'Copy URL',
        download: 'Download',
        next: 'Next',
        previous: 'Previous',
        page: 'Page',
        home: 'Home',
        homes: 'Homes',
        sessions: 'Sessions',
        users: 'Users',
        admins: 'Admins',
        yes: 'Yes',
        no: 'No',
        daysAgo: '{count, plural, one {1 day ago} other {{count} days ago}}',
        hoursAgo: '{count, plural, one {1 hour ago} other {{count} hours ago}}',
        minutesAgo: '{count, plural, one {1 minute ago} other {{count} minutes ago}}',
        justNow: 'just now',
        bytes: 'Bytes',
        kb: 'KB',
        mb: 'MB',
        gb: 'GB',
        tb: 'TB',
        pb: 'PB',
    },
    options: {
        sidebar: {
            config: 'Configuration',
            home: 'Home Directories',
            sessions: 'Active Sessions',
            pinned: 'Pinned Behavior',
            appStore: 'App Store',
            appTemplates: 'App Templates',
            appLaboratory: 'App Laboratory',
            installedApps: 'Installed Apps',
            users: 'Users',
            groups: 'Groups',
            admins: 'Admins',
        },
        dashboard: {
            title: 'Dashboard',
            clientSettings: 'Client Settings',
            exportConfig: 'Export Config',
            userStatus: 'User Status',
            loggedInAs: 'Logged in as:',
            role: 'Role',
            roleAdmin: 'Administrator',
            roleUser: 'Standard User',
            serverInfo: 'Server Info',
            server: 'Server:',
            cpuModel: 'CPU Model:',
            storageUsage: 'Storage Usage:',
            detectedGpus: 'Detected GPUs:',
            logout: 'Logout & Clear Config',
            howTo: 'How to Use SealSkin',
            howToDescription: 'This section contains basic documentation on how to use the extension.',
            howToList: [
                '<strong>To open content in isolation:</strong> Right-click on any link, image, or selected text and choose an option from the "SealSkin Isolation" context menu.',
                '<strong>To send a download to isolation:</strong> Right-click on the page and select "Send Next Download to Isolation". The next file you download will be intercepted and sent to a secure session.',
                '<strong>To launch a clean application:</strong> Click the SealSkin icon in your browser\'s toolbar.',
                '<strong>To manage persistent storage:</strong> Use the "Home Directories" tab on this page to create and delete storage volumes that can be used across multiple sessions.',
                '<strong>To save launch options:</strong> Check the "Save these launch options" box in the popup before launching an application for a specific file type (e.g., .pdf) or for all URLs. Manage these saved preferences in the "Pinned Behavior" tab.'
            ],
            confirmLogout: 'Are you sure you want to logout? This will clear your saved configuration from this browser.',
        },
        config: {
            quickSetup: 'Quick Setup',
            quickSetupDescription: 'Upload the configuration file (.json) provided by your administrator, or paste its contents below to automatically set up the extension.',
            uploadLabel: 'Upload Config File',
            pasteLabel: 'Or Paste Config Text',
            pastePlaceholder: 'Paste your JSON configuration here...',
            applyButton: 'Apply Configuration',
            manualLink: 'Manual Configuration',
            advancedTitle: 'Client Configuration (Advanced)',
            serverIpLabel: 'Server IP or Domain',
            serverIpPlaceholder: 'e.g., 192.168.1.100',
            apiPortLabel: 'API Port',
            apiPortPlaceholder: 'e.g., 8000',
            sessionPortLabel: 'Session Port',
            sessionPortPlaceholder: 'e.g., 8443',
            usernameLabel: 'Username',
            usernamePlaceholder: 'Your username',
            privateKeyLabel: 'Your Private Key (PEM Format)',
            privateKeyPlaceholder: 'Paste your private key content here',
            serverKeyLabel: 'Server Public Key (PEM Format)',
            serverKeyPlaceholder: 'Paste the server_public.pem content here',
            searchEngineLabel: 'Default Search Engine for Selected Text',
            saveButton: 'Save Configuration',
            loginButton: 'Login & Test',
            automaticLink: 'Automatic Configuration',
            chooseFile: 'Choose File',
            keyGeneration: 'Key Generation',
            keyGenDescription: 'If you don\'t have a key pair, you can generate one here. The private key will be filled in above. Provide the public key to your administrator.',
            generateKeyButton: 'Generate New Key Pair',
            publicKeyForAdminLabel: 'Your Public Key (for admin)',
        },
        home: {
            title: 'Your Home Directories',
            description: 'Create persistent storage directories to use across sessions. These will be mounted into your applications as your configuration directory.',
            newTitle: 'Create New Home Directory',
            nameLabel: 'Directory Name:',
            namePlaceholder: 'e.g., my-project-files',
            nameTitle: 'Use only letters, numbers, underscore, or hyphen.',
            createButton: 'Create Directory',
            confirmDelete: 'Are you sure you want to delete the home directory \'{homeName}\'? All data within it will be permanently lost.',
        },
        sessions: {
            title: 'Active Sessions',
            application: 'Application',
            started: 'Started',
            noSessionsUser: 'No active sessions found.',
            noSessionsAdmin: 'No active sessions found for any user.',
            sessionsFor: 'Sessions for {username} ({count})',
            confirmStop: 'Are you sure you want to stop this session? The container will be destroyed.',
        },
        pinned: {
            title: 'Pinned Extension Behavior',
            description: 'This table shows the launch options you have saved for specific file types or for all URLs. You can remove a pinned behavior to be prompted for launch options again.',
            trigger: 'Trigger',
            savedApp: 'Saved Application',
            triggerSimple: 'Simple Launch (Toolbar Button)',
            triggerUrl: 'All URLs (from context menu)',
            triggerFile: 'File Type: <strong>{fileType}</strong>',
            unknownApp: 'Unknown App ({appId}...)'
        },
        admins: {
            serverKeyTitle: 'Server Public Key',
            serverKeyDescription: 'This is the public key that user configuration files will need to connect to this server.',
            title: 'Admin Management',
            searchPlaceholder: 'Search admins...',
            newTitle: 'Create New Admin',
            publicKeyOptionalLabel: 'Public Key (Optional):',
            publicKeyPlaceholder: 'Paste public key here, or leave blank to generate one.',
            createButton: 'Create Admin',
            confirmDelete: 'Are you sure you want to delete admin \'{username}\'? This will also delete all their persistent storage and cannot be undone.',
        },
        users: {
            title: 'User Management',
            searchPlaceholder: 'Search users by name or group...',
            newTitle: 'Create New User',
            publicKeyOptionalLabel: 'Public Key (Optional):',
            publicKeyPlaceholder: 'Paste user\'s public key here, or leave blank to generate one.',
            settingsTitle: 'User Settings',
            sessionLimitLabel: 'Sessions limit',
            sessionLimitTitle: 'Number of active sessions a user can have. -1 for unlimited.',
            permissionsTitle: 'Permissions & Hardening',
            activeAccount: 'Active Account',
            allowStorage: 'Allow Persistent Storage',
            allowGpu: 'Allow GPU Access',
            hardenContainer: 'Harden Container',
            hardenWm: 'Harden Window Manager',
            createButton: 'Create User',
            homesDisabledTooltip: 'Persistent storage disabled for this user',
            confirmDelete: 'Are you sure you want to delete user \'{username}\'? This will also delete all their persistent storage and cannot be undone.',
            allowPublicSharing: 'Allow Public File Sharing',
        },
        groups: {
            title: 'Group Management',
            searchPlaceholder: 'Search groups...',
            newTitle: 'Create New Group',
            nameLabel: 'Group Name:',
            overrideTitle: 'Group Override Settings',
            permissionsTitle: 'Permissions & Hardening Overrides',
            createButton: 'Create Group',
            confirmDelete: 'Are you sure you want to delete group \'{groupName}\'? Users in this group will revert to their individual settings.',
        },
        installedApps: {
            title: 'Installed Applications',
            searchPlaceholder: 'Search installed apps...',
            noAppsFound: 'No installed apps found.',
            pulling: 'Pulling new image...',
            notLocal: 'Image not found locally',
            isLaboratory: 'This is a Laboratory app, built from a base image with custom settings.',
            laboratory: 'Laboratory',
            confirmDelete: 'Are you sure you want to delete the installed app \'{appName}\'?'
        },
        appStore: {
            title: 'App Stores',
            refreshTitle: 'Refresh selected store',
            selectLabel: 'Select App Store',
            addLabel: 'Add New App Store',
            namePlaceholder: 'Store Name',
            urlPlaceholder: 'Store YAML URL',
            availableTitle: 'Available Apps',
            addManual: "Add Manual App",
            searchPlaceholder: 'Search available apps...',
            noAppsFound: 'No applications found.',
            availableFrom: 'Available Apps from {storeName}',
            couldNotLoad: 'Could not load apps from this store.',
        },
        appTemplates: {
            title: 'Application Template Editor',
            loadLabel: 'Load Template',
            createOption: 'Create New Template',
            nameLabel: 'Template Name',
            namePlaceholder: 'Enter a name for the new template',
            saveButton: 'Save Profile',
            deleteButton: 'Delete',
            previewTitle: 'UI Preview',
            contentArea: 'Application Content Area',
            confirmDelete: 'Are you sure you want to delete the template \'{templateName}\'? This action cannot be undone.',
            deleteDisabled: 'This template cannot be deleted.',
            enterName: 'Please enter a name for the new template.',
            settings: {
                TITLE: { label: "Page Title", description: "The page title displayed on the web browser." },
                SELKIES_UI_TITLE: { label: "Sidebar Title", description: "Title in top left corner of sidebar." },
                SELKIES_UI_SHOW_SIDEBAR: { label: "Show Sidebar", description: "Show the main sidebar UI." },
                SELKIES_UI_SHOW_LOGO: { label: "Show Logo", description: "Show the Selkies logo in the sidebar." },
                SELKIES_UI_SHOW_CORE_BUTTONS: { label: "Show Core Buttons", description: "Show the core components buttons (display, audio, etc)." },
                SELKIES_UI_SIDEBAR_SHOW_VIDEO_SETTINGS: { label: "Show Video Settings", description: "Show the video settings section in the sidebar." },
                SELKIES_UI_SIDEBAR_SHOW_SCREEN_SETTINGS: { label: "Show Screen Settings", description: "Show the screen settings section in the sidebar." },
                SELKIES_UI_SIDEBAR_SHOW_AUDIO_SETTINGS: { label: "Show Audio Settings", description: "Show the audio settings section in the sidebar." },
                SELKIES_UI_SIDEBAR_SHOW_STATS: { label: "Show Stats", description: "Show the stats section in the sidebar." },
                SELKIES_UI_SIDEBAR_SHOW_CLIPBOARD: { label: "Show Clipboard", description: "Show the clipboard section in the sidebar." },
                SELKIES_UI_SIDEBAR_SHOW_FILES: { label: "Show Files Section", description: "Show the file transfer section in the sidebar." },
                SELKIES_UI_SIDEBAR_SHOW_APPS: { label: "Show Apps Section", description: "Show the applications section in the sidebar." },
                SELKIES_UI_SIDEBAR_SHOW_SHARING: { label: "Show Sharing Section", description: "Show the sharing section in the sidebar." },
                SELKIES_UI_SIDEBAR_SHOW_GAMEPADS: { label: "Show Gamepads Section", description: "Show the gamepads section in the sidebar." },
                SELKIES_UI_SIDEBAR_SHOW_KEYBOARD_BUTTON: { label: "Show Keyboard Button", description: "Show the on-screen keyboard button." },
                SELKIES_UI_SIDEBAR_SHOW_SOFT_BUTTONS: { label: "Show Soft Buttons", description: "Show the soft buttons section (for mobile)." },
                WATERMARK_PNG: { label: "Watermark PNG Path", description: "Full path inside the container to a watermark png." },
                WATERMARK_LOCATION: { label: "Watermark Location", description: "Where to paint the image over the stream.", options: { disabled: "Disabled", topLeft: "Top-Left", topRight: "Top-Right", bottomLeft: "Bottom-Left", bottomRight: "Bottom-Right", centered: "Centered", animated: "Animated" } },
                DASHBOARD: { label: "Dashboard Style", description: "Allows the user to set their dashboard.", options: { default: "Default", selkiesDefault: "Selkies (Default)", zinc: "Zinc", wish: "Wish" } },
                SELKIES_AUDIO_ENABLED: { label: "Enable Audio", description: "Enable server-to-client audio streaming." },
                SELKIES_MICROPHONE_ENABLED: { label: "Enable Microphone", description: "Enable client-to-server microphone forwarding." },
                SELKIES_GAMEPAD_ENABLED: { label: "Enable Gamepad", description: "Enable gamepad support." },
                SELKIES_CLIPBOARD_ENABLED: { label: "Enable Clipboard", description: "Enable clipboard synchronization." },
                SELKIES_ENABLE_BINARY_CLIPBOARD: { label: "Enable Binary Clipboard", description: "Allow binary data (images) on the clipboard." },
                SELKIES_COMMAND_ENABLED: { label: "Enable Command Websocket", description: "Enable parsing of command websocket messages." },
                SELKIES_FILE_TRANSFERS: { label: "File Transfers", description: "Allowed directions ('upload,download', 'upload', 'download', 'none')." },
                SELKIES_ENABLE_SHARING: { label: "Enable All Sharing", description: "Master toggle for all sharing features." },
                SELKIES_SECOND_SCREEN: { label: "Enable Second Screen", description: "Enable support for a second monitor/display." },
                SELKIES_USE_BROWSER_CURSORS: { label: "Use Browser Cursors", description: "Use browser CSS cursors instead of rendering to canvas." },
                SELKIES_USE_CSS_SCALING: { label: "Use CSS Scaling (LoDPI)", description: "If true, a lower resolution is sent and the canvas is stretched." },
                SELKIES_IS_MANUAL_RESOLUTION_MODE: { label: "Manual Resolution Mode", description: "Lock the resolution to the manual width/height values." },
                SELKIES_MANUAL_WIDTH: { label: "Manual Width", description: "Lock width to a fixed value. Forces manual mode." },
                SELKIES_MANUAL_HEIGHT: { label: "Manual Height", description: "Lock height to a fixed value. Forces manual mode." },
                SELKIES_SCALING_DPI: { label: "UI Scaling DPI", description: "The default DPI for UI scaling." },
                SELKIES_AUDIO_BITRATE: { label: "Audio Bitrate", description: "The default audio bitrate." },
                SELKIES_ENCODER: { label: "Encoders", description: "Comma-separated list of encoders. First is default." },
                SELKIES_USE_CPU: { label: "Force CPU Encoding", description: "Force CPU-based encoding for pixelflux." },
                SELKIES_FRAMERATE: { label: "Framerate (Range or Fixed)", description: "e.g., '8-120' for a range or '60' for fixed." },
                SELKIES_H264_CRF: { label: "H.264 CRF (Range or Fixed)", description: "e.g., '5-50' for a range or '25' for fixed." },
                SELKIES_JPEG_QUALITY: { label: "JPEG Quality (Range or Fixed)", description: "e.g., '1-100' for a range or '60' for fixed." },
                SELKIES_H264_FULLCOLOR: { label: "H.264 Full Color", description: "Enable H.264 full color range for pixelflux encoders." },
                SELKIES_H264_STREAMING_MODE: { label: "H.264 Streaming (Turbo) Mode", description: "Enable H.264 low-latency streaming mode." },
                SELKIES_USE_PAINT_OVER_QUALITY: { label: "Use Paint-Over Quality", description: "Enable high-quality paint-over for static scenes." },
                SELKIES_PAINT_OVER_JPEG_QUALITY: { label: "Paint-Over JPEG Quality", description: "e.g., '1-100' for a range or '90' for fixed." },
                SELKIES_H264_PAINTOVER_CRF: { label: "Paint-Over H.264 CRF", description: "e.g., '5-50' for a range or '18' for fixed." },
                SELKIES_H264_PAINTOVER_BURST_FRAMES: { label: "Paint-Over Burst Frames", description: "e.g., '1-30' for a range or '5' for fixed." },
                HARDEN_DESKTOP: { label: "Harden Desktop (Preset)", description: "Enables DISABLE_OPEN_TOOLS, DISABLE_SUDO, and DISABLE_TERMINALS." },
                HARDEN_OPENBOX: { label: "Harden Window Manager (Preset)", description: "Enables DISABLE_CLOSE_BUTTON, DISABLE_MOUSE_BUTTONS, and HARDEN_KEYBINDS. Also enables RESTART_APP." },
                DISABLE_OPEN_TOOLS: { label: "Disable Open Tools", description: "Disables xdg-open and exo-open binaries." },
                DISABLE_SUDO: { label: "Disable Sudo", description: "Disables the sudo command." },
                DISABLE_TERMINALS: { label: "Disable Terminals", description: "Disables common terminal emulators." },
                DISABLE_CLOSE_BUTTON: { label: "Disable Window Close Button", description: "Removes the close button from window title bars." },
                DISABLE_MOUSE_BUTTONS: { label: "Disable Right/Middle Click", description: "Disables right-click and middle-click context menus." },
                HARDEN_KEYBINDS: { label: "Harden Keybinds", description: "Disables default Openbox keybinds like Alt+F4." },
                RESTART_APP: { label: "Restart App on Close", description: "Automatically restarts the main application if it is closed." },
                MAX_RES: { label: "Maximum Resolution", description: "Max resolution for the container, default is 16k." },
                START_DOCKER: { label: "Start Docker-in-Docker", description: "If false, a privileged container will not start DinD." },
                DISABLE_IPV6: { label: "Disable IPv6", description: "If true, this will disable IPv6." },
                DISABLE_ZINK: { label: "Disable Zink", description: "Do not set Zink env vars if a video card is detected." },
                DISABLE_DRI3: { label: "Disable DRI3", description: "Do not use DRI3 acceleration if a video card is detected." },
                NO_DECOR: { label: "No Window Decorations", description: "Run application without window borders for PWA use." },
                NO_FULL: { label: "No Fullscreen", description: "Do not automatically fullscreen applications." },
                NO_GAMEPAD: { label: "Disable Gamepad Injection", description: "Disable userspace gamepad interposer injection." },
                SELKIES_DEBUG: { label: "Enable Selkies Debugging", description: "Enable debug logging for streaming components." },
            }
        },
        appLaboratory: {
            title: 'App Laboratory',
            description: 'Create and test custom application configurations by layering changes on top of a base app.',
            selectApp: 'Select App',
            createNew: 'Create New App',
            baseApp: 'Base Application',
            baseAppDescription: 'The installed application that your new custom app will be based on.',
            selectBase: 'Select a Base App',
            customizationTitle: 'Customization',
            appName: 'App Name',
            appIcon: 'App Icon',
            uploadIcon: 'Upload Icon',
            autostartScriptLabel: 'Custom Autostart Script',
            permissionsTitle: 'Permissions',
            usersLabel: 'Allowed Users',
            groupsLabel: 'Allowed Groups',
            launchButton: 'Save & Launch Customization Session',
            closeButton: 'Close Session & Finalize',
            savingAndLaunching: 'Saving & Launching...',
            placeholder: 'The App Labratory allows you to configure the base home directory and launch script for an application based on an existing installed application. This home directory will be copied on first init for the user with all files and settings you setup in this session. You can re-launch an existing Labratory App to modify it\'s contents further.',
            formInvalid: 'Please select a base app and provide a name for the new app.',
        },
        modals: {
            editUserTitle: 'Edit User: {username}',
            saveChanges: 'Save Changes',
            effectiveSettings: 'Effective Settings (with group overrides)',
            editGroupTitle: 'Edit Group: {groupName}',
            userConfigTitle: 'User Configuration',
            warning: 'This is the only time this configuration will be shown. Provide it to the user securely.',
            info: 'You can download this configuration file to easily set up SealSkin on another device. Keep this file safe as it contains your private key.',
            configDataLabel: 'Configuration Data (JSON)',
            copyButton: 'Copy Text',
            downloadButton: 'Download File',
            manageHomeDirs: 'Manage Home Directories',
            dirsForUser: 'Directories for user: {username}',
            dirsForAdmin: 'Directories for admin: {username}',
            newDirForUser: 'Create New Directory for User',
            customAutostartScriptLabel: 'Custom Autostart Script',
            customAutostartScriptDescription: 'Customize autostart logic, leave blank to use default from application provider.',
            createDirButton: 'Create Directory',
            confirmDeleteDir: 'Are you sure you want to delete \'{homeName}\' for user \'{username}\'? This is permanent.',
            installAppTitle: 'Install {appName}',
            editAppTitle: 'Edit {appName}',
            customNameLabel: 'Custom Name',
            imageLabel: 'Container Image',
            permissions: 'Permissions',
            allowedUsersLabel: 'Allowed Users (comma-separated, \'all\' for everyone)',
            allowedGroupsLabel: 'Allowed Groups (comma-separated, \'all\' for everyone)',
            features: 'Features',
            gpuSupport: 'GPU Support',
            homeMounting: 'Home Directory Mounting',
            urlSupport: 'URL Opening Support',
            fileSupport: 'File Opening Support',
            autoUpdate: 'Auto Update Image',
            advancedSettings: 'Advanced Settings',
            appTemplateLabel: 'Application Template',
            appTemplateDescription: 'Select a pre-configured template for advanced container launch settings.',
            saveInstallation: 'Save Installation',
            updateStatusTitle: 'Update Status for {appName}',
            checkingUpdates: 'Checking for updates...',
            updateAvailable: 'A new image version is available!',
            yourVersion: 'Your version: {sha}',
            latestAvailable: 'Latest version is available to pull from the registry.',
            pullLatest: 'Pull Latest Image',
            upToDate: 'Your image is up to date.',
            currentVersion: 'Current version: {sha}',
            errorChecking: 'Error checking for updates.',
            pullingLatest: 'Pulling latest image... This may take a moment.',
            pullComplete: 'Pull complete!',
            newVersion: 'New version: {sha}',
            errorPulling: 'Error pulling image.',
            manualInstallNote: "Note: Manually added images should be based on a selkies-baseimage compatible image.",
        },
        status: {
            loggingIn: 'Logging in...',
            configSaved: 'Configuration saved successfully!',
            configApplied: 'Configuration applied! Please Login & Test.',
            configApplyFailed: 'Failed to apply configuration: {error}',
            fileReadError: 'Error reading file.',
            noConfig: 'Please provide a config file or text.',
            loggedInAdmin: 'Logged in as admin: {username}',
            loggedInUser: 'Logged in as standard user: {username}.',
            loginFailed: 'Login failed: {error}',
            adminDataRefreshFailed: 'Failed to refresh admin data: {error}',
            logoutSuccess: 'Logged out and configuration cleared.',
            generateConfigFailed: 'Could not generate config, user details are missing.',
            copySuccess: 'Configuration copied to clipboard!',
            copyFailed: 'Failed to copy text.',
            publicKeyCopied: 'Public key copied!',
            keyCopyFailed: 'Failed to copy key.',
            creatingAdmin: 'Creating admin...',
            adminCreated: 'Admin \'{username}\' created.',
            adminCreateFailed: 'Error creating admin: {error}',
            adminDeleted: 'Admin \'{username}\' deleted successfully.',
            adminDeleteFailed: 'Error deleting admin: {error}',
            creatingUser: 'Creating user...',
            userCreated: 'User \'{username}\' created.',
            userCreateFailed: 'Error creating user: {error}',
            userDeleted: 'User \'{username}\' deleted successfully.',
            userDeleteFailed: 'Error deleting user: {error}',
            userUpdated: 'User \'{username}\' updated successfully.',
            userUpdateFailed: 'Error updating user: {error}',
            creatingGroup: 'Creating group...',
            groupCreated: 'Group \'{groupName}\' created.',
            groupCreateFailed: 'Error creating group: {error}',
            groupDeleted: 'Group \'{groupName}\' deleted successfully.',
            groupDeleteFailed: 'Error deleting group: {error}',
            groupUpdated: 'Group \'{groupName}\' updated successfully.',
            groupUpdateFailed: 'Error updating group: {error}',
            homedirLoadFailed: 'Failed to load home directories: {error}',
            homedirCreateFailed: 'Error creating directory: {error}',
            homedirCreated: 'Home directory \'{homeName}\' created.',
            homedirDeleted: 'Directory \'{homeName}\' deleted.',
            homedirDeleteFailed: 'Error deleting directory: {error}',
            homedirCreatedFor: 'Directory \'{homeName}\' created for {username}.',
            homedirDeletedFor: 'Directory \'{homeName}\' deleted for {username}.',
            sessionsLoadFailed: 'Failed to load sessions: {error}',
            sessionStopError: 'Error stopping session: {error}',
            sessionStopped: 'Session stopped successfully.',
            appDataRefreshFailed: 'Failed to refresh app data: {error}',
            closingSession: 'Committing customization session...',
            sessionClosed: 'Customization session closed.',
            sessionCloseFailed: 'Failed to close customization session: {error}',
            fetchingApps: 'Fetching apps from store...',
            fetchAppsFailed: 'Failed to fetch apps from store: {error}',
            appStoreAddFailed: 'Error adding store: {error}',
            appStoreAdded: 'App store \'{name}\' added.',
            appSaved: 'App \'{name}\' {action} successfully.',
            appSaveActions: {
                updated: 'updated',
                installed: 'installed'
            },
            appSaveFailed: 'Error saving app: {error}',
            appDeleted: 'App \'{name}\' deleted.',
            appDeleteFailed: 'Error deleting app: {error}',
            templateSaved: 'Template \'{name}\' saved successfully.',
            templateSaveFailed: 'Error saving template: {error}',
            templateDeleted: 'Template \'{name}\' deleted successfully.',
            templateDeleteFailed: 'Error deleting template: {error}',
            pinRemoved: 'Pinned behavior removed.',
            keyGenerated: 'New key pair generated.',
            keyGenFailed: 'Key generation failed: {{error}}',
            pendingConfigSaved: 'Pending configuration saved. You can now provide your public key to the administrator.',
            settingsSaved: 'Settings saved.',
            appCreated: 'App \'{name}\' created successfully.',
            launchFailed: 'Launch failed: {error}',
        },
        placeholders: {
            noAdmins: 'No admins found.',
            noUsers: 'No users found.',
            noGroups: 'No groups found.',
            noHomeDirs: 'No home directories found.',
            noSessions: 'No active sessions found.',
            noPinned: 'No pinned behaviors found.',
            errorLoading: 'Error loading directories.',
            noInstalledApps: 'No applications have been installed yet.',
        },
    },
    popup: {
        tabs: {
            launch: 'Launch New',
            sessions: 'Active Sessions',
            manageFiles: 'Manage Files',
            uploadStorage: 'Upload to Storage',
            uploadFiles: 'Upload Files',
            uploadFilesTitle: 'Open dedicated file upload page'
        },
        launchView: {
            searchPlaceholder: 'Search applications...',
            uploadingFile: 'Uploading file...',
            gpuLabel: 'GPU',
            storageLabel: 'Storage',
            languageLabel: 'Language',
            cleanroom: 'Cleanroom (Ephemeral)',
            noGpu: 'None',
            saveOptions: 'Save these launch options',
            saveOptionsForUrl: 'Save options for all URLs',
            saveOptionsForFile: 'Save options for .{extension} files',
            openFile: 'Open file on launch',
            launchButton: 'Launch',
            launchingButton: 'Launching...',
            uploadingButton: 'Uploading...',
            autoHome: 'Auto (per-app persistence)',
            collaborationMode: 'Collaborative Session',
            waylandMode: 'Wayland Mode',
        },
        sessionsView: {
            noSessions: 'No active sessions found.',
        },
        uploadStorageView: {
            selectHome: 'Select Home Directory',
            description: 'This will upload the file <strong>{filename}</strong> directly to your Files storage for future use.',
            descriptionFallback: 'This will upload the file <strong>{filename}</strong> directly to your Files storage for future use.',
            uploadButton: 'Upload File',
            uploadingButton: 'Uploading...',
            preparing: 'Preparing file...',
            uploadingChunk: 'Uploading chunk {current} of {total}...',
            finalizing: 'Finalizing...',
            uploadComplete: 'Upload Complete!',
        },
        status: {
            unconfigured: 'Please configure the extension via the options page.',
            openingServerFile: "Opening server-side file: {filename}",
            openingFile: 'Opening file: {filename}',
            openingUrl: 'Opening URL: {targetUrl}',
            error: 'Error: {message}',
            preparingFile: 'Preparing file...',
            sendingFile: 'Sending file to session...',
            errorSendingFile: 'Error sending file: {message}',
            errorClosingSession: 'Error closing session: {message}',
            preparingSession: 'Preparing isolated session...',
            fetchingData: 'Fetching file data...',
            fetchDataFailed: 'Failed to fetch file data: {statusText}',
            unknownAction: 'Unknown launch action.',
            noAppSelected: 'Please select an application.',
            noAppsAvailable: 'No applications are available for your account.',
            uploadSuccess: 'File uploaded successfully!',
            creatingAutoHome: 'Creating automatic home directory...',
        },
        languages: {
            default: 'Default ({locale})'
        }
    },
    upload: {
        title: 'File Upload',
        description: 'Select a file from your computer to open it in a secure, isolated session.',
        dropzone: {
            title: 'Drag & drop a file here',
            or: 'or',
            button: 'Select File',
        },
        confirm: {
            ready: 'File is ready to be opened securely.',
            button: 'Continue to Launch',
        }
    },
    files: {
        title: 'SealSkin Files',
        header: {
            title: 'Files',
            newFolder: 'New Folder',
            uploadFiles: 'Upload Files',
            uploadFolder: 'Upload Folder'
        },
        sidebar: {
            sharedFiles: 'SealSkin Files',
            publicShares: 'Public Shares'
        },
        shares: {
            title: 'Publicly Shared Files',
            searchPlaceholder: 'Search by filename or ID...'
        },
        table: {
            name: 'Name',
            size: 'Size',
            lastModified: 'Last Modified',
            created: 'Created',
            expires: 'Expires',
            url: 'Public URL',
            passwordProtected: 'Password'
        },
        dropzone: {
            title: 'Drop files to upload'
        },
        pagination: {
            previous: '« Previous',
            next: 'Next »',
            pageOf: 'Page {page} of {totalPages}'
        },
        modals: {
            newFolder: {
                title: 'Create New Folder',
                folderNameLabel: 'Folder Name',
                nameTitle: 'Use only letters, numbers, underscore, hyphen, or period.',
                createButton: 'Create'
            },
            confirmDelete: {
                title: 'Confirm Deletion',
                message: 'Are you sure you want to delete {count, plural, one {1 selected item} other {{count} selected items}}? This action cannot be undone.',
                messageDefault: 'Are you sure you want to delete the selected items? This action cannot be undone.'
            },
            uploadProgress: {
                title: 'Upload Progress',
                doneButton: 'Done'
            },
            share: {
                title: 'Share File',
                sharingFile: 'Sharing file: <strong>{filename}</strong>',
                passwordLabel: 'Password (optional)',
                passwordPlaceholder: 'Leave blank for no password',
                expiryLabel: 'Expires in (hours, optional)',
                expiryPlaceholder: 'e.g., 24 for one day',
                shareButton: 'Create Share Link'
            }
        },
        status: {
            homeDirLoadFailed: 'Failed to load home directories: {error}',
            filesLoadFailed: 'Error loading files: {error}',
            deleteProtectedError: 'Cannot delete protected system folders.',
            deletingItems: 'Deleting {count, plural, one {1 item} other {{count} items}}...',
            deleteSuccess: 'Deletion successful.',
            deleteFailed: 'Deletion failed: {error}',
            preparingUpload: 'Preparing to upload {count, plural, one {1 file} other {{count} files}}...',
            uploadPrepFailed: 'Error during folder upload preparation: {error}',
            notConfigured: 'Error: SealSkin not configured. Please set up in options.',
            folderCreated: 'Folder \'{folderName}\' created.',
            folderCreateFailed: 'Error creating folder: {error}',
            shareCreated: 'Share created successfully! The link has been copied to your clipboard.',
            shareCreateFailed: 'Failed to create share: {error}',
            sharesLoadFailed: 'Failed to load shared files: {error}',
            shareDeleteFailed: 'Failed to delete share: {error}',
            shareDeleted: 'Share successfully deleted.',
            urlCopied: 'Public URL copied to clipboard.'
        },
        placeholders: {
            errorLoading: 'Error loading files.',
            folderEmpty: 'This folder is empty.',
            noHomeDirs: 'No home directories available.',
            noShares: 'You have not shared any files yet.'
        },
        uploadStatus: {
            pending: 'pending',
            initiating: 'Initiating...',
            uploading: 'Uploading...',
            finalizing: 'Finalizing...',
            completed: 'Completed',
            error: 'Error'
        }
    }
};

// --- Spanish Translations ---
const es = {
    background: {
        contextMenu: {
            openUrl: 'Abrir enlace en SealSkin',
            openFile: 'Abrir destino del enlace como archivo en SealSkin',
            sendMedia: 'Enviar medio a SealSkin',
            searchText: 'Buscar "%s" en SealSkin',
            sendDownload: 'Enviar próxima descarga a SealSkin'
        }
    },
    common: {
        actions: 'Acciones',
        active: 'Activo',
        cancel: 'Cancelar',
        manage: 'Gestionar',
        delete: 'Eliminar',
        edit: 'Editar',
        save: 'Guardar',
        none: 'ninguno',
        error: 'Error',
        na: 'N/D',
        of: 'de',
        status: 'Estado',
        username: 'Nombre de usuario',
        group: 'Grupo',
        groups: 'Grupos',
        publicKey: 'Clave Pública',
        name: 'Nombre',
        source: 'Fuente',
        imageVersion: 'Versión de la Imagen',
        language: 'Idioma',
        storage: 'Almacenamiento',
        gpu: 'GPU',
        version: 'Versión',
        checked: 'Verificado',
        never: 'Nunca',
        stop: 'Detener',
        reopen: 'Reabrir',
        sendFile: 'Enviar Archivo',
        share: 'Compartir',
        search: 'Buscar',
        refresh: 'Actualizar',
        close: 'Cerrar',
        copy: 'Copiar',
        open: "Abrir",
        copyUrl: 'Copiar URL',
        download: 'Descargar',
        next: 'Siguiente',
        previous: 'Anterior',
        page: 'Página',
        home: 'Directorio Personal',
        homes: 'Directorios Personales',
        sessions: 'Sesiones',
        users: 'Usuarios',
        admins: 'Administradores',
        yes: 'Sí',
        no: 'No',
        daysAgo: '{count, plural, one {hace 1 día} other {hace {count} días}}',
        hoursAgo: '{count, plural, one {hace 1 hora} other {hace {count} horas}}',
        minutesAgo: '{count, plural, one {hace 1 minuto} other {hace {count} minutos}}',
        justNow: 'ahora mismo',
        bytes: 'Bytes',
        kb: 'KB',
        mb: 'MB',
        gb: 'GB',
        tb: 'TB',
        pb: 'PB',
    },
    options: {
        sidebar: {
            config: 'Configuración',
            home: 'Directorios Personales',
            sessions: 'Sesiones Activas',
            pinned: 'Comportamiento Anclado',
            appStore: 'Tienda de Apps',
            appTemplates: 'Plantillas de Apps',
            appLaboratory: 'Laboratorio de Apps',
            installedApps: 'Apps Instaladas',
            users: 'Usuarios',
            groups: 'Grupos',
            admins: 'Administradores',
        },
        dashboard: {
            title: 'Panel de Control',
            clientSettings: 'Configuración del Cliente',
            exportConfig: 'Exportar Configuración',
            userStatus: 'Estado del Usuario',
            loggedInAs: 'Sesión iniciada como:',
            role: 'Rol',
            roleAdmin: 'Administrador',
            roleUser: 'Usuario Estándar',
            serverInfo: 'Información del Servidor',
            server: 'Servidor:',
            cpuModel: 'Modelo de CPU:',
            storageUsage: 'Uso de Almacenamiento:',
            detectedGpus: 'GPUs Detectadas:',
            logout: 'Cerrar Sesión y Limpiar Config.',
            howTo: 'Cómo Usar SealSkin',
            howToDescription: 'Esta sección contiene documentación básica sobre cómo usar la extensión.',
            howToList: [
                '<strong>Para abrir contenido en aislamiento:</strong> Haga clic derecho en cualquier enlace, imagen o texto seleccionado y elija una opción del menú contextual "Aislamiento SealSkin".',
                '<strong>Para enviar una descarga a aislamiento:</strong> Haga clic derecho en la página y seleccione "Enviar Próxima Descarga a Aislamiento". El siguiente archivo que descargue será interceptado y enviado a una sesión segura.',
                '<strong>Para iniciar una aplicación limpia:</strong> Haga clic en el icono de SealSkin en la barra de herramientas de su navegador.',
                '<strong>Para gestionar el almacenamiento persistente:</strong> Use la pestaña "Directorios Personales" en esta página para crear y eliminar volúmenes de almacenamiento que pueden ser usados en múltiples sesiones.',
                '<strong>Para guardar opciones de inicio:</strong> Marque la casilla "Guardar estas opciones de inicio" en la ventana emergente antes de iniciar una aplicación para un tipo de archivo específico (ej., .pdf) o para todas las URLs. Gestione estas preferencias guardadas en la pestaña "Comportamiento Anclado".'
            ],
            confirmLogout: '¿Está seguro de que quiere cerrar sesión? Esto borrará su configuración guardada de este navegador.',
        },
        config: {
            quickSetup: 'Configuración Rápida',
            quickSetupDescription: 'Suba el archivo de configuración (.json) proporcionado por su administrador, o pegue su contenido a continuación para configurar automáticamente la extensión.',
            uploadLabel: 'Subir Archivo de Config.',
            pasteLabel: 'O Pegar Texto de Config.',
            pastePlaceholder: 'Pegue su configuración JSON aquí...',
            applyButton: 'Aplicar Configuración',
            manualLink: 'Configuración Manual',
            advancedTitle: 'Configuración del Cliente (Avanzado)',
            serverIpLabel: 'IP o Dominio del Servidor',
            serverIpPlaceholder: 'ej., 192.168.1.100',
            apiPortLabel: 'Puerto de la API',
            apiPortPlaceholder: 'ej., 8000',
            sessionPortLabel: 'Puerto de Sesión',
            sessionPortPlaceholder: 'ej., 8443',
            usernameLabel: 'Nombre de usuario',
            usernamePlaceholder: 'Su nombre de usuario',
            privateKeyLabel: 'Su Clave Privada (Formato PEM)',
            privateKeyPlaceholder: 'Pegue el contenido de su clave privada aquí',
            serverKeyLabel: 'Clave Pública del Servidor (Formato PEM)',
            serverKeyPlaceholder: 'Pegue el contenido de server_public.pem aquí',
            searchEngineLabel: 'Motor de Búsqueda por Defecto para Texto Seleccionado',
            saveButton: 'Guardar Configuración',
            loginButton: 'Iniciar Sesión y Probar',
            automaticLink: 'Configuración Automática',
            chooseFile: 'Elegir Archivo',
            keyGeneration: 'Generación de Claves',
            keyGenDescription: 'Si no tiene un par de claves, puede generar uno aquí. La clave privada se completará arriba. Proporcione la clave pública a su administrador.',
            generateKeyButton: 'Generar Nuevo Par de Claves',
            publicKeyForAdminLabel: 'Su Clave Pública (para el admin)',
        },
        home: {
            title: 'Sus Directorios Personales',
            description: 'Cree directorios de almacenamiento persistente para usar entre sesiones. Estos se montarán en sus aplicaciones como su directorio de configuración.',
            newTitle: 'Crear Nuevo Directorio Personal',
            nameLabel: 'Nombre del Directorio:',
            namePlaceholder: 'ej., mis-archivos-de-proyecto',
            nameTitle: 'Use solo letras, números, guion bajo o guion.',
            createButton: 'Crear Directorio',
            isLaboratory: 'Esta es una aplicación de Laboratorio, creada a partir de una imagen base con configuraciones personalizadas.',
            laboratory: 'Laboratorio',
            confirmDelete: '¿Está seguro de que quiere eliminar la app instalada \'{appName}\'?'
        },
        sessions: {
            title: 'Sesiones Activas',
            application: 'Aplicación',
            started: 'Iniciado',
            noSessionsUser: 'No se encontraron sesiones activas.',
            noSessionsAdmin: 'No se encontraron sesiones activas para ningún usuario.',
            sessionsFor: 'Sesiones para {username} ({count})',
            confirmStop: '¿Está seguro de que quiere detener esta sesión? El contenedor será destruido.',
        },
        pinned: {
            title: 'Comportamiento Anclado de la Extensión',
            description: 'Esta tabla muestra las opciones de inicio que ha guardado para tipos de archivo específicos o para todas las URLs. Puede eliminar un comportamiento anclado para que se le vuelvan a solicitar las opciones de inicio.',
            trigger: 'Activador',
            savedApp: 'Aplicación Guardada',
            triggerSimple: 'Inicio Simple (Botón de la Barra)',
            triggerUrl: 'Todas las URLs (desde menú contextual)',
            triggerFile: 'Tipo de Archivo: <strong>{fileType}</strong>',
            unknownApp: 'App Desconocida ({appId}...)'
        },
        admins: {
            serverKeyTitle: 'Clave Pública del Servidor',
            serverKeyDescription: 'Esta es la clave pública que los archivos de configuración de usuario necesitarán para conectarse a este servidor.',
            title: 'Gestión de Administradores',
            searchPlaceholder: 'Buscar administradores...',
            newTitle: 'Crear Nuevo Administrador',
            publicKeyOptionalLabel: 'Clave Pública (Opcional):',
            publicKeyPlaceholder: 'Pegue la clave pública aquí, o déjelo en blanco para generar una.',
            createButton: 'Crear Administrador',
            confirmDelete: '¿Está seguro de que quiere eliminar al administrador \'{username}\'? Esto también eliminará todo su almacenamiento persistente y no se puede deshacer.',
        },
        users: {
            title: 'Gestión de Usuarios',
            searchPlaceholder: 'Buscar usuarios por nombre o grupo...',
            newTitle: 'Crear Nuevo Usuario',
            publicKeyOptionalLabel: 'Clave Pública (Opcional):',
            publicKeyPlaceholder: 'Pegue la clave pública del usuario aquí, o déjelo en blanco para generar una.',
            settingsTitle: 'Configuración de Usuario',
            sessionLimitLabel: 'Límite de Sesiones',
            sessionLimitTitle: 'Número de sesiones activas que un usuario puede tener. -1 para ilimitado.',
            permissionsTitle: 'Permisos y Fortalecimiento',
            activeAccount: 'Cuenta Activa',
            allowStorage: 'Permitir Almacenamiento Persistente',
            allowGpu: 'Permitir Acceso a GPU',
            hardenContainer: 'Fortalecer Contenedor',
            hardenWm: 'Fortalecer Gestor de Ventanas',
            createButton: 'Crear Usuario',
            homesDisabledTooltip: 'Almacenamiento persistente deshabilitado para este usuario',
            confirmDelete: '¿Está seguro de que quiere eliminar al usuario \'{username}\'? Esto también eliminará todo su almacenamiento persistente y no se puede deshacer.',
            allowPublicSharing: 'Permitir compartir archivos públicamente',
        },
        groups: {
            title: 'Gestión de Grupos',
            searchPlaceholder: 'Buscar grupos...',
            newTitle: 'Crear Nuevo Grupo',
            nameLabel: 'Nombre del Grupo:',
            overrideTitle: 'Configuración de Anulación de Grupo',
            permissionsTitle: 'Anulaciones de Permisos y Fortalecimiento',
            createButton: 'Crear Grupo',
            confirmDelete: '¿Está seguro de que quiere eliminar el grupo \'{groupName}\'? Los usuarios en este grupo volverán a su configuración individual.',
        },
        installedApps: {
            title: 'Aplicaciones Instaladas',
            searchPlaceholder: 'Buscar apps instaladas...',
            noAppsFound: 'No se encontraron apps instaladas.',
            pulling: 'Descargando nueva imagen...',
            notLocal: 'Imagen no encontrada localmente',
            confirmDelete: '¿Está seguro de que quiere eliminar la app instalada \'{appName}\'?',
        },
        appStore: {
            title: 'Tiendas de Apps',
            refreshTitle: 'Actualizar tienda seleccionada',
            selectLabel: 'Seleccionar Tienda de Apps',
            addLabel: 'Añadir Nueva Tienda de Apps',
            namePlaceholder: 'Nombre de la Tienda',
            urlPlaceholder: 'URL YAML de la Tienda',
            availableTitle: 'Apps Disponibles',
            addManual: "Añadir App Manual",
            searchPlaceholder: 'Buscar apps disponibles...',
            noAppsFound: 'No se encontraron aplicaciones.',
            availableFrom: 'Apps Disponibles de {storeName}',
            couldNotLoad: 'No se pudieron cargar las apps de esta tienda.',
        },
        appTemplates: {
            title: 'Editor de Plantillas de Aplicación',
            loadLabel: 'Cargar Plantilla',
            createOption: 'Crear Nueva Plantilla',
            nameLabel: 'Nombre de la Plantilla',
            namePlaceholder: 'Ingrese un nombre para la nueva plantilla',
            saveButton: 'Guardar Perfil',
            deleteButton: 'Eliminar',
            previewTitle: 'Vista Previa de la UI',
            contentArea: 'Área de Contenido de la Aplicación',
            confirmDelete: '¿Está seguro de que quiere eliminar la plantilla \'{templateName}\'? Esta acción no se puede deshacer.',
            deleteDisabled: 'Esta plantilla no se puede eliminar.',
            enterName: 'Por favor, ingrese un nombre para la nueva plantilla.',
            settings: {
                TITLE: { label: "Título de la Página", description: "El título de la página que se muestra en el navegador web." },
                SELKIES_UI_TITLE: { label: "Título de la Barra Lateral", description: "Título en la esquina superior izquierda de la barra lateral." },
                SELKIES_UI_SHOW_SIDEBAR: { label: "Mostrar Barra Lateral", description: "Mostrar la interfaz de usuario principal de la barra lateral." },
                SELKIES_UI_SHOW_LOGO: { label: "Mostrar Logo", description: "Mostrar el logo de Selkies en la barra lateral." },
                SELKIES_UI_SHOW_CORE_BUTTONS: { label: "Mostrar Botones Principales", description: "Mostrar los botones de componentes principales (pantalla, audio, etc.)." },
                SELKIES_UI_SIDEBAR_SHOW_VIDEO_SETTINGS: { label: "Mostrar Ajustes de Video", description: "Mostrar la sección de ajustes de video en la barra lateral." },
                SELKIES_UI_SIDEBAR_SHOW_SCREEN_SETTINGS: { label: "Mostrar Ajustes de Pantalla", description: "Mostrar la sección de ajustes de pantalla en la barra lateral." },
                SELKIES_UI_SIDEBAR_SHOW_AUDIO_SETTINGS: { label: "Mostrar Ajustes de Audio", description: "Mostrar la sección de ajustes de audio en la barra lateral." },
                SELKIES_UI_SIDEBAR_SHOW_STATS: { label: "Mostrar Estadísticas", description: "Mostrar la sección de estadísticas en la barra lateral." },
                SELKIES_UI_SIDEBAR_SHOW_CLIPBOARD: { label: "Mostrar Portapapeles", description: "Mostrar la sección del portapapeles en la barra lateral." },
                SELKIES_UI_SIDEBAR_SHOW_FILES: { label: "Mostrar Sección de Archivos", description: "Mostrar la sección de transferencia de archivos en la barra lateral." },
                SELKIES_UI_SIDEBAR_SHOW_APPS: { label: "Mostrar Sección de Apps", description: "Mostrar la sección de aplicaciones en la barra lateral." },
                SELKIES_UI_SIDEBAR_SHOW_SHARING: { label: "Mostrar Sección de Compartir", description: "Mostrar la sección para compartir en la barra lateral." },
                SELKIES_UI_SIDEBAR_SHOW_GAMEPADS: { label: "Mostrar Sección de Gamepads", description: "Mostrar la sección de gamepads en la barra lateral." },
                SELKIES_UI_SIDEBAR_SHOW_KEYBOARD_BUTTON: { label: "Mostrar Botón de Teclado", description: "Mostrar el botón del teclado en pantalla." },
                SELKIES_UI_SIDEBAR_SHOW_SOFT_BUTTONS: { label: "Mostrar Botones Virtuales", description: "Mostrar la sección de botones virtuales (para móviles)." },
                WATERMARK_PNG: { label: "Ruta del PNG de Marca de Agua", description: "Ruta completa dentro del contenedor a un archivo png de marca de agua." },
                WATERMARK_LOCATION: { label: "Ubicación de Marca de Agua", description: "Dónde pintar la imagen sobre la transmisión.", options: { disabled: "Deshabilitado", topLeft: "Arriba-Izquierda", topRight: "Arriba-Derecha", bottomLeft: "Abajo-Izquierda", bottomRight: "Abajo-Derecha", centered: "Centrado", animated: "Animado" } },
                DASHBOARD: { label: "Estilo del Panel", description: "Permite al usuario establecer su panel de control.", options: { default: "Por Defecto", selkiesDefault: "Selkies (Por Defecto)", zinc: "Zinc", wish: "Wish" } },
                SELKIES_AUDIO_ENABLED: { label: "Habilitar Audio", description: "Habilitar la transmisión de audio del servidor al cliente." },
                SELKIES_MICROPHONE_ENABLED: { label: "Habilitar Micrófono", description: "Habilitar el reenvío de micrófono del cliente al servidor." },
                SELKIES_GAMEPAD_ENABLED: { label: "Habilitar Gamepad", description: "Habilitar el soporte para gamepad." },
                SELKIES_CLIPBOARD_ENABLED: { label: "Habilitar Portapapeles", description: "Habilitar la sincronización del portapapeles." },
                SELKIES_ENABLE_BINARY_CLIPBOARD: { label: "Habilitar Portapapeles Binario", description: "Permitir datos binarios (imágenes) en el portapapeles." },
                SELKIES_COMMAND_ENABLED: { label: "Habilitar Websocket de Comandos", description: "Habilitar el análisis de mensajes del websocket de comandos." },
                SELKIES_FILE_TRANSFERS: { label: "Transferencias de Archivos", description: "Direcciones permitidas ('upload,download', 'upload', 'download', 'none')." },
                SELKIES_ENABLE_SHARING: { label: "Habilitar Todo para Compartir", description: "Interruptor maestro para todas las funciones de compartir." },
                SELKIES_SECOND_SCREEN: { label: "Habilitar Segunda Pantalla", description: "Habilitar soporte para un segundo monitor/pantalla." },
                SELKIES_USE_BROWSER_CURSORS: { label: "Usar Cursores del Navegador", description: "Usar cursores CSS del navegador en lugar de renderizar en el lienzo." },
                SELKIES_USE_CSS_SCALING: { label: "Usar Escalado CSS (LoDPI)", description: "Si es verdadero, se envía una resolución más baja y se estira el lienzo." },
                SELKIES_IS_MANUAL_RESOLUTION_MODE: { label: "Modo de Resolución Manual", description: "Bloquear la resolución a los valores de ancho/alto manuales." },
                SELKIES_MANUAL_WIDTH: { label: "Ancho Manual", description: "Bloquear el ancho a un valor fijo. Fuerza el modo manual." },
                SELKIES_MANUAL_HEIGHT: { label: "Alto Manual", description: "Bloquear el alto a un valor fijo. Fuerza el modo manual." },
                SELKIES_SCALING_DPI: { label: "DPI de Escalado de UI", description: "El DPI predeterminado para el escalado de la interfaz de usuario." },
                SELKIES_AUDIO_BITRATE: { label: "Tasa de Bits de Audio", description: "La tasa de bits de audio predeterminada." },
                SELKIES_ENCODER: { label: "Codificadores", description: "Lista de codificadores separados por comas. El primero es el predeterminado." },
                SELKIES_USE_CPU: { label: "Forzar Codificación por CPU", description: "Forzar la codificación basada en CPU para pixelflux." },
                SELKIES_FRAMERATE: { label: "Tasa de Fotogramas (Rango o Fijo)", description: "ej., '8-120' para un rango o '60' para un valor fijo." },
                SELKIES_H264_CRF: { label: "CRF H.264 (Rango o Fijo)", description: "ej., '5-50' para un rango o '25' para un valor fijo." },
                SELKIES_JPEG_QUALITY: { label: "Calidad JPEG (Rango o Fijo)", description: "ej., '1-100' para un rango o '60' para un valor fijo." },
                SELKIES_H264_FULLCOLOR: { label: "Color Completo H.264", description: "Habilitar el rango de color completo de H.264 para codificadores pixelflux." },
                SELKIES_H264_STREAMING_MODE: { label: "Modo Streaming H.264 (Turbo)", description: "Habilitar el modo de transmisión de baja latencia H.264." },
                SELKIES_USE_PAINT_OVER_QUALITY: { label: "Usar Calidad de Repintado", description: "Habilitar el repintado de alta calidad para escenas estáticas." },
                SELKIES_PAINT_OVER_JPEG_QUALITY: { label: "Calidad JPEG de Repintado", description: "ej., '1-100' para un rango o '90' para un valor fijo." },
                SELKIES_H264_PAINTOVER_CRF: { label: "CRF H.264 de Repintado", description: "ej., '5-50' para un rango o '18' para un valor fijo." },
                SELKIES_H264_PAINTOVER_BURST_FRAMES: { label: "Ráfaga de Fotogramas de Repintado", description: "ej., '1-30' para un rango o '5' para un valor fijo." },
                HARDEN_DESKTOP: { label: "Fortalecer Escritorio (Preajuste)", description: "Habilita DISABLE_OPEN_TOOLS, DISABLE_SUDO y DISABLE_TERMINALS." },
                HARDEN_OPENBOX: { label: "Fortalecer Gestor de Ventanas (Preajuste)", description: "Habilita DISABLE_CLOSE_BUTTON, DISABLE_MOUSE_BUTTONS y HARDEN_KEYBINDS. También habilita RESTART_APP." },
                DISABLE_OPEN_TOOLS: { label: "Deshabilitar Herramientas de Apertura", description: "Deshabilita los binarios xdg-open y exo-open." },
                DISABLE_SUDO: { label: "Deshabilitar Sudo", description: "Deshabilita el comando sudo." },
                DISABLE_TERMINALS: { label: "Deshabilitar Terminales", description: "Deshabilita emuladores de terminal comunes." },
                DISABLE_CLOSE_BUTTON: { label: "Deshabilitar Botón de Cierre de Ventana", description: "Elimina el botón de cierre de las barras de título de las ventanas." },
                DISABLE_MOUSE_BUTTONS: { label: "Deshabilitar Clic Derecho/Medio", description: "Deshabilita los menús contextuales de clic derecho y medio." },
                HARDEN_KEYBINDS: { label: "Fortalecer Atajos de Teclado", description: "Deshabilita los atajos de teclado predeterminados de Openbox como Alt+F4." },
                RESTART_APP: { label: "Reiniciar App al Cerrar", description: "Reinicia automáticamente la aplicación principal si se cierra." },
                MAX_RES: { label: "Resolución Máxima", description: "Resolución máxima para el contenedor, el valor predeterminado es 16k." },
                START_DOCKER: { label: "Iniciar Docker-in-Docker", description: "Si es falso, un contenedor privilegiado no iniciará DinD." },
                DISABLE_IPV6: { label: "Deshabilitar IPv6", description: "Si es verdadero, esto deshabilitará IPv6." },
                DISABLE_ZINK: { label: "Deshabilitar Zink", description: "No establecer variables de entorno de Zink si se detecta una tarjeta de video." },
                DISABLE_DRI3: { label: "Deshabilitar DRI3", description: "No usar la aceleración DRI3 si se detecta una tarjeta de video." },
                NO_DECOR: { label: "Sin Decoraciones de Ventana", description: "Ejecutar la aplicación sin bordes de ventana para uso PWA." },
                NO_FULL: { label: "Sin Pantalla Completa", description: "No poner automáticamente las aplicaciones en pantalla completa." },
                NO_GAMEPAD: { label: "Deshabilitar Inyección de Gamepad", description: "Deshabilitar la inyección del interpositor de gamepad en el espacio de usuario." },
                SELKIES_DEBUG: { label: "Habilitar Depuración de Selkies", description: "Habilitar el registro de depuración para los componentes de transmisión." },
            }
        },
        appLaboratory: {
            title: 'Laboratorio de Apps',
            description: 'Cree y pruebe configuraciones de aplicaciones personalizadas superponiendo cambios sobre una aplicación base.',
            selectApp: 'Seleccionar App',
            createNew: 'Crear Nueva App',
            baseApp: 'Aplicación Base',
            baseAppDescription: 'La aplicación instalada en la que se basará su nueva aplicación personalizada.',
            selectBase: 'Seleccionar una App Base',
            customizationTitle: 'Personalización',
            appName: 'Nombre de la App',
            appIcon: 'Icono de la App',
            uploadIcon: 'Subir Icono',
            autostartScriptLabel: 'Script de Autoinicio Personalizado',
            permissionsTitle: 'Permisos',
            usersLabel: 'Usuarios Permitidos',
            groupsLabel: 'Grupos Permitidos',
            launchButton: 'Guardar y Lanzar Sesión de Personalización',
            closeButton: 'Cerrar Sesión y Finalizar',
            savingAndLaunching: 'Guardando y Lanzando...',
            placeholder: 'El Laboratorio de Apps le permite configurar el directorio de inicio base y el script de lanzamiento para una aplicación basada en una aplicación instalada existente. Este directorio de inicio se copiará en la primera inicialización para el usuario con todos los archivos y configuraciones que configure en esta sesión. Puede volver a lanzar una App de Laboratorio existente para modificar su contenido.',
            formInvalid: 'Por favor, seleccione una aplicación base y proporcione un nombre para la nueva aplicación.',
        },
        modals: {
            editUserTitle: 'Editar Usuario: {username}',
            saveChanges: 'Guardar Cambios',
            effectiveSettings: 'Configuración Efectiva (con anulaciones de grupo)',
            editGroupTitle: 'Editar Grupo: {groupName}',
            userConfigTitle: 'Configuración de Usuario',
            warning: 'Esta es la única vez que se mostrará esta configuración. Entréguela al usuario de forma segura.',
            info: 'Puede descargar este archivo de configuración para configurar fácilmente SealSkin en otro dispositivo. Guarde este archivo en un lugar seguro ya que contiene su clave privada.',
            configDataLabel: 'Datos de Configuración (JSON)',
            copyButton: 'Copiar Texto',
            downloadButton: 'Descargar Archivo',
            manageHomeDirs: 'Gestionar Directorios Personales',
            dirsForUser: 'Directorios para el usuario: {username}',
            dirsForAdmin: 'Directorios para el administrador: {username}',
            newDirForUser: 'Crear Nuevo Directorio para Usuario',
            createDirButton: 'Crear Directorio',
            confirmDeleteDir: '¿Está seguro de que quiere eliminar \'{homeName}\' para el usuario \'{username}\'? Esto es permanente.',
            installAppTitle: 'Instalar {appName}',
            editAppTitle: 'Editar {appName}',
            customNameLabel: 'Nombre Personalizado',
            imageLabel: 'Imagen del Contenedor',
            permissions: 'Permisos',
            allowedUsersLabel: 'Usuarios Permitidos (separados por coma, \'all\' para todos)',
            allowedGroupsLabel: 'Grupos Permitidos (separados por coma, \'all\' para todos)',
            features: 'Características',
            gpuSupport: 'Soporte de GPU',
            homeMounting: 'Montaje de Directorio Personal',
            urlSupport: 'Soporte para Abrir URL',
            fileSupport: 'Soporte para Abrir Archivos',
            autoUpdate: 'Actualizar Imagen Automáticamente',
            advancedSettings: 'Configuración Avanzada',
            appTemplateLabel: 'Plantilla de Aplicación',
            appTemplateDescription: 'Seleccione una plantilla preconfigurada para ajustes avanzados de inicio de contenedor.',
            customAutostartScriptLabel: 'Script de Autoinicio Personalizado',
            customAutostartScriptDescription: 'Personalice la lógica de autoinicio, déjelo en blanco para usar el predeterminado del proveedor de la aplicación.',
            saveInstallation: 'Guardar Instalación',
            updateStatusTitle: 'Estado de Actualización para {appName}',
            checkingUpdates: 'Buscando actualizaciones...',
            updateAvailable: '¡Hay una nueva versión de la imagen disponible!',
            yourVersion: 'Su versión: {sha}',
            latestAvailable: 'La última versión está disponible para descargar del registro.',
            pullLatest: 'Descargar Última Imagen',
            upToDate: 'Su imagen está actualizada.',
            currentVersion: 'Versión actual: {sha}',
            errorChecking: 'Error al buscar actualizaciones.',
            pullingLatest: 'Descargando última imagen... Esto puede tardar un momento.',
            pullComplete: '¡Descarga completa!',
            newVersion: 'Nueva versión: {sha}',
            errorPulling: 'Error al descargar la imagen.',
            manualInstallNote: "Nota: Las imágenes añadidas manualmente deben basarse en una imagen compatible con selkies-baseimage.",
        },
        status: {
            loggingIn: 'Iniciando sesión...',
            configSaved: '¡Configuración guardada con éxito!',
            configApplied: '¡Configuración aplicada! Por favor, inicie sesión y pruebe.',
            configApplyFailed: 'Fallo al aplicar la configuración: {error}',
            fileReadError: 'Error al leer el archivo.',
            noConfig: 'Por favor, proporcione un archivo de configuración o texto.',
            loggedInAdmin: 'Sesión iniciada como admin: {username}',
            loggedInUser: 'Sesión iniciada como usuario estándar: {username}.',
            loginFailed: 'Fallo de inicio de sesión: {error}',
            adminDataRefreshFailed: 'Fallo al actualizar datos de admin: {error}',
            closingSession: 'Confirmando sesión de personalización...',
            sessionClosed: 'Sesión de personalización cerrada.',
            sessionCloseFailed: 'Fallo al cerrar la sesión de personalización: {error}',
            logoutSuccess: 'Sesión cerrada y configuración limpiada.',
            generateConfigFailed: 'No se pudo generar la configuración, faltan detalles del usuario.',
            copySuccess: '¡Configuración copiada al portapapeles!',
            copyFailed: 'Fallo al copiar el texto.',
            publicKeyCopied: '¡Clave pública copiada!',
            keyCopyFailed: 'Fallo al copiar la clave.',
            creatingAdmin: 'Creando administrador...',
            adminCreated: 'Administrador \'{username}\' creado.',
            adminCreateFailed: 'Error al crear administrador: {error}',
            adminDeleted: 'Administrador \'{username}\' eliminado con éxito.',
            adminDeleteFailed: 'Error al eliminar administrador: {error}',
            creatingUser: 'Creando usuario...',
            userCreated: 'Usuario \'{username}\' creado.',
            userCreateFailed: 'Error al crear usuario: {error}',
            userDeleted: 'Usuario \'{username}\' eliminado con éxito.',
            userDeleteFailed: 'Error al eliminar usuario: {error}',
            userUpdated: 'Usuario \'{username}\' actualizado con éxito.',
            userUpdateFailed: 'Error al actualizar usuario: {error}',
            creatingGroup: 'Creando grupo...',
            groupCreated: 'Grupo \'{groupName}\' creado.',
            groupCreateFailed: 'Error al crear grupo: {error}',
            groupDeleted: 'Grupo \'{groupName}\' eliminado con éxito.',
            groupDeleteFailed: 'Error al eliminar grupo: {error}',
            groupUpdated: 'Grupo \'{groupName}\' actualizado con éxito.',
            groupUpdateFailed: 'Error al actualizar grupo: {error}',
            homedirLoadFailed: 'Fallo al cargar directorios personales: {error}',
            homedirCreateFailed: 'Error al crear el directorio: {error}',
            homedirCreated: 'Directorio personal \'{homeName}\' creado.',
            homedirDeleted: 'Directorio \'{homeName}\' eliminado.',
            homedirDeleteFailed: 'Error al eliminar el directorio: {error}',
            homedirCreatedFor: 'Directorio \'{homeName}\' creado para {username}.',
            homedirDeletedFor: 'Directorio \'{homeName}\' eliminado para {username}.',
            sessionsLoadFailed: 'Fallo al cargar sesiones: {error}',
            sessionStopError: 'Error al detener la sesión: {error}',
            sessionStopped: 'Sesión detenida con éxito.',
            appDataRefreshFailed: 'Fallo al actualizar datos de la app: {error}',
            fetchingApps: 'Obteniendo apps de la tienda...',
            fetchAppsFailed: 'Fallo al obtener apps de la tienda: {error}',
            appStoreAddFailed: 'Error al añadir la tienda: {error}',
            appStoreAdded: 'Tienda de apps \'{name}\' añadida.',
            appSaved: 'App \'{name}\' {action} con éxito.',
            appSaveActions: {
                updated: 'actualizada',
                installed: 'instalada'
            },
            appSaveFailed: 'Error al guardar la app: {error}',
            appDeleted: 'App \'{name}\' eliminada.',
            appDeleteFailed: 'Error al eliminar la app: {error}',
            templateSaved: 'Plantilla \'{name}\' guardada con éxito.',
            templateSaveFailed: 'Error al guardar la plantilla: {error}',
            templateDeleted: 'Plantilla \'{name}\' eliminada con éxito.',
            templateDeleteFailed: 'Error al eliminar la plantilla: {error}',
            pinRemoved: 'Comportamiento anclado eliminado.',
            keyGenerated: 'Nuevo par de claves generado.',
            keyGenFailed: 'Falló la generación de claves: {{error}}',
            pendingConfigSaved: 'Configuración pendiente guardada. Ahora puede proporcionar su clave pública al administrador.',
            settingsSaved: 'Configuración guardada.',
            appCreated: 'App \'{name}\' creada con éxito.',
            launchFailed: 'Lanzamiento fallido: {error}',
        },
        placeholders: {
            noAdmins: 'No se encontraron administradores.',
            noUsers: 'No se encontraron usuarios.',
            noGroups: 'No se encontraron grupos.',
            noHomeDirs: 'No se encontraron directorios personales.',
            noSessions: 'No se encontraron sesiones activas.',
            noPinned: 'No se encontraron comportamientos anclados.',
            errorLoading: 'Error al cargar los directorios.',
            noInstalledApps: 'Aún no se han instalado aplicaciones.',
        },
    },
    popup: {
        tabs: {
            launch: 'Iniciar Nuevo',
            sessions: 'Sesiones Activas',
            manageFiles: 'Gestionar Archivos',
            uploadStorage: 'Subir a Almacenamiento',
            uploadFiles: 'Subir Archivos',
            uploadFilesTitle: 'Abrir página dedicada para subir archivos'
        },
        launchView: {
            searchPlaceholder: 'Buscar aplicaciones...',
            uploadingFile: 'Subiendo archivo...',
            gpuLabel: 'GPU',
            storageLabel: 'Almacenamiento',
            languageLabel: 'Idioma',
            cleanroom: 'Sala Limpia (Efímero)',
            noGpu: 'Ninguno',
            saveOptions: 'Guardar estas opciones de inicio',
            saveOptionsForUrl: 'Guardar opciones para todas las URLs',
            saveOptionsForFile: 'Guardar opciones para archivos .{extension}',
            openFile: 'Abrir archivo al iniciar',
            launchButton: 'Iniciar',
            launchingButton: 'Iniciando...',
            uploadingButton: 'Subiendo...',
            autoHome: 'Automático (persistencia por aplicación)',
            collaborationMode: 'Sesión colaborativa',
            waylandMode: 'Modo Wayland',
        },
        sessionsView: {
            noSessions: 'No se encontraron sesiones activas.',
        },
        uploadStorageView: {
            selectHome: 'Seleccionar Directorio Personal',
            description: 'Esto subirá el archivo <strong>{filename}</strong> directamente a tu almacenamiento de Archivos para uso futuro.',
            descriptionFallback: 'Esto subirá el archivo <strong>{filename}</strong> directamente a tu almacenamiento de Archivos para uso futuro.',
            uploadButton: 'Subir Archivo',
            uploadingButton: 'Subiendo...',
            preparing: 'Preparando archivo...',
            uploadingChunk: 'Subiendo parte {current} de {total}...',
            finalizing: 'Finalizando...',
            uploadComplete: '¡Subida Completa!',
        },
        status: {
            unconfigured: 'Por favor, configure la extensión a través de la página de opciones.',
            openingServerFile: "Abriendo archivo del servidor: {filename}",
            openingFile: 'Abriendo archivo: {filename}',
            openingUrl: 'Abriendo URL: {targetUrl}',
            error: 'Error: {message}',
            preparingFile: 'Preparando archivo...',
            sendingFile: 'Enviando archivo a la sesión...',
            errorSendingFile: 'Error al enviar archivo: {message}',
            errorClosingSession: 'Error al cerrar sesión: {message}',
            preparingSession: 'Preparando sesión aislada...',
            fetchingData: 'Obteniendo datos del archivo...',
            fetchDataFailed: 'Fallo al obtener datos del archivo: {statusText}',
            unknownAction: 'Acción de inicio desconocida.',
            noAppSelected: 'Por favor, seleccione una aplicación.',
            noAppsAvailable: 'No hay aplicaciones disponibles para su cuenta.',
            uploadSuccess: '¡Archivo subido con éxito!',
            creatingAutoHome: 'Creando directorio personal automático...',
        },
        languages: {
            default: 'Por defecto ({locale})'
        }
    },
    upload: {
        title: 'Subida de Archivo',
        description: 'Seleccione un archivo de su computadora para abrirlo en una sesión segura y aislada.',
        dropzone: {
            title: 'Arrastre y suelte un archivo aquí',
            or: 'o',
            button: 'Seleccionar Archivo',
        },
        confirm: {
            ready: 'El archivo está listo para ser abierto de forma segura.',
            button: 'Continuar para Iniciar',
        }
    },
    files: {
        title: 'Archivos de SealSkin',
        header: {
            title: 'Archivos',
            newFolder: 'Nueva Carpeta',
            uploadFiles: 'Subir Archivos',
            uploadFolder: 'Subir Carpeta'
        },
        sidebar: {
            sharedFiles: 'Archivos de SealSkin',
            publicShares: 'Recursos Compartidos Públicos'
        },
        shares: {
            title: 'Archivos Compartidos Públicamente',
            searchPlaceholder: 'Buscar por nombre de archivo o ID...'
        },
        table: {
            name: 'Nombre',
            size: 'Tamaño',
            lastModified: 'Última Modificación',
            created: 'Creado',
            expires: 'Expira',
            url: 'URL Pública',
            passwordProtected: 'Contraseña'
        },
        dropzone: {
            title: 'Suelta los archivos para subirlos'
        },
        pagination: {
            previous: '« Anterior',
            next: 'Siguiente »',
            pageOf: 'Página {page} de {totalPages}'
        },
        modals: {
            newFolder: {
                title: 'Crear Nueva Carpeta',
                folderNameLabel: 'Nombre de la Carpeta',
                nameTitle: 'Usa solo letras, números, guion bajo, guion o punto.',
                createButton: 'Crear'
            },
            confirmDelete: {
                title: 'Confirmar Eliminación',
                message: '¿Estás seguro de que quieres eliminar {count, plural, one {1 elemento seleccionado} other {{count} elementos seleccionados}}? Esta acción no se puede deshacer.',
                messageDefault: '¿Estás seguro de que quieres eliminar los elementos seleccionados? Esta acción no se puede deshacer.'
            },
            uploadProgress: {
                title: 'Progreso de la Subida',
                doneButton: 'Hecho'
            },
            share: {
                title: 'Compartir Archivo',
                sharingFile: 'Compartiendo archivo: <strong>{filename}</strong>',
                passwordLabel: 'Contraseña (opcional)',
                passwordPlaceholder: 'Dejar en blanco para no usar contraseña',
                expiryLabel: 'Expira en (horas, opcional)',
                expiryPlaceholder: 'ej., 24 para un día',
                shareButton: 'Crear Enlace para Compartir'
            }
        },
        status: {
            homeDirLoadFailed: 'Error al cargar los directorios de inicio: {error}',
            filesLoadFailed: 'Error al cargar los archivos: {error}',
            deleteProtectedError: 'No se pueden eliminar las carpetas protegidas del sistema.',
            deletingItems: 'Eliminando {count, plural, one {1 elemento} other {{count} elementos}}...',
            deleteSuccess: 'Eliminación exitosa.',
            deleteFailed: 'Error en la eliminación: {error}',
            preparingUpload: 'Preparando para subir {count, plural, one {1 archivo} other {{count} archivos}}...',
            uploadPrepFailed: 'Error durante la preparación de la subida de la carpeta: {error}',
            notConfigured: 'Error: SealSkin no está configurado. Por favor, configúralo en las opciones.',
            folderCreated: 'Carpeta \'{folderName}\' creada.',
            folderCreateFailed: 'Error al crear la carpeta: {error}',
            shareCreated: '¡Enlace creado con éxito! El enlace ha sido copiado a su portapapeles.',
            shareCreateFailed: 'Error al crear el enlace: {error}',
            sharesLoadFailed: 'Error al cargar los archivos compartidos: {error}',
            shareDeleteFailed: 'Error al eliminar el enlace: {error}',
            shareDeleted: 'Enlace eliminado con éxito.',
            urlCopied: 'URL pública copiada al portapapeles.'
        },
        placeholders: {
            errorLoading: 'Error al cargar los archivos.',
            folderEmpty: 'Esta carpeta está vacía.',
            noHomeDirs: 'No hay directorios de inicio disponibles.',
            noShares: 'Aún no has compartido ningún archivo.'
        },
        uploadStatus: {
            pending: 'pendiente',
            initiating: 'Iniciando...',
            uploading: 'Subiendo...',
            finalizing: 'Finalizando...',
            completed: 'Completado',
            error: 'Error'
        }
    }
};

// --- Chinese Translations ---
const zh = {
    background: {
        contextMenu: {
            openUrl: '在 SealSkin 中打开链接',
            openFile: '在 SealSkin 中以文件形式打开链接目标',
            sendMedia: '发送媒体到 SealSkin',
            searchText: '在 SealSkin 中搜索“{selection}”',
            sendDownload: '将下一次下载发送到 SealSkin'
        }
    },
    common: {
        actions: '操作',
        active: '启用',
        cancel: '取消',
        manage: '管理',
        delete: '删除',
        edit: '编辑',
        save: '保存',
        none: '无',
        error: '错误',
        na: '不适用',
        of: '之',
        status: '状态',
        username: '用户名',
        group: '群组',
        groups: '群组',
        publicKey: '公钥',
        name: '名称',
        source: '来源',
        imageVersion: '镜像版本',
        language: '语言',
        storage: '存储',
        gpu: 'GPU',
        version: '版本',
        checked: '已选中',
        never: '永不',
        stop: '停止',
        reopen: '重新打开',
        sendFile: '发送文件',
        share: '分享',
        search: '搜索',
        refresh: '刷新',
        close: '关闭',
        copy: '复制',
        open: "打开",
        copyUrl: '复制URL',
        download: '下载',
        next: '下一页',
        previous: '上一页',
        page: '页码',
        home: '主目录',
        homes: '主目录',
        sessions: '会话',
        users: '用户',
        admins: '管理员',
        yes: '是',
        no: '否',
        daysAgo: '{count}天前',
        hoursAgo: '{count}小时前',
        minutesAgo: '{count}分钟前',
        justNow: '刚刚',
        bytes: '字节',
        kb: 'KB',
        mb: 'MB',
        gb: 'GB',
        tb: 'TB',
        pb: 'PB',
    },
    options: {
        sidebar: {
            config: '配置',
            home: '主目录',
            sessions: '活跃会话',
            pinned: '固定行为',
            appStore: '应用商店',
            appTemplates: '应用模板',
            appLaboratory: '应用实验室',
            installedApps: '已安装应用',
            users: '用户',
            groups: '群组',
            admins: '管理员',
        },
        dashboard: {
            title: '仪表盘',
            clientSettings: '客户端设置',
            exportConfig: '导出配置',
            userStatus: '用户状态',
            loggedInAs: '登录为:',
            role: '角色',
            roleAdmin: '管理员',
            roleUser: '标准用户',
            serverInfo: '服务器信息',
            server: '服务器:',
            cpuModel: 'CPU型号:',
            storageUsage: '存储使用情况:',
            detectedGpus: '检测到的GPU:',
            logout: '登出并清除配置',
            howTo: '如何使用SealSkin',
            howToDescription: '本节包含有关如何使用此扩展程序的基本文档。',
            howToList: [
                '<strong>在隔离环境中打开内容:</strong> 右键单击任何链接、图片或选定的文本，然后从“SealSkin隔离”上下文菜单中选择一个选项。',
                '<strong>将下载发送到隔离环境:</strong> 在页面上右键单击并选择“将下一次下载发送到隔离环境”。您下载的下一个文件将被拦截并发送到一个安全的会话中。',
                '<strong>启动一个干净的应用程序:</strong> 单击浏览器工具栏中的SealSkin图标。',
                '<strong>管理持久性存储:</strong> 使用此页面上的“主目录”选项卡创建和删除可在多个会话中使用的存储卷。',
                '<strong>保存启动选项:</strong> 在启动应用程序之前，在弹出窗口中勾选“保存这些启动选项”框，可为特定文件类型（例如.pdf）或所有URL保存设置。在“固定行为”选项卡中管理这些已保存的首选项。'
            ],
            confirmLogout: '您确定要登出吗？这将清除此浏览器中保存的配置。',
        },
        config: {
            quickSetup: '快速设置',
            quickSetupDescription: '上传您的管理员提供的配置文件（.json），或在下方粘贴其内容以自动设置扩展程序。',
            uploadLabel: '上传配置文件',
            pasteLabel: '或粘贴配置文本',
            pastePlaceholder: '在此处粘贴您的JSON配置...',
            applyButton: '应用配置',
            manualLink: '手动配置',
            advancedTitle: '客户端配置（高级）',
            serverIpLabel: '服务器IP或域名',
            serverIpPlaceholder: '例如, 192.168.1.100',
            apiPortLabel: 'API端口',
            apiPortPlaceholder: '例如, 8000',
            sessionPortLabel: '会话端口',
            sessionPortPlaceholder: '例如, 8443',
            usernameLabel: '用户名',
            usernamePlaceholder: '您的用户名',
            privateKeyLabel: '您的私钥（PEM格式）',
            privateKeyPlaceholder: '在此处粘贴您的私钥内容',
            serverKeyLabel: '服务器公钥（PEM格式）',
            serverKeyPlaceholder: '在此处粘贴server_public.pem的内容',
            searchEngineLabel: '选定文本的默认搜索引擎',
            saveButton: '保存配置',
            loginButton: '登录并测试',
            automaticLink: '自动配置',
            chooseFile: '选择文件',
            keyGeneration: '密钥生成',
            keyGenDescription: '如果您没有密钥对，可以在此处生成一个。私钥将自动填写在上方。请将公钥提供给您的管理员。',
            generateKeyButton: '生成新密钥对',
            publicKeyForAdminLabel: '您的公钥（提供给管理员）',
        },
        home: {
            title: '您的主目录',
            description: '创建持久性存储目录以在会话之间使用。这些目录将作为您的配置目录挂载到您的应用程序中。',
            newTitle: '创建新的主目录',
            nameLabel: '目录名称:',
            namePlaceholder: '例如, my-project-files',
            nameTitle: '只能使用字母、数字、下划线或连字符。',
            createButton: '创建目录',
            isLaboratory: '这是一个实验室应用，基于基础镜像和自定义设置构建。',
            laboratory: '实验室',
            confirmDelete: '您确定要删除已安装的应用“{appName}”吗？'
        },
        sessions: {
            title: '活跃会话',
            application: '应用程序',
            started: '开始时间',
            noSessionsUser: '未找到活跃会话。',
            noSessionsAdmin: '未找到任何用户的活跃会话。',
            sessionsFor: '用户 {username} 的会话 ({count})',
            confirmStop: '您确定要停止此会话吗？容器将被销毁。',
        },
        pinned: {
            title: '固定的扩展行为',
            description: '此表显示了您为特定文件类型或所有URL保存的启动选项。您可以删除一个固定行为，以便再次提示您选择启动选项。',
            trigger: '触发器',
            savedApp: '已保存的应用',
            triggerSimple: '简单启动（工具栏按钮）',
            triggerUrl: '所有URL（来自上下文菜单）',
            triggerFile: '文件类型: <strong>{fileType}</strong>',
            unknownApp: '未知应用 ({appId}...)'
        },
        admins: {
            serverKeyTitle: '服务器公钥',
            serverKeyDescription: '这是用户配置文件连接到此服务器所需的公钥。',
            title: '管理员管理',
            searchPlaceholder: '搜索管理员...',
            newTitle: '创建新管理员',
            publicKeyOptionalLabel: '公钥（可选）:',
            publicKeyPlaceholder: '在此处粘贴公钥，或留空以生成一个。',
            createButton: '创建管理员',
            confirmDelete: '您确定要删除管理员“{username}”吗？此操作还将删除其所有持久性存储，且无法撤销。',
        },
        users: {
            title: '用户管理',
            searchPlaceholder: '按名称或群组搜索用户...',
            newTitle: '创建新用户',
            publicKeyOptionalLabel: '公钥（可选）:',
            publicKeyPlaceholder: '在此处粘贴用户的公钥，或留空以生成一个。',
            settingsTitle: '用户设置',
            sessionLimitLabel: '会话限制',
            sessionLimitTitle: '用户可以拥有的活跃会话数。-1表示无限制。',
            permissionsTitle: '权限与安全加固',
            activeAccount: '启用账户',
            allowStorage: '允许持久性存储',
            allowGpu: '允许GPU访问',
            hardenContainer: '加固容器',
            hardenWm: '加固窗口管理器',
            createButton: '创建用户',
            homesDisabledTooltip: '此用户的持久性存储已禁用',
            confirmDelete: '您确定要删除用户“{username}”吗？此操作还将删除其所有持久性存储，且无法撤销。',
            allowPublicSharing: '允许公开文件共享',
        },
        groups: {
            title: '群组管理',
            searchPlaceholder: '搜索群组...',
            newTitle: '创建新群组',
            nameLabel: '群组名称:',
            overrideTitle: '群组覆盖设置',
            permissionsTitle: '权限与安全加固覆盖',
            createButton: '创建群组',
            confirmDelete: '您确定要删除群组“{groupName}”吗？此群组中的用户将恢复其个人设置。',
        },
        installedApps: {
            title: '已安装应用',
            searchPlaceholder: '搜索已安装的应用...',
            noAppsFound: '未找到已安装的应用。',
            pulling: '正在拉取新镜像...',
            notLocal: '本地未找到镜像',
            confirmDelete: '您确定要删除已安装的应用“{appName}”吗？',
        },
        appStore: {
            title: '应用商店',
            refreshTitle: '刷新所选商店',
            selectLabel: '选择应用商店',
            addLabel: '添加新应用商店',
            namePlaceholder: '商店名称',
            urlPlaceholder: '商店YAML URL',
            availableTitle: '可用应用',
            addManual: "手动添加应用",
            searchPlaceholder: '搜索可用应用...',
            noAppsFound: '未找到应用程序。',
            availableFrom: '来自 {storeName} 的可用应用',
            couldNotLoad: '无法从此商店加载应用。',
        },
        appTemplates: {
            title: '应用程序模板编辑器',
            loadLabel: '加载模板',
            createOption: '创建新模板',
            nameLabel: '模板名称',
            namePlaceholder: '为新模板输入一个名称',
            saveButton: '保存配置文件',
            deleteButton: '删除',
            previewTitle: 'UI预览',
            contentArea: '应用程序内容区域',
            confirmDelete: '您确定要删除模板“{templateName}”吗？此操作无法撤销。',
            deleteDisabled: '此模板无法删除。',
            enterName: '请输入新模板的名称。',
            settings: {
                TITLE: { label: "页面标题", description: "Web浏览器上显示的页面标题。" },
                SELKIES_UI_TITLE: { label: "侧边栏标题", description: "侧边栏左上角的标题。" },
                SELKIES_UI_SHOW_SIDEBAR: { label: "显示侧边栏", description: "显示主侧边栏UI。" },
                SELKIES_UI_SHOW_LOGO: { label: "显示Logo", description: "在侧边栏中显示Selkies Logo。" },
                SELKIES_UI_SHOW_CORE_BUTTONS: { label: "显示核心按钮", description: "显示核心组件按钮（显示、音频等）。" },
                SELKIES_UI_SIDEBAR_SHOW_VIDEO_SETTINGS: { label: "显示视频设置", description: "在侧边栏中显示视频设置部分。" },
                SELKIES_UI_SIDEBAR_SHOW_SCREEN_SETTINGS: { label: "显示屏幕设置", description: "在侧边栏中显示屏幕设置部分。" },
                SELKIES_UI_SIDEBAR_SHOW_AUDIO_SETTINGS: { label: "显示音频设置", description: "在侧边栏中显示音频设置部分。" },
                SELKIES_UI_SIDEBAR_SHOW_STATS: { label: "显示统计信息", description: "在侧边栏中显示统计信息部分。" },
                SELKIES_UI_SIDEBAR_SHOW_CLIPBOARD: { label: "显示剪贴板", description: "在侧边栏中显示剪贴板部分。" },
                SELKIES_UI_SIDEBAR_SHOW_FILES: { label: "显示文件部分", description: "在侧边栏中显示文件传输部分。" },
                SELKIES_UI_SIDEBAR_SHOW_APPS: { label: "显示应用部分", description: "在侧边栏中显示应用程序部分。" },
                SELKIES_UI_SIDEBAR_SHOW_SHARING: { label: "显示共享部分", description: "在侧边栏中显示共享部分。" },
                SELKIES_UI_SIDEBAR_SHOW_GAMEPADS: { label: "显示游戏手柄部分", description: "在侧边栏中显示游戏手柄部分。" },
                SELKIES_UI_SIDEBAR_SHOW_KEYBOARD_BUTTON: { label: "显示键盘按钮", description: "显示屏幕键盘按钮。" },
                SELKIES_UI_SIDEBAR_SHOW_SOFT_BUTTONS: { label: "显示软按钮", description: "显示软按钮部分（用于移动设备）。" },
                WATERMARK_PNG: { label: "水印PNG路径", description: "容器内水印PNG的完整路径。" },
                WATERMARK_LOCATION: { label: "水印位置", description: "在视频流上绘制图像的位置。", options: { disabled: "禁用", topLeft: "左上", topRight: "右上", bottomLeft: "左下", bottomRight: "右下", centered: "居中", animated: "动画" } },
                DASHBOARD: { label: "仪表盘样式", description: "允许用户设置他们的仪表盘。", options: { default: "默认", selkiesDefault: "Selkies (默认)", zinc: "Zinc", wish: "Wish" } },
                SELKIES_AUDIO_ENABLED: { label: "启用音频", description: "启用服务器到客户端的音频流。" },
                SELKIES_MICROPHONE_ENABLED: { label: "启用麦克风", description: "启用客户端到服务器的麦克风转发。" },
                SELKIES_GAMEPAD_ENABLED: { label: "启用游戏手柄", description: "启用游戏手柄支持。" },
                SELKIES_CLIPBOARD_ENABLED: { label: "启用剪贴板", description: "启用剪贴板同步。" },
                SELKIES_ENABLE_BINARY_CLIPBOARD: { label: "启用二进制剪贴板", description: "允许剪贴板上的二进制数据（图像）。" },
                SELKIES_COMMAND_ENABLED: { label: "启用命令Websocket", description: "启用命令Websocket消息的解析。" },
                SELKIES_FILE_TRANSFERS: { label: "文件传输", description: "允许的方向（'upload,download', 'upload', 'download', 'none'）。" },
                SELKIES_ENABLE_SHARING: { label: "启用所有共享", description: "所有共享功能的主开关。" },
                SELKIES_SECOND_SCREEN: { label: "启用第二屏幕", description: "启用对第二台显示器/屏幕的支持。" },
                SELKIES_USE_BROWSER_CURSORS: { label: "使用浏览器光标", description: "使用浏览器CSS光标而不是渲染到画布。" },
                SELKIES_USE_CSS_SCALING: { label: "使用CSS缩放 (LoDPI)", description: "如果为true，则发送较低分辨率并拉伸画布。" },
                SELKIES_IS_MANUAL_RESOLUTION_MODE: { label: "手动分辨率模式", description: "将分辨率锁定为手动设置的宽度/高度值。" },
                SELKIES_MANUAL_WIDTH: { label: "手动宽度", description: "将宽度锁定为固定值。强制使用手动模式。" },
                SELKIES_MANUAL_HEIGHT: { label: "手动高度", description: "将高度锁定为固定值。强制使用手动模式。" },
                SELKIES_SCALING_DPI: { label: "UI缩放DPI", description: "UI缩放的默认DPI。" },
                SELKIES_AUDIO_BITRATE: { label: "音频比特率", description: "默认音频比特率。" },
                SELKIES_ENCODER: { label: "编码器", description: "逗号分隔的编码器列表。第一个为默认。" },
                SELKIES_USE_CPU: { label: "强制CPU编码", description: "强制为pixelflux使用基于CPU的编码。" },
                SELKIES_FRAMERATE: { label: "帧率（范围或固定值）", description: "例如，'8-120'表示范围，'60'表示固定值。" },
                SELKIES_H264_CRF: { label: "H.264 CRF（范围或固定值）", description: "例如，'5-50'表示范围，'25'表示固定值。" },
                SELKIES_JPEG_QUALITY: { label: "JPEG质量（范围或固定值）", description: "例如，'1-100'表示范围，'60'表示固定值。" },
                SELKIES_H264_FULLCOLOR: { label: "H.264全彩", description: "为pixelflux编码器启用H.264全彩范围。" },
                SELKIES_H264_STREAMING_MODE: { label: "H.264流媒体（Turbo）模式", description: "启用H.264低延迟流媒体模式。" },
                SELKIES_USE_PAINT_OVER_QUALITY: { label: "使用重绘质量", description: "为静态场景启用高质量的重绘。" },
                SELKIES_PAINT_OVER_JPEG_QUALITY: { label: "重绘JPEG质量", description: "例如，'1-100'表示范围，'90'表示固定值。" },
                SELKIES_H264_PAINTOVER_CRF: { label: "重绘H.264 CRF", description: "例如，'5-50'表示范围，'18'表示固定值。" },
                SELKIES_H264_PAINTOVER_BURST_FRAMES: { label: "重绘突发帧数", description: "例如，'1-30'表示范围，'5'表示固定值。" },
                HARDEN_DESKTOP: { label: "桌面加固（预设）", description: "启用DISABLE_OPEN_TOOLS、DISABLE_SUDO和DISABLE_TERMINALS。" },
                HARDEN_OPENBOX: { label: "窗口管理器加固（预设）", description: "启用DISABLE_CLOSE_BUTTON、DISABLE_MOUSE_BUTTONS和HARDEN_KEYBINDS。同时启用RESTART_APP。" },
                DISABLE_OPEN_TOOLS: { label: "禁用打开工具", description: "禁用xdg-open和exo-open二进制文件。" },
                DISABLE_SUDO: { label: "禁用Sudo", description: "禁用sudo命令。" },
                DISABLE_TERMINALS: { label: "禁用终端", description: "禁用常见的终端模拟器。" },
                DISABLE_CLOSE_BUTTON: { label: "禁用窗口关闭按钮", description: "从窗口标题栏中移除关闭按钮。" },
                DISABLE_MOUSE_BUTTONS: { label: "禁用右键/中键单击", description: "禁用右键和中键单击的上下文菜单。" },
                HARDEN_KEYBINDS: { label: "加固快捷键", description: "禁用默认的Openbox快捷键，如Alt+F4。" },
                RESTART_APP: { label: "关闭时重启应用", description: "如果主应用程序关闭，则自动重启它。" },
                MAX_RES: { label: "最大分辨率", description: "容器的最大分辨率，默认为16k。" },
                START_DOCKER: { label: "启动Docker-in-Docker", description: "如果为false，特权容器将不会启动DinD。" },
                DISABLE_IPV6: { label: "禁用IPv6", description: "如果为true，将禁用IPv6。" },
                DISABLE_ZINK: { label: "禁用Zink", description: "如果检测到显卡，则不设置Zink环境变量。" },
                DISABLE_DRI3: { label: "禁用DRI3", description: "如果检测到显卡，则不使用DRI3加速。" },
                NO_DECOR: { label: "无窗口装饰", description: "为PWA使用而运行无窗口边框的应用程序。" },
                NO_FULL: { label: "无全屏", description: "不自动全屏应用程序。" },
                NO_GAMEPAD: { label: "禁用游戏手柄注入", description: "禁用用户空间游戏手柄插入器注入。" },
                SELKIES_DEBUG: { label: "启用Selkies调试", description: "为流媒体组件启用调试日志记录。" },
            }
        },
        appLaboratory: {
            title: '应用实验室',
            description: '在基础应用之上叠加更改，创建和测试自定义应用程序配置。',
            selectApp: '选择应用',
            createNew: '创建新应用',
            baseApp: '基础应用',
            baseAppDescription: '您的新自定义应用将基于此已安装的应用程序。',
            selectBase: '选择一个基础应用',
            customizationTitle: '自定义',
            appName: '应用名称',
            appIcon: '应用图标',
            uploadIcon: '上传图标',
            autostartScriptLabel: '自定义自动启动脚本',
            permissionsTitle: '权限',
            usersLabel: '允许的用户',
            groupsLabel: '允许的群组',
            launchButton: '保存并启动自定义会话',
            closeButton: '关闭会话并最终确定',
            savingAndLaunching: '正在保存并启动...',
            placeholder: '应用实验室允许您基于现有的已安装应用程序配置基础主目录和启动脚本。此主目录将在用户首次初始化时复制，包含您在此会话中设置的所有文件和设置。您可以重新启动现有的实验室应用以进一步修改其内容。',
            formInvalid: '请选择一个基础应用并为新应用提供一个名称。',
        },
        modals: {
            editUserTitle: '编辑用户: {username}',
            saveChanges: '保存更改',
            effectiveSettings: '生效设置（含群组覆盖）',
            editGroupTitle: '编辑群组: {groupName}',
            userConfigTitle: '用户配置',
            warning: '此配置仅显示一次。请安全地提供给用户。',
            info: '您可以下载此配置文件，以便在另一台设备上轻松设置SealSkin。请妥善保管此文件，因为它包含您的私钥。',
            configDataLabel: '配置数据 (JSON)',
            copyButton: '复制文本',
            downloadButton: '下载文件',
            manageHomeDirs: '管理主目录',
            dirsForUser: '用户目录: {username}',
            dirsForAdmin: '管理员目录: {username}',
            newDirForUser: '为用户创建新目录',
            createDirButton: '创建目录',
            confirmDeleteDir: '您确定要删除用户“{username}”的目录“{homeName}”吗？此操作是永久性的。',
            installAppTitle: '安装 {appName}',
            editAppTitle: '编辑 {appName}',
            customNameLabel: '自定义名称',
            imageLabel: '容器镜像',
            permissions: '权限',
            allowedUsersLabel: '允许的用户（逗号分隔，\'all\'表示所有人）',
            allowedGroupsLabel: '允许的群组（逗号分隔，\'all\'表示所有群组）',
            features: '功能',
            gpuSupport: 'GPU支持',
            homeMounting: '主目录挂载',
            urlSupport: 'URL打开支持',
            fileSupport: '文件打开支持',
            autoUpdate: '自动更新镜像',
            advancedSettings: '高级设置',
            appTemplateLabel: '应用程序模板',
            appTemplateDescription: '为高级容器启动设置选择一个预配置的模板。',
            customAutostartScriptLabel: '自定义自动启动脚本',
            customAutostartScriptDescription: '自定义自动启动逻辑，留空以使用应用程序提供商的默认设置。',
            saveInstallation: '保存安装',
            updateStatusTitle: '{appName}的更新状态',
            checkingUpdates: '正在检查更新...',
            updateAvailable: '有新的镜像版本可用！',
            yourVersion: '您的版本: {sha}',
            latestAvailable: '最新版本可从注册表中拉取。',
            pullLatest: '拉取最新镜像',
            upToDate: '您的镜像已是最新版本。',
            currentVersion: '当前版本: {sha}',
            errorChecking: '检查更新时出错。',
            pullingLatest: '正在拉取最新镜像... 这可能需要一些时间。',
            pullComplete: '拉取完成！',
            newVersion: '新版本: {sha}',
            errorPulling: '拉取镜像时出错。',
            manualInstallNote: "注意：手动添加的镜像应基于与 selkies-baseimage 兼容的镜像。",
        },
        status: {
            loggingIn: '登录中...',
            configSaved: '配置保存成功！',
            configApplied: '配置已应用！请登录并测试。',
            configApplyFailed: '应用配置失败: {error}',
            fileReadError: '读取文件时出错。',
            noConfig: '请提供配置文件或文本。',
            loggedInAdmin: '以管理员身份登录: {username}',
            loggedInUser: '以标准用户身份登录: {username}。',
            loginFailed: '登录失败: {error}',
            adminDataRefreshFailed: '刷新管理员数据失败: {error}',
            logoutSuccess: '已登出并清除配置。',
            generateConfigFailed: '无法生成配置，缺少用户详细信息。',
            copySuccess: '配置已复制到剪贴板！',
            copyFailed: '复制文本失败。',
            publicKeyCopied: '公钥已复制！',
            keyCopyFailed: '复制密钥失败。',
            creatingAdmin: '正在创建管理员...',
            adminCreated: '管理员“{username}”已创建。',
            adminCreateFailed: '创建管理员时出错: {error}',
            adminDeleted: '管理员“{username}”已成功删除。',
            adminDeleteFailed: '删除管理员时出错: {error}',
            creatingUser: '正在创建用户...',
            userCreated: '用户“{username}”已创建。',
            userCreateFailed: '创建用户时出错: {error}',
            userDeleted: '用户“{username}”已成功删除。',
            userDeleteFailed: '删除用户时出错: {error}',
            userUpdated: '用户“{username}”已成功更新。',
            userUpdateFailed: '更新用户时出错: {error}',
            creatingGroup: '正在创建群组...',
            groupCreated: '群组“{groupName}”已创建。',
            groupCreateFailed: '创建群组时出错: {error}',
            groupDeleted: '群组“{groupName}”已成功删除。',
            groupDeleteFailed: '删除群组时出错: {error}',
            groupUpdated: '群组“{groupName}”已成功更新。',
            groupUpdateFailed: '更新群组时出错: {error}',
            homedirLoadFailed: '加载主目录失败: {error}',
            homedirCreateFailed: '创建目录时出错: {error}',
            homedirCreated: '主目录“{homeName}”已创建。',
            homedirDeleted: '目录“{homeName}”已删除。',
            homedirDeleteFailed: '删除目录时出错: {error}',
            homedirCreatedFor: '为{username}创建了目录“{homeName}”。',
            homedirDeletedFor: '为{username}删除了目录“{homeName}”。',
            sessionsLoadFailed: '加载会话失败: {error}',
            sessionStopError: '停止会话时出错: {error}',
            sessionStopped: '会话已成功停止。',
            appDataRefreshFailed: '刷新应用数据失败: {error}',
            closingSession: '正在提交自定义会话...',
            sessionClosed: '自定义会话已关闭。',
            sessionCloseFailed: '关闭自定义会话失败：{error}',
            fetchingApps: '正在从商店获取应用...',
            fetchAppsFailed: '从商店获取应用失败: {error}',
            appStoreAddFailed: '添加商店时出错: {error}',
            appStoreAdded: '应用商店“{name}”已添加。',
            appSaved: '应用“{name}”已成功{action}。',
            appSaveActions: {
                updated: '更新',
                installed: '安装'
            },
            appSaveFailed: '保存应用时出错: {error}',
            appDeleted: '应用“{name}”已删除。',
            appDeleteFailed: '删除应用时出错: {error}',
            templateSaved: '模板“{name}”已成功保存。',
            templateSaveFailed: '保存模板时出错: {error}',
            templateDeleted: '模板“{name}”已成功删除。',
            templateDeleteFailed: '删除模板时出错: {error}',
            pinRemoved: '已删除固定行为。',
            keyGenerated: '已生成新的密钥对。',
            keyGenFailed: '密钥生成失败：{{error}}',
            pendingConfigSaved: '待定配置已保存。您现在可以将您的公钥提供给管理员。',
            settingsSaved: '设置已保存。',
            appCreated: '应用“{name}”已成功创建。',
            launchFailed: '启动失败：{error}',
        },
        placeholders: {
            noAdmins: '未找到管理员。',
            noUsers: '未找到用户。',
            noGroups: '未找到群组。',
            noHomeDirs: '未找到主目录。',
            noSessions: '未找到活跃会话。',
            noPinned: '未找到固定行为。',
            errorLoading: '加载目录时出错。',
            noInstalledApps: '尚未安装任何应用程序。',
        },
    },
    popup: {
        tabs: {
            launch: '启动新的',
            sessions: '活跃会话',
            manageFiles: '管理文件',
            uploadStorage: '上传到存储',
            uploadFiles: '上传文件',
            uploadFilesTitle: '打开专用的文件上传页面'
        },
        launchView: {
            searchPlaceholder: '搜索应用程序...',
            uploadingFile: '正在上传文件...',
            gpuLabel: 'GPU',
            storageLabel: '存储',
            languageLabel: '语言',
            cleanroom: '无尘室 (临时)',
            noGpu: '无',
            saveOptions: '保存这些启动选项',
            saveOptionsForUrl: '为所有URL保存选项',
            saveOptionsForFile: '为.{extension}文件保存选项',
            openFile: '启动时打开文件',
            launchButton: '启动',
            launchingButton: '启动中...',
            uploadingButton: '上传中...',
            autoHome: '自动 (按应用持久化)',
            collaborationMode: '协作会话',
            waylandMode: 'Wayland 模式',
        },
        sessionsView: {
            noSessions: '未找到活跃会话。',
        },
        uploadStorageView: {
            selectHome: '选择主目录',
            description: '这将上传文件 <strong>{filename}</strong> 直接到您的“文件”存储中，以备将来使用。',
            descriptionFallback: '这将上传文件 <strong>{filename}</strong> 直接到您的“文件”存储中，以备将来使用。',
            uploadButton: '上传文件',
            uploadingButton: '上传中...',
            preparing: '准备文件中...',
            uploadingChunk: '正在上传分块 {current} / {total}...',
            finalizing: '正在完成...',
            uploadComplete: '上传完成！',
        },
        status: {
            unconfigured: '请通过选项页面配置扩展程序。',
            openingServerFile: "正在打开服务器端文件：{filename}",
            openingFile: '正在打开文件: {filename}',
            openingUrl: '正在打开URL: {targetUrl}',
            error: '错误: {message}',
            preparingFile: '准备文件中...',
            sendingFile: '正在发送文件到会话...',
            errorSendingFile: '发送文件时出错: {message}',
            errorClosingSession: '关闭会话时出错: {message}',
            preparingSession: '准备隔离会话中...',
            fetchingData: '正在获取文件数据...',
            fetchDataFailed: '获取文件数据失败: {statusText}',
            unknownAction: '未知的启动操作。',
            noAppSelected: '请选择一个应用程序。',
            noAppsAvailable: '您的账户没有可用的应用程序。',
            uploadSuccess: '文件上传成功！',
            creatingAutoHome: '正在创建自动主目录...',
        },
        languages: {
            default: '默认 ({locale})'
        }
    },
    upload: {
        title: '文件上传',
        description: '从您的计算机中选择一个文件，以在安全的隔离会话中打开它。',
        dropzone: {
            title: '将文件拖放到此处',
            or: '或',
            button: '选择文件',
        },
        confirm: {
            ready: '文件已准备好，可以安全打开。',
            button: '继续启动',
        }
    },
    files: {
        title: 'SealSkin 文件',
        header: {
            title: '文件',
            newFolder: '新建文件夹',
            uploadFiles: '上传文件',
            uploadFolder: '上传文件夹'
        },
        sidebar: {
            sharedFiles: 'SealSkin 文件',
            publicShares: '公开分享'
        },
        shares: {
            title: '公开分享的文件',
            searchPlaceholder: '按文件名或ID搜索...'
        },
        table: {
            name: '名称',
            size: '大小',
            lastModified: '最后修改',
            created: '创建时间',
            expires: '过期时间',
            url: '公开URL',
            passwordProtected: '密码'
        },
        dropzone: {
            title: '拖放文件以上传'
        },
        pagination: {
            previous: '« 上一页',
            next: '下一页 »',
            pageOf: '第 {page} 页 / 共 {totalPages} 页'
        },
        modals: {
            newFolder: {
                title: '创建新文件夹',
                folderNameLabel: '文件夹名称',
                nameTitle: '只能使用字母、数字、下划线、连字符或句点。',
                createButton: '创建'
            },
            confirmDelete: {
                title: '确认删除',
                message: '您确定要删除{count, plural, one {1 个选定项目} other {{count} 个选定项目}}吗？此操作无法撤销。',
                messageDefault: '您确定要删除所选项目吗？此操作无法撤销。'
            },
            uploadProgress: {
                title: '上传进度',
                doneButton: '完成'
            },
            share: {
                title: '分享文件',
                sharingFile: '正在分享文件: <strong>{filename}</strong>',
                passwordLabel: '密码 (可选)',
                passwordPlaceholder: '留空则无密码',
                expiryLabel: '过期时间 (小时, 可选)',
                expiryPlaceholder: '例如, 24代表一天',
                shareButton: '创建分享链接'
            }
        },
        status: {
            homeDirLoadFailed: '加载主目录失败：{error}',
            filesLoadFailed: '加载文件时出错：{error}',
            deleteProtectedError: '无法删除受保护的系统文件夹。',
            deletingItems: '正在删除 {count, plural, one {1 个项目} other {{count} 个项目}}...',
            deleteSuccess: '删除成功。',
            deleteFailed: '删除失败：{error}',
            preparingUpload: '准备上传 {count, plural, one {1 个文件} other {{count} 个文件}}...',
            uploadPrepFailed: '文件夹上传准备过程中出错：{error}',
            notConfigured: '错误：SealSkin 未配置。请在选项中进行设置。',
            folderCreated: '文件夹“{folderName}”已创建。',
            folderCreateFailed: '创建文件夹时出错：{error}',
            shareCreated: '分享链接创建成功！链接已复制到剪贴板。',
            shareCreateFailed: '创建分享失败: {error}',
            sharesLoadFailed: '加载分享文件失败: {error}',
            shareDeleteFailed: '删除分享失败: {error}',
            shareDeleted: '分享已成功删除。',
            urlCopied: '公开URL已复制到剪贴板。'
        },
        placeholders: {
            errorLoading: '加载文件时出错。',
            folderEmpty: '此文件夹为空。',
            noHomeDirs: '没有可用的主目录。',
            noShares: '您尚未分享任何文件。'
        },
        uploadStatus: {
            pending: '待处理',
            initiating: '正在开始...',
            uploading: '上传中...',
            finalizing: '正在完成...',
            completed: '已完成',
            error: '错误'
        }
    }
};

// --- Hindi Translations ---
const hi = {
    background: {
        contextMenu: {
            openUrl: 'SealSkin में लिंक खोलें',
            openFile: 'लिंक लक्ष्य को SealSkin में फ़ाइल के रूप में खोलें',
            sendMedia: 'मीडिया को SealSkin में भेजें',
            searchText: 'SealSkin में "%s" खोजें',
            sendDownload: 'अगला डाउनलोड SealSkin में भेजें'
        }
    },
    common: {
        actions: 'कार्रवाइयाँ',
        active: 'सक्रिय',
        cancel: 'रद्द करें',
        manage: 'प्रबंधित करें',
        delete: 'हटाएं',
        edit: 'संपादित करें',
        save: 'सहेजें',
        none: 'कोई नहीं',
        error: 'त्रुटि',
        na: 'लागू नहीं',
        of: 'का',
        status: 'स्थिति',
        username: 'उपयोगकर्ता नाम',
        group: 'समूह',
        groups: 'समूह',
        publicKey: 'सार्वजनिक कुंजी',
        name: 'नाम',
        source: 'स्रोत',
        imageVersion: 'छवि संस्करण',
        language: 'भाषा',
        storage: 'भंडारण',
        gpu: 'GPU',
        version: 'संस्करण',
        checked: 'जाँचा गया',
        never: 'कभी नहीं',
        stop: 'रोकें',
        reopen: 'फिर से खोलें',
        sendFile: 'फ़ाइल भेजें',
        share: 'साझा करें',
        search: 'खोजें',
        refresh: 'ताज़ा करें',
        close: 'बंद करें',
        copy: 'कॉपी करें',
        open: "खोलें",
        copyUrl: 'URL कॉपी करें',
        download: 'डाउनलोड करें',
        next: 'अगला',
        previous: 'पिछला',
        page: 'पृष्ठ',
        home: 'होम डायरेक्टरी',
        homes: 'होम डायरेक्टरी',
        sessions: 'सत्र',
        users: 'उपयोगकर्ता',
        admins: 'प्रशासक',
        yes: 'हाँ',
        no: 'नहीं',
        daysAgo: '{count, plural, one {1 दिन पहले} other {{count} दिन पहले}}',
        hoursAgo: '{count, plural, one {1 घंटा पहले} other {{count} घंटे पहले}}',
        minutesAgo: '{count, plural, one {1 मिनट पहले} other {{count} मिनट पहले}}',
        justNow: 'अभी-अभी',
        bytes: 'बाइट्स',
        kb: 'KB',
        mb: 'MB',
        gb: 'GB',
        tb: 'TB',
        pb: 'PB',
    },
    options: {
        sidebar: {
            config: 'कॉन्फ़िगरेशन',
            home: 'होम डायरेक्टरी',
            sessions: 'सक्रिय सत्र',
            pinned: 'पिन किया गया व्यवहार',
            appStore: 'ऐप स्टोर',
            appTemplates: 'ऐप टेम्पलेट्स',
            appLaboratory: 'ऐप प्रयोगशाला',
            installedApps: 'स्थापित ऐप्स',
            users: 'उपयोगकर्ता',
            groups: 'समूह',
            admins: 'प्रशासक',
        },
        dashboard: {
            title: 'डैशबोर्ड',
            clientSettings: 'क्लाइंट सेटिंग्स',
            exportConfig: 'कॉन्फ़िगरेशन निर्यात करें',
            userStatus: 'उपयोगकर्ता स्थिति',
            loggedInAs: 'इस रूप में लॉग इन हैं:',
            role: 'भूमिका',
            roleAdmin: 'प्रशासक',
            roleUser: 'मानक उपयोगकर्ता',
            serverInfo: 'सर्वर जानकारी',
            server: 'सर्वर:',
            cpuModel: 'सीपीयू मॉडल:',
            storageUsage: 'भंडारण उपयोग:',
            detectedGpus: 'पता लगाए गए जीपीयू:',
            logout: 'लॉगआउट और कॉन्फ़िग साफ़ करें',
            howTo: 'SealSkin का उपयोग कैसे करें',
            howToDescription: 'इस अनुभाग में एक्सटेंशन का उपयोग करने के तरीके पर बुनियादी दस्तावेज़ शामिल हैं।',
            howToList: [
                '<strong>सामग्री को अलगाव में खोलने के लिए:</strong> किसी भी लिंक, छवि, या चयनित पाठ पर राइट-क्लिक करें और "SealSkin Isolation" संदर्भ मेनू से एक विकल्प चुनें।',
                '<strong>डाउनलोड को अलगाव में भेजने के लिए:</strong> पृष्ठ पर राइट-क्लिक करें और "अगला डाउनलोड अलगाव में भेजें" चुनें। आपके द्वारा डाउनलोड की जाने वाली अगली फ़ाइल को रोककर एक सुरक्षित सत्र में भेजा जाएगा।',
                '<strong>एक स्वच्छ एप्लिकेशन लॉन्च करने के लिए:</strong> अपने ब्राउज़र के टूलबार में SealSkin आइकन पर क्लिक करें।',
                '<strong>स्थायी भंडारण का प्रबंधन करने के लिए:</strong> इस पृष्ठ पर "होम डायरेक्टरी" टैब का उपयोग करके भंडारण वॉल्यूम बनाएं और हटाएं जिनका उपयोग कई सत्रों में किया जा सकता है।',
                '<strong>लॉन्च विकल्पों को सहेजने के लिए:</strong> किसी विशिष्ट फ़ाइल प्रकार (जैसे, .pdf) या सभी URL के लिए एप्लिकेशन लॉन्च करने से पहले पॉपअप में "इन लॉन्च विकल्पों को सहेजें" बॉक्स को चेक करें। इन सहेजी गई प्राथमिकताओं को "पिन किया गया व्यवहार" टैब में प्रबंधित करें।'
            ],
            confirmLogout: 'क्या आप वाकई लॉगआउट करना चाहते हैं? यह इस ब्राउज़र से आपकी सहेजी गई कॉन्फ़िगरेशन को साफ़ कर देगा।',
        },
        config: {
            quickSetup: 'त्वरित सेटअप',
            quickSetupDescription: 'अपने व्यवस्थापक द्वारा प्रदान की गई कॉन्फ़िगरेशन फ़ाइल (.json) अपलोड करें, या एक्सटेंशन को स्वचालित रूप से सेट करने के लिए नीचे इसकी सामग्री पेस्ट करें।',
            uploadLabel: 'कॉन्फ़िग फ़ाइल अपलोड करें',
            pasteLabel: 'या कॉन्फ़िग टेक्स्ट पेस्ट करें',
            pastePlaceholder: 'अपना JSON कॉन्फ़िगरेशन यहाँ पेस्ट करें...',
            applyButton: 'कॉन्फ़िगरेशन लागू करें',
            manualLink: 'मैनुअल कॉन्फ़िगरेशन',
            advancedTitle: 'क्लाइंट कॉन्फ़िगरेशन (उन्नत)',
            serverIpLabel: 'सर्वर आईपी या डोमेन',
            serverIpPlaceholder: 'उदा., 192.168.1.100',
            apiPortLabel: 'एपीआई पोर्ट',
            apiPortPlaceholder: 'उदा., 8000',
            sessionPortLabel: 'सत्र पोर्ट',
            sessionPortPlaceholder: 'उदा., 8443',
            usernameLabel: 'उपयोगकर्ता नाम',
            usernamePlaceholder: 'आपका उपयोगकर्ता नाम',
            privateKeyLabel: 'आपकी निजी कुंजी (PEM प्रारूप)',
            privateKeyPlaceholder: 'अपनी निजी कुंजी की सामग्री यहाँ पेस्ट करें',
            serverKeyLabel: 'सर्वर सार्वजनिक कुंजी (PEM प्रारूप)',
            serverKeyPlaceholder: 'server_public.pem की सामग्री यहाँ पेस्ट करें',
            searchEngineLabel: 'चयनित पाठ के लिए डिफ़ॉल्ट खोज इंजन',
            saveButton: 'कॉन्फ़िगरेशन सहेजें',
            loginButton: 'लॉगिन और परीक्षण करें',
            automaticLink: 'स्वचालित कॉन्फ़िगरेशन',
            chooseFile: 'फ़ाइल चुनें',
            keyGeneration: 'कुंजी निर्माण',
            keyGenDescription: 'यदि आपके पास कुंजी जोड़ी नहीं है, तो आप यहाँ एक बना सकते हैं। निजी कुंजी ऊपर भर दी जाएगी। अपने प्रशासक को सार्वजनिक कुंजी प्रदान करें।',
            generateKeyButton: 'नया कुंजी जोड़ा उत्पन्न करें',
            publicKeyForAdminLabel: 'आपकी सार्वजनिक कुंजी (व्यवस्थापक के लिए)',
        },
        home: {
            title: 'आपकी होम डायरेक्टरी',
            description: 'सत्रों में उपयोग के लिए स्थायी भंडारण डायरेक्टरी बनाएं। ये आपके कॉन्फ़िगरेशन डायरेक्टरी के रूप में आपके एप्लिकेशन में माउंट की जाएंगी।',
            newTitle: 'नई होम डायरेक्टरी बनाएं',
            nameLabel: 'डायरेक्टरी का नाम:',
            namePlaceholder: 'उदा., my-project-files',
            nameTitle: 'केवल अक्षर, संख्याएं, अंडरस्कोर, या हाइफ़न का उपयोग करें।',
            createButton: 'डायरेक्टरी बनाएं',
            isLaboratory: 'यह एक प्रयोगशाला ऐप है, जो कस्टम सेटिंग्स के साथ बेस इमेज से बनाया गया है।',
            laboratory: 'प्रयोगशाला',
            confirmDelete: 'क्या आप वाकई स्थापित ऐप \'{appName}\' को हटाना चाहते हैं?'
        },
        sessions: {
            title: 'सक्रिय सत्र',
            application: 'एप्लिकेशन',
            started: 'शुरू हुआ',
            noSessionsUser: 'कोई सक्रिय सत्र नहीं मिला।',
            noSessionsAdmin: 'किसी भी उपयोगकर्ता के लिए कोई सक्रिय सत्र नहीं मिला।',
            sessionsFor: '{username} के लिए सत्र ({count})',
            confirmStop: 'क्या आप वाकई इस सत्र को रोकना चाहते हैं? कंटेनर नष्ट हो जाएगा।',
        },
        pinned: {
            title: 'पिन किया गया एक्सटेंशन व्यवहार',
            description: 'यह तालिका आपके द्वारा विशिष्ट फ़ाइल प्रकारों या सभी URL के लिए सहेजे गए लॉन्च विकल्पों को दिखाती है। आप लॉन्च विकल्पों के लिए फिर से संकेत पाने के लिए पिन किए गए व्यवहार को हटा सकते हैं।',
            trigger: 'ट्रिगर',
            savedApp: 'सहेजा गया एप्लिकेशन',
            triggerSimple: 'सरल लॉन्च (टूलबार बटन)',
            triggerUrl: 'सभी यूआरएल (संदर्भ मेनू से)',
            triggerFile: 'फ़ाइल प्रकार: <strong>{fileType}</strong>',
            unknownApp: 'अज्ञात ऐप ({appId}...)'
        },
        admins: {
            serverKeyTitle: 'सर्वर सार्वजनिक कुंजी',
            serverKeyDescription: 'यह वह सार्वजनिक कुंजी है जिसकी आवश्यकता उपयोगकर्ता कॉन्फ़िगरेशन फ़ाइलों को इस सर्वर से कनेक्ट करने के लिए होगी।',
            title: 'व्यवस्थापक प्रबंधन',
            searchPlaceholder: 'व्यवस्थापकों को खोजें...',
            newTitle: 'नया व्यवस्थापक बनाएं',
            publicKeyOptionalLabel: 'सार्वजनिक कुंजी (वैकल्पिक):',
            publicKeyPlaceholder: 'सार्वजनिक कुंजी यहाँ पेस्ट करें, या एक उत्पन्न करने के लिए खाली छोड़ दें।',
            createButton: 'व्यवस्थापक बनाएं',
            confirmDelete: 'क्या आप वाकई व्यवस्थापक \'{username}\' को हटाना चाहते हैं? यह उनके सभी स्थायी भंडारण को भी हटा देगा और इसे पूर्ववत नहीं किया जा सकता है।',
        },
        users: {
            title: 'उपयोगकर्ता प्रबंधन',
            searchPlaceholder: 'नाम या समूह द्वारा उपयोगकर्ताओं को खोजें...',
            newTitle: 'नया उपयोगकर्ता बनाएं',
            publicKeyOptionalLabel: 'सार्वजनिक कुंजी (वैकल्पिक):',
            publicKeyPlaceholder: 'उपयोगकर्ता की सार्वजनिक कुंजी यहाँ पेस्ट करें, या एक उत्पन्न करने के लिए खाली छोड़ दें।',
            settingsTitle: 'उपयोगकर्ता सेटिंग्स',
            sessionLimitLabel: 'सत्र सीमा',
            sessionLimitTitle: 'एक उपयोगकर्ता के पास सक्रिय सत्रों की संख्या। असीमित के लिए -1।',
            permissionsTitle: 'अनुमतियाँ और सुदृढीकरण',
            activeAccount: 'सक्रिय खाता',
            allowStorage: 'स्थायी भंडारण की अनुमति दें',
            allowGpu: 'जीपीयू एक्सेस की अनुमति दें',
            hardenContainer: 'कंटेनर को सुदृढ़ करें',
            hardenWm: 'विंडो मैनेजर को सुदृढ़ करें',
            createButton: 'उपयोगकर्ता बनाएं',
            homesDisabledTooltip: 'इस उपयोगकर्ता के लिए स्थायी भंडारण अक्षम है',
            confirmDelete: 'क्या आप वाकई उपयोगकर्ता \'{username}\' को हटाना चाहते हैं? यह उनके सभी स्थायी भंडारण को भी हटा देगा और इसे पूर्ववत नहीं किया जा सकता है।',
            allowPublicSharing: 'सार्वजनिक फ़ाइल साझाकरण की अनुमति दें',
        },
        groups: {
            title: 'समूह प्रबंधन',
            searchPlaceholder: 'समूह खोजें...',
            newTitle: 'नया समूह बनाएं',
            nameLabel: 'समूह का नाम:',
            overrideTitle: 'समूह ओवरराइड सेटिंग्स',
            permissionsTitle: 'अनुमतियाँ और सुदृढीकरण ओवरराइड',
            createButton: 'समूह बनाएं',
            confirmDelete: 'क्या आप वाकई समूह \'{groupName}\' को हटाना चाहते हैं? इस समूह के उपयोगकर्ता अपनी व्यक्तिगत सेटिंग्स पर वापस आ जाएंगे।',
        },
        installedApps: {
            title: 'स्थापित एप्लिकेशन',
            searchPlaceholder: 'स्थापित ऐप्स खोजें...',
            noAppsFound: 'कोई स्थापित ऐप नहीं मिला।',
            pulling: 'नई छवि खींची जा रही है...',
            notLocal: 'छवि स्थानीय रूप से नहीं मिली',
            confirmDelete: 'क्या आप वाकई स्थापित ऐप \'{appName}\' को हटाना चाहते हैं?',
        },
        appStore: {
            title: 'ऐप स्टोर',
            refreshTitle: 'चयनित स्टोर को ताज़ा करें',
            selectLabel: 'ऐप स्टोर चुनें',
            addLabel: 'नया ऐप स्टोर जोड़ें',
            namePlaceholder: 'स्टोर का नाम',
            urlPlaceholder: 'स्टोर YAML यूआरएल',
            availableTitle: 'उपलब्ध ऐप्स',
            addManual: "मैन्युअल ऐप जोड़ें",
            searchPlaceholder: 'उपलब्ध ऐप्स खोजें...',
            noAppsFound: 'कोई एप्लिकेशन नहीं मिला।',
            availableFrom: '{storeName} से उपलब्ध ऐप्स',
            couldNotLoad: 'इस स्टोर से ऐप्स लोड नहीं किए जा सके।',
        },
        appTemplates: {
            title: 'एप्लिकेशन टेम्पलेट संपादक',
            loadLabel: 'टेम्पलेट लोड करें',
            createOption: 'नया टेम्पलेट बनाएं',
            nameLabel: 'टेम्पलेट का नाम',
            namePlaceholder: 'नए टेम्पलेट के लिए एक नाम दर्ज करें',
            saveButton: 'प्रोफ़ाइल सहेजें',
            deleteButton: 'हटाएं',
            previewTitle: 'यूआई पूर्वावलोकन',
            contentArea: 'एप्लिकेशन सामग्री क्षेत्र',
            confirmDelete: 'क्या आप वाकई टेम्पलेट \'{templateName}\' को हटाना चाहते हैं? यह क्रिया पूर्ववत नहीं की जा सकती है।',
            deleteDisabled: 'यह टेम्पलेट हटाया नहीं जा सकता।',
            enterName: 'कृपया नए टेम्पलेट के लिए एक नाम दर्ज करें।',
            settings: {
                TITLE: { label: "पृष्ठ शीर्षक", description: "वेब ब्राउज़र पर प्रदर्शित पृष्ठ शीर्षक।" },
                SELKIES_UI_TITLE: { label: "साइडबार शीर्षक", description: "साइडबार के ऊपरी बाएं कोने में शीर्षक।" },
                SELKIES_UI_SHOW_SIDEBAR: { label: "साइडबार दिखाएं", description: "मुख्य साइडबार यूआई दिखाएं।" },
                SELKIES_UI_SHOW_LOGO: { label: "लोगो दिखाएं", description: "साइडबार में सेल्कीज़ लोगो दिखाएं।" },
                SELKIES_UI_SHOW_CORE_BUTTONS: { label: "कोर बटन दिखाएं", description: "कोर कंपोनेंट्स बटन (डिस्प्ले, ऑडियो, आदि) दिखाएं।" },
                SELKIES_UI_SIDEBAR_SHOW_VIDEO_SETTINGS: { label: "वीडियो सेटिंग्स दिखाएं", description: "साइडबार में वीडियो सेटिंग्स अनुभाग दिखाएं।" },
                SELKIES_UI_SIDEBAR_SHOW_SCREEN_SETTINGS: { label: "स्क्रीन सेटिंग्स दिखाएं", description: "साइडबार में स्क्रीन सेटिंग्स अनुभाग दिखाएं।" },
                SELKIES_UI_SIDEBAR_SHOW_AUDIO_SETTINGS: { label: "ऑडियो सेटिंग्स दिखाएं", description: "साइडबार में ऑडियो सेटिंग्स अनुभाग दिखाएं।" },
                SELKIES_UI_SIDEBAR_SHOW_STATS: { label: "आँकड़े दिखाएं", description: "साइडबार में आँकड़े अनुभाग दिखाएं।" },
                SELKIES_UI_SIDEBAR_SHOW_CLIPBOARD: { label: "क्लिपबोर्ड दिखाएं", description: "साइडबार में क्लिपबोर्ड अनुभाग दिखाएं।" },
                SELKIES_UI_SIDEBAR_SHOW_FILES: { label: "फ़ाइलें अनुभाग दिखाएं", description: "साइडबार में फ़ाइल स्थानांतरण अनुभाग दिखाएं।" },
                SELKIES_UI_SIDEBAR_SHOW_APPS: { label: "ऐप्स अनुभाग दिखाएं", description: "साइडबार में एप्लिकेशन अनुभाग दिखाएं।" },
                SELKIES_UI_SIDEBAR_SHOW_SHARING: { label: "साझाकरण अनुभाग दिखाएं", description: "साइडबार में साझाकरण अनुभाग दिखाएं।" },
                SELKIES_UI_SIDEBAR_SHOW_GAMEPADS: { label: "गेमपैड अनुभाग दिखाएं", description: "साइडबार में गेमपैड अनुभाग दिखाएं।" },
                SELKIES_UI_SIDEBAR_SHOW_KEYBOARD_BUTTON: { label: "कीबोर्ड बटन दिखाएं", description: "ऑन-स्क्रीन कीबोर्ड बटन दिखाएं।" },
                SELKIES_UI_SIDEBAR_SHOW_SOFT_BUTTONS: { label: "सॉफ्ट बटन दिखाएं", description: "सॉफ्ट बटन अनुभाग (मोबाइल के लिए) दिखाएं।" },
                WATERMARK_PNG: { label: "वॉटरमार्क पीएनजी पथ", description: "कंटेनर के अंदर वॉटरमार्क पीएनजी का पूरा पथ।" },
                WATERMARK_LOCATION: { label: "वॉटरमार्क स्थान", description: "स्ट्रीम पर छवि को कहाँ पेंट करना है।", options: { disabled: "अक्षम", topLeft: "ऊपर-बाएँ", topRight: "ऊपर-दाएँ", bottomLeft: "नीचे-बाएँ", bottomRight: "नीचे-दाएँ", centered: "केंद्रित", animated: "एनिमेटेड" } },
                DASHBOARD: { label: "डैशबोर्ड शैली", description: "उपयोगकर्ता को अपना डैशबोर्ड सेट करने की अनुमति देता है।", options: { default: "डिफ़ॉल्ट", selkiesDefault: "सेल्कीज़ (डिफ़ॉल्ट)", zinc: "जिंक", wish: "विश" } },
                SELKIES_AUDIO_ENABLED: { label: "ऑडियो सक्षम करें", description: "सर्वर-से-क्लाइंट ऑडियो स्ट्रीमिंग सक्षम करें।" },
                SELKIES_MICROPHONE_ENABLED: { label: "माइक्रोफ़ोन सक्षम करें", description: "क्लाइंट-से-सर्वर माइक्रोफ़ोन फॉरवर्डिंग सक्षम करें।" },
                SELKIES_GAMEPAD_ENABLED: { label: "गेमपैड सक्षम करें", description: "गेमपैड समर्थन सक्षम करें।" },
                SELKIES_CLIPBOARD_ENABLED: { label: "क्लिपबोर्ड सक्षम करें", description: "क्लिपबोर्ड सिंक्रनाइज़ेशन सक्षम करें।" },
                SELKIES_ENABLE_BINARY_CLIPBOARD: { label: "बाइनरी क्लिपबोर्ड सक्षम करें", description: "क्लिपबोर्ड पर बाइनरी डेटा (छवियों) की अनुमति दें।" },
                SELKIES_COMMAND_ENABLED: { label: "कमांड वेबसॉकेट सक्षम करें", description: "कमांड वेबसॉकेट संदेशों का पार्सिंग सक्षम करें।" },
                SELKIES_FILE_TRANSFERS: { label: "फ़ाइल स्थानांतरण", description: "अनुमत दिशाएँ ('upload,download', 'upload', 'download', 'none')।" },
                SELKIES_ENABLE_SHARING: { label: "सभी साझाकरण सक्षम करें", description: "सभी साझाकरण सुविधाओं के लिए मास्टर टॉगल।" },
                SELKIES_SECOND_SCREEN: { label: "दूसरी स्क्रीन सक्षम करें", description: "दूसरे मॉनिटर/डिस्प्ले के लिए समर्थन सक्षम करें।" },
                SELKIES_USE_BROWSER_CURSORS: { label: "ब्राउज़र कर्सर का उपयोग करें", description: "कैनवास पर रेंडर करने के बजाय ब्राउज़र सीएसएस कर्सर का उपयोग करें।" },
                SELKIES_USE_CSS_SCALING: { label: "सीएसएस स्केलिंग का उपयोग करें (LoDPI)", description: "यदि सत्य है, तो एक कम रिज़ॉल्यूशन भेजा जाता है और कैनवास को खींचा जाता है।" },
                SELKIES_IS_MANUAL_RESOLUTION_MODE: { label: "मैनुअल रिज़ॉल्यूशन मोड", description: "रिज़ॉल्यूशन को मैनुअल चौड़ाई/ऊंचाई मानों पर लॉक करें।" },
                SELKIES_MANUAL_WIDTH: { label: "मैनुअल चौड़ाई", description: "चौड़ाई को एक निश्चित मान पर लॉक करें। मैनुअल मोड को बाध्य करता है।" },
                SELKIES_MANUAL_HEIGHT: { label: "मैनुअल ऊंचाई", description: "ऊंचाई को एक निश्चित मान पर लॉक करें। मैनुअल मोड को बाध्य करता है।" },
                SELKIES_SCALING_DPI: { label: "यूआई स्केलिंग डीपीआई", description: "यूआई स्केलिंग के लिए डिफ़ॉल्ट डीपीआई।" },
                SELKIES_AUDIO_BITRATE: { label: "ऑडियो बिटरेट", description: "डिफ़ॉल्ट ऑडियो बिटरेट।" },
                SELKIES_ENCODER: { label: "एन्कोडर्स", description: "अल्पविराम से अलग किए गए एन्कोडर्स की सूची। पहला डिफ़ॉल्ट है।" },
                SELKIES_USE_CPU: { label: "सीपीयू एन्कोडिंग को बाध्य करें", description: "पिक्सेलफ्लक्स के लिए सीपीयू-आधारित एन्कोडिंग को बाध्य करें।" },
                SELKIES_FRAMERATE: { label: "फ्रेमरेट (रेंज या निश्चित)", description: "उदा., एक रेंज के लिए '8-120' या निश्चित के लिए '60'।" },
                SELKIES_H264_CRF: { label: "H.264 CRF (रेंज या निश्चित)", description: "उदा., एक रेंज के लिए '5-50' या निश्चित के लिए '25'।" },
                SELKIES_JPEG_QUALITY: { label: "JPEG गुणवत्ता (रेंज या निश्चित)", description: "उदा., एक रेंज के लिए '1-100' या निश्चित के लिए '60'।" },
                SELKIES_H264_FULLCOLOR: { label: "H.264 पूर्ण रंग", description: "पिक्सेलफ्लक्स एन्कोडर्स के लिए H.264 पूर्ण रंग रेंज सक्षम करें।" },
                SELKIES_H264_STREAMING_MODE: { label: "H.264 स्ट्रीमिंग (टर्बो) मोड", description: "H.264 कम-विलंबता स्ट्रीमिंग मोड सक्षम करें।" },
                SELKIES_USE_PAINT_OVER_QUALITY: { label: "पेंट-ओवर गुणवत्ता का उपयोग करें", description: "स्थिर दृश्यों के लिए उच्च-गुणवत्ता वाले पेंट-ओवर को सक्षम करें।" },
                SELKIES_PAINT_OVER_JPEG_QUALITY: { label: "पेंट-ओवर JPEG गुणवत्ता", description: "उदा., एक रेंज के लिए '1-100' या निश्चित के लिए '90'।" },
                SELKIES_H264_PAINTOVER_CRF: { label: "पेंट-ओवर H.264 CRF", description: "उदा., एक रेंज के लिए '5-50' या निश्चित के लिए '18'।" },
                SELKIES_H264_PAINTOVER_BURST_FRAMES: { label: "पेंट-ओवर बर्स्ट फ्रेम्स", description: "उदा., एक रेंज के लिए '1-30' या निश्चित के लिए '5'।" },
                HARDEN_DESKTOP: { label: "डेस्कटॉप को सुदृढ़ करें (प्रीसेट)", description: "DISABLE_OPEN_TOOLS, DISABLE_SUDO, और DISABLE_TERMINALS को सक्षम करता है।" },
                HARDEN_OPENBOX: { label: "विंडो मैनेजर को सुदृढ़ करें (प्रीसेट)", description: "DISABLE_CLOSE_BUTTON, DISABLE_MOUSE_BUTTONS, और HARDEN_KEYBINDS को सक्षम करता है। RESTART_APP को भी सक्षम करता है।" },
                DISABLE_OPEN_TOOLS: { label: "ओपन टूल्स अक्षम करें", description: "xdg-open और exo-open बाइनरी को अक्षम करता है।" },
                DISABLE_SUDO: { label: "sudo अक्षम करें", description: "sudo कमांड को अक्षम करता है।" },
                DISABLE_TERMINALS: { label: "टर्मिनल अक्षम करें", description: "सामान्य टर्मिनल एमुलेटर को अक्षम करता है।" },
                DISABLE_CLOSE_BUTTON: { label: "विंडो बंद करें बटन अक्षम करें", description: "विंडो शीर्षक बार से बंद करें बटन को हटाता है।" },
                DISABLE_MOUSE_BUTTONS: { label: "दायां/मध्य क्लिक अक्षम करें", description: "दायां-क्लिक और मध्य-क्लिक संदर्भ मेनू को अक्षम करता है।" },
                HARDEN_KEYBINDS: { label: "कीबाइंड्स को सुदृढ़ करें", description: "Alt+F4 जैसे डिफ़ॉल्ट ओपनबॉक्स कीबाइंड्स को अक्षम करता है।" },
                RESTART_APP: { label: "बंद होने पर ऐप पुनः आरंभ करें", description: "यदि मुख्य एप्लिकेशन बंद हो जाता है तो उसे स्वचालित रूप से पुनः आरंभ करता है।" },
                MAX_RES: { label: "अधिकतम रिज़ॉल्यूशन", description: "कंटेनर के लिए अधिकतम रिज़ॉल्यूशन, डिफ़ॉल्ट 16k है।" },
                START_DOCKER: { label: "डॉकर-इन-डॉकर प्रारंभ करें", description: "यदि गलत है, तो एक विशेषाधिकार प्राप्त कंटेनर DinD प्रारंभ नहीं करेगा।" },
                DISABLE_IPV6: { label: "IPv6 अक्षम करें", description: "यदि सत्य है, तो यह IPv6 को अक्षम कर देगा।" },
                DISABLE_ZINK: { label: "जिंक अक्षम करें", description: "यदि वीडियो कार्ड का पता चलता है तो जिंक पर्यावरण चर सेट न करें।" },
                DISABLE_DRI3: { label: "DRI3 अक्षम करें", description: "यदि वीडियो कार्ड का पता चलता है तो DRI3 त्वरण का उपयोग न करें।" },
                NO_DECOR: { label: "कोई विंडो सजावट नहीं", description: "PWA उपयोग के लिए विंडो सीमाओं के बिना एप्लिकेशन चलाएं।" },
                NO_FULL: { label: "कोई फ़ुलस्क्रीन नहीं", description: "एप्लिकेशन को स्वचालित रूप से फ़ुलस्क्रीन न करें।" },
                NO_GAMEPAD: { label: "गेमपैड इंजेक्शन अक्षम करें", description: "उपयोगकर्ता-स्थान गेमपैड इंटरपोज़र इंजेक्शन को अक्षम करें।" },
                SELKIES_DEBUG: { label: "सेल्कीज़ डिबगिंग सक्षम करें", description: "स्ट्रीमिंग घटकों के लिए डिबग लॉगिंग सक्षम करें।" },
            }
        },
        appLaboratory: {
            title: 'ऐप प्रयोगशाला',
            description: 'बेस ऐप के ऊपर परिवर्तनों को परत करके कस्टम एप्लिकेशन कॉन्फ़िगरेशन बनाएं और परीक्षण करें।',
            selectApp: 'ऐप चुनें',
            createNew: 'नया ऐप बनाएं',
            baseApp: 'बेस एप्लिकेशन',
            baseAppDescription: 'स्थापित एप्लिकेशन जिस पर आपका नया कस्टम ऐप आधारित होगा।',
            selectBase: 'एक बेस ऐप चुनें',
            customizationTitle: 'अनुकूलन',
            appName: 'ऐप का नाम',
            appIcon: 'ऐप आइकन',
            uploadIcon: 'आइकन अपलोड करें',
            autostartScriptLabel: 'कस्टम ऑटोस्टार्ट स्क्रिप्ट',
            permissionsTitle: 'अनुमतियाँ',
            usersLabel: 'अनुमत उपयोगकर्ता',
            groupsLabel: 'अनुमत समूह',
            launchButton: 'सहेजें और अनुकूलन सत्र लॉन्च करें',
            closeButton: 'सत्र बंद करें और अंतिम रूप दें',
            savingAndLaunching: 'सहेजा और लॉन्च किया जा रहा है...',
            placeholder: 'ऐप प्रयोगशाला आपको मौजूदा स्थापित एप्लिकेशन के आधार पर एप्लिकेशन के लिए बेस होम डायरेक्टरी और लॉन्च स्क्रिप्ट को कॉन्फ़िगर करने की अनुमति देती है। यह होम डायरेक्टरी उपयोगकर्ता के लिए पहली बार इनिट पर सभी फ़ाइलों और सेटिंग्स के साथ कॉपी की जाएगी जो आपने इस सत्र में सेटअप की हैं। आप इसकी सामग्री को और संशोधित करने के लिए मौजूदा प्रयोगशाला ऐप को फिर से लॉन्च कर सकते हैं।',
            formInvalid: 'कृपया एक बेस ऐप चुनें और नए ऐप के लिए एक नाम प्रदान करें।',
        },
        modals: {
            editUserTitle: 'उपयोगकर्ता संपादित करें: {username}',
            saveChanges: 'बदलाव सहेजें',
            effectiveSettings: 'प्रभावी सेटिंग्स (समूह ओवरराइड के साथ)',
            editGroupTitle: 'समूह संपादित करें: {groupName}',
            userConfigTitle: 'उपयोगकर्ता कॉन्फ़िगरेशन',
            warning: 'यह एकमात्र समय है जब यह कॉन्फ़िगरेशन दिखाया जाएगा। इसे उपयोगकर्ता को सुरक्षित रूप से प्रदान करें।',
            info: 'आप इस कॉन्फ़िगरेशन फ़ाइल को किसी अन्य डिवाइस पर आसानी से SealSkin सेट करने के लिए डाउनलोड कर सकते हैं। इस फ़ाइल को सुरक्षित रखें क्योंकि इसमें आपकी निजी कुंजी है।',
            configDataLabel: 'कॉन्फ़िगरेशन डेटा (JSON)',
            copyButton: 'टेक्स्ट कॉपी करें',
            downloadButton: 'फ़ाइल डाउनलोड करें',
            manageHomeDirs: 'होम डायरेक्टरी प्रबंधित करें',
            dirsForUser: 'उपयोगकर्ता के लिए डायरेक्टरी: {username}',
            dirsForAdmin: 'व्यवस्थापक के लिए डायरेक्टरी: {username}',
            newDirForUser: 'उपयोगकर्ता के लिए नई डायरेक्टरी बनाएं',
            createDirButton: 'डायरेक्टरी बनाएं',
            confirmDeleteDir: 'क्या आप वाकई उपयोगकर्ता \'{username}\' के लिए \'{homeName}\' को हटाना चाहते हैं? यह स्थायी है।',
            installAppTitle: '{appName} इंस्टॉल करें',
            editAppTitle: '{appName} संपादित करें',
            customNameLabel: 'कस्टम नाम',
            imageLabel: 'कंटेनर छवि',
            permissions: 'अनुमतियाँ',
            allowedUsersLabel: 'अनुमत उपयोगकर्ता (अल्पविराम से अलग, सभी के लिए \'all\')',
            allowedGroupsLabel: 'अनुमत समूह (अल्पविराम से अलग, सभी के लिए \'all\')',
            features: 'विशेषताएँ',
            gpuSupport: 'जीपीयू समर्थन',
            homeMounting: 'होम डायरेक्टरी माउंटिंग',
            urlSupport: 'यूआरएल खोलने का समर्थन',
            fileSupport: 'फ़ाइल खोलने का समर्थन',
            autoUpdate: 'छवि को स्वतः अपडेट करें',
            advancedSettings: 'उन्नत सेटिंग्स',
            appTemplateLabel: 'एप्लिकेशन टेम्पलेट',
            appTemplateDescription: 'उन्नत कंटेनर लॉन्च सेटिंग्स के लिए एक पूर्व-कॉन्फ़िगर टेम्पलेट चुनें।',
            customAutostartScriptLabel: 'कस्टम ऑटोस्टार्ट स्क्रिप्ट',
            customAutostartScriptDescription: 'ऑटोस्टार्ट तर्क को अनुकूलित करें, एप्लिकेशन प्रदाता से डिफ़ॉल्ट का उपयोग करने के लिए खाली छोड़ दें।',
            saveInstallation: 'इंस्टॉलेशन सहेजें',
            updateStatusTitle: '{appName} के लिए अपडेट स्थिति',
            checkingUpdates: 'अपडेट की जाँच हो रही है...',
            updateAvailable: 'एक नया छवि संस्करण उपलब्ध है!',
            yourVersion: 'आपका संस्करण: {sha}',
            latestAvailable: 'नवीनतम संस्करण रजिस्ट्री से खींचने के लिए उपलब्ध है।',
            pullLatest: 'नवीनतम छवि खींचें',
            upToDate: 'आपकी छवि अद्यतित है।',
            currentVersion: 'वर्तमान संस्करण: {sha}',
            errorChecking: 'अपडेट की जाँच में त्रुटि।',
            pullingLatest: 'नवीनतम छवि खींची जा रही है... इसमें कुछ समय लग सकता है।',
            pullComplete: 'खींचना पूरा हुआ!',
            newVersion: 'नया संस्करण: {sha}',
            errorPulling: 'छवि खींचने में त्रुटि।',
            manualInstallNote: "ध्यान दें: मैन्युअल रूप से जोड़ी गई छवियां selkies-baseimage संगत छवि पर आधारित होनी चाहिए।",
        },
        status: {
            loggingIn: 'लॉग इन हो रहा है...',
            configSaved: 'कॉन्फ़िगरेशन सफलतापूर्वक सहेजा गया!',
            configApplied: 'कॉन्फ़िगरेशन लागू किया गया! कृपया लॉगिन और परीक्षण करें।',
            configApplyFailed: 'कॉन्फ़िगरेशन लागू करने में विफल: {error}',
            fileReadError: 'फ़ाइल पढ़ने में त्रुटि।',
            noConfig: 'कृपया एक कॉन्फ़िग फ़ाइल या टेक्स्ट प्रदान करें।',
            loggedInAdmin: 'व्यवस्थापक के रूप में लॉग इन: {username}',
            loggedInUser: 'मानक उपयोगकर्ता के रूप में लॉग इन: {username}।',
            loginFailed: 'लॉगिन विफल: {error}',
            adminDataRefreshFailed: 'व्यवस्थापक डेटा को ताज़ा करने में विफल: {error}',
            logoutSuccess: 'लॉग आउट और कॉन्फ़िगरेशन साफ़ किया गया।',
            generateConfigFailed: 'कॉन्फ़िग उत्पन्न नहीं किया जा सका, उपयोगकर्ता विवरण गायब हैं।',
            copySuccess: 'कॉन्फ़िगरेशन क्लिपबोर्ड पर कॉपी किया गया!',
            copyFailed: 'टेक्स्ट कॉपी करने में विफल।',
            publicKeyCopied: 'सार्वजनिक कुंजी कॉपी की गई!',
            keyCopyFailed: 'कुंजी कॉपी करने में विफल।',
            creatingAdmin: 'व्यवस्थापक बनाया जा रहा है...',
            adminCreated: 'व्यवस्थापक \'{username}\' बनाया गया।',
            adminCreateFailed: 'व्यवस्थापक बनाने में त्रुटि: {error}',
            adminDeleted: 'व्यवस्थापक \'{username}\' सफलतापूर्वक हटा दिया गया।',
            adminDeleteFailed: 'व्यवस्थापक हटाने में त्रुटि: {error}',
            creatingUser: 'उपयोगकर्ता बनाया जा रहा है...',
            userCreated: 'उपयोगकर्ता \'{username}\' बनाया गया।',
            userCreateFailed: 'उपयोगकर्ता बनाने में त्रुटि: {error}',
            userDeleted: 'उपयोगकर्ता \'{username}\' सफलतापूर्वक हटा दिया गया।',
            userDeleteFailed: 'उपयोगकर्ता हटाने में त्रुटि: {error}',
            userUpdated: 'उपयोगकर्ता \'{username}\' सफलतापूर्वक अपडेट किया गया।',
            userUpdateFailed: 'उपयोगकर्ता अपडेट करने में त्रुटि: {error}',
            creatingGroup: 'समूह बनाया जा रहा है...',
            groupCreated: 'समूह \'{groupName}\' बनाया गया।',
            groupCreateFailed: 'समूह बनाने में त्रुटि: {error}',
            groupDeleted: 'समूह \'{groupName}\' सफलतापूर्वक हटा दिया गया।',
            groupDeleteFailed: 'समूह हटाने में त्रुटि: {error}',
            groupUpdated: 'समूह \'{groupName}\' सफलतापूर्वक अपडेट किया गया।',
            groupUpdateFailed: 'समूह अपडेट करने में त्रुटि: {error}',
            homedirLoadFailed: 'होम डायरेक्टरी लोड करने में विफल: {error}',
            homedirCreateFailed: 'डायरेक्टरी बनाने में त्रुटि: {error}',
            homedirCreated: 'होम डायरेक्टरी \'{homeName}\' बनाई गई।',
            homedirDeleted: 'डायरेक्टरी \'{homeName}\' हटा दी गई।',
            homedirDeleteFailed: 'डायरेक्टरी हटाने में त्रुटि: {error}',
            homedirCreatedFor: '{username} के लिए डायरेक्टरी \'{homeName}\' बनाई गई।',
            homedirDeletedFor: '{username} के लिए डायरेक्टरी \'{homeName}\' हटा दी गई।',
            sessionsLoadFailed: 'सत्र लोड करने में विफल: {error}',
            sessionStopError: 'सत्र रोकने में त्रुटि: {error}',
            sessionStopped: 'सत्र सफलतापूर्वक रोका गया।',
            appDataRefreshFailed: 'ऐप डेटा को ताज़ा करने में विफल: {error}',
            closingSession: 'अनुकूलन सत्र प्रतिबद्ध किया जा रहा है...',
            sessionClosed: 'अनुकूलन सत्र बंद हो गया।',
            sessionCloseFailed: 'अनुकूलन सत्र बंद करने में विफल: {error}',
            fetchingApps: 'स्टोर से ऐप्स प्राप्त किए जा रहे हैं...',
            fetchAppsFailed: 'स्टोर से ऐप्स प्राप्त करने में विफल: {error}',
            appStoreAddFailed: 'स्टोर जोड़ने में त्रुटि: {error}',
            appStoreAdded: 'ऐप स्टोर \'{name}\' जोड़ा गया।',
            appSaved: 'ऐप \'{name}\' सफलतापूर्वक {action}।',
            appSaveActions: {
                updated: 'अद्यतन किया गया',
                installed: 'स्थापित किया गया'
            },
            appSaveFailed: 'ऐप सहेजने में त्रुटि: {error}',
            appDeleted: 'ऐप \'{name}\' हटा दिया गया।',
            appDeleteFailed: 'ऐप हटाने में त्रुटि: {error}',
            templateSaved: 'टेम्पलेट \'{name}\' सफलतापूर्वक सहेजा गया।',
            templateSaveFailed: 'टेम्पलेट सहेजने में त्रुटि: {error}',
            templateDeleted: 'टेम्पलेट \'{name}\' सफलतापूर्वक हटा दिया गया।',
            templateDeleteFailed: 'टेम्पलेट हटाने में त्रुटि: {error}',
            pinRemoved: 'पिन किया गया व्यवहार हटाया गया।',
            keyGenerated: 'नई कुंजी जोड़ी उत्पन्न हुई।',
            keyGenFailed: 'कुंजी निर्माण विफल: {{error}}',
            pendingConfigSaved: 'लंबित कॉन्फ़िगरेशन सहेजा गया। अब आप अपने प्रशासक को अपनी सार्वजनिक कुंजी प्रदान कर सकते हैं।',
            settingsSaved: 'सेटिंग्स सहेजी गईं।',
            appCreated: 'ऐप \'{name}\' सफलतापूर्वक बनाया गया।',
            launchFailed: 'लॉन्च विफल: {error}',
        },
        placeholders: {
            noAdmins: 'कोई व्यवस्थापक नहीं मिला।',
            noUsers: 'कोई उपयोगकर्ता नहीं मिला।',
            noGroups: 'कोई समूह नहीं मिला।',
            noHomeDirs: 'कोई होम डायरेक्टरी नहीं मिली।',
            noSessions: 'कोई सक्रिय सत्र नहीं मिला।',
            noPinned: 'कोई पिन किया गया व्यवहार नहीं मिला।',
            errorLoading: 'डायरेक्टरी लोड करने में त्रुटि।',
            noInstalledApps: 'अभी तक कोई एप्लिकेशन इंस्टॉल नहीं किया गया है।',
        },
    },
    popup: {
        tabs: {
            launch: 'नया लॉन्च करें',
            sessions: 'सक्रिय सत्र',
            manageFiles: 'फ़ाइलें प्रबंधित करें',
            uploadStorage: 'भंडारण में अपलोड करें',
            uploadFiles: 'फ़ाइलें अपलोड करें',
            uploadFilesTitle: 'समर्पित फ़ाइल अपलोड पृष्ठ खोलें'
        },
        launchView: {
            searchPlaceholder: 'एप्लिकेशन खोजें...',
            uploadingFile: 'फ़ाइल अपलोड हो रही है...',
            gpuLabel: 'GPU',
            storageLabel: 'भंडारण',
            languageLabel: 'भाषा',
            cleanroom: 'क्लीनरूम (अस्थायी)',
            noGpu: 'कोई नहीं',
            saveOptions: 'इन लॉन्च विकल्पों को सहेजें',
            saveOptionsForUrl: 'सभी URL के लिए विकल्प सहेजें',
            saveOptionsForFile: '.{extension} फ़ाइलों के लिए विकल्प सहेजें',
            openFile: 'लॉन्च पर फ़ाइल खोलें',
            launchButton: 'लॉन्च करें',
            launchingButton: 'लॉन्च हो रहा है...',
            uploadingButton: 'अपलोड हो रहा है...',
            autoHome: 'ऑटो (प्रति-ऐप दृढ़ता)',
            collaborationMode: 'सहयोगी सत्र',
            waylandMode: 'Wayland मोड',
        },
        sessionsView: {
            noSessions: 'कोई सक्रिय सत्र नहीं मिला।',
        },
        uploadStorageView: {
            selectHome: 'होम डायरेक्टरी चुनें',
            description: 'यह फ़ाइल <strong>{filename}</strong> को भविष्य में उपयोग के लिए सीधे आपके फ़ाइल स्टोरेज में अपलोड करेगा।',
            descriptionFallback: 'यह फ़ाइल <strong>{filename}</strong> को भविष्य में उपयोग के लिए सीधे आपके फ़ाइल स्टोरेज में अपलोड करेगा।',
            uploadButton: 'फ़ाइल अपलोड करें',
            uploadingButton: 'अपलोड हो रहा है...',
            preparing: 'फ़ाइल तैयार हो रही है...',
            uploadingChunk: 'हिस्सा {current} का {total} अपलोड हो रहा है...',
            finalizing: 'अंतिम रूप दिया जा रहा है...',
            uploadComplete: 'अपलोड पूरा हुआ!',
        },
        status: {
            unconfigured: 'कृपया विकल्प पृष्ठ के माध्यम से एक्सटेंशन को कॉन्फ़िगर करें।',
            openingServerFile: "सर्वर-साइड फ़ाइल खोली जा रही है: {filename}",
            openingFile: 'फ़ाइल खोली जा रही है: {filename}',
            openingUrl: 'यूआरएल खोला जा रहा है: {targetUrl}',
            error: 'त्रुटि: {message}',
            preparingFile: 'फ़ाइल तैयार हो रही है...',
            sendingFile: 'सत्र में फ़ाइल भेजी जा रही है...',
            errorSendingFile: 'फ़ाइल भेजने में त्रुटि: {message}',
            errorClosingSession: 'सत्र बंद करने में त्रुटि: {message}',
            preparingSession: 'पृथक सत्र तैयार हो रहा है...',
            fetchingData: 'फ़ाइल डेटा प्राप्त किया जा रहा है...',
            fetchDataFailed: 'फ़ाइल डेटा प्राप्त करने में विफल: {statusText}',
            unknownAction: 'अज्ञात लॉन्च क्रिया।',
            noAppSelected: 'कृपया एक एप्लिकेशन चुनें।',
            noAppsAvailable: 'आपके खाते के लिए कोई एप्लिकेशन उपलब्ध नहीं है।',
            uploadSuccess: 'फ़ाइल सफलतापूर्वक अपलोड हुई!',
            creatingAutoHome: 'स्वचालित होम डायरेक्टरी बना रहा है...',
        },
        languages: {
            default: 'डिफ़ॉल्ट ({locale})'
        }
    },
    upload: {
        title: 'फ़ाइल अपलोड',
        description: 'इसे एक सुरक्षित, पृथक सत्र में खोलने के लिए अपने कंप्यूटर से एक फ़ाइल चुनें।',
        dropzone: {
            title: 'एक फ़ाइल यहाँ खींचें और छोड़ें',
            or: 'या',
            button: 'फ़ाइल चुनें',
        },
        confirm: {
            ready: 'फ़ाइल सुरक्षित रूप से खोले जाने के लिए तैयार है।',
            button: 'लॉन्च करने के लिए जारी रखें',
        }
    },
    files: {
        title: 'SealSkin फ़ाइलें',
        header: {
            title: 'फ़ाइलें',
            newFolder: 'नया फ़ोल्डर',
            uploadFiles: 'फ़ाइलें अपलोड करें',
            uploadFolder: 'फ़ोल्डर अपलोड करें'
        },
        sidebar: {
            sharedFiles: 'SealSkin फ़ाइलें',
            publicShares: 'सार्वजनिक शेयर'
        },
        shares: {
            title: 'सार्वजनिक रूप से साझा की गई फ़ाइलें',
            searchPlaceholder: 'फ़ाइल नाम या आईडी द्वारा खोजें...'
        },
        table: {
            name: 'नाम',
            size: 'आकार',
            lastModified: 'अंतिम संशोधित',
            created: 'बनाया गया',
            expires: 'समाप्त होता है',
            url: 'सार्वजनिक URL',
            passwordProtected: 'पासवर्ड'
        },
        dropzone: {
            title: 'अपलोड करने के लिए फ़ाइलें यहाँ छोड़ें'
        },
        pagination: {
            previous: '« पिछला',
            next: 'अगला »',
            pageOf: 'पेज {page} / {totalPages}'
        },
        modals: {
            newFolder: {
                title: 'नया फ़ोल्डर बनाएँ',
                folderNameLabel: 'फ़ोल्डर का नाम',
                nameTitle: 'केवल अक्षर, संख्या, अंडरस्कोर, हाइफ़न, या अवधि का उपयोग करें।',
                createButton: 'बनाएँ'
            },
            confirmDelete: {
                title: 'हटाने की पुष्टि करें',
                message: 'क्या आप वाकई {count, plural, one {1 चयनित आइटम} other {{count} चयनित आइटम}} हटाना चाहते हैं? यह क्रिया पूर्ववत नहीं की जा सकती।',
                messageDefault: 'क्या आप वाकई चयनित आइटम हटाना चाहते हैं? यह क्रिया पूर्ववत नहीं की जा सकती।'
            },
            uploadProgress: {
                title: 'अपलोड प्रगति',
                doneButton: 'हो गया'
            },
            share: {
                title: 'फ़ाइल साझा करें',
                sharingFile: 'फ़ाइल साझा की जा रही है: <strong>{filename}</strong>',
                passwordLabel: 'पासवर्ड (वैकल्पिक)',
                passwordPlaceholder: 'बिना पासवर्ड के लिए खाली छोड़ दें',
                expiryLabel: 'समाप्त होने में (घंटे, वैकल्पिक)',
                expiryPlaceholder: 'उदा., एक दिन के लिए 24',
                shareButton: 'शेयर लिंक बनाएं'
            }
        },
        status: {
            homeDirLoadFailed: 'होम निर्देशिका लोड करने में विफल: {error}',
            filesLoadFailed: 'फ़ाइलें लोड करने में त्रुटि: {error}',
            deleteProtectedError: 'संरक्षित सिस्टम फ़ोल्डर नहीं हटा सकते।',
            deletingItems: '{count, plural, one {1 आइटम} other {{count} आइटम}} हटा रहा है...',
            deleteSuccess: 'सफलतापूर्वक हटाया गया।',
            deleteFailed: 'हटाने में विफल: {error}',
            preparingUpload: '{count, plural, one {1 फ़ाइल} other {{count} फ़ाइलें}} अपलोड करने की तैयारी कर रहा है...',
            uploadPrepFailed: 'फ़ोल्डर अपलोड की तैयारी के दौरान त्रुटि: {error}',
            notConfigured: 'त्रुटि: SealSkin कॉन्फ़िगर नहीं है। कृपया विकल्पों में सेटअप करें।',
            folderCreated: 'फ़ोल्डर \'{folderName}\' बनाया गया।',
            folderCreateFailed: 'फ़ोल्डर बनाने में त्रुटि: {error}',
            shareCreated: 'शेयर सफलतापूर्वक बनाया गया! लिंक आपके क्लिपबोर्ड पर कॉपी कर लिया गया है।',
            shareCreateFailed: 'शेयर बनाने में विफल: {error}',
            sharesLoadFailed: 'साझा की गई फ़ाइलों को लोड करने में विफल: {error}',
            shareDeleteFailed: 'शेयर हटाने में विफल: {error}',
            shareDeleted: 'शेयर सफलतापूर्वक हटा दिया गया।',
            urlCopied: 'सार्वजनिक URL क्लिपबोर्ड पर कॉपी किया गया।'
        },
        placeholders: {
            errorLoading: 'फ़ाइलें लोड करने में त्रुटि।',
            folderEmpty: 'यह फ़ोल्डर खाली है।',
            noHomeDirs: 'कोई होम निर्देशिका उपलब्ध नहीं है।',
            noShares: 'आपने अभी तक कोई फ़ाइल साझा नहीं की है।'
        },
        uploadStatus: {
            pending: 'लंबित',
            initiating: 'शुरू हो रहा है...',
            uploading: 'अपलोड हो रहा है...',
            finalizing: 'अंतिम रूप दिया जा रहा है...',
            completed: 'पूरा हुआ',
            error: 'त्रुटि'
        }
    }
};

// --- Portuguese Translations ---
const pt = {
    background: {
        contextMenu: {
            openUrl: 'Abrir link no SealSkin',
            openFile: 'Abrir destino do link como arquivo no SealSkin',
            sendMedia: 'Enviar mídia para o SealSkin',
            searchText: 'Pesquisar por "%s" no SealSkin',
            sendDownload: 'Enviar próximo download para o SealSkin'
        }
    },
    common: {
        actions: 'Ações',
        active: 'Ativo',
        cancel: 'Cancelar',
        manage: 'Gerenciar',
        delete: 'Excluir',
        edit: 'Editar',
        save: 'Salvar',
        none: 'nenhum',
        error: 'Erro',
        na: 'N/D',
        of: 'de',
        status: 'Status',
        username: 'Nome de usuário',
        group: 'Grupo',
        groups: 'Grupos',
        publicKey: 'Chave Pública',
        name: 'Nome',
        source: 'Fonte',
        imageVersion: 'Versão da Imagem',
        language: 'Idioma',
        storage: 'Armazenamento',
        gpu: 'GPU',
        version: 'Versão',
        checked: 'Verificado',
        never: 'Nunca',
        stop: 'Parar',
        reopen: 'Reabrir',
        sendFile: 'Enviar Arquivo',
        share: 'Compartilhar',
        search: 'Pesquisar',
        refresh: 'Atualizar',
        close: 'Fechar',
        copy: 'Copiar',
        open: "Abrir",
        copyUrl: 'Copiar URL',
        download: 'Baixar',
        next: 'Próximo',
        previous: 'Anterior',
        page: 'Página',
        home: 'Diretório Home',
        homes: 'Diretórios Home',
        sessions: 'Sessões',
        users: 'Usuários',
        admins: 'Admins',
        yes: 'Sim',
        no: 'Não',
        daysAgo: '{count, plural, one {há 1 dia} other {há {count} dias}}',
        hoursAgo: '{count, plural, one {há 1 hora} other {há {count} horas}}',
        minutesAgo: '{count, plural, one {há 1 minuto} other {há {count} minutos}}',
        justNow: 'agora mesmo',
        bytes: 'Bytes',
        kb: 'KB',
        mb: 'MB',
        gb: 'GB',
        tb: 'TB',
        pb: 'PB',
    },
    options: {
        sidebar: {
            config: 'Configuração',
            home: 'Diretórios Home',
            sessions: 'Sessões Ativas',
            pinned: 'Comportamento Fixo',
            appStore: 'Loja de Aplicativos',
            appTemplates: 'Modelos de Aplicativos',
            appLaboratory: 'Laboratório de Aplicativos',
            installedApps: 'Aplicativos Instalados',
            users: 'Usuários',
            groups: 'Grupos',
            admins: 'Admins',
        },
        dashboard: {
            title: 'Painel',
            clientSettings: 'Configurações do Cliente',
            exportConfig: 'Exportar Configuração',
            userStatus: 'Status do Usuário',
            loggedInAs: 'Logado como:',
            role: 'Função',
            roleAdmin: 'Administrador',
            roleUser: 'Usuário Padrão',
            serverInfo: 'Informações do Servidor',
            server: 'Servidor:',
            cpuModel: 'Modelo da CPU:',
            storageUsage: 'Uso de Armazenamento:',
            detectedGpus: 'GPUs Detectadas:',
            logout: 'Sair e Limpar Configuração',
            howTo: 'Como Usar o SealSkin',
            howToDescription: 'Esta seção contém documentação básica sobre como usar a extensão.',
            howToList: [
                '<strong>Para abrir conteúdo isoladamente:</strong> Clique com o botão direito em qualquer link, imagem ou texto selecionado e escolha uma opção no menu de contexto "Isolamento SealSkin".',
                '<strong>Para enviar um download para isolamento:</strong> Clique com o botão direito na página e selecione "Enviar Próximo Download para Isolamento". O próximo arquivo que você baixar será interceptado e enviado para uma sessão segura.',
                '<strong>Para iniciar um aplicativo limpo:</strong> Clique no ícone do SealSkin na barra de ferramentas do seu navegador.',
                '<strong>Para gerenciar armazenamento persistente:</strong> Use a aba "Diretórios Home" nesta página para criar e excluir volumes de armazenamento que podem ser usados em várias sessões.',
                '<strong>Para salvar opções de inicialização:</strong> Marque a caixa "Salvar estas opções de inicialização" no pop-up antes de iniciar um aplicativo para um tipo de arquivo específico (ex., .pdf) ou para todas as URLs. Gerencie essas preferências salvas na aba "Comportamento Fixo".'
            ],
            confirmLogout: 'Tem certeza de que deseja sair? Isso limpará sua configuração salva deste navegador.',
        },
        config: {
            quickSetup: 'Configuração Rápida',
            quickSetupDescription: 'Faça o upload do arquivo de configuração (.json) fornecido pelo seu administrador, ou cole o conteúdo abaixo para configurar automaticamente a extensão.',
            uploadLabel: 'Carregar Arquivo de Configuração',
            pasteLabel: 'Ou Cole o Texto de Configuração',
            pastePlaceholder: 'Cole sua configuração JSON aqui...',
            applyButton: 'Aplicar Configuração',
            manualLink: 'Configuração Manual',
            advancedTitle: 'Configuração do Cliente (Avançado)',
            serverIpLabel: 'IP ou Domínio do Servidor',
            serverIpPlaceholder: 'ex., 192.168.1.100',
            apiPortLabel: 'Porta da API',
            apiPortPlaceholder: 'ex., 8000',
            sessionPortLabel: 'Porta da Sessão',
            sessionPortPlaceholder: 'ex., 8443',
            usernameLabel: 'Nome de usuário',
            usernamePlaceholder: 'Seu nome de usuário',
            privateKeyLabel: 'Sua Chave Privada (Formato PEM)',
            privateKeyPlaceholder: 'Cole o conteúdo da sua chave privada aqui',
            serverKeyLabel: 'Chave Pública do Servidor (Formato PEM)',
            serverKeyPlaceholder: 'Cole o conteúdo do server_public.pem aqui',
            searchEngineLabel: 'Mecanismo de Busca Padrão para Texto Selecionado',
            saveButton: 'Salvar Configuração',
            loginButton: 'Login e Teste',
            automaticLink: 'Configuração Automática',
            chooseFile: 'Escolher Arquivo',
            keyGeneration: 'Geração de Chave',
            keyGenDescription: 'Se você não tiver um par de chaves, pode gerar um aqui. A chave privada será preenchida acima. Forneça a chave pública ao seu administrador.',
            generateKeyButton: 'Gerar Novo Par de Chaves',
            publicKeyForAdminLabel: 'Sua Chave Pública (para o admin)',
        },
        home: {
            title: 'Seus Diretórios Home',
            description: 'Crie diretórios de armazenamento persistente para usar entre sessões. Eles serão montados em seus aplicativos como seu diretório de configuração.',
            newTitle: 'Criar Novo Diretório Home',
            nameLabel: 'Nome do Diretório:',
            namePlaceholder: 'ex., meus-arquivos-de-projeto',
            nameTitle: 'Use apenas letras, números, sublinhado ou hífen.',
            createButton: 'Criar Diretório',
            isLaboratory: 'Este é um aplicativo de Laboratório, construído a partir de uma imagem base com configurações personalizadas.',
            laboratory: 'Laboratório',
            confirmDelete: 'Tem certeza de que deseja excluir o aplicativo instalado \'{appName}\'?'
        },
        sessions: {
            title: 'Sessões Ativas',
            application: 'Aplicativo',
            started: 'Iniciado',
            noSessionsUser: 'Nenhuma sessão ativa encontrada.',
            noSessionsAdmin: 'Nenhuma sessão ativa encontrada para nenhum usuário.',
            sessionsFor: 'Sessões para {username} ({count})',
            confirmStop: 'Tem certeza de que deseja parar esta sessão? O contêiner será destruído.',
        },
        pinned: {
            title: 'Comportamento Fixo da Extensão',
            description: 'Esta tabela mostra as opções de inicialização que você salvou para tipos de arquivo específicos ou para todas as URLs. Você pode remover um comportamento fixo para ser solicitado novamente pelas opções de inicialização.',
            trigger: 'Gatilho',
            savedApp: 'Aplicativo Salvo',
            triggerSimple: 'Inicialização Simples (Botão da Barra de Ferramentas)',
            triggerUrl: 'Todas as URLs (do menu de contexto)',
            triggerFile: 'Tipo de Arquivo: <strong>{fileType}</strong>',
            unknownApp: 'Aplicativo Desconhecido ({appId}...)'
        },
        admins: {
            serverKeyTitle: 'Chave Pública do Servidor',
            serverKeyDescription: 'Esta é a chave pública que os arquivos de configuração do usuário precisarão para se conectar a este servidor.',
            title: 'Gerenciamento de Admins',
            searchPlaceholder: 'Pesquisar admins...',
            newTitle: 'Criar Novo Admin',
            publicKeyOptionalLabel: 'Chave Pública (Opcional):',
            publicKeyPlaceholder: 'Cole a chave pública aqui, ou deixe em branco para gerar uma.',
            createButton: 'Criar Admin',
            confirmDelete: 'Tem certeza de que deseja excluir o admin \'{username}\'? Isso também excluirá todo o seu armazenamento persistente e não pode ser desfeito.',
        },
        users: {
            title: 'Gerenciamento de Usuários',
            searchPlaceholder: 'Pesquisar usuários por nome ou grupo...',
            newTitle: 'Criar Novo Usuário',
            publicKeyOptionalLabel: 'Chave Pública (Opcional):',
            publicKeyPlaceholder: 'Cole a chave pública do usuário aqui, ou deixe em branco para gerar uma.',
            settingsTitle: 'Configurações do Usuário',
            sessionLimitLabel: 'Limite de sessões',
            sessionLimitTitle: 'Número de sessões ativas que um usuário pode ter. -1 para ilimitado.',
            permissionsTitle: 'Permissões e Reforço',
            activeAccount: 'Conta Ativa',
            allowStorage: 'Permitir Armazenamento Persistente',
            allowGpu: 'Permitir Acesso à GPU',
            hardenContainer: 'Reforçar Contêiner',
            hardenWm: 'Reforçar Gerenciador de Janelas',
            createButton: 'Criar Usuário',
            homesDisabledTooltip: 'Armazenamento persistente desativado para este usuário',
            confirmDelete: 'Tem certeza de que deseja excluir o usuário \'{username}\'? Isso também excluirá todo o seu armazenamento persistente e não pode ser desfeito.',
            allowPublicSharing: 'Permitir Compartilhamento Público de Arquivos',
        },
        groups: {
            title: 'Gerenciamento de Grupos',
            searchPlaceholder: 'Pesquisar grupos...',
            newTitle: 'Criar Novo Grupo',
            nameLabel: 'Nome do Grupo:',
            overrideTitle: 'Configurações de Sobrescrita do Grupo',
            permissionsTitle: 'Sobrescritas de Permissões e Reforço',
            createButton: 'Criar Grupo',
            confirmDelete: 'Tem certeza de que deseja excluir o grupo \'{groupName}\'? Os usuários neste grupo reverterão para suas configurações individuais.',
        },
        installedApps: {
            title: 'Aplicativos Instalados',
            searchPlaceholder: 'Pesquisar aplicativos instalados...',
            noAppsFound: 'Nenhum aplicativo instalado encontrado.',
            pulling: 'Puxando nova imagem...',
            notLocal: 'Imagem não encontrada localmente',
            confirmDelete: 'Tem certeza de que deseja excluir o aplicativo instalado \'{appName}\'?',
        },
        appStore: {
            title: 'Lojas de Aplicativos',
            refreshTitle: 'Atualizar loja selecionada',
            selectLabel: 'Selecionar Loja de Aplicativos',
            addLabel: 'Adicionar Nova Loja de Aplicativos',
            namePlaceholder: 'Nome da Loja',
            urlPlaceholder: 'URL YAML da Loja',
            availableTitle: 'Aplicativos Disponíveis',
            addManual: "Adicionar Aplicativo Manual",
            searchPlaceholder: 'Pesquisar aplicativos disponíveis...',
            noAppsFound: 'Nenhum aplicativo encontrado.',
            availableFrom: 'Aplicativos Disponíveis de {storeName}',
            couldNotLoad: 'Não foi possível carregar os aplicativos desta loja.',
        },
        appTemplates: {
            title: 'Editor de Modelos de Aplicativo',
            loadLabel: 'Carregar Modelo',
            createOption: 'Criar Novo Modelo',
            nameLabel: 'Nome do Modelo',
            namePlaceholder: 'Digite um nome para o novo modelo',
            saveButton: 'Salvar Perfil',
            deleteButton: 'Excluir',
            previewTitle: 'Pré-visualização da UI',
            contentArea: 'Área de Conteúdo do Aplicativo',
            confirmDelete: 'Tem certeza de que deseja excluir o modelo \'{templateName}\'? Esta ação não pode ser desfeita.',
            deleteDisabled: 'Este modelo não pode ser excluído.',
            enterName: 'Por favor, insira um nome para o novo modelo.',
            settings: {
                TITLE: { label: "Título da Página", description: "O título da página exibido no navegador web." },
                SELKIES_UI_TITLE: { label: "Título da Barra Lateral", description: "Título no canto superior esquerdo da barra lateral." },
                SELKIES_UI_SHOW_SIDEBAR: { label: "Exibir Barra Lateral", description: "Exibir a interface principal da barra lateral." },
                SELKIES_UI_SHOW_LOGO: { label: "Exibir Logo", description: "Exibir o logo Selkies na barra lateral." },
                SELKIES_UI_SHOW_CORE_BUTTONS: { label: "Exibir Botões Principais", description: "Exibir os botões dos componentes principais (tela, áudio, etc)." },
                SELKIES_UI_SIDEBAR_SHOW_VIDEO_SETTINGS: { label: "Exibir Configurações de Vídeo", description: "Exibir a seção de configurações de vídeo na barra lateral." },
                SELKIES_UI_SIDEBAR_SHOW_SCREEN_SETTINGS: { label: "Exibir Configurações de Tela", description: "Exibir a seção de configurações de tela na barra lateral." },
                SELKIES_UI_SIDEBAR_SHOW_AUDIO_SETTINGS: { label: "Exibir Configurações de Áudio", description: "Exibir a seção de configurações de áudio na barra lateral." },
                SELKIES_UI_SIDEBAR_SHOW_STATS: { label: "Exibir Estatísticas", description: "Exibir a seção de estatísticas na barra lateral." },
                SELKIES_UI_SIDEBAR_SHOW_CLIPBOARD: { label: "Exibir Área de Transferência", description: "Exibir a seção da área de transferência na barra lateral." },
                SELKIES_UI_SIDEBAR_SHOW_FILES: { label: "Exibir Seção de Arquivos", description: "Exibir a seção de transferência de arquivos na barra lateral." },
                SELKIES_UI_SIDEBAR_SHOW_APPS: { label: "Exibir Seção de Aplicativos", description: "Exibir a seção de aplicativos na barra lateral." },
                SELKIES_UI_SIDEBAR_SHOW_SHARING: { label: "Exibir Seção de Compartilhamento", description: "Exibir a seção de compartilhamento na barra lateral." },
                SELKIES_UI_SIDEBAR_SHOW_GAMEPADS: { label: "Exibir Seção de Gamepads", description: "Exibir a seção de gamepads na barra lateral." },
                SELKIES_UI_SIDEBAR_SHOW_KEYBOARD_BUTTON: { label: "Exibir Botão de Teclado", description: "Exibir o botão do teclado na tela." },
                SELKIES_UI_SIDEBAR_SHOW_SOFT_BUTTONS: { label: "Exibir Botões Virtuais", description: "Exibir a seção de botões virtuais (para celular)." },
                WATERMARK_PNG: { label: "Caminho do PNG da Marca D'água", description: "Caminho completo dentro do contêiner para um png de marca d'água." },
                WATERMARK_LOCATION: { label: "Localização da Marca D'água", description: "Onde pintar a imagem sobre o stream.", options: { disabled: "Desativado", topLeft: "Superior-Esquerdo", topRight: "Superior-Direito", bottomLeft: "Inferior-Esquerdo", bottomRight: "Inferior-Direito", centered: "Centralizado", animated: "Animado" } },
                DASHBOARD: { label: "Estilo do Painel", description: "Permite ao usuário definir seu painel.", options: { default: "Padrão", selkiesDefault: "Selkies (Padrão)", zinc: "Zinc", wish: "Wish" } },
                SELKIES_AUDIO_ENABLED: { label: "Habilitar Áudio", description: "Habilitar streaming de áudio do servidor para o cliente." },
                SELKIES_MICROPHONE_ENABLED: { label: "Habilitar Microfone", description: "Habilitar encaminhamento de microfone do cliente para o servidor." },
                SELKIES_GAMEPAD_ENABLED: { label: "Habilitar Gamepad", description: "Habilitar suporte a gamepad." },
                SELKIES_CLIPBOARD_ENABLED: { label: "Habilitar Área de Transferência", description: "Habilitar sincronização da área de transferência." },
                SELKIES_ENABLE_BINARY_CLIPBOARD: { label: "Habilitar Área de Transferência Binária", description: "Permitir dados binários (imagens) na área de transferência." },
                SELKIES_COMMAND_ENABLED: { label: "Habilitar Websocket de Comando", description: "Habilitar a análise de mensagens do websocket de comando." },
                SELKIES_FILE_TRANSFERS: { label: "Transferências de Arquivos", description: "Direções permitidas ('upload,download', 'upload', 'download', 'none')." },
                SELKIES_ENABLE_SHARING: { label: "Habilitar Todo o Compartilhamento", description: "Interruptor mestre para todos os recursos de compartilhamento." },
                SELKIES_SECOND_SCREEN: { label: "Habilitar Segunda Tela", description: "Habilitar suporte para um segundo monitor/tela." },
                SELKIES_USE_BROWSER_CURSORS: { label: "Usar Cursores do Navegador", description: "Usar cursores CSS do navegador em vez de renderizar no canvas." },
                SELKIES_USE_CSS_SCALING: { label: "Usar Escalonamento CSS (LoDPI)", description: "Se verdadeiro, uma resolução mais baixa é enviada e o canvas é esticado." },
                SELKIES_IS_MANUAL_RESOLUTION_MODE: { label: "Modo de Resolução Manual", description: "Bloquear a resolução nos valores de largura/altura manuais." },
                SELKIES_MANUAL_WIDTH: { label: "Largura Manual", description: "Bloquear a largura para um valor fixo. Força o modo manual." },
                SELKIES_MANUAL_HEIGHT: { label: "Altura Manual", description: "Bloquear a altura para um valor fixo. Força o modo manual." },
                SELKIES_SCALING_DPI: { label: "DPI de Escalonamento da UI", description: "O DPI padrão para o escalonamento da UI." },
                SELKIES_AUDIO_BITRATE: { label: "Taxa de Bits de Áudio", description: "A taxa de bits de áudio padrão." },
                SELKIES_ENCODER: { label: "Codificadores", description: "Lista de codificadores separados por vírgula. O primeiro é o padrão." },
                SELKIES_USE_CPU: { label: "Forçar Codificação por CPU", description: "Forçar codificação baseada em CPU para o pixelflux." },
                SELKIES_FRAMERATE: { label: "Taxa de Quadros (Intervalo ou Fixo)", description: "ex., '8-120' para um intervalo ou '60' para fixo." },
                SELKIES_H264_CRF: { label: "CRF H.264 (Intervalo ou Fixo)", description: "ex., '5-50' para um intervalo ou '25' para fixo." },
                SELKIES_JPEG_QUALITY: { label: "Qualidade JPEG (Intervalo ou Fixo)", description: "ex., '1-100' para um intervalo ou '60' para fixo." },
                SELKIES_H264_FULLCOLOR: { label: "Cor Completa H.264", description: "Habilitar a gama completa de cores H.264 para codificadores pixelflux." },
                SELKIES_H264_STREAMING_MODE: { label: "Modo de Streaming H.264 (Turbo)", description: "Habilitar o modo de streaming de baixa latência H.264." },
                SELKIES_USE_PAINT_OVER_QUALITY: { label: "Usar Qualidade de Repintura", description: "Habilitar repintura de alta qualidade para cenas estáticas." },
                SELKIES_PAINT_OVER_JPEG_QUALITY: { label: "Qualidade JPEG de Repintura", description: "ex., '1-100' para um intervalo ou '90' para fixo." },
                SELKIES_H264_PAINTOVER_CRF: { label: "CRF H.264 de Repintura", description: "ex., '5-50' para um intervalo ou '18' para fixo." },
                SELKIES_H264_PAINTOVER_BURST_FRAMES: { label: "Quadros de Rajada de Repintura", description: "ex., '1-30' para um intervalo ou '5' para fixo." },
                HARDEN_DESKTOP: { label: "Reforçar Desktop (Predefinição)", description: "Habilita DISABLE_OPEN_TOOLS, DISABLE_SUDO e DISABLE_TERMINALS." },
                HARDEN_OPENBOX: { label: "Reforçar Gerenciador de Janelas (Predefinição)", description: "Habilita DISABLE_CLOSE_BUTTON, DISABLE_MOUSE_BUTTONS e HARDEN_KEYBINDS. Também habilita RESTART_APP." },
                DISABLE_OPEN_TOOLS: { label: "Desabilitar Ferramentas de Abertura", description: "Desabilita os binários xdg-open e exo-open." },
                DISABLE_SUDO: { label: "Desabilitar Sudo", description: "Desabilita o comando sudo." },
                DISABLE_TERMINALS: { label: "Desabilitar Terminais", description: "Desabilita emuladores de terminal comuns." },
                DISABLE_CLOSE_BUTTON: { label: "Desabilitar Botão de Fechar Janela", description: "Remove o botão de fechar das barras de título das janelas." },
                DISABLE_MOUSE_BUTTONS: { label: "Desabilitar Clique Direito/Meio", description: "Desabilita menus de contexto de clique direito e do meio." },
                HARDEN_KEYBINDS: { label: "Reforçar Atalhos de Teclado", description: "Desabilita atalhos de teclado padrão do Openbox como Alt+F4." },
                RESTART_APP: { label: "Reiniciar App ao Fechar", description: "Reinicia automaticamente o aplicativo principal se ele for fechado." },
                MAX_RES: { label: "Resolução Máxima", description: "Resolução máxima para o contêiner, o padrão é 16k." },
                START_DOCKER: { label: "Iniciar Docker-in-Docker", description: "Se falso, um contêiner privilegiado não iniciará o DinD." },
                DISABLE_IPV6: { label: "Desabilitar IPv6", description: "Se verdadeiro, isso desabilitará o IPv6." },
                DISABLE_ZINK: { label: "Desabilitar Zink", description: "Não definir variáveis de ambiente Zink se uma placa de vídeo for detectada." },
                DISABLE_DRI3: { label: "Desabilitar DRI3", description: "Não usar aceleração DRI3 se uma placa de vídeo for detectada." },
                NO_DECOR: { label: "Sem Decorações de Janela", description: "Executar aplicativo sem bordas de janela para uso PWA." },
                NO_FULL: { label: "Sem Tela Cheia", description: "Não colocar aplicativos em tela cheia automaticamente." },
                NO_GAMEPAD: { label: "Desabilitar Injeção de Gamepad", description: "Desabilitar a injeção do interpositor de gamepad no espaço do usuário." },
                SELKIES_DEBUG: { label: "Habilitar Depuração Selkies", description: "Habilitar registro de depuração para componentes de streaming." },
            }
        },
        appLaboratory: {
            title: 'Laboratório de Aplicativos',
            description: 'Crie e teste configurações de aplicativos personalizadas sobrepondo alterações em um aplicativo base.',
            selectApp: 'Selecionar Aplicativo',
            createNew: 'Criar Novo Aplicativo',
            baseApp: 'Aplicativo Base',
            baseAppDescription: 'O aplicativo instalado no qual seu novo aplicativo personalizado será baseado.',
            selectBase: 'Selecione um Aplicativo Base',
            customizationTitle: 'Personalização',
            appName: 'Nome do Aplicativo',
            appIcon: 'Ícone do Aplicativo',
            uploadIcon: 'Carregar Ícone',
            autostartScriptLabel: 'Script de Autoinicialização Personalizado',
            permissionsTitle: 'Permissões',
            usersLabel: 'Usuários Permitidos',
            groupsLabel: 'Grupos Permitidos',
            launchButton: 'Salvar e Iniciar Sessão de Personalização',
            closeButton: 'Fechar Sessão e Finalizar',
            savingAndLaunching: 'Salvando e Iniciando...',
            placeholder: 'O Laboratório de Aplicativos permite que você configure o diretório home base e o script de inicialização para uma aplicação baseada em uma aplicação instalada existente. Este diretório home será copiado na primeira inicialização para o usuário com todos os arquivos e configurações que você configurar nesta sessão. Você pode reiniciar um Aplicativo de Laboratório existente para modificar seu conteúdo.',
            formInvalid: 'Por favor, selecione um aplicativo base e forneça um nome para o novo aplicativo.',
        },
        modals: {
            editUserTitle: 'Editar Usuário: {username}',
            saveChanges: 'Salvar Alterações',
            effectiveSettings: 'Configurações Efetivas (com sobrescritas de grupo)',
            editGroupTitle: 'Editar Grupo: {groupName}',
            userConfigTitle: 'Configuração do Usuário',
            warning: 'Esta é a única vez que esta configuração será mostrada. Forneça-a ao usuário de forma segura.',
            info: 'Você pode baixar este arquivo de configuração para configurar facilmente o SealSkin em outro dispositivo. Mantenha este arquivo seguro, pois ele contém sua chave privada.',
            configDataLabel: 'Dados de Configuração (JSON)',
            copyButton: 'Copiar Texto',
            downloadButton: 'Baixar Arquivo',
            manageHomeDirs: 'Gerenciar Diretórios Home',
            dirsForUser: 'Diretórios para o usuário: {username}',
            dirsForAdmin: 'Diretórios para o admin: {username}',
            newDirForUser: 'Criar Novo Diretório para o Usuário',
            createDirButton: 'Criar Diretório',
            confirmDeleteDir: 'Tem certeza de que deseja excluir \'{homeName}\' para o usuário \'{username}\'? Isso é permanente.',
            installAppTitle: 'Instalar {appName}',
            editAppTitle: 'Editar {appName}',
            customNameLabel: 'Nome Personalizado',
            imageLabel: 'Imagem do Contêiner',
            permissions: 'Permissões',
            allowedUsersLabel: 'Usuários Permitidos (separados por vírgula, \'all\' para todos)',
            allowedGroupsLabel: 'Grupos Permitidos (separados por vírgula, \'all\' para todos)',
            features: 'Recursos',
            gpuSupport: 'Suporte a GPU',
            homeMounting: 'Montagem de Diretório Home',
            urlSupport: 'Suporte para Abertura de URL',
            fileSupport: 'Suporte para Abertura de Arquivo',
            autoUpdate: 'Atualizar Imagem Automaticamente',
            advancedSettings: 'Configurações Avançadas',
            appTemplateLabel: 'Modelo de Aplicativo',
            appTemplateDescription: 'Selecione um modelo pré-configurado para configurações avançadas de inicialização do contêiner.',
            customAutostartScriptLabel: 'Script de Autoinicialização Personalizado',
            customAutostartScriptDescription: 'Personalize a lógica de autoinicialização, deixe em branco para usar o padrão do provedor do aplicativo.',
            saveInstallation: 'Salvar Instalação',
            updateStatusTitle: 'Status da Atualização para {appName}',
            checkingUpdates: 'Verificando atualizações...',
            updateAvailable: 'Uma nova versão da imagem está disponível!',
            yourVersion: 'Sua versão: {sha}',
            latestAvailable: 'A versão mais recente está disponível para puxar do registro.',
            pullLatest: 'Puxar Imagem Mais Recente',
            upToDate: 'Sua imagem está atualizada.',
            currentVersion: 'Versão atual: {sha}',
            errorChecking: 'Erro ao verificar atualizações.',
            pullingLatest: 'Puxando a imagem mais recente... Isso pode levar um momento.',
            pullComplete: 'Download completo!',
            newVersion: 'Nova versão: {sha}',
            errorPulling: 'Erro ao puxar a imagem.',
            manualInstallNote: "Nota: Imagens adicionadas manualmente devem ser baseadas em uma imagem compatível com selkies-baseimage.",
        },
        status: {
            loggingIn: 'Fazendo login...',
            configSaved: 'Configuração salva com sucesso!',
            configApplied: 'Configuração aplicada! Por favor, faça Login e Teste.',
            configApplyFailed: 'Falha ao aplicar a configuração: {error}',
            fileReadError: 'Erro ao ler o arquivo.',
            noConfig: 'Forneça um arquivo de configuração ou texto.',
            loggedInAdmin: 'Logado como admin: {username}',
            loggedInUser: 'Logado como usuário padrão: {username}.',
            loginFailed: 'Falha no login: {error}',
            adminDataRefreshFailed: 'Falha ao atualizar dados do admin: {error}',
            closingSession: 'Confirmando sessão de personalização...',
            sessionClosed: 'Sessão de personalização fechada.',
            sessionCloseFailed: 'Falha ao fechar sessão de personalização: {error}',
            logoutSuccess: 'Logout realizado e configuração limpa.',
            generateConfigFailed: 'Não foi possível gerar a configuração, detalhes do usuário estão faltando.',
            copySuccess: 'Configuração copiada para a área de transferência!',
            copyFailed: 'Falha ao copiar texto.',
            publicKeyCopied: 'Chave pública copiada!',
            keyCopyFailed: 'Falha ao copiar a chave.',
            creatingAdmin: 'Criando admin...',
            adminCreated: 'Admin \'{username}\' criado.',
            adminCreateFailed: 'Erro ao criar admin: {error}',
            adminDeleted: 'Admin \'{username}\' excluído com sucesso.',
            adminDeleteFailed: 'Erro ao excluir admin: {error}',
            creatingUser: 'Criando usuário...',
            userCreated: 'Usuário \'{username}\' criado.',
            userCreateFailed: 'Erro ao criar usuário: {error}',
            userDeleted: 'Usuário \'{username}\' excluído com sucesso.',
            userDeleteFailed: 'Erro ao excluir usuário: {error}',
            userUpdated: 'Usuário \'{username}\' atualizado com sucesso.',
            userUpdateFailed: 'Erro ao atualizar usuário: {error}',
            creatingGroup: 'Criando grupo...',
            groupCreated: 'Grupo \'{groupName}\' criado.',
            groupCreateFailed: 'Erro ao criar grupo: {error}',
            groupDeleted: 'Grupo \'{groupName}\' excluído com sucesso.',
            groupDeleteFailed: 'Erro ao excluir grupo: {error}',
            groupUpdated: 'Grupo \'{groupName}\' atualizado com sucesso.',
            groupUpdateFailed: 'Erro ao atualizar grupo: {error}',
            homedirLoadFailed: 'Falha ao carregar diretórios home: {error}',
            homedirCreateFailed: 'Erro ao criar diretório: {error}',
            homedirCreated: 'Diretório home \'{homeName}\' criado.',
            homedirDeleted: 'Diretório \'{homeName}\' excluído.',
            homedirDeleteFailed: 'Erro ao excluir diretório: {error}',
            homedirCreatedFor: 'Diretório \'{homeName}\' criado para {username}.',
            homedirDeletedFor: 'Diretório \'{homeName}\' excluído para {username}.',
            sessionsLoadFailed: 'Falha ao carregar sessões: {error}',
            sessionStopError: 'Erro ao parar sessão: {error}',
            sessionStopped: 'Sessão parada com sucesso.',
            appDataRefreshFailed: 'Falha ao atualizar dados do aplicativo: {error}',
            fetchingApps: 'Buscando aplicativos da loja...',
            fetchAppsFailed: 'Falha ao buscar aplicativos da loja: {error}',
            appStoreAddFailed: 'Erro ao adicionar loja: {error}',
            appStoreAdded: 'Loja de aplicativos \'{name}\' adicionada.',
            appSaved: 'Aplicativo \'{name}\' {action} com sucesso.',
            appSaveActions: {
                updated: 'atualizado',
                installed: 'instalado'
            },
            appSaveFailed: 'Erro ao salvar aplicativo: {error}',
            appDeleted: 'Aplicativo \'{name}\' excluído.',
            appDeleteFailed: 'Erro ao excluir aplicativo: {error}',
            templateSaved: 'Modelo \'{name}\' salvo com sucesso.',
            templateSaveFailed: 'Erro ao salvar modelo: {error}',
            templateDeleted: 'Modelo \'{name}\' excluído com sucesso.',
            templateDeleteFailed: 'Erro ao excluir modelo: {error}',
            pinRemoved: 'Comportamento fixo removido.',
            keyGenerated: 'Novo par de chaves gerado.',
            keyGenFailed: 'Falha na geração da chave: {{error}}',
            pendingConfigSaved: 'Configuração pendente salva. Agora você pode fornecer sua chave pública ao administrador.',
            settingsSaved: 'Configurações salvas.',
            appCreated: 'Aplicativo \'{name}\' criado com sucesso.',
            launchFailed: 'Falha ao iniciar: {error}',
        },
        placeholders: {
            noAdmins: 'Nenhum admin encontrado.',
            noUsers: 'Nenhum usuário encontrado.',
            noGroups: 'Nenhum grupo encontrado.',
            noHomeDirs: 'Nenhum diretório home encontrado.',
            noSessions: 'Nenhuma sessão ativa encontrada.',
            noPinned: 'Nenhum comportamento fixo encontrado.',
            errorLoading: 'Erro ao carregar diretórios.',
            noInstalledApps: 'Nenhuma aplicação foi instalada ainda.',
        },
    },
    popup: {
        tabs: {
            launch: 'Iniciar Novo',
            sessions: 'Sessões Ativas',
            manageFiles: 'Gerenciar Arquivos',
            uploadStorage: 'Enviar para Armazenamento',
            uploadFiles: 'Enviar Arquivos',
            uploadFilesTitle: 'Abrir página dedicada para envio de arquivos'
        },
        launchView: {
            searchPlaceholder: 'Pesquisar aplicativos...',
            uploadingFile: 'Enviando arquivo...',
            gpuLabel: 'GPU',
            storageLabel: 'Armazenamento',
            languageLabel: 'Idioma',
            cleanroom: 'Sala Limpa (Efêmero)',
            noGpu: 'Nenhum',
            saveOptions: 'Salvar estas opções de inicialização',
            saveOptionsForUrl: 'Salvar opções para todas as URLs',
            saveOptionsForFile: 'Salvar opções para arquivos .{extension}',
            openFile: 'Abrir arquivo ao iniciar',
            launchButton: 'Iniciar',
            launchingButton: 'Iniciando...',
            uploadingButton: 'Enviando...',
            autoHome: 'Automático (persistência por aplicativo)',
            collaborationMode: 'Sessão Colaborativa',
            waylandMode: 'Modo Wayland',
        },
        sessionsView: {
            noSessions: 'Nenhuma sessão ativa encontrada.',
        },
        uploadStorageView: {
            selectHome: 'Selecionar Diretório Home',
            description: 'Isso enviará o arquivo <strong>{filename}</strong> diretamente para o seu armazenamento de Arquivos para uso futuro.',
            descriptionFallback: 'Isso enviará o arquivo <strong>{filename}</strong> diretamente para o seu armazenamento de Arquivos para uso futuro.',
            uploadButton: 'Enviar Arquivo',
            uploadingButton: 'Enviando...',
            preparing: 'Preparando arquivo...',
            uploadingChunk: 'Enviando parte {current} de {total}...',
            finalizing: 'Finalizando...',
            uploadComplete: 'Envio Concluído!',
        },
        status: {
            unconfigured: 'Por favor, configure a extensão através da página de opções.',
            openingServerFile: "Abrindo arquivo do lado do servidor: {filename}",
            openingFile: 'Abrindo arquivo: {filename}',
            openingUrl: 'Abrindo URL: {targetUrl}',
            error: 'Erro: {message}',
            preparingFile: 'Preparando arquivo...',
            sendingFile: 'Enviando arquivo para a sessão...',
            errorSendingFile: 'Erro ao enviar arquivo: {message}',
            errorClosingSession: 'Erro ao fechar sessão: {message}',
            preparingSession: 'Preparando sessão isolada...',
            fetchingData: 'Buscando dados do arquivo...',
            fetchDataFailed: 'Falha ao buscar dados do arquivo: {statusText}',
            unknownAction: 'Ação de inicialização desconhecida.',
            noAppSelected: 'Por favor, selecione um aplicativo.',
            noAppsAvailable: 'Nenhum aplicativo está disponível para sua conta.',
            uploadSuccess: 'Arquivo enviado com sucesso!',
            creatingAutoHome: 'Criando diretório home automático...',
        },
        languages: {
            default: 'Padrão ({locale})'
        }
    },
    upload: {
        title: 'Envio de Arquivo',
        description: 'Selecione um arquivo do seu computador para abri-lo em uma sessão segura e isolada.',
        dropzone: {
            title: 'Arraste e solte um arquivo aqui',
            or: 'ou',
            button: 'Selecionar Arquivo',
        },
        confirm: {
            ready: 'O arquivo está pronto para ser aberto com segurança.',
            button: 'Continuar para Iniciar',
        }
    },
    files: {
        title: 'Arquivos SealSkin',
        header: {
            title: 'Arquivos',
            newFolder: 'Nova Pasta',
            uploadFiles: 'Carregar Arquivos',
            uploadFolder: 'Carregar Pasta'
        },
        sidebar: {
            sharedFiles: 'Arquivos SealSkin',
            publicShares: 'Compartilhamentos Públicos'
        },
        shares: {
            title: 'Arquivos Compartilhados Publicamente',
            searchPlaceholder: 'Pesquisar por nome de arquivo ou ID...'
        },
        table: {
            name: 'Nome',
            size: 'Tamanho',
            lastModified: 'Última Modificação',
            created: 'Criado',
            expires: 'Expira',
            url: 'URL Pública',
            passwordProtected: 'Senha'
        },
        dropzone: {
            title: 'Arraste arquivos para carregar'
        },
        pagination: {
            previous: '« Anterior',
            next: 'Próximo »',
            pageOf: 'Página {page} de {totalPages}'
        },
        modals: {
            newFolder: {
                title: 'Criar Nova Pasta',
                folderNameLabel: 'Nome da Pasta',
                nameTitle: 'Use apenas letras, números, sublinhado, hífen ou ponto.',
                createButton: 'Criar'
            },
            confirmDelete: {
                title: 'Confirmar Exclusão',
                message: 'Tem certeza de que deseja excluir {count, plural, one {1 item selecionado} other {{count} itens selecionados}}? Esta ação não pode ser desfeita.',
                messageDefault: 'Tem certeza de que deseja excluir os itens selecionados? Esta ação não pode ser desfeita.'
            },
            uploadProgress: {
                title: 'Progresso do Upload',
                doneButton: 'Concluído'
            },
            share: {
                title: 'Compartilhar Arquivo',
                sharingFile: 'Compartilhando arquivo: <strong>{filename}</strong>',
                passwordLabel: 'Senha (opcional)',
                passwordPlaceholder: 'Deixe em branco para não ter senha',
                expiryLabel: 'Expira em (horas, opcional)',
                expiryPlaceholder: 'ex., 24 para um dia',
                shareButton: 'Criar Link de Compartilhamento'
            }
        },
        status: {
            homeDirLoadFailed: 'Falha ao carregar diretórios home: {error}',
            filesLoadFailed: 'Erro ao carregar arquivos: {error}',
            deleteProtectedError: 'Não é possível excluir pastas de sistema protegidas.',
            deletingItems: 'Excluindo {count, plural, one {1 item} other {{count} itens}}...',
            deleteSuccess: 'Exclusão bem-sucedida.',
            deleteFailed: 'Falha na exclusão: {error}',
            preparingUpload: 'Preparando para carregar {count, plural, one {1 arquivo} other {{count} arquivos}}...',
            uploadPrepFailed: 'Erro durante a preparação do upload da pasta: {error}',
            notConfigured: 'Erro: SealSkin não configurado. Por favor, configure nas opções.',
            folderCreated: 'Pasta \'{folderName}\' criada.',
            folderCreateFailed: 'Erro ao criar pasta: {error}',
            shareCreated: 'Compartilhamento criado com sucesso! O link foi copiado para sua área de transferência.',
            shareCreateFailed: 'Falha ao criar compartilhamento: {error}',
            sharesLoadFailed: 'Falha ao carregar arquivos compartilhados: {error}',
            shareDeleteFailed: 'Falha ao excluir compartilhamento: {error}',
            shareDeleted: 'Compartilhamento excluído com sucesso.',
            urlCopied: 'URL pública copiada para a área de transferência.'
        },
        placeholders: {
            errorLoading: 'Erro ao carregar arquivos.',
            folderEmpty: 'Esta pasta está vazia.',
            noHomeDirs: 'Nenhum diretório home disponível.',
            noShares: 'Você ainda não compartilhou nenhum arquivo.'
        },
        uploadStatus: {
            pending: 'pendente',
            initiating: 'Iniciando...',
            uploading: 'Carregando...',
            finalizing: 'Finalizando...',
            completed: 'Concluído',
            error: 'Erro'
        }
    }
};

// --- French Translations ---
const fr = {
    background: {
        contextMenu: {
            openUrl: 'Ouvrir le lien dans SealSkin',
            openFile: 'Ouvrir la cible du lien en tant que fichier dans SealSkin',
            sendMedia: 'Envoyer le média à SealSkin',
            searchText: 'Rechercher "%s" dans SealSkin',
            sendDownload: 'Envoyer le prochain téléchargement à SealSkin'
        }
    },
    common: {
        actions: 'Actions',
        active: 'Actif',
        cancel: 'Annuler',
        manage: 'Gérer',
        delete: 'Supprimer',
        edit: 'Modifier',
        save: 'Enregistrer',
        none: 'aucun',
        error: 'Erreur',
        na: 'N/A',
        of: 'de',
        status: 'Statut',
        username: 'Nom d\'utilisateur',
        group: 'Groupe',
        groups: 'Groupes',
        publicKey: 'Clé Publique',
        name: 'Nom',
        source: 'Source',
        imageVersion: 'Version de l\'image',
        language: 'Langue',
        storage: 'Stockage',
        gpu: 'GPU',
        version: 'Version',
        checked: 'Vérifié',
        never: 'Jamais',
        stop: 'Arrêter',
        reopen: 'Réouvrir',
        sendFile: 'Envoyer Fichier',
        share: 'Partager',
        search: 'Rechercher',
        refresh: 'Actualiser',
        close: 'Fermer',
        copy: 'Copier',
        open: "Ouvrir",
        copyUrl: 'Copier l\'URL',
        download: 'Télécharger',
        next: 'Suivant',
        previous: 'Précédent',
        page: 'Page',
        home: 'Dossier Personnel',
        homes: 'Dossiers Personnels',
        sessions: 'Sessions',
        users: 'Utilisateurs',
        admins: 'Admins',
        yes: 'Oui',
        no: 'Non',
        daysAgo: '{count, plural, one {il y a 1 jour} other {il y a {count} jours}}',
        hoursAgo: '{count, plural, one {il y a 1 heure} other {il y a {count} heures}}',
        minutesAgo: '{count, plural, one {il y a 1 minute} other {il y a {count} minutes}}',
        justNow: 'à l\'instant',
        bytes: 'Octets',
        kb: 'Ko',
        mb: 'Mo',
        gb: 'Go',
        tb: 'To',
        pb: 'Po',
    },
    options: {
        sidebar: {
            config: 'Configuration',
            home: 'Dossiers Personnels',
            sessions: 'Sessions Actives',
            pinned: 'Comportement Épinglé',
            appStore: 'Magasin d\'applications',
            appTemplates: 'Modèles d\'applications',
            appLaboratory: 'Laboratoire d\'applications',
            installedApps: 'Applications Installées',
            users: 'Utilisateurs',
            groups: 'Groupes',
            admins: 'Admins',
        },
        dashboard: {
            title: 'Tableau de Bord',
            clientSettings: 'Paramètres du Client',
            exportConfig: 'Exporter la Configuration',
            userStatus: 'Statut de l\'Utilisateur',
            loggedInAs: 'Connecté en tant que :',
            role: 'Rôle',
            roleAdmin: 'Administrateur',
            roleUser: 'Utilisateur Standard',
            serverInfo: 'Infos Serveur',
            server: 'Serveur :',
            cpuModel: 'Modèle CPU :',
            storageUsage: 'Utilisation du Stockage :',
            detectedGpus: 'GPUs Détectés :',
            logout: 'Déconnexion & Effacer Config',
            howTo: 'Comment Utiliser SealSkin',
            howToDescription: 'Cette section contient la documentation de base sur l\'utilisation de l\'extension.',
            howToList: [
                '<strong>Pour ouvrir du contenu en isolation :</strong> Faites un clic droit sur n\'importe quel lien, image ou texte sélectionné et choisissez une option dans le menu contextuel "Isolation SealSkin".',
                '<strong>Pour envoyer un téléchargement en isolation :</strong> Faites un clic droit sur la page et sélectionnez "Envoyer le prochain téléchargement en isolation". Le prochain fichier que vous téléchargerez sera intercepté et envoyé vers une session sécurisée.',
                '<strong>Pour lancer une application propre :</strong> Cliquez sur l\'icône SealSkin dans la barre d\'outils de votre navigateur.',
                '<strong>Pour gérer le stockage persistant :</strong> Utilisez l\'onglet "Dossiers Personnels" sur cette page pour créer et supprimer des volumes de stockage pouvant être utilisés sur plusieurs sessions.',
                '<strong>Pour enregistrer les options de lancement :</strong> Cochez la case "Enregistrer ces options de lancement" dans la fenêtre contextuelle avant de lancer une application pour un type de fichier spécifique (par ex., .pdf) ou pour toutes les URL. Gérez ces préférences enregistrées dans l\'onglet "Comportement Épinglé".'
            ],
            confirmLogout: 'Êtes-vous sûr de vouloir vous déconnecter ? Cela effacera votre configuration enregistrée de ce navigateur.',
        },
        config: {
            quickSetup: 'Configuration Rapide',
            quickSetupDescription: 'Téléversez le fichier de configuration (.json) fourni par votre administrateur, ou collez son contenu ci-dessous pour configurer automatiquement l\'extension.',
            uploadLabel: 'Téléverser Fichier de Config',
            pasteLabel: 'Ou Coller le Texte de Config',
            pastePlaceholder: 'Collez votre configuration JSON ici...',
            applyButton: 'Appliquer la Configuration',
            manualLink: 'Configuration Manuelle',
            advancedTitle: 'Configuration du Client (Avancé)',
            serverIpLabel: 'IP ou Domaine du Serveur',
            serverIpPlaceholder: 'ex., 192.168.1.100',
            apiPortLabel: 'Port de l\'API',
            apiPortPlaceholder: 'ex., 8000',
            sessionPortLabel: 'Port de Session',
            sessionPortPlaceholder: 'ex., 8443',
            usernameLabel: 'Nom d\'utilisateur',
            usernamePlaceholder: 'Votre nom d\'utilisateur',
            privateKeyLabel: 'Votre Clé Privée (Format PEM)',
            privateKeyPlaceholder: 'Collez le contenu de votre clé privée ici',
            serverKeyLabel: 'Clé Publique du Serveur (Format PEM)',
            serverKeyPlaceholder: 'Collez le contenu de server_public.pem ici',
            searchEngineLabel: 'Moteur de Recherche par Défaut pour le Texte Sélectionné',
            saveButton: 'Enregistrer la Configuration',
            loginButton: 'Connexion & Test',
            automaticLink: 'Configuration Automatique',
            chooseFile: 'Choisir un Fichier',
            keyGeneration: 'Génération de Clé',
            keyGenDescription: 'Si vous n\'avez pas de paire de clés, vous pouvez en générer une ici. La clé privée sera remplie ci-dessus. Fournissez la clé publique à votre administrateur.',
            generateKeyButton: 'Générer une Nouvelle Paire de Clés',
            publicKeyForAdminLabel: 'Votre Clé Publique (pour l\'admin)',
        },
        home: {
            title: 'Vos Dossiers Personnels',
            description: 'Créez des dossiers de stockage persistants à utiliser entre les sessions. Ils seront montés dans vos applications en tant que dossier de configuration.',
            newTitle: 'Créer un Nouveau Dossier Personnel',
            nameLabel: 'Nom du Dossier :',
            namePlaceholder: 'ex., mes-fichiers-projet',
            nameTitle: 'Utilisez uniquement des lettres, des chiffres, des underscores ou des tirets.',
            createButton: 'Créer le Dossier',
            isLaboratory: 'Ceci est une application de Laboratoire, construite à partir d\'une image de base avec des paramètres personnalisés.',
            laboratory: 'Laboratoire',
            confirmDelete: 'Êtes-vous sûr de vouloir supprimer l\'application installée \'{appName}\' ?'
        },
        sessions: {
            title: 'Sessions Actives',
            application: 'Application',
            started: 'Démarrée',
            noSessionsUser: 'Aucune session active trouvée.',
            noSessionsAdmin: 'Aucune session active trouvée pour aucun utilisateur.',
            sessionsFor: 'Sessions pour {username} ({count})',
            confirmStop: 'Êtes-vous sûr de vouloir arrêter cette session ? Le conteneur sera détruit.',
        },
        pinned: {
            title: 'Comportement Épinglé de l\'Extension',
            description: 'Ce tableau montre les options de lancement que vous avez enregistrées pour des types de fichiers spécifiques ou pour toutes les URL. Vous pouvez supprimer un comportement épinglé pour être à nouveau invité à choisir les options de lancement.',
            trigger: 'Déclencheur',
            savedApp: 'Application Enregistrée',
            triggerSimple: 'Lancement Simple (Bouton de la barre d\'outils)',
            triggerUrl: 'Toutes les URL (depuis le menu contextuel)',
            triggerFile: 'Type de fichier : <strong>{fileType}</strong>',
            unknownApp: 'App Inconnue ({appId}...)'
        },
        admins: {
            serverKeyTitle: 'Clé Publique du Serveur',
            serverKeyDescription: 'Ceci est la clé publique dont les fichiers de configuration des utilisateurs auront besoin pour se connecter à ce serveur.',
            title: 'Gestion des Admins',
            searchPlaceholder: 'Rechercher des admins...',
            newTitle: 'Créer un Nouvel Admin',
            publicKeyOptionalLabel: 'Clé Publique (Optionnel) :',
            publicKeyPlaceholder: 'Collez la clé publique ici, ou laissez vide pour en générer une.',
            createButton: 'Créer l\'Admin',
            confirmDelete: 'Êtes-vous sûr de vouloir supprimer l\'admin \'{username}\' ? Cela supprimera également tout son stockage persistant et ne pourra pas être annulé.',
        },
        users: {
            title: 'Gestion des Utilisateurs',
            searchPlaceholder: 'Rechercher des utilisateurs par nom ou groupe...',
            newTitle: 'Créer un Nouvel Utilisateur',
            publicKeyOptionalLabel: 'Clé Publique (Optionnel) :',
            publicKeyPlaceholder: 'Collez la clé publique de l\'utilisateur ici, ou laissez vide pour en générer une.',
            settingsTitle: 'Paramètres de l\'Utilisateur',
            sessionLimitLabel: 'Limite de sessions',
            sessionLimitTitle: 'Nombre de sessions actives qu\'un utilisateur peut avoir. -1 pour illimité.',
            permissionsTitle: 'Permissions & Renforcement',
            activeAccount: 'Compte Actif',
            allowStorage: 'Autoriser le Stockage Persistant',
            allowGpu: 'Autoriser l\'Accès GPU',
            hardenContainer: 'Renforcer le Conteneur',
            hardenWm: 'Renforcer le Gestionnaire de Fenêtres',
            createButton: 'Créer l\'Utilisateur',
            homesDisabledTooltip: 'Stockage persistant désactivé pour cet utilisateur',
            confirmDelete: 'Êtes-vous sûr de vouloir supprimer l\'utilisateur \'{username}\' ? Cela supprimera également tout son stockage persistant et ne pourra pas être annulé.',
            allowPublicSharing: 'Autoriser le partage de fichiers public',
        },
        groups: {
            title: 'Gestion des Groupes',
            searchPlaceholder: 'Rechercher des groupes...',
            newTitle: 'Créer un Nouveau Groupe',
            nameLabel: 'Nom du Groupe :',
            overrideTitle: 'Paramètres de Surcharge du Groupe',
            permissionsTitle: 'Surcharges des Permissions & Renforcement',
            createButton: 'Créer le Groupe',
            confirmDelete: 'Êtes-vous sûr de vouloir supprimer le groupe \'{groupName}\' ? Les utilisateurs de ce groupe reviendront à leurs paramètres individuels.',
        },
        installedApps: {
            title: 'Applications Installées',
            searchPlaceholder: 'Rechercher des applications installées...',
            noAppsFound: 'Aucune application installée trouvée.',
            pulling: 'Téléchargement de la nouvelle image...',
            notLocal: 'Image non trouvée localement',
            confirmDelete: 'Êtes-vous sûr de vouloir supprimer l\'application installée \'{appName}\' ?',
        },
        appStore: {
            title: 'Magasins d\'Applications',
            refreshTitle: 'Actualiser le magasin sélectionné',
            selectLabel: 'Sélectionner un Magasin d\'App',
            addLabel: 'Ajouter un Nouveau Magasin d\'App',
            namePlaceholder: 'Nom du Magasin',
            urlPlaceholder: 'URL YAML du Magasin',
            availableTitle: 'Applications Disponibles',
            addManual: "Ajouter une application manuelle",
            searchPlaceholder: 'Rechercher des applications disponibles...',
            noAppsFound: 'Aucune application trouvée.',
            availableFrom: 'Applications Disponibles de {storeName}',
            couldNotLoad: 'Impossible de charger les applications de ce magasin.',
        },
        appTemplates: {
            title: 'Éditeur de Modèles d\'Application',
            loadLabel: 'Charger un Modèle',
            createOption: 'Créer un Nouveau Modèle',
            nameLabel: 'Nom du Modèle',
            namePlaceholder: 'Entrez un nom pour le nouveau modèle',
            saveButton: 'Enregistrer le Profil',
            deleteButton: 'Supprimer',
            previewTitle: 'Aperçu de l\'UI',
            contentArea: 'Zone de Contenu de l\'Application',
            confirmDelete: 'Êtes-vous sûr de vouloir supprimer le modèle \'{templateName}\' ? Cette action ne peut pas être annulée.',
            deleteDisabled: 'Ce modèle ne peut pas être supprimé.',
            enterName: 'Veuillez entrer un nom pour le nouveau modèle.',
            settings: {
                TITLE: { label: "Titre de la Page", description: "Le titre de la page affiché dans le navigateur web." },
                SELKIES_UI_TITLE: { label: "Titre de la Barre Latérale", description: "Titre dans le coin supérieur gauche de la barre latérale." },
                SELKIES_UI_SHOW_SIDEBAR: { label: "Afficher la Barre Latérale", description: "Afficher l'interface utilisateur principale de la barre latérale." },
                SELKIES_UI_SHOW_LOGO: { label: "Afficher le Logo", description: "Afficher le logo Selkies dans la barre latérale." },
                SELKIES_UI_SHOW_CORE_BUTTONS: { label: "Afficher les Boutons Principaux", description: "Afficher les boutons des composants principaux (affichage, audio, etc.)." },
                SELKIES_UI_SIDEBAR_SHOW_VIDEO_SETTINGS: { label: "Afficher les Paramètres Vidéo", description: "Afficher la section des paramètres vidéo dans la barre latérale." },
                SELKIES_UI_SIDEBAR_SHOW_SCREEN_SETTINGS: { label: "Afficher les Paramètres d'Écran", description: "Afficher la section des paramètres d'écran dans la barre latérale." },
                SELKIES_UI_SIDEBAR_SHOW_AUDIO_SETTINGS: { label: "Afficher les Paramètres Audio", description: "Afficher la section des paramètres audio dans la barre latérale." },
                SELKIES_UI_SIDEBAR_SHOW_STATS: { label: "Afficher les Statistiques", description: "Afficher la section des statistiques dans la barre latérale." },
                SELKIES_UI_SIDEBAR_SHOW_CLIPBOARD: { label: "Afficher le Presse-papiers", description: "Afficher la section du presse-papiers dans la barre latérale." },
                SELKIES_UI_SIDEBAR_SHOW_FILES: { label: "Afficher la Section Fichiers", description: "Afficher la section de transfert de fichiers dans la barre latérale." },
                SELKIES_UI_SIDEBAR_SHOW_APPS: { label: "Afficher la Section Applications", description: "Afficher la section des applications dans la barre latérale." },
                SELKIES_UI_SIDEBAR_SHOW_SHARING: { label: "Afficher la Section Partage", description: "Afficher la section de partage dans la barre latérale." },
                SELKIES_UI_SIDEBAR_SHOW_GAMEPADS: { label: "Afficher la Section Manettes", description: "Afficher la section des manettes de jeu dans la barre latérale." },
                SELKIES_UI_SIDEBAR_SHOW_KEYBOARD_BUTTON: { label: "Afficher le Bouton Clavier", description: "Afficher le bouton du clavier visuel." },
                SELKIES_UI_SIDEBAR_SHOW_SOFT_BUTTONS: { label: "Afficher les Boutons Logiciels", description: "Afficher la section des boutons logiciels (pour mobile)." },
                WATERMARK_PNG: { label: "Chemin PNG du Filigrane", description: "Chemin complet à l'intérieur du conteneur vers un fichier png de filigrane." },
                WATERMARK_LOCATION: { label: "Emplacement du Filigrane", description: "Où peindre l'image sur le flux.", options: { disabled: "Désactivé", topLeft: "En haut à gauche", topRight: "En haut à droite", bottomLeft: "En bas à gauche", bottomRight: "En bas à droite", centered: "Centré", animated: "Animé" } },
                DASHBOARD: { label: "Style du Tableau de Bord", description: "Permet à l'utilisateur de définir son tableau de bord.", options: { default: "Défaut", selkiesDefault: "Selkies (Défaut)", zinc: "Zinc", wish: "Wish" } },
                SELKIES_AUDIO_ENABLED: { label: "Activer l'Audio", description: "Activer le streaming audio du serveur au client." },
                SELKIES_MICROPHONE_ENABLED: { label: "Activer le Microphone", description: "Activer la transmission du microphone du client au serveur." },
                SELKIES_GAMEPAD_ENABLED: { label: "Activer la Manette de Jeu", description: "Activer le support des manettes de jeu." },
                SELKIES_CLIPBOARD_ENABLED: { label: "Activer le Presse-papiers", description: "Activer la synchronisation du presse-papiers." },
                SELKIES_ENABLE_BINARY_CLIPBOARD: { label: "Activer le Presse-papiers Binaire", description: "Autoriser les données binaires (images) dans le presse-papiers." },
                SELKIES_COMMAND_ENABLED: { label: "Activer le Websocket de Commande", description: "Activer l'analyse des messages du websocket de commande." },
                SELKIES_FILE_TRANSFERS: { label: "Transferts de Fichiers", description: "Directions autorisées ('upload,download', 'upload', 'download', 'none')." },
                SELKIES_ENABLE_SHARING: { label: "Activer Tout le Partage", description: "Interrupteur principal pour toutes les fonctionnalités de partage." },
                SELKIES_SECOND_SCREEN: { label: "Activer le Second Écran", description: "Activer le support pour un second moniteur/affichage." },
                SELKIES_USE_BROWSER_CURSORS: { label: "Utiliser les Curseurs du Navigateur", description: "Utiliser les curseurs CSS du navigateur au lieu du rendu sur le canevas." },
                SELKIES_USE_CSS_SCALING: { label: "Utiliser la Mise à l'Échelle CSS (LoDPI)", description: "Si vrai, une résolution inférieure est envoyée et le canevas est étiré." },
                SELKIES_IS_MANUAL_RESOLUTION_MODE: { label: "Mode Résolution Manuelle", description: "Verrouiller la résolution sur les valeurs de largeur/hauteur manuelles." },
                SELKIES_MANUAL_WIDTH: { label: "Largeur Manuelle", description: "Verrouiller la largeur à une valeur fixe. Force le mode manuel." },
                SELKIES_MANUAL_HEIGHT: { label: "Hauteur Manuelle", description: "Verrouiller la hauteur à une valeur fixe. Force le mode manuel." },
                SELKIES_SCALING_DPI: { label: "DPI de Mise à l'Échelle de l'UI", description: "Le DPI par défaut pour la mise à l'échelle de l'interface utilisateur." },
                SELKIES_AUDIO_BITRATE: { label: "Débit Audio", description: "Le débit audio par défaut." },
                SELKIES_ENCODER: { label: "Encodeurs", description: "Liste d'encodeurs séparés par des virgules. Le premier est celui par défaut." },
                SELKIES_USE_CPU: { label: "Forcer l'Encodage CPU", description: "Forcer l'encodage basé sur le CPU pour pixelflux." },
                SELKIES_FRAMERATE: { label: "Fréquence d'Images (Plage ou Fixe)", description: "ex., '8-120' pour une plage ou '60' pour une valeur fixe." },
                SELKIES_H264_CRF: { label: "CRF H.264 (Plage ou Fixe)", description: "ex., '5-50' pour une plage ou '25' pour une valeur fixe." },
                SELKIES_JPEG_QUALITY: { label: "Qualité JPEG (Plage ou Fixe)", description: "ex., '1-100' pour une plage ou '60' pour une valeur fixe." },
                SELKIES_H264_FULLCOLOR: { label: "Couleur Complète H.264", description: "Activer la plage de couleurs complète H.264 pour les encodeurs pixelflux." },
                SELKIES_H264_STREAMING_MODE: { label: "Mode Streaming H.264 (Turbo)", description: "Activer le mode de streaming à faible latence H.264." },
                SELKIES_USE_PAINT_OVER_QUALITY: { label: "Utiliser la Qualité de Sur-peinture", description: "Activer la sur-peinture de haute qualité pour les scènes statiques." },
                SELKIES_PAINT_OVER_JPEG_QUALITY: { label: "Qualité JPEG de Sur-peinture", description: "ex., '1-100' pour une plage ou '90' pour une valeur fixe." },
                SELKIES_H264_PAINTOVER_CRF: { label: "CRF H.264 de Sur-peinture", description: "ex., '5-50' pour une plage ou '18' pour une valeur fixe." },
                SELKIES_H264_PAINTOVER_BURST_FRAMES: { label: "Rafale d'Images de Sur-peinture", description: "ex., '1-30' pour une plage ou '5' pour une valeur fixe." },
                HARDEN_DESKTOP: { label: "Renforcer le Bureau (Préréglage)", description: "Active DISABLE_OPEN_TOOLS, DISABLE_SUDO, et DISABLE_TERMINALS." },
                HARDEN_OPENBOX: { label: "Renforcer le Gestionnaire de Fenêtres (Préréglage)", description: "Active DISABLE_CLOSE_BUTTON, DISABLE_MOUSE_BUTTONS, et HARDEN_KEYBINDS. Active aussi RESTART_APP." },
                DISABLE_OPEN_TOOLS: { label: "Désactiver les Outils d'Ouverture", description: "Désactive les binaires xdg-open et exo-open." },
                DISABLE_SUDO: { label: "Désactiver Sudo", description: "Désactive la commande sudo." },
                DISABLE_TERMINALS: { label: "Désactiver les Terminaux", description: "Désactive les émulateurs de terminaux courants." },
                DISABLE_CLOSE_BUTTON: { label: "Désactiver le Bouton de Fermeture de Fenêtre", description: "Supprime le bouton de fermeture des barres de titre des fenêtres." },
                DISABLE_MOUSE_BUTTONS: { label: "Désactiver Clic Droit/Milieu", description: "Désactive les menus contextuels du clic droit et du clic du milieu." },
                HARDEN_KEYBINDS: { label: "Renforcer les Raccourcis Clavier", description: "Désactive les raccourcis clavier par défaut d'Openbox comme Alt+F4." },
                RESTART_APP: { label: "Redémarrer l'App à la Fermeture", description: "Redémarre automatiquement l'application principale si elle est fermée." },
                MAX_RES: { label: "Résolution Maximale", description: "Résolution maximale pour le conteneur, la valeur par défaut est 16k." },
                START_DOCKER: { label: "Démarrer Docker-in-Docker", description: "Si faux, un conteneur privilégié ne démarrera pas DinD." },
                DISABLE_IPV6: { label: "Désactiver IPv6", description: "Si vrai, cela désactivera IPv6." },
                DISABLE_ZINK: { label: "Désactiver Zink", description: "Ne pas définir les variables d'environnement Zink si une carte vidéo est détectée." },
                DISABLE_DRI3: { label: "Désactiver DRI3", description: "Ne pas utiliser l'accélération DRI3 si une carte vidéo est détectée." },
                NO_DECOR: { label: "Pas de Décorations de Fenêtre", description: "Exécuter l'application sans bordures de fenêtre pour une utilisation PWA." },
                NO_FULL: { label: "Pas de Plein Écran", description: "Ne pas mettre automatiquement les applications en plein écran." },
                NO_GAMEPAD: { label: "Désactiver l'Injection de Manette", description: "Désactiver l'injection de l'interposeur de manette en espace utilisateur." },
                SELKIES_DEBUG: { label: "Activer le Débogage Selkies", description: "Activer la journalisation de débogage pour les composants de streaming." },
            }
        },
        appLaboratory: {
            title: 'Laboratoire d\'applications',
            description: 'Créez et testez des configurations d\'applications personnalisées en superposant des modifications sur une application de base.',
            selectApp: 'Sélectionner une application',
            createNew: 'Créer une nouvelle application',
            baseApp: 'Application de base',
            baseAppDescription: 'L\'application installée sur laquelle votre nouvelle application personnalisée sera basée.',
            selectBase: 'Sélectionner une application de base',
            customizationTitle: 'Personnalisation',
            appName: 'Nom de l\'application',
            appIcon: 'Icône de l\'application',
            uploadIcon: 'Téléverser une icône',
            autostartScriptLabel: 'Script de Démarrage Automatique Personnalisé',
            permissionsTitle: 'Permissions',
            usersLabel: 'Utilisateurs Autorisés',
            groupsLabel: 'Groupes Autorisés',
            launchButton: 'Enregistrer et Lancer la Session de Personnalisation',
            closeButton: 'Fermer la Session et Finaliser',
            savingAndLaunching: 'Enregistrement et Lancement...',
            placeholder: 'Le Laboratoire d\'applications vous permet de configurer le répertoire personnel de base et le script de lancement pour une application basée sur une application installée existante. Ce répertoire personnel sera copié lors de la première initialisation pour l\'utilisateur avec tous les fichiers et paramètres que vous configurez dans cette session. Vous pouvez relancer une application de Laboratoire existante pour en modifier davantage le contenu.',
            formInvalid: 'Veuillez sélectionner une application de base et fournir un nom pour la nouvelle application.',
        },
        modals: {
            editUserTitle: 'Modifier l\'Utilisateur : {username}',
            saveChanges: 'Enregistrer les Modifications',
            effectiveSettings: 'Paramètres Effectifs (avec surcharges de groupe)',
            editGroupTitle: 'Modifier le Groupe : {groupName}',
            userConfigTitle: 'Configuration de l\'Utilisateur',
            warning: 'C\'est la seule fois que cette configuration sera affichée. Fournissez-la à l\'utilisateur de manière sécurisée.',
            info: 'Vous pouvez télécharger ce fichier de configuration pour configurer facilement SealSkin sur un autre appareil. Conservez ce fichier en lieu sûr car il contient votre clé privée.',
            configDataLabel: 'Données de Configuration (JSON)',
            copyButton: 'Copier le Texte',
            downloadButton: 'Télécharger le Fichier',
            manageHomeDirs: 'Gérer les Dossiers Personnels',
            dirsForUser: 'Dossiers pour l\'utilisateur : {username}',
            dirsForAdmin: 'Dossiers pour l\'admin : {username}',
            newDirForUser: 'Créer un Nouveau Dossier pour l\'Utilisateur',
            createDirButton: 'Créer le Dossier',
            confirmDeleteDir: 'Êtes-vous sûr de vouloir supprimer \'{homeName}\' pour l\'utilisateur \'{username}\' ? C\'est permanent.',
            installAppTitle: 'Installer {appName}',
            editAppTitle: 'Modifier {appName}',
            customNameLabel: 'Nom Personnalisé',
            imageLabel: 'Image du Conteneur',
            permissions: 'Permissions',
            allowedUsersLabel: 'Utilisateurs Autorisés (séparés par virgule, \'all\' pour tout le monde)',
            allowedGroupsLabel: 'Groupes Autorisés (séparés par virgule, \'all\' pour tout le monde)',
            features: 'Fonctionnalités',
            gpuSupport: 'Support GPU',
            homeMounting: 'Montage du Dossier Personnel',
            urlSupport: 'Support d\'Ouverture d\'URL',
            fileSupport: 'Support d\'Ouverture de Fichier',
            autoUpdate: 'Mettre à Jour l\'Image Automatiquement',
            advancedSettings: 'Paramètres Avancés',
            appTemplateLabel: 'Modèle d\'Application',
            appTemplateDescription: 'Sélectionnez un modèle préconfiguré pour les paramètres de lancement avancés du conteneur.',
            customAutostartScriptLabel: 'Script de Démarrage Automatique Personnalisé',
            customAutostartScriptDescription: 'Personnalisez la logique de démarrage automatique, laissez vide pour utiliser celle par défaut du fournisseur de l\'application.',
            saveInstallation: 'Enregistrer l\'Installation',
            updateStatusTitle: 'Statut de la Mise à Jour pour {appName}',
            checkingUpdates: 'Vérification des mises à jour...',
            updateAvailable: 'Une nouvelle version de l\'image est disponible !',
            yourVersion: 'Votre version : {sha}',
            latestAvailable: 'La dernière version est disponible pour être téléchargée depuis le registre.',
            pullLatest: 'Télécharger la Dernière Image',
            upToDate: 'Votre image est à jour.',
            currentVersion: 'Version actuelle : {sha}',
            errorChecking: 'Erreur lors de la vérification des mises à jour.',
            pullingLatest: 'Téléchargement de la dernière image... Cela peut prendre un moment.',
            pullComplete: 'Téléchargement terminé !',
            newVersion: 'Nouvelle version : {sha}',
            errorPulling: 'Erreur lors du téléchargement de l\'image.',
            manualInstallNote: "Note : Les images ajoutées manuellement doivent être basées sur une image compatible avec selkies-baseimage.",
        },
        status: {
            loggingIn: 'Connexion en cours...',
            configSaved: 'Configuration enregistrée avec succès !',
            configApplied: 'Configuration appliquée ! Veuillez vous connecter et tester.',
            configApplyFailed: 'Échec de l\'application de la configuration : {error}',
            fileReadError: 'Erreur de lecture du fichier.',
            noConfig: 'Veuillez fournir un fichier de configuration ou du texte.',
            loggedInAdmin: 'Connecté en tant qu\'admin : {username}',
            loggedInUser: 'Connecté en tant qu\'utilisateur standard : {username}.',
            loginFailed: 'Échec de la connexion : {error}',
            adminDataRefreshFailed: 'Échec de l\'actualisation des données admin : {error}',
            closingSession: 'Validation de la session de personnalisation...',
            sessionClosed: 'Session de personnalisation fermée.',
            sessionCloseFailed: 'Échec de la fermeture de la session de personnalisation : {error}',
            logoutSuccess: 'Déconnecté et configuration effacée.',
            generateConfigFailed: 'Impossible de générer la config, les détails de l\'utilisateur sont manquants.',
            copySuccess: 'Configuration copiée dans le presse-papiers !',
            copyFailed: 'Échec de la copie du texte.',
            publicKeyCopied: 'Clé publique copiée !',
            keyCopyFailed: 'Échec de la copie de la clé.',
            creatingAdmin: 'Création de l\'admin...',
            adminCreated: 'Admin \'{username}\' créé.',
            adminCreateFailed: 'Erreur lors de la création de l\'admin : {error}',
            adminDeleted: 'Admin \'{username}\' supprimé avec succès.',
            adminDeleteFailed: 'Erreur lors de la suppression de l\'admin : {error}',
            creatingUser: 'Création de l\'utilisateur...',
            userCreated: 'Utilisateur \'{username}\' créé.',
            userCreateFailed: 'Erreur lors de la création de l\'utilisateur : {error}',
            userDeleted: 'Utilisateur \'{username}\' supprimé avec succès.',
            userDeleteFailed: 'Erreur lors de la suppression de l\'utilisateur : {error}',
            userUpdated: 'Utilisateur \'{username}\' mis à jour avec succès.',
            userUpdateFailed: 'Erreur lors de la mise à jour de l\'utilisateur : {error}',
            creatingGroup: 'Création du groupe...',
            groupCreated: 'Groupe \'{groupName}\' créé.',
            groupCreateFailed: 'Erreur lors de la création du groupe : {error}',
            groupDeleted: 'Groupe \'{groupName}\' supprimé avec succès.',
            groupDeleteFailed: 'Erreur lors de la suppression du groupe : {error}',
            groupUpdated: 'Groupe \'{groupName}\' mis à jour avec succès.',
            groupUpdateFailed: 'Erreur lors de la mise à jour du groupe : {error}',
            homedirLoadFailed: 'Échec du chargement des dossiers personnels : {error}',
            homedirCreateFailed: 'Erreur lors de la création du dossier : {error}',
            homedirCreated: 'Dossier personnel \'{homeName}\' créé.',
            homedirDeleted: 'Dossier \'{homeName}\' supprimé.',
            homedirDeleteFailed: 'Erreur lors de la suppression du dossier : {error}',
            homedirCreatedFor: 'Dossier \'{homeName}\' créé pour {username}.',
            homedirDeletedFor: 'Dossier \'{homeName}\' supprimé pour {username}.',
            sessionsLoadFailed: 'Échec du chargement des sessions : {error}',
            sessionStopError: 'Erreur lors de l\'arrêt de la session : {error}',
            sessionStopped: 'Session arrêtée avec succès.',
            appDataRefreshFailed: 'Échec de l\'actualisation des données de l\'app : {error}',
            fetchingApps: 'Récupération des apps du magasin...',
            fetchAppsFailed: 'Échec de la récupération des apps du magasin : {error}',
            appStoreAddFailed: 'Erreur lors de l\'ajout du magasin : {error}',
            appStoreAdded: 'Magasin d\'apps \'{name}\' ajouté.',
            appSaved: 'App \'{name}\' {action} avec succès.',
            appSaveActions: {
                updated: 'mise à jour',
                installed: 'installée'
            },
            appSaveFailed: 'Erreur lors de l\'enregistrement de l\'app : {error}',
            appDeleted: 'App \'{name}\' supprimée.',
            appDeleteFailed: 'Erreur lors de la suppression de l\'app : {error}',
            templateSaved: 'Modèle \'{name}\' enregistré avec succès.',
            templateSaveFailed: 'Erreur lors de l\'enregistrement du modèle : {error}',
            templateDeleted: 'Modèle \'{name}\' supprimé avec succès.',
            templateDeleteFailed: 'Erreur lors de la suppression du modèle : {error}',
            pinRemoved: 'Comportement épinglé supprimé.',
            keyGenerated: 'Nouvelle paire de clés générée.',
            keyGenFailed: 'La génération de la clé a échoué : {{error}}',
            pendingConfigSaved: 'Configuration en attente enregistrée. Vous pouvez maintenant fournir votre clé publique à l\'administrateur.',
            settingsSaved: 'Paramètres enregistrés.',
            appCreated: 'Application \'{name}\' créée avec succès.',
            launchFailed: 'Échec du lancement : {error}',
        },
        placeholders: {
            noAdmins: 'Aucun admin trouvé.',
            noUsers: 'Aucun utilisateur trouvé.',
            noGroups: 'Aucun groupe trouvé.',
            noHomeDirs: 'Aucun dossier personnel trouvé.',
            noSessions: 'Aucune session active trouvée.',
            noPinned: 'Aucun comportement épinglé trouvé.',
            errorLoading: 'Erreur lors du chargement des dossiers.',
            noInstalledApps: 'Aucune application n\'a encore été installée.',
        },
    },
    popup: {
        tabs: {
            launch: 'Lancer Nouveau',
            sessions: 'Sessions Actives',
            manageFiles: 'Gérer les fichiers',
            uploadStorage: 'Téléverser vers Stockage',
            uploadFiles: 'Téléverser Fichiers',
            uploadFilesTitle: 'Ouvrir la page dédiée au téléversement de fichiers'
        },
        launchView: {
            searchPlaceholder: 'Rechercher des applications...',
            uploadingFile: 'Téléversement du fichier...',
            gpuLabel: 'GPU',
            storageLabel: 'Stockage',
            languageLabel: 'Langue',
            cleanroom: 'Salle Blanche (Éphémère)',
            noGpu: 'Aucun',
            saveOptions: 'Enregistrer ces options de lancement',
            saveOptionsForUrl: 'Enregistrer les options pour toutes les URL',
            saveOptionsForFile: 'Enregistrer les options pour les fichiers .{extension}',
            openFile: 'Ouvrir le fichier au lancement',
            launchButton: 'Lancer',
            launchingButton: 'Lancement...',
            uploadingButton: 'Téléversement...',
            autoHome: 'Auto (persistance par application)',
            collaborationMode: 'Session collaborative',
            waylandMode: 'Mode Wayland',
        },
        sessionsView: {
            noSessions: 'Aucune session active trouvée.',
        },
        uploadStorageView: {
            selectHome: 'Sélectionner un Dossier Personnel',
            description: 'Ceci téléversera le fichier <strong>{filename}</strong> directement dans votre espace de stockage Fichiers pour une utilisation future.',
            descriptionFallback: 'Ceci téléversera le fichier <strong>{filename}</strong> directement dans votre espace de stockage Fichiers pour une utilisation future.',
            uploadButton: 'Téléverser le Fichier',
            uploadingButton: 'Téléversement...',
            preparing: 'Préparation du fichier...',
            uploadingChunk: 'Téléversement du segment {current} sur {total}...',
            finalizing: 'Finalisation...',
            uploadComplete: 'Téléversement Terminé !',
        },
        status: {
            unconfigured: 'Veuillez configurer l\'extension via la page des options.',
            openingServerFile: "Ouverture du fichier côté serveur : {filename}",
            openingFile: 'Ouverture du fichier : {filename}',
            openingUrl: 'Ouverture de l\'URL : {targetUrl}',
            error: 'Erreur : {message}',
            preparingFile: 'Préparation du fichier...',
            sendingFile: 'Envoi du fichier à la session...',
            errorSendingFile: 'Erreur lors de l\'envoi du fichier : {message}',
            errorClosingSession: 'Erreur lors de la fermeture de la session : {message}',
            preparingSession: 'Préparation de la session isolée...',
            fetchingData: 'Récupération des données du fichier...',
            fetchDataFailed: 'Échec de la récupération des données du fichier : {statusText}',
            unknownAction: 'Action de lancement inconnue.',
            noAppSelected: 'Veuillez sélectionner une application.',
            noAppsAvailable: 'Aucune application n\'est disponible pour votre compte.',
            uploadSuccess: 'Fichier téléversé avec succès !',
            creatingAutoHome: 'Création du répertoire personnel automatique...',
        },
        languages: {
            default: 'Défaut ({locale})'
        }
    },
    upload: {
        title: 'Téléversement de Fichier',
        description: 'Sélectionnez un fichier de votre ordinateur pour l\'ouvrir dans une session sécurisée et isolée.',
        dropzone: {
            title: 'Glissez et déposez un fichier ici',
            or: 'ou',
            button: 'Sélectionner un Fichier',
        },
        confirm: {
            ready: 'Le fichier est prêt à être ouvert de manière sécurisée.',
            button: 'Continuer pour Lancer',
        }
    },
    files: {
        title: 'Fichiers SealSkin',
        header: {
            title: 'Fichiers',
            newFolder: 'Nouveau Dossier',
            uploadFiles: 'Téléverser des Fichiers',
            uploadFolder: 'Téléverser un Dossier'
        },
        sidebar: {
            sharedFiles: 'Fichiers SealSkin',
            publicShares: 'Partages Publics'
        },
        shares: {
            title: 'Fichiers Partagés Publiquement',
            searchPlaceholder: 'Rechercher par nom de fichier ou ID...'
        },
        table: {
            name: 'Nom',
            size: 'Taille',
            lastModified: 'Dernière Modification',
            created: 'Créé le',
            expires: 'Expire le',
            url: 'URL Publique',
            passwordProtected: 'Mot de passe'
        },
        dropzone: {
            title: 'Déposez des fichiers pour les téléverser'
        },
        pagination: {
            previous: '« Précédent',
            next: 'Suivant »',
            pageOf: 'Page {page} sur {totalPages}'
        },
        modals: {
            newFolder: {
                title: 'Créer un Nouveau Dossier',
                folderNameLabel: 'Nom du Dossier',
                nameTitle: 'Utilisez uniquement des lettres, des chiffres, des traits de soulignement, des tirets ou des points.',
                createButton: 'Créer'
            },
            confirmDelete: {
                title: 'Confirmer la Suppression',
                message: 'Êtes-vous sûr de vouloir supprimer {count, plural, one {1 élément sélectionné} other {{count} éléments sélectionnés}} ? Cette action est irréversible.',
                messageDefault: 'Êtes-vous sûr de vouloir supprimer les éléments sélectionnés ? Cette action est irréversible.'
            },
            uploadProgress: {
                title: 'Progression du Téléversement',
                doneButton: 'Terminé'
            },
            share: {
                title: 'Partager le Fichier',
                sharingFile: 'Partage du fichier : <strong>{filename}</strong>',
                passwordLabel: 'Mot de passe (optionnel)',
                passwordPlaceholder: 'Laisser vide pour ne pas mettre de mot de passe',
                expiryLabel: 'Expire dans (heures, optionnel)',
                expiryPlaceholder: 'ex., 24 pour un jour',
                shareButton: 'Créer un Lien de Partage'
            }
        },
        status: {
            homeDirLoadFailed: 'Échec du chargement des répertoires personnels : {error}',
            filesLoadFailed: 'Erreur lors du chargement des fichiers : {error}',
            deleteProtectedError: 'Impossible de supprimer les dossiers système protégés.',
            deletingItems: 'Suppression de {count, plural, one {1 élément} other {{count} éléments}}...',
            deleteSuccess: 'Suppression réussie.',
            deleteFailed: 'Échec de la suppression : {error}',
            preparingUpload: 'Préparation du téléversement de {count, plural, one {1 fichier} other {{count} fichiers}}...',
            uploadPrepFailed: 'Erreur lors de la préparation du téléversement du dossier : {error}',
            notConfigured: 'Erreur : SealSkin non configuré. Veuillez le configurer dans les options.',
            folderCreated: 'Dossier \'{folderName}\' créé.',
            folderCreateFailed: 'Erreur lors de la création du dossier : {error}',
            shareCreated: 'Partage créé avec succès ! Le lien a été copié dans votre presse-papiers.',
            shareCreateFailed: 'Échec de la création du partage : {error}',
            sharesLoadFailed: 'Échec du chargement des fichiers partagés : {error}',
            shareDeleteFailed: 'Échec de la suppression du partage : {error}',
            shareDeleted: 'Partage supprimé avec succès.',
            urlCopied: 'URL publique copiée dans le presse-papiers.'
        },
        placeholders: {
            errorLoading: 'Erreur lors du chargement des fichiers.',
            folderEmpty: 'Ce dossier est vide.',
            noHomeDirs: 'Aucun répertoire personnel disponible.',
            noShares: 'Vous n\'avez encore partagé aucun fichier.'
        },
        uploadStatus: {
            pending: 'en attente',
            initiating: 'Initialisation...',
            uploading: 'Téléversement...',
            finalizing: 'Finalisation...',
            completed: 'Terminé',
            error: 'Erreur'
        }
    }
};

// --- Russian Translations ---
const ru = {
    background: {
        contextMenu: {
            openUrl: 'Открыть ссылку в SealSkin',
            openFile: 'Открыть объект ссылки как файл в SealSkin',
            sendMedia: 'Отправить медиа в SealSkin',
            searchText: 'Искать "%s" в SealSkin',
            sendDownload: 'Отправить следующую загрузку в SealSkin'
        }
    },
    common: {
        actions: 'Действия',
        active: 'Активен',
        cancel: 'Отмена',
        manage: 'Управлять',
        delete: 'Удалить',
        edit: 'Изменить',
        save: 'Сохранить',
        none: 'нет',
        error: 'Ошибка',
        na: 'Н/Д',
        of: 'из',
        status: 'Статус',
        username: 'Имя пользователя',
        group: 'Группа',
        groups: 'Группы',
        publicKey: 'Открытый ключ',
        name: 'Имя',
        source: 'Источник',
        imageVersion: 'Версия образа',
        language: 'Язык',
        storage: 'Хранилище',
        gpu: 'ГП',
        version: 'Версия',
        checked: 'Проверено',
        never: 'Никогда',
        stop: 'Остановить',
        reopen: 'Открыть снова',
        sendFile: 'Отправить файл',
        share: 'Поделиться',
        search: 'Поиск',
        refresh: 'Обновить',
        close: 'Закрыть',
        copy: 'Копировать',
        open: "Открыть",
        copyUrl: 'Копировать URL',
        download: 'Скачать',
        next: 'Далее',
        previous: 'Назад',
        page: 'Страница',
        home: 'Домашний каталог',
        homes: 'Домашние каталоги',
        sessions: 'Сессии',
        users: 'Пользователи',
        admins: 'Администраторы',
        yes: 'Да',
        no: 'Нет',
        daysAgo: '{count, plural, one {# день назад} few {# дня назад} many {# дней назад}}',
        hoursAgo: '{count, plural, one {# час назад} few {# часа назад} many {# часов назад}}',
        minutesAgo: '{count, plural, one {# минуту назад} few {# минуты назад} many {# минут назад}}',
        justNow: 'только что',
        bytes: 'Байты',
        kb: 'КБ',
        mb: 'МБ',
        gb: 'ГБ',
        tb: 'ТБ',
        pb: 'ПБ',
    },
    options: {
        sidebar: {
            config: 'Конфигурация',
            home: 'Домашние каталоги',
            sessions: 'Активные сессии',
            pinned: 'Закреплённое поведение',
            appStore: 'Магазин приложений',
            appTemplates: 'Шаблоны приложений',
            appLaboratory: 'Лаборатория приложений',
            installedApps: 'Установленные приложения',
            users: 'Пользователи',
            groups: 'Группы',
            admins: 'Администраторы',
        },
        dashboard: {
            title: 'Панель управления',
            clientSettings: 'Настройки клиента',
            exportConfig: 'Экспорт конфигурации',
            userStatus: 'Статус пользователя',
            loggedInAs: 'Вы вошли как:',
            role: 'Роль',
            roleAdmin: 'Администратор',
            roleUser: 'Стандартный пользователь',
            serverInfo: 'Информация о сервере',
            server: 'Сервер:',
            cpuModel: 'Модель ЦП:',
            storageUsage: 'Использование хранилища:',
            detectedGpus: 'Обнаруженные ГП:',
            logout: 'Выйти и очистить конфигурацию',
            howTo: 'Как использовать SealSkin',
            howToDescription: 'Этот раздел содержит базовую документацию по использованию расширения.',
            howToList: [
                '<strong>Чтобы открыть контент в изоляции:</strong> Щёлкните правой кнопкой мыши по любой ссылке, изображению или выделенному тексту и выберите опцию из контекстного меню "SealSkin Isolation".',
                '<strong>Чтобы отправить загрузку в изоляцию:</strong> Щёлкните правой кнопкой мыши на странице и выберите "Отправить следующую загрузку в изоляцию". Следующий загружаемый файл будет перехвачен и отправлен в безопасную сессию.',
                '<strong>Чтобы запустить чистое приложение:</strong> Нажмите на иконку SealSkin на панели инструментов вашего браузера.',
                '<strong>Для управления постоянным хранилищем:</strong> Используйте вкладку "Домашние каталоги" на этой странице для создания и удаления томов хранения, которые можно использовать в нескольких сессиях.',
                '<strong>Чтобы сохранить параметры запуска:</strong> Установите флажок "Сохранить эти параметры запуска" во всплывающем окне перед запуском приложения для определённого типа файлов (например, .pdf) или для всех URL-адресов. Управляйте этими сохранёнными предпочтениями на вкладке "Закреплённое поведение".'
            ],
            confirmLogout: 'Вы уверены, что хотите выйти? Это удалит вашу сохранённую конфигурацию из этого браузера.',
        },
        config: {
            quickSetup: 'Быстрая настройка',
            quickSetupDescription: 'Загрузите файл конфигурации (.json), предоставленный вашим администратором, или вставьте его содержимое ниже, чтобы автоматически настроить расширение.',
            uploadLabel: 'Загрузить файл конфигурации',
            pasteLabel: 'Или вставьте текст конфигурации',
            pastePlaceholder: 'Вставьте вашу JSON конфигурацию сюда...',
            applyButton: 'Применить конфигурацию',
            manualLink: 'Ручная настройка',
            advancedTitle: 'Конфигурация клиента (расширенная)',
            serverIpLabel: 'IP или домен сервера',
            serverIpPlaceholder: 'например, 192.168.1.100',
            apiPortLabel: 'Порт API',
            apiPortPlaceholder: 'например, 8000',
            sessionPortLabel: 'Порт сессии',
            sessionPortPlaceholder: 'например, 8443',
            usernameLabel: 'Имя пользователя',
            usernamePlaceholder: 'Ваше имя пользователя',
            privateKeyLabel: 'Ваш закрытый ключ (формат PEM)',
            privateKeyPlaceholder: 'Вставьте содержимое вашего закрытого ключа сюда',
            serverKeyLabel: 'Открытый ключ сервера (формат PEM)',
            serverKeyPlaceholder: 'Вставьте содержимое server_public.pem сюда',
            searchEngineLabel: 'Поисковая система по умолчанию для выделенного текста',
            saveButton: 'Сохранить конфигурацию',
            loginButton: 'Войти и проверить',
            automaticLink: 'Автоматическая настройка',
            chooseFile: 'Выберите файл',
            keyGeneration: 'Генерация ключей',
            keyGenDescription: 'Если у вас нет пары ключей, вы можете сгенерировать ее здесь. Закрытый ключ будет вставлен выше. Предоставьте открытый ключ вашему администратору.',
            generateKeyButton: 'Сгенерировать новую пару ключей',
            publicKeyForAdminLabel: 'Ваш открытый ключ (для администратора)',
        },
        home: {
            title: 'Ваши домашние каталоги',
            description: 'Создавайте постоянные каталоги хранения для использования в разных сессиях. Они будут смонтированы в ваши приложения как ваш конфигурационный каталог.',
            newTitle: 'Создать новый домашний каталог',
            nameLabel: 'Имя каталога:',
            namePlaceholder: 'например, мои-проектные-файлы',
            nameTitle: 'Используйте только буквы, цифры, подчёркивание или дефис.',
            createButton: 'Создать каталог',
            isLaboratory: 'Это лабораторное приложение, созданное на основе базового образа с пользовательскими настройками.',
            laboratory: 'Лаборатория',
            confirmDelete: 'Вы уверены, что хотите удалить установленное приложение \'{appName}\'?'
        },
        sessions: {
            title: 'Активные сессии',
            application: 'Приложение',
            started: 'Запущена',
            noSessionsUser: 'Активных сессий не найдено.',
            noSessionsAdmin: 'Не найдено активных сессий ни у одного пользователя.',
            sessionsFor: 'Сессии для {username} ({count})',
            confirmStop: 'Вы уверены, что хотите остановить эту сессию? Контейнер будет уничтожен.',
        },
        pinned: {
            title: 'Закреплённое поведение расширения',
            description: 'В этой таблице показаны параметры запуска, которые вы сохранили для определённых типов файлов или для всех URL-адресов. Вы можете удалить закреплённое поведение, чтобы снова получать запрос на выбор параметров запуска.',
            trigger: 'Триггер',
            savedApp: 'Сохранённое приложение',
            triggerSimple: 'Простой запуск (кнопка на панели)',
            triggerUrl: 'Все URL (из контекстного меню)',
            triggerFile: 'Тип файла: <strong>{fileType}</strong>',
            unknownApp: 'Неизвестное приложение ({appId}...)'
        },
        admins: {
            serverKeyTitle: 'Открытый ключ сервера',
            serverKeyDescription: 'Это открытый ключ, который потребуется файлам конфигурации пользователей для подключения к этому серверу.',
            title: 'Управление администраторами',
            searchPlaceholder: 'Поиск администраторов...',
            newTitle: 'Создать нового администратора',
            publicKeyOptionalLabel: 'Открытый ключ (необязательно):',
            publicKeyPlaceholder: 'Вставьте открытый ключ сюда или оставьте пустым для генерации.',
            createButton: 'Создать администратора',
            confirmDelete: 'Вы уверены, что хотите удалить администратора \'{username}\'? Это также удалит всё его постоянное хранилище и не может быть отменено.',
        },
        users: {
            title: 'Управление пользователями',
            searchPlaceholder: 'Поиск пользователей по имени или группе...',
            newTitle: 'Создать нового пользователя',
            publicKeyOptionalLabel: 'Открытый ключ (необязательно):',
            publicKeyPlaceholder: 'Вставьте открытый ключ пользователя сюда или оставьте пустым для генерации.',
            settingsTitle: 'Настройки пользователя',
            sessionLimitLabel: 'Лимит сессий',
            sessionLimitTitle: 'Количество активных сессий, которое может иметь пользователь. -1 для неограниченного.',
            permissionsTitle: 'Разрешения и усиление защиты',
            activeAccount: 'Активная учётная запись',
            allowStorage: 'Разрешить постоянное хранилище',
            allowGpu: 'Разрешить доступ к ГП',
            hardenContainer: 'Усилить защиту контейнера',
            hardenWm: 'Усилить защиту оконного менеджера',
            createButton: 'Создать пользователя',
            homesDisabledTooltip: 'Постоянное хранилище отключено для этого пользователя',
            confirmDelete: 'Вы уверены, что хотите удалить пользователя \'{username}\'? Это также удалит всё его постоянное хранилище и не может быть отменено.',
            allowPublicSharing: 'Разрешить публичный обмен файлами',
        },
        groups: {
            title: 'Управление группами',
            searchPlaceholder: 'Поиск групп...',
            newTitle: 'Создать новую группу',
            nameLabel: 'Название группы:',
            overrideTitle: 'Настройки переопределения для группы',
            permissionsTitle: 'Переопределения разрешений и усиления защиты',
            createButton: 'Создать группу',
            confirmDelete: 'Вы уверены, что хотите удалить группу \'{groupName}\'? Пользователи в этой группе вернутся к своим индивидуальным настройкам.',
        },
        installedApps: {
            title: 'Установленные приложения',
            searchPlaceholder: 'Поиск установленных приложений...',
            noAppsFound: 'Установленных приложений не найдено.',
            pulling: 'Загрузка нового образа...',
            notLocal: 'Образ не найден локально',
            confirmDelete: 'Вы уверены, что хотите удалить установленное приложение \'{appName}\'?',
        },
        appStore: {
            title: 'Магазины приложений',
            refreshTitle: 'Обновить выбранный магазин',
            selectLabel: 'Выберите магазин приложений',
            addLabel: 'Добавить новый магазин приложений',
            namePlaceholder: 'Название магазина',
            urlPlaceholder: 'URL YAML магазина',
            availableTitle: 'Доступные приложения',
            addManual: "Добавить приложение вручную",
            searchPlaceholder: 'Поиск доступных приложений...',
            noAppsFound: 'Приложений не найдено.',
            availableFrom: 'Доступные приложения из {storeName}',
            couldNotLoad: 'Не удалось загрузить приложения из этого магазина.',
        },
        appTemplates: {
            title: 'Редактор шаблонов приложений',
            loadLabel: 'Загрузить шаблон',
            createOption: 'Создать новый шаблон',
            nameLabel: 'Имя шаблона',
            namePlaceholder: 'Введите имя для нового шаблона',
            saveButton: 'Сохранить профиль',
            deleteButton: 'Удалить',
            previewTitle: 'Предпросмотр интерфейса',
            contentArea: 'Область содержимого приложения',
            confirmDelete: 'Вы уверены, что хотите удалить шаблон \'{templateName}\'? Это действие нельзя отменить.',
            deleteDisabled: 'Этот шаблон не может быть удалён.',
            enterName: 'Пожалуйста, введите имя для нового шаблона.',
            settings: {
                TITLE: { label: "Заголовок страницы", description: "Заголовок страницы, отображаемый в веб-браузере." },
                SELKIES_UI_TITLE: { label: "Заголовок боковой панели", description: "Заголовок в верхнем левом углу боковой панели." },
                SELKIES_UI_SHOW_SIDEBAR: { label: "Показывать боковую панель", description: "Показывать основной интерфейс боковой панели." },
                SELKIES_UI_SHOW_LOGO: { label: "Показывать логотип", description: "Показывать логотип Selkies на боковой панели." },
                SELKIES_UI_SHOW_CORE_BUTTONS: { label: "Показывать основные кнопки", description: "Показывать кнопки основных компонентов (дисплей, аудио и т.д.)." },
                SELKIES_UI_SIDEBAR_SHOW_VIDEO_SETTINGS: { label: "Показывать настройки видео", description: "Показывать раздел настроек видео на боковой панели." },
                SELKIES_UI_SIDEBAR_SHOW_SCREEN_SETTINGS: { label: "Показывать настройки экрана", description: "Показывать раздел настроек экрана на боковой панели." },
                SELKIES_UI_SIDEBAR_SHOW_AUDIO_SETTINGS: { label: "Показывать настройки аудио", description: "Показывать раздел настроек аудио на боковой панели." },
                SELKIES_UI_SIDEBAR_SHOW_STATS: { label: "Показывать статистику", description: "Показывать раздел статистики на боковой панели." },
                SELKIES_UI_SIDEBAR_SHOW_CLIPBOARD: { label: "Показывать буфер обмена", description: "Показывать раздел буфера обмена на боковой панели." },
                SELKIES_UI_SIDEBAR_SHOW_FILES: { label: "Показывать раздел файлов", description: "Показывать раздел передачи файлов на боковой панели." },
                SELKIES_UI_SIDEBAR_SHOW_APPS: { label: "Показывать раздел приложений", description: "Показывать раздел приложений на боковой панели." },
                SELKIES_UI_SIDEBAR_SHOW_SHARING: { label: "Показывать раздел общего доступа", description: "Показывать раздел общего доступа на боковой панели." },
                SELKIES_UI_SIDEBAR_SHOW_GAMEPADS: { label: "Показывать раздел геймпадов", description: "Показывать раздел геймпадов на боковой панели." },
                SELKIES_UI_SIDEBAR_SHOW_KEYBOARD_BUTTON: { label: "Показывать кнопку клавиатуры", description: "Показывать кнопку экранной клавиатуры." },
                SELKIES_UI_SIDEBAR_SHOW_SOFT_BUTTONS: { label: "Показывать экранные кнопки", description: "Показывать раздел экранных кнопок (для мобильных устройств)." },
                WATERMARK_PNG: { label: "Путь к PNG водяного знака", description: "Полный путь внутри контейнера к PNG-файлу водяного знака." },
                WATERMARK_LOCATION: { label: "Расположение водяного знака", description: "Где рисовать изображение поверх потока.", options: { disabled: "Отключено", topLeft: "Сверху-слева", topRight: "Сверху-справа", bottomLeft: "Снизу-слева", bottomRight: "Снизу-справа", centered: "По центру", animated: "Анимированный" } },
                DASHBOARD: { label: "Стиль панели управления", description: "Позволяет пользователю установить свою панель управления.", options: { default: "По умолчанию", selkiesDefault: "Selkies (по умолчанию)", zinc: "Zinc", wish: "Wish" } },
                SELKIES_AUDIO_ENABLED: { label: "Включить аудио", description: "Включить потоковую передачу аудио с сервера на клиент." },
                SELKIES_MICROPHONE_ENABLED: { label: "Включить микрофон", description: "Включить перенаправление микрофона с клиента на сервер." },
                SELKIES_GAMEPAD_ENABLED: { label: "Включить геймпад", description: "Включить поддержку геймпада." },
                SELKIES_CLIPBOARD_ENABLED: { label: "Включить буфер обмена", description: "Включить синхронизацию буфера обмена." },
                SELKIES_ENABLE_BINARY_CLIPBOARD: { label: "Включить бинарный буфер обмена", description: "Разрешить двоичные данные (изображения) в буфере обмена." },
                SELKIES_COMMAND_ENABLED: { label: "Включить командный веб-сокет", description: "Включить разбор сообщений командного веб-сокета." },
                SELKIES_FILE_TRANSFERS: { label: "Передача файлов", description: "Разрешённые направления ('upload,download', 'upload', 'download', 'none')." },
                SELKIES_ENABLE_SHARING: { label: "Включить весь общий доступ", description: "Главный переключатель для всех функций общего доступа." },
                SELKIES_SECOND_SCREEN: { label: "Включить второй экран", description: "Включить поддержку второго монитора/дисплея." },
                SELKIES_USE_BROWSER_CURSORS: { label: "Использовать курсоры браузера", description: "Использовать CSS-курсоры браузера вместо рендеринга на холсте." },
                SELKIES_USE_CSS_SCALING: { label: "Использовать CSS-масштабирование (LoDPI)", description: "Если true, отправляется более низкое разрешение, и холст растягивается." },
                SELKIES_IS_MANUAL_RESOLUTION_MODE: { label: "Режим ручного разрешения", description: "Заблокировать разрешение на ручных значениях ширины/высоты." },
                SELKIES_MANUAL_WIDTH: { label: "Ручная ширина", description: "Заблокировать ширину на фиксированном значении. Принудительно включает ручной режим." },
                SELKIES_MANUAL_HEIGHT: { label: "Ручная высота", description: "Заблокировать высоту на фиксированном значении. Принудительно включает ручной режим." },
                SELKIES_SCALING_DPI: { label: "DPI масштабирования интерфейса", description: "DPI по умолчанию для масштабирования интерфейса." },
                SELKIES_AUDIO_BITRATE: { label: "Битрейт аудио", description: "Битрейт аудио по умолчанию." },
                SELKIES_ENCODER: { label: "Кодировщики", description: "Список кодировщиков через запятую. Первый является кодировщиком по умолчанию." },
                SELKIES_USE_CPU: { label: "Принудительное кодирование ЦП", description: "Принудительное кодирование на основе ЦП для pixelflux." },
                SELKIES_FRAMERATE: { label: "Частота кадров (диапазон или фиксированная)", description: "например, '8-120' для диапазона или '60' для фиксированного значения." },
                SELKIES_H264_CRF: { label: "H.264 CRF (диапазон или фиксированный)", description: "например, '5-50' для диапазона или '25' для фиксированного значения." },
                SELKIES_JPEG_QUALITY: { label: "Качество JPEG (диапазон или фиксированное)", description: "например, '1-100' для диапазона или '60' для фиксированного значения." },
                SELKIES_H264_FULLCOLOR: { label: "Полный цвет H.264", description: "Включить полный цветовой диапазон H.264 для кодировщиков pixelflux." },
                SELKIES_H264_STREAMING_MODE: { label: "Режим потоковой передачи H.264 (Turbo)", description: "Включить режим потоковой передачи H.264 с низкой задержкой." },
                SELKIES_USE_PAINT_OVER_QUALITY: { label: "Использовать качество для статичных сцен", description: "Включить высококачественную прорисовку для статичных сцен." },
                SELKIES_PAINT_OVER_JPEG_QUALITY: { label: "Качество JPEG для статичных сцен", description: "например, '1-100' для диапазона или '90' для фиксированного значения." },
                SELKIES_H264_PAINTOVER_CRF: { label: "H.264 CRF для статичных сцен", description: "например, '5-50' для диапазона или '18' для фиксированного значения." },
                SELKIES_H264_PAINTOVER_BURST_FRAMES: { label: "Пакет кадров для статичных сцен", description: "например, '1-30' для диапазона или '5' для фиксированного значения." },
                HARDEN_DESKTOP: { label: "Усилить защиту рабочего стола (пресет)", description: "Включает DISABLE_OPEN_TOOLS, DISABLE_SUDO и DISABLE_TERMINALS." },
                HARDEN_OPENBOX: { label: "Усилить защиту оконного менеджера (пресет)", description: "Включает DISABLE_CLOSE_BUTTON, DISABLE_MOUSE_BUTTONS и HARDEN_KEYBINDS. Также включает RESTART_APP." },
                DISABLE_OPEN_TOOLS: { label: "Отключить инструменты открытия", description: "Отключает бинарные файлы xdg-open и exo-open." },
                DISABLE_SUDO: { label: "Отключить Sudo", description: "Отключает команду sudo." },
                DISABLE_TERMINALS: { label: "Отключить терминалы", description: "Отключает распространённые эмуляторы терминалов." },
                DISABLE_CLOSE_BUTTON: { label: "Отключить кнопку закрытия окна", description: "Удаляет кнопку закрытия из заголовков окон." },
                DISABLE_MOUSE_BUTTONS: { label: "Отключить правую/среднюю кнопки мыши", description: "Отключает контекстные меню по правому и среднему щелчку мыши." },
                HARDEN_KEYBINDS: { label: "Усилить защиту сочетаний клавиш", description: "Отключает сочетания клавиш Openbox по умолчанию, такие как Alt+F4." },
                RESTART_APP: { label: "Перезапускать приложение при закрытии", description: "Автоматически перезапускает основное приложение, если оно было закрыто." },
                MAX_RES: { label: "Максимальное разрешение", description: "Максимальное разрешение для контейнера, по умолчанию 16k." },
                START_DOCKER: { label: "Запускать Docker-in-Docker", description: "Если false, привилегированный контейнер не будет запускать DinD." },
                DISABLE_IPV6: { label: "Отключить IPv6", description: "Если true, это отключит IPv6." },
                DISABLE_ZINK: { label: "Отключить Zink", description: "Не устанавливать переменные окружения Zink при обнаружении видеокарты." },
                DISABLE_DRI3: { label: "Отключить DRI3", description: "Не использовать ускорение DRI3 при обнаружении видеокарты." },
                NO_DECOR: { label: "Без декораций окна", description: "Запускать приложение без рамок окна для использования в PWA." },
                NO_FULL: { label: "Не в полноэкранном режиме", description: "Не разворачивать приложения на весь экран автоматически." },
                NO_GAMEPAD: { label: "Отключить инъекцию геймпада", description: "Отключить инъекцию перехватчика геймпада в пользовательском пространстве." },
                SELKIES_DEBUG: { label: "Включить отладку Selkies", description: "Включить отладочное логирование для компонентов потоковой передачи." },
            }
        },
        appLaboratory: {
            title: 'Лаборатория приложений',
            description: 'Создавайте и тестируйте пользовательские конфигурации приложений, накладывая изменения поверх базового приложения.',
            selectApp: 'Выбрать приложение',
            createNew: 'Создать новое приложение',
            baseApp: 'Базовое приложение',
            baseAppDescription: 'Установленное приложение, на котором будет основано ваше новое пользовательское приложение.',
            selectBase: 'Выберите базовое приложение',
            customizationTitle: 'Настройка',
            appName: 'Название приложения',
            appIcon: 'Иконка приложения',
            uploadIcon: 'Загрузить иконку',
            autostartScriptLabel: 'Пользовательский скрипт автозапуска',
            permissionsTitle: 'Разрешения',
            usersLabel: 'Разрешённые пользователи',
            groupsLabel: 'Разрешённые группы',
            launchButton: 'Сохранить и запустить сеанс настройки',
            closeButton: 'Закрыть сеанс и завершить',
            savingAndLaunching: 'Сохранение и запуск...',
            placeholder: 'Лаборатория приложений позволяет вам настраивать базовый домашний каталог и скрипт запуска для приложения на основе существующего установленного приложения. Этот домашний каталог будет скопирован при первой инициализации для пользователя со всеми файлами и настройками, которые вы установите в этом сеансе. Вы можете перезапустить существующее лабораторное приложение для дальнейшего изменения его содержимого.',
            formInvalid: 'Пожалуйста, выберите базовое приложение и укажите имя для нового приложения.',
        },
        modals: {
            editUserTitle: 'Изменить пользователя: {username}',
            saveChanges: 'Сохранить изменения',
            effectiveSettings: 'Действующие настройки (с учётом переопределений группы)',
            editGroupTitle: 'Изменить группу: {groupName}',
            userConfigTitle: 'Конфигурация пользователя',
            warning: 'Эта конфигурация будет показана только один раз. Предоставьте её пользователю безопасным способом.',
            info: 'Вы можете скачать этот файл конфигурации, чтобы легко настроить SealSkin на другом устройстве. Храните этот файл в безопасности, так как он содержит ваш закрытый ключ.',
            configDataLabel: 'Данные конфигурации (JSON)',
            copyButton: 'Копировать текст',
            downloadButton: 'Скачать файл',
            manageHomeDirs: 'Управление домашними каталогами',
            dirsForUser: 'Каталоги для пользователя: {username}',
            dirsForAdmin: 'Каталоги для администратора: {username}',
            newDirForUser: 'Создать новый каталог для пользователя',
            createDirButton: 'Создать каталог',
            confirmDeleteDir: 'Вы уверены, что хотите удалить \'{homeName}\' для пользователя \'{username}\'? Это действие необратимо.',
            installAppTitle: 'Установить {appName}',
            editAppTitle: 'Изменить {appName}',
            customNameLabel: 'Пользовательское имя',
            imageLabel: 'Образ контейнера',
            permissions: 'Разрешения',
            allowedUsersLabel: 'Разрешённые пользователи (через запятую, \'all\' для всех)',
            allowedGroupsLabel: 'Разрешённые группы (через запятую, \'all\' для всех)',
            features: 'Возможности',
            gpuSupport: 'Поддержка ГП',
            homeMounting: 'Монтирование домашнего каталога',
            urlSupport: 'Поддержка открытия URL',
            fileSupport: 'Поддержка открытия файлов',
            autoUpdate: 'Автоматически обновлять образ',
            advancedSettings: 'Расширенные настройки',
            appTemplateLabel: 'Шаблон приложения',
            appTemplateDescription: 'Выберите предварительно настроенный шаблон для расширенных настроек запуска контейнера.',
            customAutostartScriptLabel: 'Пользовательский скрипт автозапуска',
            customAutostartScriptDescription: 'Настройте логику автозапуска, оставьте поле пустым, чтобы использовать значение по умолчанию от поставщика приложения.',
            saveInstallation: 'Сохранить установку',
            updateStatusTitle: 'Статус обновления для {appName}',
            checkingUpdates: 'Проверка обновлений...',
            updateAvailable: 'Доступна новая версия образа!',
            yourVersion: 'Ваша версия: {sha}',
            latestAvailable: 'Последняя версия доступна для загрузки из реестра.',
            pullLatest: 'Загрузить последнюю версию',
            upToDate: 'Ваш образ обновлён до последней версии.',
            currentVersion: 'Текущая версия: {sha}',
            errorChecking: 'Ошибка при проверке обновлений.',
            pullingLatest: 'Загрузка последней версии образа... Это может занять некоторое время.',
            pullComplete: 'Загрузка завершена!',
            newVersion: 'Новая версия: {sha}',
            errorPulling: 'Ошибка при загрузке образа.',
            manualInstallNote: "Примечание: Образы, добавленные вручную, должны быть основаны на образе, совместимом с selkies-baseimage.",
        },
        status: {
            loggingIn: 'Вход в систему...',
            configSaved: 'Конфигурация успешно сохранена!',
            configApplied: 'Конфигурация применена! Пожалуйста, войдите и проверьте.',
            configApplyFailed: 'Не удалось применить конфигурацию: {error}',
            fileReadError: 'Ошибка чтения файла.',
            noConfig: 'Пожалуйста, предоставьте файл конфигурации или текст.',
            loggedInAdmin: 'Вы вошли как администратор: {username}',
            loggedInUser: 'Вы вошли как стандартный пользователь: {username}.',
            loginFailed: 'Ошибка входа: {error}',
            adminDataRefreshFailed: 'Не удалось обновить данные администратора: {error}',
            logoutSuccess: 'Выход выполнен, конфигурация очищена.',
            generateConfigFailed: 'Не удалось сгенерировать конфигурацию, отсутствуют данные пользователя.',
            copySuccess: 'Конфигурация скопирована в буфер обмена!',
            copyFailed: 'Не удалось скопировать текст.',
            publicKeyCopied: 'Открытый ключ скопирован!',
            keyCopyFailed: 'Не удалось скопировать ключ.',
            creatingAdmin: 'Создание администратора...',
            adminCreated: 'Администратор \'{username}\' создан.',
            adminCreateFailed: 'Ошибка создания администратора: {error}',
            adminDeleted: 'Администратор \'{username}\' успешно удалён.',
            adminDeleteFailed: 'Ошибка удаления администратора: {error}',
            creatingUser: 'Создание пользователя...',
            userCreated: 'Пользователь \'{username}\' создан.',
            userCreateFailed: 'Ошибка создания пользователя: {error}',
            userDeleted: 'Пользователь \'{username}\' успешно удалён.',
            userDeleteFailed: 'Ошибка удаления пользователя: {error}',
            userUpdated: 'Пользователь \'{username}\' успешно обновлён.',
            userUpdateFailed: 'Ошибка обновления пользователя: {error}',
            creatingGroup: 'Создание группы...',
            groupCreated: 'Группа \'{groupName}\' создана.',
            groupCreateFailed: 'Ошибка создания группы: {error}',
            groupDeleted: 'Группа \'{groupName}\' успешно удалена.',
            groupDeleteFailed: 'Ошибка удаления группы: {error}',
            groupUpdated: 'Группа \'{groupName}\' успешно обновлена.',
            groupUpdateFailed: 'Ошибка обновления группы: {error}',
            homedirLoadFailed: 'Не удалось загрузить домашние каталоги: {error}',
            homedirCreateFailed: 'Ошибка создания каталога: {error}',
            homedirCreated: 'Домашний каталог \'{homeName}\' создан.',
            homedirDeleted: 'Каталог \'{homeName}\' удалён.',
            homedirDeleteFailed: 'Ошибка удаления каталога: {error}',
            homedirCreatedFor: 'Каталог \'{homeName}\' создан для {username}.',
            homedirDeletedFor: 'Каталог \'{homeName}\' удалён для {username}.',
            sessionsLoadFailed: 'Не удалось загрузить сессии: {error}',
            sessionStopError: 'Ошибка остановки сессии: {error}',
            sessionStopped: 'Сессия успешно остановлена.',
            appDataRefreshFailed: 'Не удалось обновить данные приложения: {error}',
            closingSession: 'Сохранение сеанса настройки...',
            sessionClosed: 'Сеанс настройки закрыт.',
            sessionCloseFailed: 'Не удалось закрыть сеанс настройки: {error}',
            fetchingApps: 'Получение приложений из магазина...',
            fetchAppsFailed: 'Не удалось получить приложения из магазина: {error}',
            appStoreAddFailed: 'Ошибка добавления магазина: {error}',
            appStoreAdded: 'Магазин приложений \'{name}\' добавлен.',
            appSaved: 'Приложение \'{name}\' успешно {action}.',
            appSaveActions: {
                updated: 'обновлено',
                installed: 'установлено'
            },
            appSaveFailed: 'Ошибка сохранения приложения: {error}',
            appDeleted: 'Приложение \'{name}\' удалено.',
            appDeleteFailed: 'Ошибка удаления приложения: {error}',
            templateSaved: 'Шаблон \'{name}\' успешно сохранён.',
            templateSaveFailed: 'Ошибка сохранения шаблона: {error}',
            templateDeleted: 'Шаблон \'{name}\' успешно удалён.',
            templateDeleteFailed: 'Ошибка удаления шаблона: {error}',
            pinRemoved: 'Закреплённое поведение удалено.',
            keyGenerated: 'Новая пара ключей сгенерирована.',
            keyGenFailed: 'Ошибка генерации ключей: {{error}}',
            pendingConfigSaved: 'Ожидающая конфигурация сохранена. Теперь вы можете предоставить свой открытый ключ администратору.',
            settingsSaved: 'Настройки сохранены.',
            appCreated: 'Приложение \'{name}\' успешно создано.',
            launchFailed: 'Запуск не удался: {error}',
        },
        placeholders: {
            noAdmins: 'Администраторы не найдены.',
            noUsers: 'Пользователи не найдены.',
            noGroups: 'Группы не найдены.',
            noHomeDirs: 'Домашние каталоги не найдены.',
            noSessions: 'Активные сессии не найдены.',
            noPinned: 'Закреплённые поведения не найдены.',
            errorLoading: 'Ошибка загрузки каталогов.',
            noInstalledApps: 'Приложения еще не установлены.',
        },
    },
    popup: {
        tabs: {
            launch: 'Запустить',
            sessions: 'Активные сессии',
            manageFiles: 'Управлять файлами',
            uploadStorage: 'Загрузить в хранилище',
            uploadFiles: 'Загрузить файлы',
            uploadFilesTitle: 'Открыть отдельную страницу загрузки файлов'
        },
        launchView: {
            searchPlaceholder: 'Поиск приложений...',
            uploadingFile: 'Загрузка файла...',
            gpuLabel: 'ГП',
            storageLabel: 'Хранилище',
            languageLabel: 'Язык',
            cleanroom: 'Изолированная среда (Временная)',
            noGpu: 'Нет',
            saveOptions: 'Сохранить эти параметры запуска',
            saveOptionsForUrl: 'Сохранить параметры для всех URL',
            saveOptionsForFile: 'Сохранить параметры для файлов .{extension}',
            openFile: 'Открыть файл при запуске',
            launchButton: 'Запустить',
            launchingButton: 'Запуск...',
            uploadingButton: 'Загрузка...',
            autoHome: 'Авто (постоянство для каждого приложения)',
            collaborationMode: 'Совместная сессия',
            waylandMode: 'Режим Wayland',
        },
        sessionsView: {
            noSessions: 'Активных сессий не найдено.',
        },
        uploadStorageView: {
            selectHome: 'Выберите домашний каталог',
            description: 'Это загрузит файл <strong>{filename}</strong> напрямую в ваше хранилище файлов для будущего использования.',
            descriptionFallback: 'Это загрузит файл <strong>{filename}</strong> напрямую в ваше хранилище файлов для будущего использования.',
            uploadButton: 'Загрузить файл',
            uploadingButton: 'Загрузка...',
            preparing: 'Подготовка файла...',
            uploadingChunk: 'Загрузка части {current} из {total}...',
            finalizing: 'Завершение...',
            uploadComplete: 'Загрузка завершена!',
        },
        status: {
            unconfigured: 'Пожалуйста, настройте расширение на странице опций.',
            openingServerFile: "Открытие файла на стороне сервера: {filename}",
            openingFile: 'Открытие файла: {filename}',
            openingUrl: 'Открытие URL: {targetUrl}',
            error: 'Ошибка: {message}',
            preparingFile: 'Подготовка файла...',
            sendingFile: 'Отправка файла в сессию...',
            errorSendingFile: 'Ошибка отправки файла: {message}',
            errorClosingSession: 'Ошибка закрытия сессии: {message}',
            preparingSession: 'Подготовка изолированной сессии...',
            fetchingData: 'Получение данных файла...',
            fetchDataFailed: 'Не удалось получить данные файла: {statusText}',
            unknownAction: 'Неизвестное действие запуска.',
            noAppSelected: 'Пожалуйста, выберите приложение.',
            noAppsAvailable: 'Для вашей учётной записи нет доступных приложений.',
            uploadSuccess: 'Файл успешно загружен!',
            creatingAutoHome: 'Создание автоматического домашнего каталога...',
        },
        languages: {
            default: 'По умолчанию ({locale})'
        }
    },
    upload: {
        title: 'Загрузка файла',
        description: 'Выберите файл с вашего компьютера, чтобы открыть его в безопасной, изолированной сессии.',
        dropzone: {
            title: 'Перетащите файл сюда',
            or: 'или',
            button: 'Выберите файл',
        },
        confirm: {
            ready: 'Файл готов к безопасному открытию.',
            button: 'Продолжить к запуску',
        }
    },
    files: {
        title: 'Файлы SealSkin',
        header: {
            title: 'Файлы',
            newFolder: 'Новая папка',
            uploadFiles: 'Загрузить файлы',
            uploadFolder: 'Загрузить папку'
        },
        sidebar: {
            sharedFiles: 'Файлы SealSkin',
            publicShares: 'Общие ресурсы'
        },
        shares: {
            title: 'Общие файлы',
            searchPlaceholder: 'Поиск по имени файла или ID...'
        },
        table: {
            name: 'Имя',
            size: 'Размер',
            lastModified: 'Последнее изменение',
            created: 'Создан',
            expires: 'Истекает',
            url: 'Публичный URL',
            passwordProtected: 'Пароль'
        },
        dropzone: {
            title: 'Перетащите файлы для загрузки'
        },
        pagination: {
            previous: '« Назад',
            next: 'Вперед »',
            pageOf: 'Страница {page} из {totalPages}'
        },
        modals: {
            newFolder: {
                title: 'Создать новую папку',
                folderNameLabel: 'Имя папки',
                nameTitle: 'Используйте только буквы, цифры, подчеркивание, дефис или точку.',
                createButton: 'Создать'
            },
            confirmDelete: {
                title: 'Подтвердить удаление',
                message: 'Вы уверены, что хотите удалить {count, plural, one {1 выбранный элемент} other {{count} выбранных элементов}}? Это действие нельзя отменить.',
                messageDefault: 'Вы уверены, что хотите удалить выбранные элементы? Это действие нельзя отменить.'
            },
            uploadProgress: {
                title: 'Прогресс загрузки',
                doneButton: 'Готово'
            },
            share: {
                title: 'Поделиться файлом',
                sharingFile: 'Общий доступ к файлу: <strong>{filename}</strong>',
                passwordLabel: 'Пароль (необязательно)',
                passwordPlaceholder: 'Оставьте пустым для отсутствия пароля',
                expiryLabel: 'Истекает через (часы, необязательно)',
                expiryPlaceholder: 'например, 24 для одного дня',
                shareButton: 'Создать ссылку для общего доступа'
            }
        },
        status: {
            homeDirLoadFailed: 'Не удалось загрузить домашние каталоги: {error}',
            filesLoadFailed: 'Ошибка загрузки файлов: {error}',
            deleteProtectedError: 'Невозможно удалить защищенные системные папки.',
            deletingItems: 'Удаление {count, plural, one {1 элемента} few {{count} элементов} many {{count} элементов} other {{count} элементов}}...',
            deleteSuccess: 'Удаление успешно.',
            deleteFailed: 'Ошибка удаления: {error}',
            preparingUpload: 'Подготовка к загрузке {count, plural, one {1 файла} few {{count} файлов} many {{count} файлов} other {{count} файлов}}...',
            uploadPrepFailed: 'Ошибка при подготовке к загрузке папки: {error}',
            notConfigured: 'Ошибка: SealSkin не настроен. Пожалуйста, настройте в опциях.',
            folderCreated: 'Папка \'{folderName}\' создана.',
            folderCreateFailed: 'Ошибка при создании папки: {error}',
            shareCreated: 'Общий доступ успешно создан! Ссылка скопирована в буфер обмена.',
            shareCreateFailed: 'Не удалось создать общий доступ: {error}',
            sharesLoadFailed: 'Не удалось загрузить общие файлы: {error}',
            shareDeleteFailed: 'Не удалось удалить общий доступ: {error}',
            shareDeleted: 'Общий доступ успешно удален.',
            urlCopied: 'Публичный URL скопирован в буфер обмена.'
        },
        placeholders: {
            errorLoading: 'Ошибка загрузки файлов.',
            folderEmpty: 'Эта папка пуста.',
            noHomeDirs: 'Нет доступных домашних каталогов.',
            noShares: 'Вы еще не делились никакими файлами.'
        },
        uploadStatus: {
            pending: 'ожидание',
            initiating: 'Инициализация...',
            uploading: 'Загрузка...',
            finalizing: 'Завершение...',
            completed: 'Завершено',
            error: 'Ошибка'
        }
    }
};

// --- German Translations ---
const de = {
    background: {
        contextMenu: {
            openUrl: 'Link in SealSkin öffnen',
            openFile: 'Link-Ziel als Datei in SealSkin öffnen',
            sendMedia: 'Medien an SealSkin senden',
            searchText: 'Nach "%s" in SealSkin suchen',
            sendDownload: 'Nächsten Download an SealSkin senden'
        }
    },
    common: {
        actions: 'Aktionen',
        active: 'Aktiv',
        cancel: 'Abbrechen',
        manage: 'Verwalten',
        delete: 'Löschen',
        edit: 'Bearbeiten',
        save: 'Speichern',
        none: 'keine',
        error: 'Fehler',
        na: 'N/V',
        of: 'von',
        status: 'Status',
        username: 'Benutzername',
        group: 'Gruppe',
        groups: 'Gruppen',
        publicKey: 'Öffentlicher Schlüssel',
        name: 'Name',
        source: 'Quelle',
        imageVersion: 'Image-Version',
        language: 'Sprache',
        storage: 'Speicher',
        gpu: 'GPU',
        version: 'Version',
        checked: 'Geprüft',
        never: 'Nie',
        stop: 'Stoppen',
        reopen: 'Erneut öffnen',
        sendFile: 'Datei senden',
        share: 'Teilen',
        search: 'Suchen',
        refresh: 'Aktualisieren',
        close: 'Schließen',
        copy: 'Kopieren',
        open: "Öffnen",
        copyUrl: 'URL kopieren',
        download: 'Herunterladen',
        next: 'Weiter',
        previous: 'Zurück',
        page: 'Seite',
        home: 'Home-Verzeichnis',
        homes: 'Home-Verzeichnisse',
        sessions: 'Sitzungen',
        users: 'Benutzer',
        admins: 'Admins',
        yes: 'Ja',
        no: 'Nein',
        daysAgo: '{count, plural, one {vor 1 Tag} other {vor {count} Tagen}}',
        hoursAgo: '{count, plural, one {vor 1 Stunde} other {vor {count} Stunden}}',
        minutesAgo: '{count, plural, one {vor 1 Minute} other {vor {count} Minuten}}',
        justNow: 'gerade eben',
        bytes: 'Bytes',
        kb: 'KB',
        mb: 'MB',
        gb: 'GB',
        tb: 'TB',
        pb: 'PB',
    },
    options: {
        sidebar: {
            config: 'Konfiguration',
            home: 'Home-Verzeichnisse',
            sessions: 'Aktive Sitzungen',
            pinned: 'Gepinntes Verhalten',
            appStore: 'App Store',
            appTemplates: 'App-Vorlagen',
            appLaboratory: 'App-Labor',
            installedApps: 'Installierte Apps',
            users: 'Benutzer',
            groups: 'Gruppen',
            admins: 'Admins',
        },
        dashboard: {
            title: 'Dashboard',
            clientSettings: 'Client-Einstellungen',
            exportConfig: 'Konfiguration exportieren',
            userStatus: 'Benutzerstatus',
            loggedInAs: 'Angemeldet als:',
            role: 'Rolle',
            roleAdmin: 'Administrator',
            roleUser: 'Standardbenutzer',
            serverInfo: 'Serverinformationen',
            server: 'Server:',
            cpuModel: 'CPU-Modell:',
            storageUsage: 'Speichernutzung:',
            detectedGpus: 'Erkannte GPUs:',
            logout: 'Abmelden & Konfig. löschen',
            howTo: 'Wie man SealSkin verwendet',
            howToDescription: 'Dieser Abschnitt enthält eine grundlegende Dokumentation zur Verwendung der Erweiterung.',
            howToList: [
                '<strong>Um Inhalte isoliert zu öffnen:</strong> Klicken Sie mit der rechten Maustaste auf einen Link, ein Bild oder einen ausgewählten Text und wählen Sie eine Option aus dem Kontextmenü "SealSkin Isolation".',
                '<strong>Um einen Download in die Isolation zu senden:</strong> Klicken Sie mit der rechten Maustaste auf die Seite und wählen Sie "Nächsten Download in die Isolation senden". Die nächste Datei, die Sie herunterladen, wird abgefangen und an eine sichere Sitzung gesendet.',
                '<strong>Um eine saubere Anwendung zu starten:</strong> Klicken Sie auf das SealSkin-Symbol in der Symbolleiste Ihres Browsers.',
                '<strong>Um persistenten Speicher zu verwalten:</strong> Verwenden Sie den Tab "Home-Verzeichnisse" auf dieser Seite, um Speichervolumes zu erstellen und zu löschen, die über mehrere Sitzungen hinweg verwendet werden können.',
                '<strong>Um Startoptionen zu speichern:</strong> Aktivieren Sie das Kontrollkästchen "Diese Startoptionen speichern" im Popup, bevor Sie eine Anwendung für einen bestimmten Dateityp (z. B. .pdf) oder für alle URLs starten. Verwalten Sie diese gespeicherten Einstellungen im Tab "Gepinntes Verhalten".'
            ],
            confirmLogout: 'Sind Sie sicher, dass Sie sich abmelden möchten? Dadurch wird Ihre gespeicherte Konfiguration aus diesem Browser gelöscht.',
        },
        config: {
            quickSetup: 'Schnelleinrichtung',
            quickSetupDescription: 'Laden Sie die von Ihrem Administrator bereitgestellte Konfigurationsdatei (.json) hoch oder fügen Sie deren Inhalt unten ein, um die Erweiterung automatisch einzurichten.',
            uploadLabel: 'Konfigurationsdatei hochladen',
            pasteLabel: 'Oder Konfigurationstext einfügen',
            pastePlaceholder: 'Fügen Sie hier Ihre JSON-Konfiguration ein...',
            applyButton: 'Konfiguration anwenden',
            manualLink: 'Manuelle Konfiguration',
            advancedTitle: 'Client-Konfiguration (Erweitert)',
            serverIpLabel: 'Server-IP oder Domain',
            serverIpPlaceholder: 'z.B. 192.168.1.100',
            apiPortLabel: 'API-Port',
            apiPortPlaceholder: 'z.B. 8000',
            sessionPortLabel: 'Sitzungs-Port',
            sessionPortPlaceholder: 'z.B. 8443',
            usernameLabel: 'Benutzername',
            usernamePlaceholder: 'Ihr Benutzername',
            privateKeyLabel: 'Ihr privater Schlüssel (PEM-Format)',
            privateKeyPlaceholder: 'Fügen Sie hier den Inhalt Ihres privaten Schlüssels ein',
            serverKeyLabel: 'Öffentlicher Schlüssel des Servers (PEM-Format)',
            serverKeyPlaceholder: 'Fügen Sie hier den Inhalt von server_public.pem ein',
            searchEngineLabel: 'Standard-Suchmaschine für ausgewählten Text',
            saveButton: 'Konfiguration speichern',
            loginButton: 'Anmelden & Testen',
            automaticLink: 'Automatische Konfiguration',
            chooseFile: 'Datei auswählen',
            keyGeneration: 'Schlüsselgenerierung',
            keyGenDescription: 'Wenn Sie kein Schlüsselpaar haben, können Sie hier eines generieren. Der private Schlüssel wird oben eingefügt. Geben Sie den öffentlichen Schlüssel an Ihren Administrator weiter.',
            generateKeyButton: 'Neues Schlüsselpaar generieren',
            publicKeyForAdminLabel: 'Ihr öffentlicher Schlüssel (für den Admin)',
        },
        home: {
            title: 'Ihre Home-Verzeichnisse',
            description: 'Erstellen Sie persistente Speicherverzeichnisse zur Verwendung über Sitzungen hinweg. Diese werden als Ihr Konfigurationsverzeichnis in Ihre Anwendungen gemountet.',
            newTitle: 'Neues Home-Verzeichnis erstellen',
            nameLabel: 'Verzeichnisname:',
            namePlaceholder: 'z.B. meine-projektdateien',
            nameTitle: 'Verwenden Sie nur Buchstaben, Zahlen, Unterstrich oder Bindestrich.',
            createButton: 'Verzeichnis erstellen',
            isLaboratory: 'Dies ist eine Labor-App, die aus einem Basis-Image mit benutzerdefinierten Einstellungen erstellt wurde.',
            laboratory: 'Labor',
            confirmDelete: 'Sind Sie sicher, dass Sie die installierte App \'{appName}\' löschen möchten?'
        },
        sessions: {
            title: 'Aktive Sitzungen',
            application: 'Anwendung',
            started: 'Gestartet',
            noSessionsUser: 'Keine aktiven Sitzungen gefunden.',
            noSessionsAdmin: 'Keine aktiven Sitzungen für einen Benutzer gefunden.',
            sessionsFor: 'Sitzungen für {username} ({count})',
            confirmStop: 'Sind Sie sicher, dass Sie diese Sitzung beenden möchten? Der Container wird zerstört.',
        },
        pinned: {
            title: 'Gepinntes Erweiterungsverhalten',
            description: 'Diese Tabelle zeigt die Startoptionen, die Sie für bestimmte Dateitypen oder für alle URLs gespeichert haben. Sie können ein gepinntes Verhalten entfernen, um erneut nach Startoptionen gefragt zu werden.',
            trigger: 'Auslöser',
            savedApp: 'Gespeicherte Anwendung',
            triggerSimple: 'Einfacher Start (Symbolleisten-Button)',
            triggerUrl: 'Alle URLs (aus Kontextmenü)',
            triggerFile: 'Dateityp: <strong>{fileType}</strong>',
            unknownApp: 'Unbekannte App ({appId}...)'
        },
        admins: {
            serverKeyTitle: 'Öffentlicher Schlüssel des Servers',
            serverKeyDescription: 'Dies ist der öffentliche Schlüssel, den die Benutzerkonfigurationsdateien benötigen, um sich mit diesem Server zu verbinden.',
            title: 'Admin-Verwaltung',
            searchPlaceholder: 'Admins suchen...',
            newTitle: 'Neuen Admin erstellen',
            publicKeyOptionalLabel: 'Öffentlicher Schlüssel (Optional):',
            publicKeyPlaceholder: 'Öffentlichen Schlüssel hier einfügen oder leer lassen, um einen zu generieren.',
            createButton: 'Admin erstellen',
            confirmDelete: 'Sind Sie sicher, dass Sie den Admin \'{username}\' löschen möchten? Dadurch wird auch sein gesamter persistenter Speicher gelöscht und kann nicht rückgängig gemacht werden.',
        },
        users: {
            title: 'Benutzerverwaltung',
            searchPlaceholder: 'Benutzer nach Name oder Gruppe suchen...',
            newTitle: 'Neuen Benutzer erstellen',
            publicKeyOptionalLabel: 'Öffentlicher Schlüssel (Optional):',
            publicKeyPlaceholder: 'Öffentlichen Schlüssel des Benutzers hier einfügen oder leer lassen, um einen zu generieren.',
            settingsTitle: 'Benutzereinstellungen',
            sessionLimitLabel: 'Sitzungslimit',
            sessionLimitTitle: 'Anzahl der aktiven Sitzungen, die ein Benutzer haben kann. -1 für unbegrenzt.',
            permissionsTitle: 'Berechtigungen & Härtung',
            activeAccount: 'Aktives Konto',
            allowStorage: 'Persistenten Speicher erlauben',
            allowGpu: 'GPU-Zugriff erlauben',
            hardenContainer: 'Container härten',
            hardenWm: 'Fenstermanager härten',
            createButton: 'Benutzer erstellen',
            homesDisabledTooltip: 'Persistenter Speicher für diesen Benutzer deaktiviert',
            confirmDelete: 'Sind Sie sicher, dass Sie den Benutzer \'{username}\' löschen möchten? Dadurch wird auch sein gesamter persistenter Speicher gelöscht und kann nicht rückgängig gemacht werden.',
            allowPublicSharing: 'Öffentliche Dateifreigabe zulassen',
        },
        groups: {
            title: 'Gruppenverwaltung',
            searchPlaceholder: 'Gruppen suchen...',
            newTitle: 'Neue Gruppe erstellen',
            nameLabel: 'Gruppenname:',
            overrideTitle: 'Gruppen-Überschreibungseinstellungen',
            permissionsTitle: 'Berechtigungs- & Härtungs-Überschreibungen',
            createButton: 'Gruppe erstellen',
            confirmDelete: 'Sind Sie sicher, dass Sie die Gruppe \'{groupName}\' löschen möchten? Benutzer in dieser Gruppe werden auf ihre individuellen Einstellungen zurückgesetzt.',
        },
        installedApps: {
            title: 'Installierte Anwendungen',
            searchPlaceholder: 'Installierte Apps suchen...',
            noAppsFound: 'Keine installierten Apps gefunden.',
            pulling: 'Neues Image wird heruntergeladen...',
            notLocal: 'Image lokal nicht gefunden',
            confirmDelete: 'Sind Sie sicher, dass Sie die installierte App \'{appName}\' löschen möchten?',
        },
        appStore: {
            title: 'App Stores',
            refreshTitle: 'Ausgewählten Store aktualisieren',
            selectLabel: 'App Store auswählen',
            addLabel: 'Neuen App Store hinzufügen',
            namePlaceholder: 'Store-Name',
            urlPlaceholder: 'Store YAML URL',
            availableTitle: 'Verfügbare Apps',
            addManual: "Manuelle App hinzufügen",
            searchPlaceholder: 'Verfügbare Apps suchen...',
            noAppsFound: 'Keine Anwendungen gefunden.',
            availableFrom: 'Verfügbare Apps von {storeName}',
            couldNotLoad: 'Apps aus diesem Store konnten nicht geladen werden.',
        },
        appTemplates: {
            title: 'Anwendungsvorlagen-Editor',
            loadLabel: 'Vorlage laden',
            createOption: 'Neue Vorlage erstellen',
            nameLabel: 'Vorlagenname',
            namePlaceholder: 'Geben Sie einen Namen für die neue Vorlage ein',
            saveButton: 'Profil speichern',
            deleteButton: 'Löschen',
            previewTitle: 'UI-Vorschau',
            contentArea: 'Anwendungsinhaltsbereich',
            confirmDelete: 'Sind Sie sicher, dass Sie die Vorlage \'{templateName}\' löschen möchten? Diese Aktion kann nicht rückgängig gemacht werden.',
            deleteDisabled: 'Diese Vorlage kann nicht gelöscht werden.',
            enterName: 'Bitte geben Sie einen Namen für die neue Vorlage ein.',
            settings: {
                TITLE: { label: "Seitentitel", description: "Der Seitentitel, der im Webbrowser angezeigt wird." },
                SELKIES_UI_TITLE: { label: "Seitenleisten-Titel", description: "Titel in der oberen linken Ecke der Seitenleiste." },
                SELKIES_UI_SHOW_SIDEBAR: { label: "Seitenleiste anzeigen", description: "Die Haupt-UI der Seitenleiste anzeigen." },
                SELKIES_UI_SHOW_LOGO: { label: "Logo anzeigen", description: "Das Selkies-Logo in der Seitenleiste anzeigen." },
                SELKIES_UI_SHOW_CORE_BUTTONS: { label: "Kern-Schaltflächen anzeigen", description: "Die Schaltflächen der Kernkomponenten (Anzeige, Audio usw.) anzeigen." },
                SELKIES_UI_SIDEBAR_SHOW_VIDEO_SETTINGS: { label: "Videoeinstellungen anzeigen", description: "Den Abschnitt Videoeinstellungen in der Seitenleiste anzeigen." },
                SELKIES_UI_SIDEBAR_SHOW_SCREEN_SETTINGS: { label: "Bildschirmeinstellungen anzeigen", description: "Den Abschnitt Bildschirmeinstellungen in der Seitenleiste anzeigen." },
                SELKIES_UI_SIDEBAR_SHOW_AUDIO_SETTINGS: { label: "Audioeinstellungen anzeigen", description: "Den Abschnitt Audioeinstellungen in der Seitenleiste anzeigen." },
                SELKIES_UI_SIDEBAR_SHOW_STATS: { label: "Statistiken anzeigen", description: "Den Statistikbereich in der Seitenleiste anzeigen." },
                SELKIES_UI_SIDEBAR_SHOW_CLIPBOARD: { label: "Zwischenablage anzeigen", description: "Den Zwischenablagebereich in der Seitenleiste anzeigen." },
                SELKIES_UI_SIDEBAR_SHOW_FILES: { label: "Dateibereich anzeigen", description: "Den Dateitransferbereich in der Seitenleiste anzeigen." },
                SELKIES_UI_SIDEBAR_SHOW_APPS: { label: "App-Bereich anzeigen", description: "Den Anwendungsbereich in der Seitenleiste anzeigen." },
                SELKIES_UI_SIDEBAR_SHOW_SHARING: { label: "Freigabebereich anzeigen", description: "Den Freigabebereich in der Seitenleiste anzeigen." },
                SELKIES_UI_SIDEBAR_SHOW_GAMEPADS: { label: "Gamepad-Bereich anzeigen", description: "Den Gamepad-Bereich in der Seitenleiste anzeigen." },
                SELKIES_UI_SIDEBAR_SHOW_KEYBOARD_BUTTON: { label: "Tastatur-Schaltfläche anzeigen", description: "Die Bildschirmtastatur-Schaltfläche anzeigen." },
                SELKIES_UI_SIDEBAR_SHOW_SOFT_BUTTONS: { label: "Soft-Buttons anzeigen", description: "Den Bereich für Soft-Buttons anzeigen (für Mobilgeräte)." },
                WATERMARK_PNG: { label: "Wasserzeichen-PNG-Pfad", description: "Vollständiger Pfad innerhalb des Containers zu einer Wasserzeichen-PNG-Datei." },
                WATERMARK_LOCATION: { label: "Wasserzeichen-Position", description: "Wo das Bild über den Stream gemalt werden soll.", options: { disabled: "Deaktiviert", topLeft: "Oben-Links", topRight: "Oben-Rechts", bottomLeft: "Unten-Links", bottomRight: "Unten-Rechts", centered: "Zentriert", animated: "Animiert" } },
                DASHBOARD: { label: "Dashboard-Stil", description: "Ermöglicht dem Benutzer, sein Dashboard festzulegen.", options: { default: "Standard", selkiesDefault: "Selkies (Standard)", zinc: "Zinc", wish: "Wish" } },
                SELKIES_AUDIO_ENABLED: { label: "Audio aktivieren", description: "Server-zu-Client-Audio-Streaming aktivieren." },
                SELKIES_MICROPHONE_ENABLED: { label: "Mikrofon aktivieren", description: "Client-zu-Server-Mikrofonweiterleitung aktivieren." },
                SELKIES_GAMEPAD_ENABLED: { label: "Gamepad aktivieren", description: "Gamepad-Unterstützung aktivieren." },
                SELKIES_CLIPBOARD_ENABLED: { label: "Zwischenablage aktivieren", description: "Synchronisierung der Zwischenablage aktivieren." },
                SELKIES_ENABLE_BINARY_CLIPBOARD: { label: "Binäre Zwischenablage aktivieren", description: "Binäre Daten (Bilder) in der Zwischenablage zulassen." },
                SELKIES_COMMAND_ENABLED: { label: "Befehls-Websocket aktivieren", description: "Das Parsen von Befehls-Websocket-Nachrichten aktivieren." },
                SELKIES_FILE_TRANSFERS: { label: "Dateiübertragungen", description: "Erlaubte Richtungen ('upload,download', 'upload', 'download', 'none')." },
                SELKIES_ENABLE_SHARING: { label: "Alle Freigaben aktivieren", description: "Hauptschalter für alle Freigabefunktionen." },
                SELKIES_SECOND_SCREEN: { label: "Zweiten Bildschirm aktivieren", description: "Unterstützung für einen zweiten Monitor/Anzeige aktivieren." },
                SELKIES_USE_BROWSER_CURSORS: { label: "Browser-Cursor verwenden", description: "Browser-CSS-Cursor anstelle des Renderns auf Canvas verwenden." },
                SELKIES_USE_CSS_SCALING: { label: "CSS-Skalierung verwenden (LoDPI)", description: "Wenn wahr, wird eine niedrigere Auflösung gesendet und das Canvas gestreckt." },
                SELKIES_IS_MANUAL_RESOLUTION_MODE: { label: "Manueller Auflösungsmodus", description: "Die Auflösung auf die manuellen Breiten-/Höhenwerte festlegen." },
                SELKIES_MANUAL_WIDTH: { label: "Manuelle Breite", description: "Breite auf einen festen Wert festlegen. Erzwingt den manuellen Modus." },
                SELKIES_MANUAL_HEIGHT: { label: "Manuelle Höhe", description: "Höhe auf einen festen Wert festlegen. Erzwingt den manuellen Modus." },
                SELKIES_SCALING_DPI: { label: "UI-Skalierungs-DPI", description: "Die Standard-DPI für die UI-Skalierung." },
                SELKIES_AUDIO_BITRATE: { label: "Audio-Bitrate", description: "Die Standard-Audio-Bitrate." },
                SELKIES_ENCODER: { label: "Encoder", description: "Komma-getrennte Liste von Encodern. Der erste ist der Standard." },
                SELKIES_USE_CPU: { label: "CPU-Codierung erzwingen", description: "CPU-basierte Codierung für Pixelflux erzwingen." },
                SELKIES_FRAMERATE: { label: "Framerate (Bereich oder fest)", description: "z.B. '8-120' für einen Bereich oder '60' für einen festen Wert." },
                SELKIES_H264_CRF: { label: "H.264 CRF (Bereich oder fest)", description: "z.B. '5-50' für einen Bereich oder '25' für einen festen Wert." },
                SELKIES_JPEG_QUALITY: { label: "JPEG-Qualität (Bereich oder fest)", description: "z.B. '1-100' für einen Bereich oder '60' für einen festen Wert." },
                SELKIES_H264_FULLCOLOR: { label: "H.264 Vollfarbe", description: "H.264-Vollfarbbereich für Pixelflux-Encoder aktivieren." },
                SELKIES_H264_STREAMING_MODE: { label: "H.264 Streaming (Turbo) Modus", description: "H.264-Streaming-Modus mit niedriger Latenz aktivieren." },
                SELKIES_USE_PAINT_OVER_QUALITY: { label: "Paint-Over-Qualität verwenden", description: "Hochwertiges Paint-Over für statische Szenen aktivieren." },
                SELKIES_PAINT_OVER_JPEG_QUALITY: { label: "Paint-Over JPEG-Qualität", description: "z.B. '1-100' für einen Bereich oder '90' für einen festen Wert." },
                SELKIES_H264_PAINTOVER_CRF: { label: "Paint-Over H.264 CRF", description: "z.B. '5-50' für einen Bereich oder '18' für einen festen Wert." },
                SELKIES_H264_PAINTOVER_BURST_FRAMES: { label: "Paint-Over Burst Frames", description: "z.B. '1-30' für einen Bereich oder '5' für einen festen Wert." },
                HARDEN_DESKTOP: { label: "Desktop härten (Voreinstellung)", description: "Aktiviert DISABLE_OPEN_TOOLS, DISABLE_SUDO und DISABLE_TERMINALS." },
                HARDEN_OPENBOX: { label: "Fenstermanager härten (Voreinstellung)", description: "Aktiviert DISABLE_CLOSE_BUTTON, DISABLE_MOUSE_BUTTONS und HARDEN_KEYBINDS. Aktiviert auch RESTART_APP." },
                DISABLE_OPEN_TOOLS: { label: "Öffnungswerkzeuge deaktivieren", description: "Deaktiviert die Binärdateien xdg-open und exo-open." },
                DISABLE_SUDO: { label: "Sudo deaktivieren", description: "Deaktiviert den sudo-Befehl." },
                DISABLE_TERMINALS: { label: "Terminals deaktivieren", description: "Deaktiviert gängige Terminal-Emulatoren." },
                DISABLE_CLOSE_BUTTON: { label: "Fenster-Schließen-Button deaktivieren", description: "Entfernt den Schließen-Button aus den Fenstertitelleisten." },
                DISABLE_MOUSE_BUTTONS: { label: "Rechts-/Mittelklick deaktivieren", description: "Deaktiviert Kontextmenüs für Rechts- und Mittelklick." },
                HARDEN_KEYBINDS: { label: "Tastenkombinationen härten", description: "Deaktiviert Standard-Openbox-Tastenkombinationen wie Alt+F4." },
                RESTART_APP: { label: "App bei Schließen neu starten", description: "Startet die Hauptanwendung automatisch neu, wenn sie geschlossen wird." },
                MAX_RES: { label: "Maximale Auflösung", description: "Maximale Auflösung für den Container, Standard ist 16k." },
                START_DOCKER: { label: "Docker-in-Docker starten", description: "Wenn falsch, startet ein privilegierter Container DinD nicht." },
                DISABLE_IPV6: { label: "IPv6 deaktivieren", description: "Wenn wahr, wird IPv6 deaktiviert." },
                DISABLE_ZINK: { label: "Zink deaktivieren", description: "Keine Zink-Umgebungsvariablen setzen, wenn eine Grafikkarte erkannt wird." },
                DISABLE_DRI3: { label: "DRI3 deaktivieren", description: "Keine DRI3-Beschleunigung verwenden, wenn eine Grafikkarte erkannt wird." },
                NO_DECOR: { label: "Keine Fensterdekorationen", description: "Anwendung ohne Fensterrahmen für PWA-Nutzung ausführen." },
                NO_FULL: { label: "Kein Vollbild", description: "Anwendungen nicht automatisch im Vollbildmodus starten." },
                NO_GAMEPAD: { label: "Gamepad-Injektion deaktivieren", description: "Userspace-Gamepad-Interposer-Injektion deaktivieren." },
                SELKIES_DEBUG: { label: "Selkies-Debugging aktivieren", description: "Debug-Logging für Streaming-Komponenten aktivieren." },
            }
        },
        appLaboratory: {
            title: 'App-Labor',
            description: 'Erstellen und testen Sie benutzerdefinierte Anwendungskonfigurationen, indem Sie Änderungen auf eine Basis-App aufschichten.',
            selectApp: 'App auswählen',
            createNew: 'Neue App erstellen',
            baseApp: 'Basisanwendung',
            baseAppDescription: 'Die installierte Anwendung, auf der Ihre neue benutzerdefinierte App basieren wird.',
            selectBase: 'Basis-App auswählen',
            customizationTitle: 'Anpassung',
            appName: 'App-Name',
            appIcon: 'App-Symbol',
            uploadIcon: 'Symbol hochladen',
            autostartScriptLabel: 'Benutzerdefiniertes Autostart-Skript',
            permissionsTitle: 'Berechtigungen',
            usersLabel: 'Erlaubte Benutzer',
            groupsLabel: 'Erlaubte Gruppen',
            launchButton: 'Speichern & Anpassungssitzung starten',
            closeButton: 'Sitzung schließen & abschließen',
            savingAndLaunching: 'Speichern & Starten...',
            placeholder: 'Das App-Labor ermöglicht es Ihnen, das Basis-Home-Verzeichnis und das Startskript für eine Anwendung zu konfigurieren, die auf einer bestehenden installierten Anwendung basiert. Dieses Home-Verzeichnis wird bei der ersten Initialisierung für den Benutzer mit allen Dateien und Einstellungen kopiert, die Sie in dieser Sitzung einrichten. Sie können eine bestehende Labor-App erneut starten, um deren Inhalt weiter zu ändern.',
            formInvalid: 'Bitte wählen Sie eine Basis-App aus und geben Sie einen Namen für die neue App an.',
        },
        modals: {
            editUserTitle: 'Benutzer bearbeiten: {username}',
            saveChanges: 'Änderungen speichern',
            effectiveSettings: 'Effektive Einstellungen (mit Gruppen-Überschreibungen)',
            editGroupTitle: 'Gruppe bearbeiten: {groupName}',
            userConfigTitle: 'Benutzerkonfiguration',
            warning: 'Diese Konfiguration wird nur dieses eine Mal angezeigt. Geben Sie sie dem Benutzer auf sichere Weise.',
            info: 'Sie können diese Konfigurationsdatei herunterladen, um SealSkin einfach auf einem anderen Gerät einzurichten. Bewahren Sie diese Datei sicher auf, da sie Ihren privaten Schlüssel enthält.',
            configDataLabel: 'Konfigurationsdaten (JSON)',
            copyButton: 'Text kopieren',
            downloadButton: 'Datei herunterladen',
            manageHomeDirs: 'Home-Verzeichnisse verwalten',
            dirsForUser: 'Verzeichnisse für Benutzer: {username}',
            dirsForAdmin: 'Verzeichnisse für Admin: {username}',
            newDirForUser: 'Neues Verzeichnis für Benutzer erstellen',
            createDirButton: 'Verzeichnis erstellen',
            confirmDeleteDir: 'Sind Sie sicher, dass Sie \'{homeName}\' für Benutzer \'{username}\' löschen möchten? Dies ist endgültig.',
            installAppTitle: '{appName} installieren',
            editAppTitle: '{appName} bearbeiten',
            customNameLabel: 'Benutzerdefinierter Name',
            imageLabel: 'Container-Image',
            permissions: 'Berechtigungen',
            allowedUsersLabel: 'Erlaubte Benutzer (komma-getrennt, \'all\' für alle)',
            allowedGroupsLabel: 'Erlaubte Gruppen (komma-getrennt, \'all\' für alle)',
            features: 'Funktionen',
            gpuSupport: 'GPU-Unterstützung',
            homeMounting: 'Home-Verzeichnis-Mounting',
            urlSupport: 'URL-Öffnungs-Unterstützung',
            fileSupport: 'Datei-Öffnungs-Unterstützung',
            autoUpdate: 'Image automatisch aktualisieren',
            advancedSettings: 'Erweiterte Einstellungen',
            appTemplateLabel: 'Anwendungsvorlage',
            appTemplateDescription: 'Wählen Sie eine vorkonfigurierte Vorlage für erweiterte Container-Starteinstellungen.',
            customAutostartScriptLabel: 'Benutzerdefiniertes Autostart-Skript',
            customAutostartScriptDescription: 'Passen Sie die Autostart-Logik an. Lassen Sie das Feld leer, um die Standardeinstellung des Anwendungsanbieters zu verwenden.',
            saveInstallation: 'Installation speichern',
            updateStatusTitle: 'Update-Status für {appName}',
            checkingUpdates: 'Suche nach Updates...',
            updateAvailable: 'Eine neue Image-Version ist verfügbar!',
            yourVersion: 'Ihre Version: {sha}',
            latestAvailable: 'Die neueste Version steht zum Herunterladen aus der Registry bereit.',
            pullLatest: 'Neuestes Image herunterladen',
            upToDate: 'Ihr Image ist auf dem neuesten Stand.',
            currentVersion: 'Aktuelle Version: {sha}',
            errorChecking: 'Fehler bei der Suche nach Updates.',
            pullingLatest: 'Neuestes Image wird heruntergeladen... Dies kann einen Moment dauern.',
            pullComplete: 'Download abgeschlossen!',
            newVersion: 'Neue Version: {sha}',
            errorPulling: 'Fehler beim Herunterladen des Images.',
            manualInstallNote: "Hinweis: Manuell hinzugefügte Images sollten auf einem selkies-baseimage-kompatiblen Image basieren.",
        },
        status: {
            loggingIn: 'Anmeldung läuft...',
            configSaved: 'Konfiguration erfolgreich gespeichert!',
            configApplied: 'Konfiguration angewendet! Bitte Anmelden & Testen.',
            configApplyFailed: 'Anwenden der Konfiguration fehlgeschlagen: {error}',
            fileReadError: 'Fehler beim Lesen der Datei.',
            noConfig: 'Bitte geben Sie eine Konfigurationsdatei oder Text an.',
            loggedInAdmin: 'Angemeldet als Admin: {username}',
            loggedInUser: 'Angemeldet als Standardbenutzer: {username}.',
            loginFailed: 'Anmeldung fehlgeschlagen: {error}',
            adminDataRefreshFailed: 'Aktualisieren der Admin-Daten fehlgeschlagen: {error}',
            closingSession: 'Anpassungssitzung wird committet...',
            sessionClosed: 'Anpassungssitzung geschlossen.',
            sessionCloseFailed: 'Fehler beim Schließen der Anpassungssitzung: {error}',
            logoutSuccess: 'Abgemeldet und Konfiguration gelöscht.',
            generateConfigFailed: 'Konfiguration konnte nicht generiert werden, Benutzerdetails fehlen.',
            copySuccess: 'Konfiguration in die Zwischenablage kopiert!',
            copyFailed: 'Fehler beim Kopieren des Textes.',
            publicKeyCopied: 'Öffentlicher Schlüssel kopiert!',
            keyCopyFailed: 'Fehler beim Kopieren des Schlüssels.',
            creatingAdmin: 'Admin wird erstellt...',
            adminCreated: 'Admin \'{username}\' erstellt.',
            adminCreateFailed: 'Fehler beim Erstellen des Admins: {error}',
            adminDeleted: 'Admin \'{username}\' erfolgreich gelöscht.',
            adminDeleteFailed: 'Fehler beim Löschen des Admins: {error}',
            creatingUser: 'Benutzer wird erstellt...',
            userCreated: 'Benutzer \'{username}\' erstellt.',
            userCreateFailed: 'Fehler beim Erstellen des Benutzers: {error}',
            userDeleted: 'Benutzer \'{username}\' erfolgreich gelöscht.',
            userDeleteFailed: 'Fehler beim Löschen des Benutzers: {error}',
            userUpdated: 'Benutzer \'{username}\' erfolgreich aktualisiert.',
            userUpdateFailed: 'Fehler beim Aktualisieren des Benutzers: {error}',
            creatingGroup: 'Gruppe wird erstellt...',
            groupCreated: 'Gruppe \'{groupName}\' erstellt.',
            groupCreateFailed: 'Fehler beim Erstellen der Gruppe: {error}',
            groupDeleted: 'Gruppe \'{groupName}\' erfolgreich gelöscht.',
            groupDeleteFailed: 'Fehler beim Löschen der Gruppe: {error}',
            groupUpdated: 'Gruppe \'{groupName}\' erfolgreich aktualisiert.',
            groupUpdateFailed: 'Fehler beim Aktualisieren der Gruppe: {error}',
            homedirLoadFailed: 'Laden der Home-Verzeichnisse fehlgeschlagen: {error}',
            homedirCreateFailed: 'Fehler beim Erstellen des Verzeichnisses: {error}',
            homedirCreated: 'Home-Verzeichnis \'{homeName}\' erstellt.',
            homedirDeleted: 'Verzeichnis \'{homeName}\' gelöscht.',
            homedirDeleteFailed: 'Fehler beim Löschen des Verzeichnisses: {error}',
            homedirCreatedFor: 'Verzeichnis \'{homeName}\' für {username} erstellt.',
            homedirDeletedFor: 'Verzeichnis \'{homeName}\' für {username} gelöscht.',
            sessionsLoadFailed: 'Laden der Sitzungen fehlgeschlagen: {error}',
            sessionStopError: 'Fehler beim Beenden der Sitzung: {error}',
            sessionStopped: 'Sitzung erfolgreich beendet.',
            appDataRefreshFailed: 'Aktualisieren der App-Daten fehlgeschlagen: {error}',
            fetchingApps: 'Apps aus dem Store werden abgerufen...',
            fetchAppsFailed: 'Abrufen der Apps aus dem Store fehlgeschlagen: {error}',
            appStoreAddFailed: 'Fehler beim Hinzufügen des Stores: {error}',
            appStoreAdded: 'App Store \'{name}\' hinzugefügt.',
            appSaved: 'App \'{name}\' erfolgreich {action}.',
            appSaveActions: {
                updated: 'aktualisiert',
                installed: 'installiert'
            },
            appSaveFailed: 'Fehler beim Speichern der App: {error}',
            appDeleted: 'App \'{name}\' gelöscht.',
            appDeleteFailed: 'Fehler beim Löschen der App: {error}',
            templateSaved: 'Vorlage \'{name}\' erfolgreich gespeichert.',
            templateSaveFailed: 'Fehler beim Speichern der Vorlage: {error}',
            templateDeleted: 'Vorlage \'{name}\' erfolgreich gelöscht.',
            templateDeleteFailed: 'Fehler beim Löschen der Vorlage: {error}',
            pinRemoved: 'Gepinntes Verhalten entfernt.',
            keyGenerated: 'Neues Schlüsselpaar generiert.',
            keyGenFailed: 'Schlüsselgenerierung fehlgeschlagen: {{error}}',
            pendingConfigSaved: 'Ausstehende Konfiguration gespeichert. Sie können Ihren öffentlichen Schlüssel jetzt dem Administrator zur Verfügung stellen.',
            settingsSaved: 'Einstellungen gespeichert.',
            appCreated: 'App \'{name}\' erfolgreich erstellt.',
            launchFailed: 'Start fehlgeschlagen: {error}',
        },
        placeholders: {
            noAdmins: 'Keine Admins gefunden.',
            noUsers: 'Keine Benutzer gefunden.',
            noGroups: 'Keine Gruppen gefunden.',
            noHomeDirs: 'Keine Home-Verzeichnisse gefunden.',
            noSessions: 'Keine aktiven Sitzungen gefunden.',
            noPinned: 'Keine gepinnten Verhalten gefunden.',
            errorLoading: 'Fehler beim Laden der Verzeichnisse.',
            noInstalledApps: 'Es wurden noch keine Anwendungen installiert.',
        },
    },
    popup: {
        tabs: {
            launch: 'Neu starten',
            sessions: 'Aktive Sitzungen',
            manageFiles: 'Dateien verwalten',
            uploadStorage: 'In Speicher hochladen',
            uploadFiles: 'Dateien hochladen',
            uploadFilesTitle: 'Dedizierte Seite zum Hochladen von Dateien öffnen'
        },
        launchView: {
            searchPlaceholder: 'Anwendungen suchen...',
            uploadingFile: 'Datei wird hochgeladen...',
            gpuLabel: 'GPU',
            storageLabel: 'Speicher',
            languageLabel: 'Sprache',
            cleanroom: 'Cleanroom (Temporär)',
            noGpu: 'Keine',
            saveOptions: 'Diese Startoptionen speichern',
            saveOptionsForUrl: 'Optionen für alle URLs speichern',
            saveOptionsForFile: 'Optionen für .{extension}-Dateien speichern',
            openFile: 'Datei beim Start öffnen',
            launchButton: 'Starten',
            launchingButton: 'Wird gestartet...',
            uploadingButton: 'Wird hochgeladen...',
            autoHome: 'Automatisch (pro-App-Persistenz)',
            collaborationMode: 'Kollaborative Sitzung',
            waylandMode: 'Wayland-Modus',
        },
        sessionsView: {
            noSessions: 'Keine aktiven Sitzungen gefunden.',
        },
        uploadStorageView: {
            selectHome: 'Home-Verzeichnis auswählen',
            description: 'Dies lädt die Datei <strong>{filename}</strong> zur zukünftigen Verwendung direkt in Ihren Dateispeicher hoch.',
            descriptionFallback: 'Dies lädt die Datei <strong>{filename}</strong> zur zukünftigen Verwendung direkt in Ihren Dateispeicher hoch.',
            uploadButton: 'Datei hochladen',
            uploadingButton: 'Wird hochgeladen...',
            preparing: 'Datei wird vorbereitet...',
            uploadingChunk: 'Lade Teil {current} von {total} hoch...',
            finalizing: 'Wird abgeschlossen...',
            uploadComplete: 'Upload abgeschlossen!',
        },
        status: {
            unconfigured: 'Bitte konfigurieren Sie die Erweiterung über die Optionsseite.',
            openingServerFile: "Öffne serverseitige Datei: {filename}",
            openingFile: 'Öffne Datei: {filename}',
            openingUrl: 'Öffne URL: {targetUrl}',
            error: 'Fehler: {message}',
            preparingFile: 'Datei wird vorbereitet...',
            sendingFile: 'Datei wird an die Sitzung gesendet...',
            errorSendingFile: 'Fehler beim Senden der Datei: {message}',
            errorClosingSession: 'Fehler beim Schließen der Sitzung: {message}',
            preparingSession: 'Isolierte Sitzung wird vorbereitet...',
            fetchingData: 'Dateidaten werden abgerufen...',
            fetchDataFailed: 'Abrufen der Dateidaten fehlgeschlagen: {statusText}',
            unknownAction: 'Unbekannte Startaktion.',
            noAppSelected: 'Bitte wählen Sie eine Anwendung aus.',
            noAppsAvailable: 'Für Ihr Konto sind keine Anwendungen verfügbar.',
            uploadSuccess: 'Datei erfolgreich hochgeladen!',
            creatingAutoHome: 'Automatisches Home-Verzeichnis wird erstellt...',
        },
        languages: {
            default: 'Standard ({locale})'
        }
    },
    upload: {
        title: 'Datei-Upload',
        description: 'Wählen Sie eine Datei von Ihrem Computer aus, um sie in einer sicheren, isolierten Sitzung zu öffnen.',
        dropzone: {
            title: 'Ziehen Sie eine Datei hierher',
            or: 'oder',
            button: 'Datei auswählen',
        },
        confirm: {
            ready: 'Die Datei ist bereit, sicher geöffnet zu werden.',
            button: 'Weiter zum Starten',
        }
    },
    files: {
        title: 'SealSkin-Dateien',
        header: {
            title: 'Dateien',
            newFolder: 'Neuer Ordner',
            uploadFiles: 'Dateien hochladen',
            uploadFolder: 'Ordner hochladen'
        },
        sidebar: {
            sharedFiles: 'SealSkin-Dateien',
            publicShares: 'Öffentliche Freigaben'
        },
        shares: {
            title: 'Öffentlich freigegebene Dateien',
            searchPlaceholder: 'Suche nach Dateiname oder ID...'
        },
        table: {
            name: 'Name',
            size: 'Größe',
            lastModified: 'Zuletzt geändert',
            created: 'Erstellt',
            expires: 'Läuft ab',
            url: 'Öffentliche URL',
            passwordProtected: 'Passwort'
        },
        dropzone: {
            title: 'Dateien zum Hochladen hier ablegen'
        },
        pagination: {
            previous: '« Zurück',
            next: 'Weiter »',
            pageOf: 'Seite {page} von {totalPages}'
        },
        modals: {
            newFolder: {
                title: 'Neuen Ordner erstellen',
                folderNameLabel: 'Ordnername',
                nameTitle: 'Verwenden Sie nur Buchstaben, Zahlen, Unterstrich, Bindestrich oder Punkt.',
                createButton: 'Erstellen'
            },
            confirmDelete: {
                title: 'Löschen bestätigen',
                message: 'Möchten Sie {count, plural, one {1 ausgewähltes Element} other {{count} ausgewählte Elemente}} wirklich löschen? Diese Aktion kann nicht rückgängig gemacht werden.',
                messageDefault: 'Möchten Sie die ausgewählten Elemente wirklich löschen? Diese Aktion kann nicht rückgängig gemacht werden.'
            },
            uploadProgress: {
                title: 'Upload-Fortschritt',
                doneButton: 'Fertig'
            },
            share: {
                title: 'Datei teilen',
                sharingFile: 'Teile Datei: <strong>{filename}</strong>',
                passwordLabel: 'Passwort (optional)',
                passwordPlaceholder: 'Leer lassen für kein Passwort',
                expiryLabel: 'Läuft ab in (Stunden, optional)',
                expiryPlaceholder: 'z.B. 24 für einen Tag',
                shareButton: 'Freigabe-Link erstellen'
            }
        },
        status: {
            homeDirLoadFailed: 'Fehler beim Laden der Home-Verzeichnisse: {error}',
            filesLoadFailed: 'Fehler beim Laden der Dateien: {error}',
            deleteProtectedError: 'Geschützte Systemordner können nicht gelöscht werden.',
            deletingItems: 'Lösche {count, plural, one {1 Element} other {{count} Elemente}}...',
            deleteSuccess: 'Löschen erfolgreich.',
            deleteFailed: 'Löschen fehlgeschlagen: {error}',
            preparingUpload: 'Vorbereitung zum Hochladen von {count, plural, one {1 Datei} other {{count} Dateien}}...',
            uploadPrepFailed: 'Fehler bei der Vorbereitung des Ordner-Uploads: {error}',
            notConfigured: 'Fehler: SealSkin nicht konfiguriert. Bitte in den Optionen einrichten.',
            folderCreated: 'Ordner \'{folderName}\' erstellt.',
            folderCreateFailed: 'Fehler beim Erstellen des Ordners: {error}',
            shareCreated: 'Freigabe erfolgreich erstellt! Der Link wurde in Ihre Zwischenablage kopiert.',
            shareCreateFailed: 'Fehler beim Erstellen der Freigabe: {error}',
            sharesLoadFailed: 'Fehler beim Laden der freigegebenen Dateien: {error}',
            shareDeleteFailed: 'Fehler beim Löschen der Freigabe: {error}',
            shareDeleted: 'Freigabe erfolgreich gelöscht.',
            urlCopied: 'Öffentliche URL in die Zwischenablage kopiert.'
        },
        placeholders: {
            errorLoading: 'Fehler beim Laden der Dateien.',
            folderEmpty: 'Dieser Ordner ist leer.',
            noHomeDirs: 'Keine Home-Verzeichnisse verfügbar.',
            noShares: 'Sie haben noch keine Dateien freigegeben.'
        },
        uploadStatus: {
            pending: 'ausstehend',
            initiating: 'Wird gestartet...',
            uploading: 'Wird hochgeladen...',
            finalizing: 'Wird abgeschlossen...',
            completed: 'Abgeschlossen',
            error: 'Fehler'
        }
    }
};

// --- Turkish Translations ---
const tr = {
    background: {
        contextMenu: {
            openUrl: 'Bağlantıyı SealSkin\'de Aç',
            openFile: 'Bağlantı Hedefini SealSkin\'de Dosya Olarak Aç',
            sendMedia: 'Medyayı SealSkin\'e Gönder',
            searchText: 'SealSkin\'de "%s" için arama yap',
            sendDownload: 'Sonraki İndirmeyi SealSkin\'e Gönder'
        }
    },
    common: {
        actions: 'Eylemler',
        active: 'Aktif',
        cancel: 'İptal',
        manage: 'Yönet',
        delete: 'Sil',
        edit: 'Düzenle',
        save: 'Kaydet',
        none: 'yok',
        error: 'Hata',
        na: 'N/A',
        of: '/',
        status: 'Durum',
        username: 'Kullanıcı Adı',
        group: 'Grup',
        groups: 'Gruplar',
        publicKey: 'Açık Anahtar',
        name: 'İsim',
        source: 'Kaynak',
        imageVersion: 'İmaj Versiyonu',
        language: 'Dil',
        storage: 'Depolama',
        gpu: 'GPU',
        version: 'Versiyon',
        checked: 'İşaretli',
        never: 'Asla',
        stop: 'Durdur',
        reopen: 'Yeniden Aç',
        sendFile: 'Dosya Gönder',
        share: 'Paylaş',
        search: 'Ara',
        refresh: 'Yenile',
        close: 'Kapat',
        copy: 'Kopyala',
        open: "Aç",
        copyUrl: 'URL\'yi Kopyala',
        download: 'İndir',
        next: 'Sonraki',
        previous: 'Önceki',
        page: 'Sayfa',
        home: 'Ana Dizin',
        homes: 'Ana Dizinler',
        sessions: 'Oturumlar',
        users: 'Kullanıcılar',
        admins: 'Yöneticiler',
        yes: 'Evet',
        no: 'Hayır',
        daysAgo: '{count} gün önce',
        hoursAgo: '{count} saat önce',
        minutesAgo: '{count} dakika önce',
        justNow: 'az önce',
        bytes: 'Bayt',
        kb: 'KB',
        mb: 'MB',
        gb: 'GB',
        tb: 'TB',
        pb: 'PB',
    },
    options: {
        sidebar: {
            config: 'Yapılandırma',
            home: 'Ana Dizinler',
            sessions: 'Aktif Oturumlar',
            pinned: 'Sabitlenmiş Davranış',
            appStore: 'Uygulama Mağazası',
            appTemplates: 'Uygulama Şablonları',
            appLaboratory: 'Uygulama Laboratuvarı',
            installedApps: 'Yüklü Uygulamalar',
            users: 'Kullanıcılar',
            groups: 'Gruplar',
            admins: 'Yöneticiler',
        },
        dashboard: {
            title: 'Kontrol Paneli',
            clientSettings: 'İstemci Ayarları',
            exportConfig: 'Yapılandırmayı Dışa Aktar',
            userStatus: 'Kullanıcı Durumu',
            loggedInAs: 'Giriş yapan:',
            role: 'Rol',
            roleAdmin: 'Yönetici',
            roleUser: 'Standart Kullanıcı',
            serverInfo: 'Sunucu Bilgisi',
            server: 'Sunucu:',
            cpuModel: 'CPU Modeli:',
            storageUsage: 'Depolama Kullanımı:',
            detectedGpus: 'Tespit Edilen GPU\'lar:',
            logout: 'Çıkış Yap ve Yapılandırmayı Temizle',
            howTo: 'SealSkin Nasıl Kullanılır',
            howToDescription: 'Bu bölüm, uzantının nasıl kullanılacağına dair temel belgeleri içerir.',
            howToList: [
                '<strong>İçeriği izolasyonda açmak için:</strong> Herhangi bir bağlantıya, resme veya seçili metne sağ tıklayın ve "SealSkin İzolasyonu" içerik menüsünden bir seçenek belirleyin.',
                '<strong>Bir indirmeyi izolasyona göndermek için:</strong> Sayfaya sağ tıklayın ve "Sıradaki İndirmeyi İzolasyona Gönder" seçeneğini seçin. İndireceğiniz bir sonraki dosya yakalanacak ve güvenli bir oturuma gönderilecektir.',
                '<strong>Temiz bir uygulama başlatmak için:</strong> Tarayıcınızın araç çubuğundaki SealSkin simgesine tıklayın.',
                '<strong>Kalıcı depolamayı yönetmek için:</strong> Birden fazla oturumda kullanılabilecek depolama birimleri oluşturmak ve silmek için bu sayfadaki "Ana Dizinler" sekmesini kullanın.',
                '<strong>Başlatma seçeneklerini kaydetmek için:</strong> Belirli bir dosya türü (ör. .pdf) veya tüm URL\'ler için bir uygulama başlatmadan önce açılır penceredeki "Bu başlatma seçeneklerini kaydet" kutusunu işaretleyin. Bu kaydedilmiş tercihleri "Sabitlenmiş Davranış" sekmesinde yönetin.'
            ],
            confirmLogout: 'Çıkış yapmak istediğinizden emin misiniz? Bu, kaydedilmiş yapılandırmanızı bu tarayıcıdan temizleyecektir.',
        },
        config: {
            quickSetup: 'Hızlı Kurulum',
            quickSetupDescription: 'Yöneticiniz tarafından sağlanan yapılandırma dosyasını (.json) yükleyin veya uzantıyı otomatik olarak kurmak için içeriğini aşağıya yapıştırın.',
            uploadLabel: 'Yapılandırma Dosyasını Yükle',
            pasteLabel: 'Veya Yapılandırma Metnini Yapıştır',
            pastePlaceholder: 'JSON yapılandırmanızı buraya yapıştırın...',
            applyButton: 'Yapılandırmayı Uygula',
            manualLink: 'Manuel Yapılandırma',
            advancedTitle: 'İstemci Yapılandırması (Gelişmiş)',
            serverIpLabel: 'Sunucu IP\'si veya Alan Adı',
            serverIpPlaceholder: 'örn. 192.168.1.100',
            apiPortLabel: 'API Portu',
            apiPortPlaceholder: 'örn. 8000',
            sessionPortLabel: 'Oturum Portu',
            sessionPortPlaceholder: 'örn. 8443',
            usernameLabel: 'Kullanıcı Adı',
            usernamePlaceholder: 'Kullanıcı adınız',
            privateKeyLabel: 'Özel Anahtarınız (PEM Formatı)',
            privateKeyPlaceholder: 'Özel anahtarınızın içeriğini buraya yapıştırın',
            serverKeyLabel: 'Sunucu Açık Anahtarı (PEM Formatı)',
            serverKeyPlaceholder: 'server_public.pem içeriğini buraya yapıştırın',
            searchEngineLabel: 'Seçili Metin için Varsayılan Arama Motoru',
            saveButton: 'Yapılandırmayı Kaydet',
            loginButton: 'Giriş Yap ve Test Et',
            automaticLink: 'Otomatik Yapılandırma',
            chooseFile: 'Dosya Seç',
            keyGeneration: 'Anahtar Oluşturma',
            keyGenDescription: 'Bir anahtar çiftiniz yoksa, buradan bir tane oluşturabilirsiniz. Özel anahtar yukarıda doldurulacaktır. Açık anahtarı yöneticinize verin.',
            generateKeyButton: 'Yeni Anahtar Çifti Oluştur',
            publicKeyForAdminLabel: 'Açık Anahtarınız (yönetici için)',
        },
        home: {
            title: 'Ana Dizinleriniz',
            description: 'Oturumlar arasında kullanmak için kalıcı depolama dizinleri oluşturun. Bunlar, uygulamalarınıza yapılandırma dizininiz olarak bağlanacaktır.',
            newTitle: 'Yeni Ana Dizin Oluştur',
            nameLabel: 'Dizin Adı:',
            namePlaceholder: 'örn. proje-dosyalarim',
            nameTitle: 'Sadece harf, rakam, alt çizgi veya tire kullanın.',
            createButton: 'Dizin Oluştur',
            isLaboratory: 'Bu, temel bir imajdan özel ayarlarla oluşturulmuş bir Laboratuvar uygulamasıdır.',
            laboratory: 'Laboratuvar',
            confirmDelete: '\'{appName}\' yüklü uygulamasını silmek istediğinizden emin misiniz?'
        },
        sessions: {
            title: 'Aktif Oturumlar',
            application: 'Uygulama',
            started: 'Başlatıldı',
            noSessionsUser: 'Aktif oturum bulunamadı.',
            noSessionsAdmin: 'Hiçbir kullanıcı için aktif oturum bulunamadı.',
            sessionsFor: '{username} için oturumlar ({count})',
            confirmStop: 'Bu oturumu durdurmak istediğinizden emin misiniz? Konteyner yok edilecek.',
        },
        pinned: {
            title: 'Sabitlenmiş Uzantı Davranışı',
            description: 'Bu tablo, belirli dosya türleri veya tüm URL\'ler için kaydettiğiniz başlatma seçeneklerini gösterir. Başlatma seçeneklerinin tekrar sorulması için sabitlenmiş bir davranışı kaldırabilirsiniz.',
            trigger: 'Tetikleyici',
            savedApp: 'Kaydedilmiş Uygulama',
            triggerSimple: 'Basit Başlatma (Araç Çubuğu Düğmesi)',
            triggerUrl: 'Tüm URL\'ler (içerik menüsünden)',
            triggerFile: 'Dosya Türü: <strong>{fileType}</strong>',
            unknownApp: 'Bilinmeyen Uygulama ({appId}...)'
        },
        admins: {
            serverKeyTitle: 'Sunucu Açık Anahtarı',
            serverKeyDescription: 'Bu, kullanıcı yapılandırma dosyalarının bu sunucuya bağlanmak için ihtiyaç duyacağı açık anahtardır.',
            title: 'Yönetici Yönetimi',
            searchPlaceholder: 'Yöneticileri ara...',
            newTitle: 'Yeni Yönetici Oluştur',
            publicKeyOptionalLabel: 'Açık Anahtar (İsteğe Bağlı):',
            publicKeyPlaceholder: 'Açık anahtarı buraya yapıştırın veya bir tane oluşturmak için boş bırakın.',
            createButton: 'Yönetici Oluştur',
            confirmDelete: '\'{username}\' yöneticisini silmek istediğinizden emin misiniz? Bu, tüm kalıcı depolamasını da silecek ve geri alınamaz.',
        },
        users: {
            title: 'Kullanıcı Yönetimi',
            searchPlaceholder: 'Kullanıcıları isme veya gruba göre ara...',
            newTitle: 'Yeni Kullanıcı Oluştur',
            publicKeyOptionalLabel: 'Açık Anahtar (İsteğe Bağlı):',
            publicKeyPlaceholder: 'Kullanıcının açık anahtarını buraya yapıştırın veya bir tane oluşturmak için boş bırakın.',
            settingsTitle: 'Kullanıcı Ayarları',
            sessionLimitLabel: 'Oturum limiti',
            sessionLimitTitle: 'Bir kullanıcının sahip olabileceği aktif oturum sayısı. Sınırsız için -1.',
            permissionsTitle: 'İzinler ve Güvenlik',
            activeAccount: 'Aktif Hesap',
            allowStorage: 'Kalıcı Depolamaya İzin Ver',
            allowGpu: 'GPU Erişimine İzin Ver',
            hardenContainer: 'Konteyneri Güçlendir',
            hardenWm: 'Pencere Yöneticisini Güçlendir',
            createButton: 'Kullanıcı Oluştur',
            homesDisabledTooltip: 'Bu kullanıcı için kalıcı depolama devre dışı bırakıldı',
            confirmDelete: '\'{username}\' kullanıcısını silmek istediğinizden emin misiniz? Bu, tüm kalıcı depolamasını da silecek ve geri alınamaz.',
            allowPublicSharing: 'Herkese Açık Dosya Paylaşımına İzin Ver',
        },
        groups: {
            title: 'Grup Yönetimi',
            searchPlaceholder: 'Grupları ara...',
            newTitle: 'Yeni Grup Oluştur',
            nameLabel: 'Grup Adı:',
            overrideTitle: 'Grup Geçersiz Kılma Ayarları',
            permissionsTitle: 'İzinler ve Güvenlik Geçersiz Kılmaları',
            createButton: 'Grup Oluştur',
            confirmDelete: '\'{groupName}\' grubunu silmek istediğinizden emin misiniz? Bu gruptaki kullanıcılar bireysel ayarlarına geri dönecektir.',
        },
        installedApps: {
            title: 'Yüklü Uygulamalar',
            searchPlaceholder: 'Yüklü uygulamaları ara...',
            noAppsFound: 'Yüklü uygulama bulunamadı.',
            pulling: 'Yeni imaj çekiliyor...',
            notLocal: 'İmaj yerel olarak bulunamadı',
            confirmDelete: '\'{appName}\' yüklü uygulamasını silmek istediğinizden emin misiniz?',
        },
        appStore: {
            title: 'Uygulama Mağazaları',
            refreshTitle: 'Seçili mağazayı yenile',
            selectLabel: 'Uygulama Mağazası Seç',
            addLabel: 'Yeni Uygulama Mağazası Ekle',
            namePlaceholder: 'Mağaza Adı',
            urlPlaceholder: 'Mağaza YAML URL\'si',
            availableTitle: 'Mevcut Uygulamalar',
            addManual: "Manuel Uygulama Ekle",
            searchPlaceholder: 'Mevcut uygulamaları ara...',
            noAppsFound: 'Uygulama bulunamadı.',
            availableFrom: '{storeName} mağazasındaki Mevcut Uygulamalar',
            couldNotLoad: 'Bu mağazadan uygulamalar yüklenemedi.',
        },
        appTemplates: {
            title: 'Uygulama Şablonu Düzenleyici',
            loadLabel: 'Şablon Yükle',
            createOption: 'Yeni Şablon Oluştur',
            nameLabel: 'Şablon Adı',
            namePlaceholder: 'Yeni şablon için bir isim girin',
            saveButton: 'Profili Kaydet',
            deleteButton: 'Sil',
            previewTitle: 'Arayüz Önizlemesi',
            contentArea: 'Uygulama İçerik Alanı',
            confirmDelete: '\'{templateName}\' şablonunu silmek istediğinizden emin misiniz? Bu işlem geri alınamaz.',
            deleteDisabled: 'Bu şablon silinemez.',
            enterName: 'Lütfen yeni şablon için bir isim girin.',
            settings: {
                TITLE: { label: "Sayfa Başlığı", description: "Web tarayıcısında görüntülenen sayfa başlığı." },
                SELKIES_UI_TITLE: { label: "Kenar Çubuğu Başlığı", description: "Kenar çubuğunun sol üst köşesindeki başlık." },
                SELKIES_UI_SHOW_SIDEBAR: { label: "Kenar Çubuğunu Göster", description: "Ana kenar çubuğu arayüzünü göster." },
                SELKIES_UI_SHOW_LOGO: { label: "Logoyu Göster", description: "Kenar çubuğunda Selkies logosunu göster." },
                SELKIES_UI_SHOW_CORE_BUTTONS: { label: "Çekirdek Düğmeleri Göster", description: "Çekirdek bileşen düğmelerini (ekran, ses vb.) göster." },
                SELKIES_UI_SIDEBAR_SHOW_VIDEO_SETTINGS: { label: "Video Ayarlarını Göster", description: "Kenar çubuğunda video ayarları bölümünü göster." },
                SELKIES_UI_SIDEBAR_SHOW_SCREEN_SETTINGS: { label: "Ekran Ayarlarını Göster", description: "Kenar çubuğunda ekran ayarları bölümünü göster." },
                SELKIES_UI_SIDEBAR_SHOW_AUDIO_SETTINGS: { label: "Ses Ayarlarını Göster", description: "Kenar çubuğunda ses ayarları bölümünü göster." },
                SELKIES_UI_SIDEBAR_SHOW_STATS: { label: "İstatistikleri Göster", description: "Kenar çubuğunda istatistikler bölümünü göster." },
                SELKIES_UI_SIDEBAR_SHOW_CLIPBOARD: { label: "Panoyu Göster", description: "Kenar çubuğunda pano bölümünü göster." },
                SELKIES_UI_SIDEBAR_SHOW_FILES: { label: "Dosyalar Bölümünü Göster", description: "Kenar çubuğunda dosya aktarımı bölümünü göster." },
                SELKIES_UI_SIDEBAR_SHOW_APPS: { label: "Uygulamalar Bölümünü Göster", description: "Kenar çubuğunda uygulamalar bölümünü göster." },
                SELKIES_UI_SIDEBAR_SHOW_SHARING: { label: "Paylaşım Bölümünü Göster", description: "Kenar çubuğunda paylaşım bölümünü göster." },
                SELKIES_UI_SIDEBAR_SHOW_GAMEPADS: { label: "Oyun Kumandaları Bölümünü Göster", description: "Kenar çubuğunda oyun kumandaları bölümünü göster." },
                SELKIES_UI_SIDEBAR_SHOW_KEYBOARD_BUTTON: { label: "Klavye Düğmesini Göster", description: "Ekran klavyesi düğmesini göster." },
                SELKIES_UI_SIDEBAR_SHOW_SOFT_BUTTONS: { label: "Sanal Düğmeleri Göster", description: "Sanal düğmeler bölümünü göster (mobil için)." },
                WATERMARK_PNG: { label: "Filigran PNG Yolu", description: "Konteyner içinde bir filigran png dosyasına tam yol." },
                WATERMARK_LOCATION: { label: "Filigran Konumu", description: "Görüntüyü akışın üzerine nerede çizileceği.", options: { disabled: "Devre Dışı", topLeft: "Sol Üst", topRight: "Sağ Üst", bottomLeft: "Sol Alt", bottomRight: "Sağ Alt", centered: "Ortalanmış", animated: "Animasyonlu" } },
                DASHBOARD: { label: "Kontrol Paneli Stili", description: "Kullanıcının kontrol panelini ayarlamasına izin verir.", options: { default: "Varsayılan", selkiesDefault: "Selkies (Varsayılan)", zinc: "Zinc", wish: "Wish" } },
                SELKIES_AUDIO_ENABLED: { label: "Sesi Etkinleştir", description: "Sunucudan istemciye ses akışını etkinleştir." },
                SELKIES_MICROPHONE_ENABLED: { label: "Mikrofonu Etkinleştir", description: "İstemciden sunucuya mikrofon yönlendirmesini etkinleştir." },
                SELKIES_GAMEPAD_ENABLED: { label: "Oyun Kumandasını Etkinleştir", description: "Oyun kumandası desteğini etkinleştir." },
                SELKIES_CLIPBOARD_ENABLED: { label: "Panoyu Etkinleştir", description: "Pano senkronizasyonunu etkinleştir." },
                SELKIES_ENABLE_BINARY_CLIPBOARD: { label: "İkili Panoyu Etkinleştir", description: "Panoda ikili verilere (resimler) izin ver." },
                SELKIES_COMMAND_ENABLED: { label: "Komut Websocket'ini Etkinleştir", description: "Komut websocket mesajlarının ayrıştırılmasını etkinleştir." },
                SELKIES_FILE_TRANSFERS: { label: "Dosya Aktarımları", description: "İzin verilen yönler ('upload,download', 'upload', 'download', 'none')." },
                SELKIES_ENABLE_SHARING: { label: "Tüm Paylaşımı Etkinleştir", description: "Tüm paylaşım özellikleri için ana anahtar." },
                SELKIES_SECOND_SCREEN: { label: "İkinci Ekranı Etkinleştir", description: "İkinci bir monitör/ekran için destek etkinleştir." },
                SELKIES_USE_BROWSER_CURSORS: { label: "Tarayıcı İmleçlerini Kullan", description: "Tuvale render etmek yerine tarayıcı CSS imleçlerini kullan." },
                SELKIES_USE_CSS_SCALING: { label: "CSS Ölçeklendirme Kullan (LoDPI)", description: "Eğer doğruysa, daha düşük bir çözünürlük gönderilir ve tuval gerilir." },
                SELKIES_IS_MANUAL_RESOLUTION_MODE: { label: "Manuel Çözünürlük Modu", description: "Çözünürlüğü manuel genişlik/yükseklik değerlerine kilitle." },
                SELKIES_MANUAL_WIDTH: { label: "Manuel Genişlik", description: "Genişliği sabit bir değere kilitle. Manuel modu zorlar." },
                SELKIES_MANUAL_HEIGHT: { label: "Manuel Yükseklik", description: "Yüksekliği sabit bir değere kilitle. Manuel modu zorlar." },
                SELKIES_SCALING_DPI: { label: "Arayüz Ölçeklendirme DPI", description: "Arayüz ölçeklendirmesi için varsayılan DPI." },
                SELKIES_AUDIO_BITRATE: { label: "Ses Bit Hızı", description: "Varsayılan ses bit hızı." },
                SELKIES_ENCODER: { label: "Kodlayıcılar", description: "Virgülle ayrılmış kodlayıcı listesi. Birincisi varsayılandır." },
                SELKIES_USE_CPU: { label: "CPU Kodlamasını Zorla", description: "Pixelflux için CPU tabanlı kodlamayı zorla." },
                SELKIES_FRAMERATE: { label: "Kare Hızı (Aralık veya Sabit)", description: "örn. bir aralık için '8-120' veya sabit için '60'." },
                SELKIES_H264_CRF: { label: "H.264 CRF (Aralık veya Sabit)", description: "örn. bir aralık için '5-50' veya sabit için '25'." },
                SELKIES_JPEG_QUALITY: { label: "JPEG Kalitesi (Aralık veya Sabit)", description: "örn. bir aralık için '1-100' veya sabit için '60'." },
                SELKIES_H264_FULLCOLOR: { label: "H.264 Tam Renk", description: "Pixelflux kodlayıcıları için H.264 tam renk aralığını etkinleştir." },
                SELKIES_H264_STREAMING_MODE: { label: "H.264 Akış (Turbo) Modu", description: "H.264 düşük gecikmeli akış modunu etkinleştir." },
                SELKIES_USE_PAINT_OVER_QUALITY: { label: "Üzerine Boyama Kalitesi Kullan", description: "Statik sahneler için yüksek kaliteli üzerine boyamayı etkinleştir." },
                SELKIES_PAINT_OVER_JPEG_QUALITY: { label: "Üzerine Boyama JPEG Kalitesi", description: "örn. bir aralık için '1-100' veya sabit için '90'." },
                SELKIES_H264_PAINTOVER_CRF: { label: "Üzerine Boyama H.264 CRF", description: "örn. bir aralık için '5-50' veya sabit için '18'." },
                SELKIES_H264_PAINTOVER_BURST_FRAMES: { label: "Üzerine Boyama Seri Çekim Kareleri", description: "örn. bir aralık için '1-30' veya sabit için '5'." },
                HARDEN_DESKTOP: { label: "Masaüstünü Güçlendir (Ön Ayar)", description: "DISABLE_OPEN_TOOLS, DISABLE_SUDO ve DISABLE_TERMINALS'ı etkinleştirir." },
                HARDEN_OPENBOX: { label: "Pencere Yöneticisini Güçlendir (Ön Ayar)", description: "DISABLE_CLOSE_BUTTON, DISABLE_MOUSE_BUTTONS ve HARDEN_KEYBINDS'ı etkinleştirir. Ayrıca RESTART_APP'ı etkinleştirir." },
                DISABLE_OPEN_TOOLS: { label: "Açma Araçlarını Devre Dışı Bırak", description: "xdg-open ve exo-open ikili dosyalarını devre dışı bırakır." },
                DISABLE_SUDO: { label: "Sudo'yu Devre Dışı Bırak", description: "sudo komutunu devre dışı bırakır." },
                DISABLE_TERMINALS: { label: "Terminalleri Devre Dışı Bırak", description: "Yaygın terminal emülatörlerini devre dışı bırakır." },
                DISABLE_CLOSE_BUTTON: { label: "Pencere Kapatma Düğmesini Devre Dışı Bırak", description: "Pencere başlık çubuklarından kapatma düğmesini kaldırır." },
                DISABLE_MOUSE_BUTTONS: { label: "Sağ/Orta Tıklamayı Devre Dışı Bırak", description: "Sağ tıklama ve orta tıklama içerik menülerini devre dışı bırakır." },
                HARDEN_KEYBINDS: { label: "Klavye Kısayollarını Güçlendir", description: "Alt+F4 gibi varsayılan Openbox klavye kısayollarını devre dışı bırakır." },
                RESTART_APP: { label: "Kapatıldığında Uygulamayı Yeniden Başlat", description: "Ana uygulama kapatılırsa otomatik olarak yeniden başlatır." },
                MAX_RES: { label: "Maksimum Çözünürlük", description: "Konteyner için maksimum çözünürlük, varsayılan 16k'dır." },
                START_DOCKER: { label: "Docker-in-Docker'ı Başlat", description: "Eğer yanlışsa, ayrıcalıklı bir konteyner DinD'yi başlatmaz." },
                DISABLE_IPV6: { label: "IPv6'yı Devre Dışı Bırak", description: "Eğer doğruysa, bu IPv6'yı devre dışı bırakacaktır." },
                DISABLE_ZINK: { label: "Zink'i Devre Dışı Bırak", description: "Bir video kartı algılanırsa Zink ortam değişkenlerini ayarlama." },
                DISABLE_DRI3: { label: "DRI3'ü Devre Dışı Bırak", description: "Bir video kartı algılanırsa DRI3 hızlandırmasını kullanma." },
                NO_DECOR: { label: "Pencere Dekorasyonu Yok", description: "Uygulamayı PWA kullanımı için pencere kenarlıkları olmadan çalıştır." },
                NO_FULL: { label: "Tam Ekran Yok", description: "Uygulamaları otomatik olarak tam ekran yapma." },
                NO_GAMEPAD: { label: "Oyun Kumandası Enjeksiyonunu Devre Dışı Bırak", description: "Kullanıcı alanı oyun kumandası aracı enjeksiyonunu devre dışı bırak." },
                SELKIES_DEBUG: { label: "Selkies Hata Ayıklamayı Etkinleştir", description: "Akış bileşenleri için hata ayıklama günlüğünü etkinleştir." },
            }
        },
        appLaboratory: {
            title: 'Uygulama Laboratuvarı',
            description: 'Temel bir uygulamanın üzerine değişiklikler katmanlayarak özel uygulama yapılandırmaları oluşturun ve test edin.',
            selectApp: 'Uygulama Seç',
            createNew: 'Yeni Uygulama Oluştur',
            baseApp: 'Temel Uygulama',
            baseAppDescription: 'Yeni özel uygulamanızın temel alacağı yüklü uygulama.',
            selectBase: 'Bir Temel Uygulama Seçin',
            customizationTitle: 'Özelleştirme',
            appName: 'Uygulama Adı',
            appIcon: 'Uygulama Simgesi',
            uploadIcon: 'Simge Yükle',
            autostartScriptLabel: 'Özel Otomatik Başlatma Betiği',
            permissionsTitle: 'İzinler',
            usersLabel: 'İzin Verilen Kullanıcılar',
            groupsLabel: 'İzin Verilen Gruplar',
            launchButton: 'Kaydet ve Özelleştirme Oturumunu Başlat',
            closeButton: 'Oturumu Kapat ve Sonlandır',
            savingAndLaunching: 'Kaydediliyor ve Başlatılıyor...',
            placeholder: 'Uygulama Laboratuvarı, mevcut yüklü bir uygulamaya dayalı bir uygulama için temel ana dizini ve başlatma betiğini yapılandırmanıza olanak tanır. Bu ana dizin, bu oturumda ayarladığınız tüm dosya ve ayarlarla birlikte kullanıcı için ilk başlatmada kopyalanacaktır. İçeriğini daha fazla değiştirmek için mevcut bir Laboratuvar Uygulamasını yeniden başlatabilirsiniz.',
            formInvalid: 'Lütfen bir temel uygulama seçin ve yeni uygulama için bir ad sağlayın.',
        },
        modals: {
            editUserTitle: 'Kullanıcıyı Düzenle: {username}',
            saveChanges: 'Değişiklikleri Kaydet',
            effectiveSettings: 'Etkin Ayarlar (grup geçersiz kılmalarıyla birlikte)',
            editGroupTitle: 'Grubu Düzenle: {groupName}',
            userConfigTitle: 'Kullanıcı Yapılandırması',
            warning: 'Bu yapılandırma sadece bu sefer gösterilecektir. Kullanıcıya güvenli bir şekilde sağlayın.',
            info: 'Bu yapılandırma dosyasını indirerek SealSkin\'i başka bir cihazda kolayca kurabilirsiniz. Bu dosya özel anahtarınızı içerdiği için güvende tutun.',
            configDataLabel: 'Yapılandırma Verisi (JSON)',
            copyButton: 'Metni Kopyala',
            downloadButton: 'Dosyayı İndir',
            manageHomeDirs: 'Ana Dizinleri Yönet',
            dirsForUser: 'Kullanıcı için dizinler: {username}',
            dirsForAdmin: 'Yönetici için dizinler: {username}',
            newDirForUser: 'Kullanıcı için Yeni Dizin Oluştur',
            createDirButton: 'Dizin Oluştur',
            confirmDeleteDir: '\'{username}\' kullanıcısı için \'{homeName}\' dizinini silmek istediğinizden emin misiniz? Bu işlem kalıcıdır.',
            installAppTitle: '{appName} Yükle',
            editAppTitle: '{appName} Düzenle',
            customNameLabel: 'Özel İsim',
            imageLabel: 'Konteyner İmajı',
            permissions: 'İzinler',
            allowedUsersLabel: 'İzin Verilen Kullanıcılar (virgülle ayrılmış, herkes için \'all\')',
            allowedGroupsLabel: 'İzin Verilen Gruplar (virgülle ayrılmış, herkes için \'all\')',
            features: 'Özellikler',
            gpuSupport: 'GPU Desteği',
            homeMounting: 'Ana Dizin Bağlama',
            urlSupport: 'URL Açma Desteği',
            fileSupport: 'Dosya Açma Desteği',
            autoUpdate: 'İmajı Otomatik Güncelle',
            advancedSettings: 'Gelişmiş Ayarlar',
            appTemplateLabel: 'Uygulama Şablonu',
            appTemplateDescription: 'Gelişmiş konteyner başlatma ayarları için önceden yapılandırılmış bir şablon seçin.',
            customAutostartScriptLabel: 'Özel Otomatik Başlatma Betiği',
            customAutostartScriptDescription: 'Otomatik başlatma mantığını özelleştirin, uygulama sağlayıcısından varsayılanı kullanmak için boş bırakın.',
            saveInstallation: 'Kurulumu Kaydet',
            updateStatusTitle: '{appName} için Güncelleme Durumu',
            checkingUpdates: 'Güncellemeler kontrol ediliyor...',
            updateAvailable: 'Yeni bir imaj versiyonu mevcut!',
            yourVersion: 'Sizin versiyonunuz: {sha}',
            latestAvailable: 'En son versiyon kayıt defterinden çekilmeye hazır.',
            pullLatest: 'En Son İmajı Çek',
            upToDate: 'İmajınız güncel.',
            currentVersion: 'Mevcut versiyon: {sha}',
            errorChecking: 'Güncellemeler kontrol edilirken hata oluştu.',
            pullingLatest: 'En son imaj çekiliyor... Bu biraz zaman alabilir.',
            pullComplete: 'Çekme tamamlandı!',
            newVersion: 'Yeni versiyon: {sha}',
            errorPulling: 'İmaj çekilirken hata oluştu.',
            manualInstallNote: "Not: Manuel olarak eklenen imajlar, selkies-baseimage uyumlu bir imaja dayanmalıdır.",
        },
        status: {
            loggingIn: 'Giriş yapılıyor...',
            configSaved: 'Yapılandırma başarıyla kaydedildi!',
            configApplied: 'Yapılandırma uygulandı! Lütfen Giriş Yapıp Test Edin.',
            configApplyFailed: 'Yapılandırma uygulanamadı: {error}',
            fileReadError: 'Dosya okunurken hata oluştu.',
            noConfig: 'Lütfen bir yapılandırma dosyası veya metni sağlayın.',
            loggedInAdmin: 'Yönetici olarak giriş yapıldı: {username}',
            loggedInUser: 'Standart kullanıcı olarak giriş yapıldı: {username}.',
            loginFailed: 'Giriş başarısız: {error}',
            adminDataRefreshFailed: 'Yönetici verileri yenilenemedi: {error}',
            logoutSuccess: 'Çıkış yapıldı ve yapılandırma temizlendi.',
            generateConfigFailed: 'Yapılandırma oluşturulamadı, kullanıcı detayları eksik.',
            copySuccess: 'Yapılandırma panoya kopyalandı!',
            copyFailed: 'Metin kopyalanamadı.',
            publicKeyCopied: 'Açık anahtar kopyalandı!',
            keyCopyFailed: 'Anahtar kopyalanamadı.',
            creatingAdmin: 'Yönetici oluşturuluyor...',
            adminCreated: 'Yönetici \'{username}\' oluşturuldu.',
            adminCreateFailed: 'Yönetici oluşturulurken hata: {error}',
            adminDeleted: 'Yönetici \'{username}\' başarıyla silindi.',
            adminDeleteFailed: 'Yönetici silinirken hata: {error}',
            creatingUser: 'Kullanıcı oluşturuluyor...',
            userCreated: 'Kullanıcı \'{username}\' oluşturuldu.',
            userCreateFailed: 'Kullanıcı oluşturulurken hata: {error}',
            userDeleted: 'Kullanıcı \'{username}\' başarıyla silindi.',
            userDeleteFailed: 'Kullanıcı silinirken hata: {error}',
            userUpdated: 'Kullanıcı \'{username}\' başarıyla güncellendi.',
            userUpdateFailed: 'Kullanıcı güncellenirken hata: {error}',
            creatingGroup: 'Grup oluşturuluyor...',
            groupCreated: 'Grup \'{groupName}\' oluşturuldu.',
            groupCreateFailed: 'Grup oluşturulurken hata: {error}',
            groupDeleted: 'Grup \'{groupName}\' başarıyla silindi.',
            groupDeleteFailed: 'Grup silinirken hata: {error}',
            groupUpdated: 'Grup \'{groupName}\' başarıyla güncellendi.',
            groupUpdateFailed: 'Grup güncellenirken hata: {error}',
            homedirLoadFailed: 'Ana dizinler yüklenemedi: {error}',
            homedirCreateFailed: 'Dizin oluşturulurken hata: {error}',
            homedirCreated: 'Ana dizin \'{homeName}\' oluşturuldu.',
            homedirDeleted: 'Dizin \'{homeName}\' silindi.',
            homedirDeleteFailed: 'Dizin silinirken hata: {error}',
            homedirCreatedFor: '{username} için \'{homeName}\' dizini oluşturuldu.',
            homedirDeletedFor: '{username} için \'{homeName}\' dizini silindi.',
            sessionsLoadFailed: 'Oturumlar yüklenemedi: {error}',
            sessionStopError: 'Oturum durdurulurken hata: {error}',
            sessionStopped: 'Oturum başarıyla durduruldu.',
            appDataRefreshFailed: 'Uygulama verileri yenilenemedi: {error}',
            closingSession: 'Özelleştirme oturumu kaydediliyor...',
            sessionClosed: 'Özelleştirme oturumu kapatıldı.',
            sessionCloseFailed: 'Özelleştirme oturumu kapatılamadı: {error}',
            fetchingApps: 'Mağazadan uygulamalar getiriliyor...',
            fetchAppsFailed: 'Mağazadan uygulamalar getirilemedi: {error}',
            appStoreAddFailed: 'Mağaza eklenirken hata: {error}',
            appStoreAdded: 'Uygulama mağazası \'{name}\' eklendi.',
            appSaved: 'Uygulama \'{name}\' başarıyla {action}.',
            appSaveActions: {
                updated: 'güncellendi',
                installed: 'yüklendi'
            },
            appSaveFailed: 'Uygulama kaydedilirken hata: {error}',
            appDeleted: 'Uygulama \'{name}\' silindi.',
            appDeleteFailed: 'Uygulama silinirken hata: {error}',
            templateSaved: 'Şablon \'{name}\' başarıyla kaydedildi.',
            templateSaveFailed: 'Şablon kaydedilirken hata: {error}',
            templateDeleted: 'Şablon \'{name}\' başarıyla silindi.',
            templateDeleteFailed: 'Şablon silinirken hata: {error}',
            pinRemoved: 'Sabitlenmiş davranış kaldırıldı.',
            keyGenerated: 'Yeni anahtar çifti oluşturuldu.',
            keyGenFailed: 'Anahtar oluşturma başarısız: {{error}}',
            pendingConfigSaved: 'Bekleyen yapılandırma kaydedildi. Artık açık anahtarınızı yöneticiye sağlayabilirsiniz.',
            settingsSaved: 'Ayarlar kaydedildi.',
            appCreated: 'Uygulama \'{name}\' başarıyla oluşturuldu.',
            launchFailed: 'Başlatma başarısız: {error}',
        },
        placeholders: {
            noAdmins: 'Yönetici bulunamadı.',
            noUsers: 'Kullanıcı bulunamadı.',
            noGroups: 'Grup bulunamadı.',
            noHomeDirs: 'Ana dizin bulunamadı.',
            noSessions: 'Aktif oturum bulunamadı.',
            noPinned: 'Sabitlenmiş davranış bulunamadı.',
            errorLoading: 'Dizinler yüklenirken hata oluştu.',
            noInstalledApps: 'Henüz hiçbir uygulama yüklenmedi.',
        },
    },
    popup: {
        tabs: {
            launch: 'Yeni Başlat',
            sessions: 'Aktif Oturumlar',
            manageFiles: 'Dosyaları Yönet',
            uploadStorage: 'Depolamaya Yükle',
            uploadFiles: 'Dosya Yükle',
            uploadFilesTitle: 'Ayrı dosya yükleme sayfasını aç'
        },
        launchView: {
            searchPlaceholder: 'Uygulamaları ara...',
            uploadingFile: 'Dosya yükleniyor...',
            gpuLabel: 'GPU',
            storageLabel: 'Depolama',
            languageLabel: 'Dil',
            cleanroom: 'Temiz Oda (Geçici)',
            noGpu: 'Yok',
            saveOptions: 'Bu başlatma seçeneklerini kaydet',
            saveOptionsForUrl: 'Tüm URL\'ler için seçenekleri kaydet',
            saveOptionsForFile: '.{extension} dosyaları için seçenekleri kaydet',
            openFile: 'Başlatıldığında dosyayı aç',
            launchButton: 'Başlat',
            launchingButton: 'Başlatılıyor...',
            uploadingButton: 'Yükleniyor...',
            autoHome: 'Otomatik (uygulama başına kalıcılık)',
            collaborationMode: 'Ortak Oturum',
            waylandMode: 'Wayland Modu',
        },
        sessionsView: {
            noSessions: 'Aktif oturum bulunamadı.',
        },
        uploadStorageView: {
            selectHome: 'Ana Dizin Seç',
            description: 'Bu, <strong>{filename}</strong> dosyasını ileride kullanmak üzere doğrudan Dosyalar depolama alanınıza yükleyecektir.',
            descriptionFallback: 'Bu, <strong>{filename}</strong> dosyasını ileride kullanmak üzere doğrudan Dosyalar depolama alanınıza yükleyecektir.',
            uploadButton: 'Dosya Yükle',
            uploadingButton: 'Yükleniyor...',
            preparing: 'Dosya hazırlanıyor...',
            uploadingChunk: '{total} parçadan {current}. yükleniyor...',
            finalizing: 'Sonlandırılıyor...',
            uploadComplete: 'Yükleme Tamamlandı!',
        },
        status: {
            unconfigured: 'Lütfen uzantıyı seçenekler sayfasından yapılandırın.',
            openingServerFile: "Sunucu tarafı dosya açılıyor: {filename}",
            openingFile: 'Dosya açılıyor: {filename}',
            openingUrl: 'URL açılıyor: {targetUrl}',
            error: 'Hata: {message}',
            preparingFile: 'Dosya hazırlanıyor...',
            sendingFile: 'Dosya oturuma gönderiliyor...',
            errorSendingFile: 'Dosya gönderilirken hata: {message}',
            errorClosingSession: 'Oturum kapatılırken hata: {message}',
            preparingSession: 'İzole oturum hazırlanıyor...',
            fetchingData: 'Dosya verileri alınıyor...',
            fetchDataFailed: 'Dosya verileri alınamadı: {statusText}',
            unknownAction: 'Bilinmeyen başlatma eylemi.',
            noAppSelected: 'Lütfen bir uygulama seçin.',
            noAppsAvailable: 'Hesabınız için uygun uygulama yok.',
            uploadSuccess: 'Dosya başarıyla yüklendi!',
            creatingAutoHome: 'Otomatik ana dizin oluşturuluyor...',
        },
        languages: {
            default: 'Varsayılan ({locale})'
        }
    },
    upload: {
        title: 'Dosya Yükleme',
        description: 'Güvenli, izole bir oturumda açmak için bilgisayarınızdan bir dosya seçin.',
        dropzone: {
            title: 'Buraya bir dosya sürükleyip bırakın',
            or: 'veya',
            button: 'Dosya Seç',
        },
        confirm: {
            ready: 'Dosya güvenli bir şekilde açılmaya hazır.',
            button: 'Başlatmaya Devam Et',
        }
    },
    files: {
        title: 'SealSkin Dosyaları',
        header: {
            title: 'Dosyalar',
            newFolder: 'Yeni Klasör',
            uploadFiles: 'Dosya Yükle',
            uploadFolder: 'Klasör Yükle'
        },
        sidebar: {
            sharedFiles: 'SealSkin Dosyaları',
            publicShares: 'Genel Paylaşımlar'
        },
        shares: {
            title: 'Genel Paylaşılan Dosyalar',
            searchPlaceholder: 'Dosya adı veya ID ile ara...'
        },
        table: {
            name: 'Ad',
            size: 'Boyut',
            lastModified: 'Son Değiştirme',
            created: 'Oluşturuldu',
            expires: 'Sona Eriyor',
            url: 'Genel URL',
            passwordProtected: 'Şifre'
        },
        dropzone: {
            title: 'Yüklemek için dosyaları buraya bırakın'
        },
        pagination: {
            previous: '« Önceki',
            next: 'Sonraki »',
            pageOf: 'Sayfa {page} / {totalPages}'
        },
        modals: {
            newFolder: {
                title: 'Yeni Klasör Oluştur',
                folderNameLabel: 'Klasör Adı',
                nameTitle: 'Yalnızca harf, sayı, alt çizgi, tire veya nokta kullanın.',
                createButton: 'Oluştur'
            },
            confirmDelete: {
                title: 'Silmeyi Onayla',
                message: '{count, plural, one {1 seçili öğeyi} other {{count} seçili öğeyi}} silmek istediğinizden emin misiniz? Bu işlem geri alınamaz.',
                messageDefault: 'Seçili öğeleri silmek istediğinizden emin misiniz? Bu işlem geri alınamaz.'
            },
            uploadProgress: {
                title: 'Yükleme İlerlemesi',
                doneButton: 'Bitti'
            },
            share: {
                title: 'Dosya Paylaş',
                sharingFile: 'Paylaşılan dosya: <strong>{filename}</strong>',
                passwordLabel: 'Şifre (isteğe bağlı)',
                passwordPlaceholder: 'Şifresiz bırakmak için boş bırakın',
                expiryLabel: 'Sona erme süresi (saat, isteğe bağlı)',
                expiryPlaceholder: 'örn. bir gün için 24',
                shareButton: 'Paylaşım Bağlantısı Oluştur'
            }
        },
        status: {
            homeDirLoadFailed: 'Ana dizinler yüklenemedi: {error}',
            filesLoadFailed: 'Dosyalar yüklenirken hata oluştu: {error}',
            deleteProtectedError: 'Korunan sistem klasörleri silinemez.',
            deletingItems: '{count, plural, one {1 öğe} other {{count} öğe}} siliniyor...',
            deleteSuccess: 'Silme başarılı.',
            deleteFailed: 'Silme başarısız: {error}',
            preparingUpload: '{count, plural, one {1 dosya} other {{count} dosya}} yüklemeye hazırlanıyor...',
            uploadPrepFailed: 'Klasör yükleme hazırlığı sırasında hata: {error}',
            notConfigured: 'Hata: SealSkin yapılandırılmamış. Lütfen seçeneklerden ayarlayın.',
            folderCreated: '\'{folderName}\' klasörü oluşturuldu.',
            folderCreateFailed: 'Klasör oluşturulurken hata: {error}',
            shareCreated: 'Paylaşım başarıyla oluşturuldu! Bağlantı panonuza kopyalandı.',
            shareCreateFailed: 'Paylaşım oluşturulamadı: {error}',
            sharesLoadFailed: 'Paylaşılan dosyalar yüklenemedi: {error}',
            shareDeleteFailed: 'Paylaşım silinemedi: {error}',
            shareDeleted: 'Paylaşım başarıyla silindi.',
            urlCopied: 'Genel URL panoya kopyalandı.'
        },
        placeholders: {
            errorLoading: 'Dosyalar yüklenirken hata oluştu.',
            folderEmpty: 'Bu klasör boş.',
            noHomeDirs: 'Kullanılabilir ana dizin yok.',
            noShares: 'Henüz hiçbir dosya paylaşmadınız.'
        },
        uploadStatus: {
            pending: 'beklemede',
            initiating: 'Başlatılıyor...',
            uploading: 'Yükleniyor...',
            finalizing: 'Tamamlanıyor...',
            completed: 'Tamamlandı',
            error: 'Hata'
        }
    }
};

// --- Italian Translations ---
const it = {
    background: {
        contextMenu: {
            openUrl: 'Apri link in SealSkin',
            openFile: 'Apri destinazione link come file in SealSkin',
            sendMedia: 'Invia media a SealSkin',
            searchText: 'Cerca "%s" in SealSkin',
            sendDownload: 'Invia prossimo download a SealSkin'
        }
    },
    common: {
        actions: 'Azioni',
        active: 'Attivo',
        cancel: 'Annulla',
        manage: 'Gestisci',
        delete: 'Elimina',
        edit: 'Modifica',
        save: 'Salva',
        none: 'nessuno',
        error: 'Errore',
        na: 'N/D',
        of: 'di',
        status: 'Stato',
        username: 'Nome utente',
        group: 'Gruppo',
        groups: 'Gruppi',
        publicKey: 'Chiave Pubblica',
        name: 'Nome',
        source: 'Origine',
        imageVersion: 'Versione Immagine',
        language: 'Lingua',
        storage: 'Archiviazione',
        gpu: 'GPU',
        version: 'Versione',
        checked: 'Verificato',
        never: 'Mai',
        stop: 'Ferma',
        reopen: 'Riapri',
        sendFile: 'Invia File',
        share: 'Condividi',
        search: 'Cerca',
        refresh: 'Aggiorna',
        close: 'Chiudi',
        copy: 'Copia',
        open: "Apri",
        copyUrl: 'Copia URL',
        download: 'Scarica',
        next: 'Successivo',
        previous: 'Precedente',
        page: 'Pagina',
        home: 'Home',
        homes: 'Home',
        sessions: 'Sessioni',
        users: 'Utenti',
        admins: 'Amministratori',
        yes: 'Sì',
        no: 'No',
        daysAgo: '{count, plural, one {1 giorno fa} other {{count} giorni fa}}',
        hoursAgo: '{count, plural, one {1 ora fa} other {{count} ore fa}}',
        minutesAgo: '{count, plural, one {1 minuto fa} other {{count} minuti fa}}',
        justNow: 'proprio ora',
        bytes: 'Byte',
        kb: 'KB',
        mb: 'MB',
        gb: 'GB',
        tb: 'TB',
        pb: 'PB',
    },
    options: {
        sidebar: {
            config: 'Configurazione',
            home: 'Cartelle Home',
            sessions: 'Sessioni Attive',
            pinned: 'Comportamento Fissato',
            appStore: 'App Store',
            appTemplates: 'Modelli App',
            appLaboratory: 'Laboratorio App',
            installedApps: 'App Installate',
            users: 'Utenti',
            groups: 'Gruppi',
            admins: 'Amministratori',
        },
        dashboard: {
            title: 'Pannello di Controllo',
            clientSettings: 'Impostazioni Client',
            exportConfig: 'Esporta Configurazione',
            userStatus: 'Stato Utente',
            loggedInAs: 'Accesso effettuato come:',
            role: 'Ruolo',
            roleAdmin: 'Amministratore',
            roleUser: 'Utente Standard',
            serverInfo: 'Informazioni Server',
            server: 'Server:',
            cpuModel: 'Modello CPU:',
            storageUsage: 'Utilizzo Archiviazione:',
            detectedGpus: 'GPU Rilevate:',
            logout: 'Logout e Pulisci Config.',
            howTo: 'Come Usare SealSkin',
            howToDescription: 'Questa sezione contiene la documentazione di base su come utilizzare l\'estensione.',
            howToList: [
                '<strong>Per aprire contenuti in isolamento:</strong> Fai clic con il pulsante destro del mouse su qualsiasi link, immagine o testo selezionato e scegli un\'opzione dal menu contestuale "Isolamento SealSkin".',
                '<strong>Per inviare un download in isolamento:</strong> Fai clic con il pulsante destro del mouse sulla pagina e seleziona "Invia Prossimo Download in Isolamento". Il file successivo che scaricherai verrà intercettato e inviato a una sessione sicura.',
                '<strong>Per avviare un\'applicazione pulita:</strong> Fai clic sull\'icona di SealSkin nella barra degli strumenti del tuo browser.',
                '<strong>Per gestire l\'archiviazione persistente:</strong> Usa la scheda "Cartelle Home" in questa pagina per creare ed eliminare volumi di archiviazione che possono essere utilizzati in più sessioni.',
                '<strong>Per salvare le opzioni di avvio:</strong> Seleziona la casella "Salva queste opzioni di avvio" nel popup prima di avviare un\'applicazione per un tipo di file specifico (es. .pdf) o per tutti gli URL. Gestisci queste preferenze salvate nella scheda "Comportamento Fissato".'
            ],
            confirmLogout: 'Sei sicuro di voler effettuare il logout? Questo cancellerà la configurazione salvata da questo browser.',
        },
        config: {
            quickSetup: 'Configurazione Rapida',
            quickSetupDescription: 'Carica il file di configurazione (.json) fornito dal tuo amministratore, o incolla il suo contenuto qui sotto per impostare automaticamente l\'estensione.',
            uploadLabel: 'Carica File di Configurazione',
            pasteLabel: 'O Incolla Testo di Configurazione',
            pastePlaceholder: 'Incolla qui la tua configurazione JSON...',
            applyButton: 'Applica Configurazione',
            manualLink: 'Configurazione Manuale',
            advancedTitle: 'Configurazione Client (Avanzata)',
            serverIpLabel: 'IP o Dominio del Server',
            serverIpPlaceholder: 'es. 192.168.1.100',
            apiPortLabel: 'Porta API',
            apiPortPlaceholder: 'es. 8000',
            sessionPortLabel: 'Porta Sessione',
            sessionPortPlaceholder: 'es. 8443',
            usernameLabel: 'Nome utente',
            usernamePlaceholder: 'Il tuo nome utente',
            privateKeyLabel: 'La Tua Chiave Privata (Formato PEM)',
            privateKeyPlaceholder: 'Incolla qui il contenuto della tua chiave privata',
            serverKeyLabel: 'Chiave Pubblica del Server (Formato PEM)',
            serverKeyPlaceholder: 'Incolla qui il contenuto di server_public.pem',
            searchEngineLabel: 'Motore di Ricerca Predefinito per Testo Selezionato',
            saveButton: 'Salva Configurazione',
            loginButton: 'Login e Testa',
            automaticLink: 'Configurazione Automatica',
            chooseFile: 'Scegli File',
            keyGeneration: 'Generazione Chiave',
            keyGenDescription: 'Se non hai una coppia di chiavi, puoi generarne una qui. La chiave privata verrà inserita sopra. Fornisci la chiave pubblica al tuo amministratore.',
            generateKeyButton: 'Genera Nuova Coppia di Chiavi',
            publicKeyForAdminLabel: 'La Tua Chiave Pubblica (per l\'admin)',
        },
        home: {
            title: 'Le Tue Cartelle Home',
            description: 'Crea cartelle di archiviazione persistenti da utilizzare tra le sessioni. Queste verranno montate nelle tue applicazioni come cartella di configurazione.',
            newTitle: 'Crea Nuova Cartella Home',
            nameLabel: 'Nome Cartella:',
            namePlaceholder: 'es. i-miei-file-di-progetto',
            nameTitle: 'Usa solo lettere, numeri, underscore o trattino.',
            createButton: 'Crea Cartella',
            isLaboratory: 'Questa è un\'app di Laboratorio, costruita da un\'immagine di base con impostazioni personalizzate.',
            laboratory: 'Laboratorio',
            confirmDelete: 'Sei sicuro di voler eliminare l\'app installata \'{appName}\'?'
        },
        sessions: {
            title: 'Sessioni Attive',
            application: 'Applicazione',
            started: 'Avviata',
            noSessionsUser: 'Nessuna sessione attiva trovata.',
            noSessionsAdmin: 'Nessuna sessione attiva trovata per alcun utente.',
            sessionsFor: 'Sessioni per {username} ({count})',
            confirmStop: 'Sei sicuro di voler fermare questa sessione? Il container verrà distrutto.',
        },
        pinned: {
            title: 'Comportamento Fissato dell\'Estensione',
            description: 'Questa tabella mostra le opzioni di avvio che hai salvato per tipi di file specifici o per tutti gli URL. Puoi rimuovere un comportamento fissato per visualizzare nuovamente le opzioni di avvio.',
            trigger: 'Attivatore',
            savedApp: 'Applicazione Salvata',
            triggerSimple: 'Avvio Semplice (Pulsante Barra Strumenti)',
            triggerUrl: 'Tutti gli URL (da menu contestuale)',
            triggerFile: 'Tipo File: <strong>{fileType}</strong>',
            unknownApp: 'App Sconosciuta ({appId}...)'
        },
        admins: {
            serverKeyTitle: 'Chiave Pubblica del Server',
            serverKeyDescription: 'Questa è la chiave pubblica di cui i file di configurazione degli utenti avranno bisogno per connettersi a questo server.',
            title: 'Gestione Amministratori',
            searchPlaceholder: 'Cerca amministratori...',
            newTitle: 'Crea Nuovo Amministratore',
            publicKeyOptionalLabel: 'Chiave Pubblica (Opzionale):',
            publicKeyPlaceholder: 'Incolla qui la chiave pubblica, o lascia vuoto per generarne una.',
            createButton: 'Crea Amministratore',
            confirmDelete: 'Sei sicuro di voler eliminare l\'amministratore \'{username}\'? Questo eliminerà anche tutta la sua archiviazione persistente e non potrà essere annullato.',
        },
        users: {
            title: 'Gestione Utenti',
            searchPlaceholder: 'Cerca utenti per nome o gruppo...',
            newTitle: 'Crea Nuovo Utente',
            publicKeyOptionalLabel: 'Chiave Pubblica (Opzionale):',
            publicKeyPlaceholder: 'Incolla qui la chiave pubblica dell\'utente, o lascia vuoto per generarne una.',
            settingsTitle: 'Impostazioni Utente',
            sessionLimitLabel: 'Limite Sessioni',
            sessionLimitTitle: 'Numero di sessioni attive che un utente può avere. -1 per illimitato.',
            permissionsTitle: 'Permessi e Rafforzamento',
            activeAccount: 'Account Attivo',
            allowStorage: 'Consenti Archiviazione Persistente',
            allowGpu: 'Consenti Accesso GPU',
            hardenContainer: 'Rafforza Container',
            hardenWm: 'Rafforza Window Manager',
            createButton: 'Crea Utente',
            homesDisabledTooltip: 'Archiviazione persistente disabilitata per questo utente',
            confirmDelete: 'Sei sicuro di voler eliminare l\'utente \'{username}\'? Questo eliminerà anche tutta la sua archiviazione persistente e non potrà essere annullato.',
            allowPublicSharing: 'Consenti condivisione file pubblica',
        },
        groups: {
            title: 'Gestione Gruppi',
            searchPlaceholder: 'Cerca gruppi...',
            newTitle: 'Crea Nuovo Gruppo',
            nameLabel: 'Nome Gruppo:',
            overrideTitle: 'Impostazioni di Sovrascrittura del Gruppo',
            permissionsTitle: 'Sovrascritture Permessi e Rafforzamento',
            createButton: 'Crea Gruppo',
            confirmDelete: 'Sei sicuro di voler eliminare il gruppo \'{groupName}\'? Gli utenti in questo gruppo torneranno alle loro impostazioni individuali.',
        },
        installedApps: {
            title: 'Applicazioni Installate',
            searchPlaceholder: 'Cerca app installate...',
            noAppsFound: 'Nessuna app installata trovata.',
            pulling: 'Scaricamento nuova immagine...',
            notLocal: 'Immagine non trovata localmente',
            confirmDelete: 'Sei sicuro di voler eliminare l\'app installata \'{appName}\'?',
        },
        appStore: {
            title: 'App Store',
            refreshTitle: 'Aggiorna lo store selezionato',
            selectLabel: 'Seleziona App Store',
            addLabel: 'Aggiungi Nuovo App Store',
            namePlaceholder: 'Nome Store',
            urlPlaceholder: 'URL YAML dello Store',
            availableTitle: 'App Disponibili',
            addManual: "Aggiungi App Manuale",
            searchPlaceholder: 'Cerca app disponibili...',
            noAppsFound: 'Nessuna applicazione trovata.',
            availableFrom: 'App Disponibili da {storeName}',
            couldNotLoad: 'Impossibile caricare le app da questo store.',
        },
        appTemplates: {
            title: 'Editor Modelli di Applicazione',
            loadLabel: 'Carica Modello',
            createOption: 'Crea Nuovo Modello',
            nameLabel: 'Nome Modello',
            namePlaceholder: 'Inserisci un nome per il nuovo modello',
            saveButton: 'Salva Profilo',
            deleteButton: 'Elimina',
            previewTitle: 'Anteprima UI',
            contentArea: 'Area Contenuto Applicazione',
            confirmDelete: 'Sei sicuro di voler eliminare il modello \'{templateName}\'? Questa azione non può essere annullata.',
            deleteDisabled: 'Questo modello non può essere eliminato.',
            enterName: 'Inserisci un nome per il nuovo modello.',
            settings: {
                TITLE: { label: "Titolo Pagina", description: "Il titolo della pagina visualizzato nel browser web." },
                SELKIES_UI_TITLE: { label: "Titolo Barra Laterale", description: "Titolo nell'angolo in alto a sinistra della barra laterale." },
                SELKIES_UI_SHOW_SIDEBAR: { label: "Mostra Barra Laterale", description: "Mostra l'interfaccia utente principale della barra laterale." },
                SELKIES_UI_SHOW_LOGO: { label: "Mostra Logo", description: "Mostra il logo Selkies nella barra laterale." },
                SELKIES_UI_SHOW_CORE_BUTTONS: { label: "Mostra Pulsanti Principali", description: "Mostra i pulsanti dei componenti principali (display, audio, ecc.)." },
                SELKIES_UI_SIDEBAR_SHOW_VIDEO_SETTINGS: { label: "Mostra Impostazioni Video", description: "Mostra la sezione delle impostazioni video nella barra laterale." },
                SELKIES_UI_SIDEBAR_SHOW_SCREEN_SETTINGS: { label: "Mostra Impostazioni Schermo", description: "Mostra la sezione delle impostazioni dello schermo nella barra laterale." },
                SELKIES_UI_SIDEBAR_SHOW_AUDIO_SETTINGS: { label: "Mostra Impostazioni Audio", description: "Mostra la sezione delle impostazioni audio nella barra laterale." },
                SELKIES_UI_SIDEBAR_SHOW_STATS: { label: "Mostra Statistiche", description: "Mostra la sezione delle statistiche nella barra laterale." },
                SELKIES_UI_SIDEBAR_SHOW_CLIPBOARD: { label: "Mostra Appunti", description: "Mostra la sezione degli appunti nella barra laterale." },
                SELKIES_UI_SIDEBAR_SHOW_FILES: { label: "Mostra Sezione File", description: "Mostra la sezione di trasferimento file nella barra laterale." },
                SELKIES_UI_SIDEBAR_SHOW_APPS: { label: "Mostra Sezione App", description: "Mostra la sezione delle applicazioni nella barra laterale." },
                SELKIES_UI_SIDEBAR_SHOW_SHARING: { label: "Mostra Sezione Condivisione", description: "Mostra la sezione di condivisione nella barra laterale." },
                SELKIES_UI_SIDEBAR_SHOW_GAMEPADS: { label: "Mostra Sezione Gamepad", description: "Mostra la sezione dei gamepad nella barra laterale." },
                SELKIES_UI_SIDEBAR_SHOW_KEYBOARD_BUTTON: { label: "Mostra Pulsante Tastiera", description: "Mostra il pulsante della tastiera su schermo." },
                SELKIES_UI_SIDEBAR_SHOW_SOFT_BUTTONS: { label: "Mostra Pulsanti Virtuali", description: "Mostra la sezione dei pulsanti virtuali (per mobile)." },
                WATERMARK_PNG: { label: "Percorso PNG Filigrana", description: "Percorso completo all'interno del container a un file png di filigrana." },
                WATERMARK_LOCATION: { label: "Posizione Filigrana", description: "Dove disegnare l'immagine sopra lo stream.", options: { disabled: "Disabilitato", topLeft: "In Alto a Sinistra", topRight: "In Alto a Destra", bottomLeft: "In Basso a Sinistra", bottomRight: "In Basso a Destra", centered: "Centrato", animated: "Animato" } },
                DASHBOARD: { label: "Stile Pannello di Controllo", description: "Permette all'utente di impostare il proprio pannello di controllo.", options: { default: "Predefinito", selkiesDefault: "Selkies (Predefinito)", zinc: "Zinc", wish: "Wish" } },
                SELKIES_AUDIO_ENABLED: { label: "Abilita Audio", description: "Abilita lo streaming audio da server a client." },
                SELKIES_MICROPHONE_ENABLED: { label: "Abilita Microfono", description: "Abilita l'inoltro del microfono da client a server." },
                SELKIES_GAMEPAD_ENABLED: { label: "Abilita Gamepad", description: "Abilita il supporto per gamepad." },
                SELKIES_CLIPBOARD_ENABLED: { label: "Abilita Appunti", description: "Abilita la sincronizzazione degli appunti." },
                SELKIES_ENABLE_BINARY_CLIPBOARD: { label: "Abilita Appunti Binari", description: "Consenti dati binari (immagini) negli appunti." },
                SELKIES_COMMAND_ENABLED: { label: "Abilita Websocket Comandi", description: "Abilita l'analisi dei messaggi del websocket dei comandi." },
                SELKIES_FILE_TRANSFERS: { label: "Trasferimenti File", description: "Direzioni consentite ('upload,download', 'upload', 'download', 'none')." },
                SELKIES_ENABLE_SHARING: { label: "Abilita Tutta la Condivisione", description: "Interruttore principale per tutte le funzionalità di condivisione." },
                SELKIES_SECOND_SCREEN: { label: "Abilita Secondo Schermo", description: "Abilita il supporto per un secondo monitor/display." },
                SELKIES_USE_BROWSER_CURSORS: { label: "Usa Cursori del Browser", description: "Usa i cursori CSS del browser invece di renderizzarli sul canvas." },
                SELKIES_USE_CSS_SCALING: { label: "Usa Ridimensionamento CSS (LoDPI)", description: "Se vero, viene inviata una risoluzione più bassa e il canvas viene allungato." },
                SELKIES_IS_MANUAL_RESOLUTION_MODE: { label: "Modalità Risoluzione Manuale", description: "Blocca la risoluzione ai valori manuali di larghezza/altezza." },
                SELKIES_MANUAL_WIDTH: { label: "Larghezza Manuale", description: "Blocca la larghezza a un valore fisso. Forza la modalità manuale." },
                SELKIES_MANUAL_HEIGHT: { label: "Altezza Manuale", description: "Blocca l'altezza a un valore fisso. Forza la modalità manuale." },
                SELKIES_SCALING_DPI: { label: "DPI Ridimensionamento UI", description: "Il DPI predefinito per il ridimensionamento dell'interfaccia utente." },
                SELKIES_AUDIO_BITRATE: { label: "Bitrate Audio", description: "Il bitrate audio predefinito." },
                SELKIES_ENCODER: { label: "Encoder", description: "Elenco di encoder separati da virgola. Il primo è il predefinito." },
                SELKIES_USE_CPU: { label: "Forza Codifica CPU", description: "Forza la codifica basata su CPU per pixelflux." },
                SELKIES_FRAMERATE: { label: "Framerate (Intervallo o Fisso)", description: "es. '8-120' per un intervallo o '60' per un valore fisso." },
                SELKIES_H264_CRF: { label: "CRF H.264 (Intervallo o Fisso)", description: "es. '5-50' per un intervallo o '25' per un valore fisso." },
                SELKIES_JPEG_QUALITY: { label: "Qualità JPEG (Intervallo o Fisso)", description: "es. '1-100' per un intervallo o '60' per un valore fisso." },
                SELKIES_H264_FULLCOLOR: { label: "H.264 Colore Pieno", description: "Abilita la gamma di colori completa H.264 per gli encoder pixelflux." },
                SELKIES_H264_STREAMING_MODE: { label: "Modalità Streaming H.264 (Turbo)", description: "Abilita la modalità di streaming H.264 a bassa latenza." },
                SELKIES_USE_PAINT_OVER_QUALITY: { label: "Usa Qualità Paint-Over", description: "Abilita il paint-over di alta qualità per scene statiche." },
                SELKIES_PAINT_OVER_JPEG_QUALITY: { label: "Qualità JPEG Paint-Over", description: "es. '1-100' per un intervallo o '90' per un valore fisso." },
                SELKIES_H264_PAINTOVER_CRF: { label: "CRF H.264 Paint-Over", description: "es. '5-50' per un intervallo o '18' per un valore fisso." },
                SELKIES_H264_PAINTOVER_BURST_FRAMES: { label: "Frame Burst Paint-Over", description: "es. '1-30' per un intervallo o '5' per un valore fisso." },
                HARDEN_DESKTOP: { label: "Rafforza Desktop (Preimpostato)", description: "Abilita DISABLE_OPEN_TOOLS, DISABLE_SUDO e DISABLE_TERMINALS." },
                HARDEN_OPENBOX: { label: "Rafforza Window Manager (Preimpostato)", description: "Abilita DISABLE_CLOSE_BUTTON, DISABLE_MOUSE_BUTTONS e HARDEN_KEYBINDS. Abilita anche RESTART_APP." },
                DISABLE_OPEN_TOOLS: { label: "Disabilita Strumenti di Apertura", description: "Disabilita i binari xdg-open e exo-open." },
                DISABLE_SUDO: { label: "Disabilita Sudo", description: "Disabilita il comando sudo." },
                DISABLE_TERMINALS: { label: "Disabilita Terminali", description: "Disabilita gli emulatori di terminale comuni." },
                DISABLE_CLOSE_BUTTON: { label: "Disabilita Pulsante Chiusura Finestra", description: "Rimuove il pulsante di chiusura dalle barre del titolo delle finestre." },
                DISABLE_MOUSE_BUTTONS: { label: "Disabilita Click Destro/Centrale", description: "Disabilita i menu contestuali del click destro e centrale." },
                HARDEN_KEYBINDS: { label: "Rafforza Combinazioni Tasti", description: "Disabilita le combinazioni di tasti predefinite di Openbox come Alt+F4." },
                RESTART_APP: { label: "Riavvia App alla Chiusura", description: "Riavvia automaticamente l'applicazione principale se viene chiusa." },
                MAX_RES: { label: "Risoluzione Massima", description: "Risoluzione massima per il container, il valore predefinito è 16k." },
                START_DOCKER: { label: "Avvia Docker-in-Docker", description: "Se falso, un container privilegiato non avvierà DinD." },
                DISABLE_IPV6: { label: "Disabilita IPv6", description: "Se vero, questo disabiliterà IPv6." },
                DISABLE_ZINK: { label: "Disabilita Zink", description: "Non impostare le variabili d'ambiente Zink se viene rilevata una scheda video." },
                DISABLE_DRI3: { label: "Disabilita DRI3", description: "Non usare l'accelerazione DRI3 se viene rilevata una scheda video." },
                NO_DECOR: { label: "Nessuna Decorazione Finestra", description: "Esegui l'applicazione senza bordi della finestra per l'uso come PWA." },
                NO_FULL: { label: "Nessun Schermo Intero", description: "Non mettere automaticamente le applicazioni a schermo intero." },
                NO_GAMEPAD: { label: "Disabilita Iniezione Gamepad", description: "Disabilita l'iniezione dell'interposer del gamepad nello spazio utente." },
                SELKIES_DEBUG: { label: "Abilita Debugging Selkies", description: "Abilita il logging di debug per i componenti di streaming." },
            }
        },
        appLaboratory: {
            title: 'Laboratorio App',
            description: 'Crea e testa configurazioni di applicazioni personalizzate stratificando le modifiche su un\'app di base.',
            selectApp: 'Seleziona App',
            createNew: 'Crea Nuova App',
            baseApp: 'Applicazione di Base',
            baseAppDescription: 'L\'applicazione installata su cui si baserà la tua nuova app personalizzata.',
            selectBase: 'Seleziona un\'App di Base',
            customizationTitle: 'Personalizzazione',
            appName: 'Nome App',
            appIcon: 'Icona App',
            uploadIcon: 'Carica Icona',
            autostartScriptLabel: 'Script di Avvio Automatico Personalizzato',
            permissionsTitle: 'Permessi',
            usersLabel: 'Utenti Consentiti',
            groupsLabel: 'Gruppi Consentiti',
            launchButton: 'Salva e Avvia Sessione di Personalizzazione',
            closeButton: 'Chiudi Sessione e Finalizza',
            savingAndLaunching: 'Salvataggio e Avvio...',
            placeholder: 'Il Laboratorio App ti permette di configurare la directory home di base e lo script di avvio per un\'applicazione basata su un\'applicazione installata esistente. Questa directory home verrà copiata al primo avvio per l\'utente con tutti i file e le impostazioni che hai configurato in questa sessione. Puoi riavviare un\'App di Laboratorio esistente per modificarne ulteriormente i contenuti.',
            formInvalid: 'Seleziona un\'app di base e fornisci un nome per la nuova app.',
        },
        modals: {
            editUserTitle: 'Modifica Utente: {username}',
            saveChanges: 'Salva Modifiche',
            effectiveSettings: 'Impostazioni Effettive (con sovrascritture di gruppo)',
            editGroupTitle: 'Modifica Gruppo: {groupName}',
            userConfigTitle: 'Configurazione Utente',
            warning: 'Questa è l\'unica volta che questa configurazione verrà mostrata. Forniscila all\'utente in modo sicuro.',
            info: 'Puoi scaricare questo file di configurazione per impostare facilmente SealSkin su un altro dispositivo. Conserva questo file al sicuro poiché contiene la tua chiave privata.',
            configDataLabel: 'Dati di Configurazione (JSON)',
            copyButton: 'Copia Testo',
            downloadButton: 'Scarica File',
            manageHomeDirs: 'Gestisci Cartelle Home',
            dirsForUser: 'Cartelle per l\'utente: {username}',
            dirsForAdmin: 'Cartelle per l\'amministratore: {username}',
            newDirForUser: 'Crea Nuova Cartella per l\'Utente',
            createDirButton: 'Crea Cartella',
            confirmDeleteDir: 'Sei sicuro di voler eliminare \'{homeName}\' per l\'utente \'{username}\'? L\'azione è permanente.',
            installAppTitle: 'Installa {appName}',
            editAppTitle: 'Modifica {appName}',
            customNameLabel: 'Nome Personalizzato',
            imageLabel: 'Immagine Container',
            permissions: 'Permessi',
            allowedUsersLabel: 'Utenti Consentiti (separati da virgola, \'all\' per tutti)',
            allowedGroupsLabel: 'Gruppi Consentiti (separati da virgola, \'all\' per tutti)',
            features: 'Funzionalità',
            gpuSupport: 'Supporto GPU',
            homeMounting: 'Montaggio Cartella Home',
            urlSupport: 'Supporto Apertura URL',
            fileSupport: 'Supporto Apertura File',
            autoUpdate: 'Aggiorna Immagine Automaticamente',
            advancedSettings: 'Impostazioni Avanzate',
            appTemplateLabel: 'Modello Applicazione',
            appTemplateDescription: 'Seleziona un modello preconfigurato per impostazioni avanzate di avvio del container.',
            customAutostartScriptLabel: 'Script di Avvio Automatico Personalizzato',
            customAutostartScriptDescription: 'Personalizza la logica di avvio automatico, lascia vuoto per usare quella predefinita del fornitore dell\'applicazione.',
            saveInstallation: 'Salva Installazione',
            updateStatusTitle: 'Stato Aggiornamento per {appName}',
            checkingUpdates: 'Verifica aggiornamenti in corso...',
            updateAvailable: 'È disponibile una nuova versione dell\'immagine!',
            yourVersion: 'La tua versione: {sha}',
            latestAvailable: 'L\'ultima versione è disponibile per il download dal registro.',
            pullLatest: 'Scarica Ultima Immagine',
            upToDate: 'La tua immagine è aggiornata.',
            currentVersion: 'Versione attuale: {sha}',
            errorChecking: 'Errore durante la verifica degli aggiornamenti.',
            pullingLatest: 'Scaricamento ultima immagine... Potrebbe richiedere un momento.',
            pullComplete: 'Scaricamento completato!',
            newVersion: 'Nuova versione: {sha}',
            errorPulling: 'Errore durante lo scaricamento dell\'immagine.',
            manualInstallNote: "Nota: Le immagini aggiunte manualmente dovrebbero essere basate su un'immagine compatibile con selkies-baseimage.",
        },
        status: {
            loggingIn: 'Accesso in corso...',
            configSaved: 'Configurazione salvata con successo!',
            configApplied: 'Configurazione applicata! Esegui il Login e Testa.',
            configApplyFailed: 'Impossibile applicare la configurazione: {error}',
            fileReadError: 'Errore durante la lettura del file.',
            noConfig: 'Fornisci un file di configurazione o del testo.',
            loggedInAdmin: 'Accesso effettuato come amministratore: {username}',
            loggedInUser: 'Accesso effettuato come utente standard: {username}.',
            loginFailed: 'Accesso fallito: {error}',
            adminDataRefreshFailed: 'Impossibile aggiornare i dati dell\'amministratore: {error}',
            logoutSuccess: 'Logout effettuato e configurazione cancellata.',
            generateConfigFailed: 'Impossibile generare la configurazione, mancano i dettagli dell\'utente.',
            copySuccess: 'Configurazione copiata negli appunti!',
            copyFailed: 'Impossibile copiare il testo.',
            publicKeyCopied: 'Chiave pubblica copiata!',
            keyCopyFailed: 'Impossibile copiare la chiave.',
            creatingAdmin: 'Creazione amministratore in corso...',
            adminCreated: 'Amministratore \'{username}\' creato.',
            adminCreateFailed: 'Errore durante la creazione dell\'amministratore: {error}',
            adminDeleted: 'Amministratore \'{username}\' eliminato con successo.',
            adminDeleteFailed: 'Errore durante l\'eliminazione dell\'amministratore: {error}',
            creatingUser: 'Creazione utente in corso...',
            userCreated: 'Utente \'{username}\' creato.',
            userCreateFailed: 'Errore durante la creazione dell\'utente: {error}',
            userDeleted: 'Utente \'{username}\' eliminato con successo.',
            userDeleteFailed: 'Errore durante l\'eliminazione dell\'utente: {error}',
            userUpdated: 'Utente \'{username}\' aggiornato con successo.',
            userUpdateFailed: 'Errore durante l\'aggiornamento dell\'utente: {error}',
            creatingGroup: 'Creazione gruppo in corso...',
            groupCreated: 'Gruppo \'{groupName}\' creato.',
            groupCreateFailed: 'Errore durante la creazione del gruppo: {error}',
            groupDeleted: 'Gruppo \'{groupName}\' eliminato con successo.',
            groupDeleteFailed: 'Errore durante l\'eliminazione del gruppo: {error}',
            groupUpdated: 'Gruppo \'{groupName}\' aggiornato con successo.',
            groupUpdateFailed: 'Errore durante l\'aggiornamento del gruppo: {error}',
            homedirLoadFailed: 'Impossibile caricare le cartelle home: {error}',
            homedirCreateFailed: 'Errore durante la creazione della cartella: {error}',
            homedirCreated: 'Cartella home \'{homeName}\' creata.',
            homedirDeleted: 'Cartella \'{homeName}\' eliminata.',
            homedirDeleteFailed: 'Errore durante l\'eliminazione della cartella: {error}',
            homedirCreatedFor: 'Cartella \'{homeName}\' creata per {username}.',
            homedirDeletedFor: 'Cartella \'{homeName}\' eliminata per {username}.',
            sessionsLoadFailed: 'Impossibile caricare le sessioni: {error}',
            sessionStopError: 'Errore durante l\'arresto della sessione: {error}',
            sessionStopped: 'Sessione fermata con successo.',
            appDataRefreshFailed: 'Impossibile aggiornare i dati dell\'app: {error}',
            closingSession: 'Commit della sessione di personalizzazione in corso...',
            sessionClosed: 'Sessione di personalizzazione chiusa.',
            sessionCloseFailed: 'Impossibile chiudere la sessione di personalizzazione: {error}',
            fetchingApps: 'Recupero app dallo store...',
            fetchAppsFailed: 'Impossibile recuperare le app dallo store: {error}',
            appStoreAddFailed: 'Errore durante l\'aggiunta dello store: {error}',
            appStoreAdded: 'App store \'{name}\' aggiunto.',
            appSaved: 'App \'{name}\' {action} con successo.',
            appSaveActions: {
                updated: 'aggiornata',
                installed: 'installata'
            },
            appSaveFailed: 'Errore durante il salvataggio dell\'app: {error}',
            appDeleted: 'App \'{name}\' eliminata.',
            appDeleteFailed: 'Errore durante l\'eliminazione dell\'app: {error}',
            templateSaved: 'Modello \'{name}\' salvato con successo.',
            templateSaveFailed: 'Errore durante il salvataggio del modello: {error}',
            templateDeleted: 'Modello \'{name}\' eliminato con successo.',
            templateDeleteFailed: 'Errore durante l\'eliminazione del modello: {error}',
            pinRemoved: 'Comportamento fissato rimosso.',
            keyGenerated: 'Nuova coppia di chiavi generata.',
            keyGenFailed: 'Generazione chiave fallita: {{error}}',
            pendingConfigSaved: 'Configurazione in sospeso salvata. Ora puoi fornire la tua chiave pubblica all\'amministratore.',
            settingsSaved: 'Impostazioni salvate.',
            appCreated: 'App \'{name}\' creata con successo.',
            launchFailed: 'Avvio fallito: {error}',
        },
        placeholders: {
            noAdmins: 'Nessun amministratore trovato.',
            noUsers: 'Nessun utente trovato.',
            noGroups: 'Nessun gruppo trovato.',
            noHomeDirs: 'Nessuna cartella home trovata.',
            noSessions: 'Nessuna sessione attiva trovata.',
            noPinned: 'Nessun comportamento fissato trovato.',
            errorLoading: 'Errore durante il caricamento delle cartelle.',
            noInstalledApps: 'Nessuna applicazione è stata ancora installata.',
        },
    },
    popup: {
        tabs: {
            launch: 'Avvia Nuovo',
            sessions: 'Sessioni Attive',
            manageFiles: 'Gestisci File',
            uploadStorage: 'Carica su Archiviazione',
            uploadFiles: 'Carica File',
            uploadFilesTitle: 'Apri pagina dedicata al caricamento file'
        },
        launchView: {
            searchPlaceholder: 'Cerca applicazioni...',
            uploadingFile: 'Caricamento file...',
            gpuLabel: 'GPU',
            storageLabel: 'Archiviazione',
            languageLabel: 'Lingua',
            cleanroom: 'Cleanroom (Effimero)',
            noGpu: 'Nessuna',
            saveOptions: 'Salva queste opzioni di avvio',
            saveOptionsForUrl: 'Salva opzioni per tutti gli URL',
            saveOptionsForFile: 'Salva opzioni per file .{extension}',
            openFile: 'Apri file all\'avvio',
            launchButton: 'Avvia',
            launchingButton: 'Avvio in corso...',
            uploadingButton: 'Caricamento...',
            autoHome: 'Automatico (persistenza per app)',
            collaborationMode: 'Sessione collaborativa',
            waylandMode: 'Modalità Wayland',
        },
        sessionsView: {
            noSessions: 'Nessuna sessione attiva trovata.',
        },
        uploadStorageView: {
            selectHome: 'Seleziona Cartella Home',
            description: 'Questo caricherà il file <strong>{filename}</strong> direttamente nel tuo archivio File per uso futuro.',
            descriptionFallback: 'Questo caricherà il file <strong>{filename}</strong> direttamente nel tuo archivio File per uso futuro.',
            uploadButton: 'Carica File',
            uploadingButton: 'Caricamento...',
            preparing: 'Preparazione file...',
            uploadingChunk: 'Caricamento chunk {current} di {total}...',
            finalizing: 'Finalizzazione...',
            uploadComplete: 'Caricamento Completato!',
        },
        status: {
            unconfigured: 'Configura l\'estensione tramite la pagina delle opzioni.',
            openingServerFile: "Apertura file lato server: {filename}",
            openingFile: 'Apertura file: {filename}',
            openingUrl: 'Apertura URL: {targetUrl}',
            error: 'Errore: {message}',
            preparingFile: 'Preparazione file...',
            sendingFile: 'Invio file alla sessione...',
            errorSendingFile: 'Errore durante l\'invio del file: {message}',
            errorClosingSession: 'Errore durante la chiusura della sessione: {message}',
            preparingSession: 'Preparazione sessione isolata...',
            fetchingData: 'Recupero dati del file...',
            fetchDataFailed: 'Impossibile recuperare i dati del file: {statusText}',
            unknownAction: 'Azione di avvio sconosciuta.',
            noAppSelected: 'Seleziona un\'applicazione.',
            noAppsAvailable: 'Nessuna applicazione disponibile per il tuo account.',
            uploadSuccess: 'File caricato con successo!',
            creatingAutoHome: 'Creazione della directory home automatica in corso...',
        },
        languages: {
            default: 'Predefinito ({locale})'
        }
    },
    upload: {
        title: 'Caricamento File',
        description: 'Seleziona un file dal tuo computer per aprirlo in una sessione sicura e isolata.',
        dropzone: {
            title: 'Trascina e rilascia un file qui',
            or: 'o',
            button: 'Seleziona File',
        },
        confirm: {
            ready: 'Il file è pronto per essere aperto in modo sicuro.',
            button: 'Continua per Avviare',
        }
    },
    files: {
        title: 'File di SealSkin',
        header: {
            title: 'File',
            newFolder: 'Nuova Cartella',
            uploadFiles: 'Carica File',
            uploadFolder: 'Carica Cartella'
        },
        sidebar: {
            sharedFiles: 'File di SealSkin',
            publicShares: 'Condivisioni Pubbliche'
        },
        shares: {
            title: 'File Condivisi Pubblicamente',
            searchPlaceholder: 'Cerca per nome file o ID...'
        },
        table: {
            name: 'Nome',
            size: 'Dimensione',
            lastModified: 'Ultima Modifica',
            created: 'Creato',
            expires: 'Scade',
            url: 'URL Pubblico',
            passwordProtected: 'Password'
        },
        dropzone: {
            title: 'Trascina i file per caricarli'
        },
        pagination: {
            previous: '« Precedente',
            next: 'Successivo »',
            pageOf: 'Pagina {page} di {totalPages}'
        },
        modals: {
            newFolder: {
                title: 'Crea Nuova Cartella',
                folderNameLabel: 'Nome Cartella',
                nameTitle: 'Usa solo lettere, numeri, trattino basso, trattino o punto.',
                createButton: 'Crea'
            },
            confirmDelete: {
                title: 'Conferma Eliminazione',
                message: 'Sei sicuro di voler eliminare {count, plural, one {1 elemento selezionato} other {{count} elementi selezionati}}? Questa azione non può essere annullata.',
                messageDefault: 'Sei sicuro di voler eliminare gli elementi selezionati? Questa azione non può essere annullata.'
            },
            uploadProgress: {
                title: 'Avanzamento Caricamento',
                doneButton: 'Fatto'
            },
            share: {
                title: 'Condividi File',
                sharingFile: 'Condivisione del file: <strong>{filename}</strong>',
                passwordLabel: 'Password (opzionale)',
                passwordPlaceholder: 'Lascia vuoto per nessuna password',
                expiryLabel: 'Scade tra (ore, opzionale)',
                expiryPlaceholder: 'es. 24 per un giorno',
                shareButton: 'Crea Link di Condivisione'
            }
        },
        status: {
            homeDirLoadFailed: 'Impossibile caricare le directory home: {error}',
            filesLoadFailed: 'Errore nel caricamento dei file: {error}',
            deleteProtectedError: 'Impossibile eliminare le cartelle di sistema protette.',
            deletingItems: 'Eliminazione di {count, plural, one {1 elemento} other {{count} elementi}}...',
            deleteSuccess: 'Eliminazione riuscita.',
            deleteFailed: 'Eliminazione fallita: {error}',
            preparingUpload: 'Preparazione al caricamento di {count, plural, one {1 file} other {{count} file}}...',
            uploadPrepFailed: 'Errore durante la preparazione del caricamento della cartella: {error}',
            notConfigured: 'Errore: SealSkin non configurato. Si prega di impostarlo nelle opzioni.',
            folderCreated: 'Cartella \'{folderName}\' creata.',
            folderCreateFailed: 'Errore nella creazione della cartella: {error}',
            shareCreated: 'Condivisione creata con successo! Il link è stato copiato negli appunti.',
            shareCreateFailed: 'Creazione della condivisione fallita: {error}',
            sharesLoadFailed: 'Caricamento dei file condivisi fallito: {error}',
            shareDeleteFailed: 'Eliminazione della condivisione fallita: {error}',
            shareDeleted: 'Condivisione eliminata con successo.',
            urlCopied: 'URL pubblico copiato negli appunti.'
        },
        placeholders: {
            errorLoading: 'Errore nel caricamento dei file.',
            folderEmpty: 'Questa cartella è vuota.',
            noHomeDirs: 'Nessuna directory home disponibile.',
            noShares: 'Non hai ancora condiviso nessun file.'
        },
        uploadStatus: {
            pending: 'in attesa',
            initiating: 'Avvio...',
            uploading: 'Caricamento...',
            finalizing: 'Finalizzazione...',
            completed: 'Completato',
            error: 'Errore'
        }
    }
};

// --- Dutch Translations ---
const nl = {
    background: {
        contextMenu: {
            openUrl: 'Link openen in SealSkin',
            openFile: 'Linkdoel openen als bestand in SealSkin',
            sendMedia: 'Media verzenden naar SealSkin',
            searchText: 'Zoeken naar "%s" in SealSkin',
            sendDownload: 'Volgende download naar SealSkin sturen'
        }
    },
    common: {
        actions: 'Acties',
        active: 'Actief',
        cancel: 'Annuleren',
        manage: 'Beheren',
        delete: 'Verwijderen',
        edit: 'Bewerken',
        save: 'Opslaan',
        none: 'geen',
        error: 'Fout',
        na: 'N.v.t.',
        of: 'van',
        status: 'Status',
        username: 'Gebruikersnaam',
        group: 'Groep',
        groups: 'Groepen',
        publicKey: 'Publieke Sleutel',
        name: 'Naam',
        source: 'Bron',
        imageVersion: 'Image Versie',
        language: 'Taal',
        storage: 'Opslag',
        gpu: 'GPU',
        version: 'Versie',
        checked: 'Gecontroleerd',
        never: 'Nooit',
        stop: 'Stoppen',
        reopen: 'Heropenen',
        sendFile: 'Bestand Verzenden',
        share: 'Delen',
        search: 'Zoeken',
        refresh: 'Vernieuwen',
        close: 'Sluiten',
        copy: 'Kopiëren',
        open: "Openen",
        copyUrl: 'URL Kopiëren',
        download: 'Downloaden',
        next: 'Volgende',
        previous: 'Vorige',
        page: 'Pagina',
        home: 'Home Directory',
        homes: 'Home Directories',
        sessions: 'Sessies',
        users: 'Gebruikers',
        admins: 'Beheerders',
        yes: 'Ja',
        no: 'Nee',
        daysAgo: '{count, plural, one {1 dag geleden} other {{count} dagen geleden}}',
        hoursAgo: '{count, plural, one {1 uur geleden} other {{count} uur geleden}}',
        minutesAgo: '{count, plural, one {1 minuut geleden} other {{count} minuten geleden}}',
        justNow: 'zojuist',
        bytes: 'Bytes',
        kb: 'KB',
        mb: 'MB',
        gb: 'GB',
        tb: 'TB',
        pb: 'PB',
    },
    options: {
        sidebar: {
            config: 'Configuratie',
            home: 'Home Directories',
            sessions: 'Actieve Sessies',
            pinned: 'Vastgezet Gedrag',
            appStore: 'App Store',
            appTemplates: 'App Sjablonen',
            appLaboratory: 'App Laboratorium',
            installedApps: 'Geïnstalleerde Apps',
            users: 'Gebruikers',
            groups: 'Groepen',
            admins: 'Beheerders',
        },
        dashboard: {
            title: 'Dashboard',
            clientSettings: 'Clientinstellingen',
            exportConfig: 'Configuratie Exporteren',
            userStatus: 'Gebruikersstatus',
            loggedInAs: 'Ingelogd als:',
            role: 'Rol',
            roleAdmin: 'Beheerder',
            roleUser: 'Standaard Gebruiker',
            serverInfo: 'Serverinformatie',
            server: 'Server:',
            cpuModel: 'CPU-model:',
            storageUsage: 'Opslaggebruik:',
            detectedGpus: 'Gedetecteerde GPU\'s:',
            logout: 'Uitloggen & Configuratie Wissen',
            howTo: 'Hoe SealSkin te Gebruiken',
            howToDescription: 'Deze sectie bevat basisdocumentatie over het gebruik van de extensie.',
            howToList: [
                '<strong>Om inhoud geïsoleerd te openen:</strong> Klik met de rechtermuisknop op een link, afbeelding of geselecteerde tekst en kies een optie uit het "SealSkin Isolation" contextmenu.',
                '<strong>Om een download naar isolatie te sturen:</strong> Klik met de rechtermuisknop op de pagina en selecteer "Volgende Download naar Isolatie Sturen". Het volgende bestand dat u downloadt, wordt onderschept en naar een veilige sessie gestuurd.',
                '<strong>Om een schone applicatie te starten:</strong> Klik op het SealSkin-icoon in de werkbalk van uw browser.',
                '<strong>Om persistente opslag te beheren:</strong> Gebruik het tabblad "Home Directories" op deze pagina om opslagvolumes te maken en te verwijderen die in meerdere sessies kunnen worden gebruikt.',
                '<strong>Om startopties op te slaan:</strong> Vink het vakje "Deze startopties opslaan" aan in de pop-up voordat u een applicatie start voor een specifiek bestandstype (bijv. .pdf) of voor alle URL\'s. Beheer deze opgeslagen voorkeuren in het tabblad "Vastgezet Gedrag".'
            ],
            confirmLogout: 'Weet u zeker dat u wilt uitloggen? Dit wist uw opgeslagen configuratie uit deze browser.',
        },
        config: {
            quickSetup: 'Snelle Installatie',
            quickSetupDescription: 'Upload het configuratiebestand (.json) dat u van uw beheerder heeft ontvangen, of plak de inhoud hieronder om de extensie automatisch in te stellen.',
            uploadLabel: 'Configuratiebestand Uploaden',
            pasteLabel: 'Of Plak Configuratietekst',
            pastePlaceholder: 'Plak hier uw JSON-configuratie...',
            applyButton: 'Configuratie Toepassen',
            manualLink: 'Handmatige Configuratie',
            advancedTitle: 'Clientconfiguratie (Geavanceerd)',
            serverIpLabel: 'Server IP of Domein',
            serverIpPlaceholder: 'bijv., 192.168.1.100',
            apiPortLabel: 'API Poort',
            apiPortPlaceholder: 'bijv., 8000',
            sessionPortLabel: 'Sessie Poort',
            sessionPortPlaceholder: 'bijv., 8443',
            usernameLabel: 'Gebruikersnaam',
            usernamePlaceholder: 'Uw gebruikersnaam',
            privateKeyLabel: 'Uw Privésleutel (PEM Formaat)',
            privateKeyPlaceholder: 'Plak hier de inhoud van uw privésleutel',
            serverKeyLabel: 'Publieke Sleutel van de Server (PEM Formaat)',
            serverKeyPlaceholder: 'Plak hier de inhoud van server_public.pem',
            searchEngineLabel: 'Standaard Zoekmachine voor Geselecteerde Tekst',
            saveButton: 'Configuratie Opslaan',
            loginButton: 'Inloggen & Testen',
            automaticLink: 'Automatische Configuratie',
            chooseFile: 'Bestand Kiezen',
            keyGeneration: 'Sleutelgeneratie',
            keyGenDescription: 'Als u geen sleutelpaar heeft, kunt u er hier een genereren. De privésleutel wordt hierboven ingevuld. Geef de publieke sleutel aan uw beheerder.',
            generateKeyButton: 'Nieuw Sleutelpaar Genereren',
            publicKeyForAdminLabel: 'Uw Publieke Sleutel (voor admin)',
        },
        home: {
            title: 'Uw Home Directories',
            description: 'Maak persistente opslagmappen aan om te gebruiken in verschillende sessies. Deze worden in uw applicaties gemount als uw configuratiemap.',
            newTitle: 'Nieuwe Home Directory Aanmaken',
            nameLabel: 'Mapnaam:',
            namePlaceholder: 'bijv., mijn-project-bestanden',
            nameTitle: 'Gebruik alleen letters, cijfers, underscore of koppelteken.',
            createButton: 'Map Aanmaken',
            isLaboratory: 'Dit is een Laboratorium-app, gebouwd op basis van een basisimage met aangepaste instellingen.',
            laboratory: 'Laboratorium',
            confirmDelete: 'Weet u zeker dat u de geïnstalleerde app \'{appName}\' wilt verwijderen?'
        },
        sessions: {
            title: 'Actieve Sessies',
            application: 'Applicatie',
            started: 'Gestart',
            noSessionsUser: 'Geen actieve sessies gevonden.',
            noSessionsAdmin: 'Geen actieve sessies gevonden voor enige gebruiker.',
            sessionsFor: 'Sessies voor {username} ({count})',
            confirmStop: 'Weet u zeker dat u deze sessie wilt stoppen? De container wordt vernietigd.',
        },
        pinned: {
            title: 'Vastgezet Extensiegedrag',
            description: 'Deze tabel toont de startopties die u heeft opgeslagen voor specifieke bestandstypen of voor alle URL\'s. U kunt een vastgezet gedrag verwijderen om opnieuw om startopties gevraagd te worden.',
            trigger: 'Trigger',
            savedApp: 'Opgeslagen Applicatie',
            triggerSimple: 'Simpele Start (Werkbalkknop)',
            triggerUrl: 'Alle URL\'s (vanuit contextmenu)',
            triggerFile: 'Bestandstype: <strong>{fileType}</strong>',
            unknownApp: 'Onbekende App ({appId}...)'
        },
        admins: {
            serverKeyTitle: 'Publieke Sleutel van de Server',
            serverKeyDescription: 'Dit is de publieke sleutel die gebruikersconfiguratiebestanden nodig hebben om verbinding te maken met deze server.',
            title: 'Beheerdersbeheer',
            searchPlaceholder: 'Zoek beheerders...',
            newTitle: 'Nieuwe Beheerder Aanmaken',
            publicKeyOptionalLabel: 'Publieke Sleutel (Optioneel):',
            publicKeyPlaceholder: 'Plak hier de publieke sleutel, of laat leeg om er een te genereren.',
            createButton: 'Beheerder Aanmaken',
            confirmDelete: 'Weet u zeker dat u beheerder \'{username}\' wilt verwijderen? Dit verwijdert ook al hun persistente opslag en kan niet ongedaan worden gemaakt.',
        },
        users: {
            title: 'Gebruikersbeheer',
            searchPlaceholder: 'Zoek gebruikers op naam of groep...',
            newTitle: 'Nieuwe Gebruiker Aanmaken',
            publicKeyOptionalLabel: 'Publieke Sleutel (Optioneel):',
            publicKeyPlaceholder: 'Plak hier de publieke sleutel van de gebruiker, of laat leeg om er een te genereren.',
            settingsTitle: 'Gebruikersinstellingen',
            sessionLimitLabel: 'Sessielimiet',
            sessionLimitTitle: 'Aantal actieve sessies dat een gebruiker kan hebben. -1 voor onbeperkt.',
            permissionsTitle: 'Permissies & Beveiliging',
            activeAccount: 'Actief Account',
            allowStorage: 'Persistente Opslag Toestaan',
            allowGpu: 'GPU-toegang Toestaan',
            hardenContainer: 'Container Beveiligen',
            hardenWm: 'Window Manager Beveiligen',
            createButton: 'Gebruiker Aanmaken',
            homesDisabledTooltip: 'Persistente opslag uitgeschakeld voor deze gebruiker',
            confirmDelete: 'Weet u zeker dat u gebruiker \'{username}\' wilt verwijderen? Dit verwijdert ook al hun persistente opslag en kan niet ongedaan worden gemaakt.',
            allowPublicSharing: 'Openbaar delen van bestanden toestaan',
        },
        groups: {
            title: 'Groepsbeheer',
            searchPlaceholder: 'Zoek groepen...',
            newTitle: 'Nieuwe Groep Aanmaken',
            nameLabel: 'Groepsnaam:',
            overrideTitle: 'Groepsoverschrijvingsinstellingen',
            permissionsTitle: 'Permissie & Beveiligingsoverschrijvingen',
            createButton: 'Groep Aanmaken',
            confirmDelete: 'Weet u zeker dat u groep \'{groupName}\' wilt verwijderen? Gebruikers in deze groep vallen terug op hun individuele instellingen.',
        },
        installedApps: {
            title: 'Geïnstalleerde Applicaties',
            searchPlaceholder: 'Zoek geïnstalleerde apps...',
            noAppsFound: 'Geen geïnstalleerde apps gevonden.',
            pulling: 'Nieuwe image wordt gedownload...',
            notLocal: 'Image niet lokaal gevonden',
            confirmDelete: 'Weet u zeker dat u de geïnstalleerde app \'{appName}\' wilt verwijderen?',
        },
        appStore: {
            title: 'App Stores',
            refreshTitle: 'Geselecteerde store vernieuwen',
            selectLabel: 'Selecteer App Store',
            addLabel: 'Nieuwe App Store Toevoegen',
            namePlaceholder: 'Store Naam',
            urlPlaceholder: 'Store YAML URL',
            availableTitle: 'Beschikbare Apps',
            addManual: "Handmatige App Toevoegen",
            searchPlaceholder: 'Zoek beschikbare apps...',
            noAppsFound: 'Geen applicaties gevonden.',
            availableFrom: 'Beschikbare Apps van {storeName}',
            couldNotLoad: 'Kon apps van deze store niet laden.',
        },
        appTemplates: {
            title: 'Applicatie Sjabloon Editor',
            loadLabel: 'Sjabloon Laden',
            createOption: 'Nieuw Sjabloon Maken',
            nameLabel: 'Sjabloonnaam',
            namePlaceholder: 'Voer een naam in voor het nieuwe sjabloon',
            saveButton: 'Profiel Opslaan',
            deleteButton: 'Verwijderen',
            previewTitle: 'UI Voorbeeld',
            contentArea: 'Applicatie Inhoudsgebied',
            confirmDelete: 'Weet u zeker dat u het sjabloon \'{templateName}\' wilt verwijderen? Deze actie kan niet ongedaan worden gemaakt.',
            deleteDisabled: 'Dit sjabloon kan niet worden verwijderd.',
            enterName: 'Voer een naam in voor het nieuwe sjabloon.',
            settings: {
                TITLE: { label: "Paginatitel", description: "De paginatitel die in de webbrowser wordt weergegeven." },
                SELKIES_UI_TITLE: { label: "Zijbalktitel", description: "Titel in de linkerbovenhoek van de zijbalk." },
                SELKIES_UI_SHOW_SIDEBAR: { label: "Zijbalk Tonen", description: "Toon de hoofdgebruikersinterface van de zijbalk." },
                SELKIES_UI_SHOW_LOGO: { label: "Logo Tonen", description: "Toon het Selkies-logo in de zijbalk." },
                SELKIES_UI_SHOW_CORE_BUTTONS: { label: "Kernknoppen Tonen", description: "Toon de knoppen voor kerncomponenten (display, audio, etc)." },
                SELKIES_UI_SIDEBAR_SHOW_VIDEO_SETTINGS: { label: "Video-instellingen Tonen", description: "Toon de sectie video-instellingen in de zijbalk." },
                SELKIES_UI_SIDEBAR_SHOW_SCREEN_SETTINGS: { label: "Scherminstellingen Tonen", description: "Toon de sectie scherminstellingen in de zijbalk." },
                SELKIES_UI_SIDEBAR_SHOW_AUDIO_SETTINGS: { label: "Audio-instellingen Tonen", description: "Toon de sectie audio-instellingen in de zijbalk." },
                SELKIES_UI_SIDEBAR_SHOW_STATS: { label: "Statistieken Tonen", description: "Toon de sectie statistieken in de zijbalk." },
                SELKIES_UI_SIDEBAR_SHOW_CLIPBOARD: { label: "Klembord Tonen", description: "Toon de klembordsectie in de zijbalk." },
                SELKIES_UI_SIDEBAR_SHOW_FILES: { label: "Bestandssectie Tonen", description: "Toon de sectie voor bestandsoverdracht in de zijbalk." },
                SELKIES_UI_SIDEBAR_SHOW_APPS: { label: "App-sectie Tonen", description: "Toon de applicatiesectie in de zijbalk." },
                SELKIES_UI_SIDEBAR_SHOW_SHARING: { label: "Deelsectie Tonen", description: "Toon de deelsectie in de zijbalk." },
                SELKIES_UI_SIDEBAR_SHOW_GAMEPADS: { label: "Gamepad-sectie Tonen", description: "Toon de gamepadsectie in de zijbalk." },
                SELKIES_UI_SIDEBAR_SHOW_KEYBOARD_BUTTON: { label: "Toetsenbordknop Tonen", description: "Toon de knop voor het schermtoetsenbord." },
                SELKIES_UI_SIDEBAR_SHOW_SOFT_BUTTONS: { label: "Soft Buttons Tonen", description: "Toon de sectie soft buttons (voor mobiel)." },
                WATERMARK_PNG: { label: "Watermerk PNG Pad", description: "Volledig pad binnen de container naar een watermerk png." },
                WATERMARK_LOCATION: { label: "Watermerk Locatie", description: "Waar de afbeelding over de stream moet worden getekend.", options: { disabled: "Uitgeschakeld", topLeft: "Links-Boven", topRight: "Rechts-Boven", bottomLeft: "Links-Onder", bottomRight: "Rechts-Onder", centered: "Gecentreerd", animated: "Geanimeerd" } },
                DASHBOARD: { label: "Dashboard Stijl", description: "Hiermee kan de gebruiker zijn dashboard instellen.", options: { default: "Standaard", selkiesDefault: "Selkies (Standaard)", zinc: "Zinc", wish: "Wish" } },
                SELKIES_AUDIO_ENABLED: { label: "Audio Inschakelen", description: "Schakel server-naar-client audiostreaming in." },
                SELKIES_MICROPHONE_ENABLED: { label: "Microfoon Inschakelen", description: "Schakel client-naar-server microfoon doorsturen in." },
                SELKIES_GAMEPAD_ENABLED: { label: "Gamepad Inschakelen", description: "Schakel gamepad-ondersteuning in." },
                SELKIES_CLIPBOARD_ENABLED: { label: "Klembord Inschakelen", description: "Schakel klembordsynchronisatie in." },
                SELKIES_ENABLE_BINARY_CLIPBOARD: { label: "Binair Klembord Inschakelen", description: "Sta binaire gegevens (afbeeldingen) toe op het klembord." },
                SELKIES_COMMAND_ENABLED: { label: "Commando Websocket Inschakelen", description: "Schakel het parsen van commando websocket-berichten in." },
                SELKIES_FILE_TRANSFERS: { label: "Bestandsoverdrachten", description: "Toegestane richtingen ('upload,download', 'upload', 'download', 'none')." },
                SELKIES_ENABLE_SHARING: { label: "Alle Deling Inschakelen", description: "Hoofdschakelaar voor alle deelfuncties." },
                SELKIES_SECOND_SCREEN: { label: "Tweede Scherm Inschakelen", description: "Schakel ondersteuning voor een tweede monitor/display in." },
                SELKIES_USE_BROWSER_CURSORS: { label: "Browser Cursors Gebruiken", description: "Gebruik browser CSS-cursors in plaats van renderen naar canvas." },
                SELKIES_USE_CSS_SCALING: { label: "CSS Schalen Gebruiken (LoDPI)", description: "Indien waar, wordt een lagere resolutie verzonden en wordt het canvas uitgerekt." },
                SELKIES_IS_MANUAL_RESOLUTION_MODE: { label: "Handmatige Resolutiemodus", description: "Vergrendel de resolutie op de handmatige breedte/hoogte waarden." },
                SELKIES_MANUAL_WIDTH: { label: "Handmatige Breedte", description: "Vergrendel de breedte op een vaste waarde. Forceert handmatige modus." },
                SELKIES_MANUAL_HEIGHT: { label: "Handmatige Hoogte", description: "Vergrendel de hoogte op een vaste waarde. Forceert handmatige modus." },
                SELKIES_SCALING_DPI: { label: "UI Schaling DPI", description: "De standaard DPI voor UI-schaling." },
                SELKIES_AUDIO_BITRATE: { label: "Audio Bitrate", description: "De standaard audio bitrate." },
                SELKIES_ENCODER: { label: "Encoders", description: "Komma-gescheiden lijst van encoders. De eerste is standaard." },
                SELKIES_USE_CPU: { label: "CPU-codering Forceren", description: "Forceer CPU-gebaseerde codering voor pixelflux." },
                SELKIES_FRAMERATE: { label: "Framerate (Bereik of Vast)", description: "bijv., '8-120' voor een bereik of '60' voor vast." },
                SELKIES_H264_CRF: { label: "H.264 CRF (Bereik of Vast)", description: "bijv., '5-50' voor een bereik of '25' voor vast." },
                SELKIES_JPEG_QUALITY: { label: "JPEG Kwaliteit (Bereik of Vast)", description: "bijv., '1-100' voor een bereik of '60' voor vast." },
                SELKIES_H264_FULLCOLOR: { label: "H.264 Volledige Kleur", description: "Schakel H.264 volledig kleurbereik in voor pixelflux-encoders." },
                SELKIES_H264_STREAMING_MODE: { label: "H.264 Streaming (Turbo) Modus", description: "Schakel H.264 lage latentie streamingmodus in." },
                SELKIES_USE_PAINT_OVER_QUALITY: { label: "Paint-Over Kwaliteit Gebruiken", description: "Schakel hoge kwaliteit paint-over in voor statische scènes." },
                SELKIES_PAINT_OVER_JPEG_QUALITY: { label: "Paint-Over JPEG Kwaliteit", description: "bijv., '1-100' voor een bereik of '90' voor vast." },
                SELKIES_H264_PAINTOVER_CRF: { label: "Paint-Over H.264 CRF", description: "bijv., '5-50' voor een bereik of '18' voor vast." },
                SELKIES_H264_PAINTOVER_BURST_FRAMES: { label: "Paint-Over Burst Frames", description: "bijv., '1-30' voor een bereik of '5' voor vast." },
                HARDEN_DESKTOP: { label: "Desktop Beveiligen (Preset)", description: "Schakelt DISABLE_OPEN_TOOLS, DISABLE_SUDO en DISABLE_TERMINALS in." },
                HARDEN_OPENBOX: { label: "Window Manager Beveiligen (Preset)", description: "Schakelt DISABLE_CLOSE_BUTTON, DISABLE_MOUSE_BUTTONS en HARDEN_KEYBINDS in. Schakelt ook RESTART_APP in." },
                DISABLE_OPEN_TOOLS: { label: "Open Tools Uitschakelen", description: "Schakelt xdg-open en exo-open binaries uit." },
                DISABLE_SUDO: { label: "Sudo Uitschakelen", description: "Schakelt het sudo-commando uit." },
                DISABLE_TERMINALS: { label: "Terminals Uitschakelen", description: "Schakelt veelvoorkomende terminalemulators uit." },
                DISABLE_CLOSE_BUTTON: { label: "Venster Sluitknop Uitschakelen", description: "Verwijdert de sluitknop uit de titelbalken van vensters." },
                DISABLE_MOUSE_BUTTONS: { label: "Rechter-/Middenklik Uitschakelen", description: "Schakelt contextmenu's voor rechter- en middenklik uit." },
                HARDEN_KEYBINDS: { label: "Sneltoetsen Beveiligen", description: "Schakelt standaard Openbox-sneltoetsen zoals Alt+F4 uit." },
                RESTART_APP: { label: "App Herstarten bij Sluiten", description: "Herstart de hoofdapplicatie automatisch als deze wordt gesloten." },
                MAX_RES: { label: "Maximale Resolutie", description: "Max resolutie voor de container, standaard is 16k." },
                START_DOCKER: { label: "Start Docker-in-Docker", description: "Indien false, zal een geprivilegieerde container DinD niet starten." },
                DISABLE_IPV6: { label: "IPv6 Uitschakelen", description: "Indien true, wordt IPv6 uitgeschakeld." },
                DISABLE_ZINK: { label: "Zink Uitschakelen", description: "Stel geen Zink-omgevingsvariabelen in als een videokaart wordt gedetecteerd." },
                DISABLE_DRI3: { label: "DRI3 Uitschakelen", description: "Gebruik geen DRI3-versnelling als een videokaart wordt gedetecteerd." },
                NO_DECOR: { label: "Geen Vensterdecoraties", description: "Draai applicatie zonder vensterranden voor PWA-gebruik." },
                NO_FULL: { label: "Geen Volledig Scherm", description: "Zet applicaties niet automatisch op volledig scherm." },
                NO_GAMEPAD: { label: "Gamepad Injectie Uitschakelen", description: "Schakel userspace gamepad interposer injectie uit." },
                SELKIES_DEBUG: { label: "Selkies Debugging Inschakelen", description: "Schakel debug-logging in voor streamingcomponenten." },
            }
        },
        appLaboratory: {
            title: 'App Laboratorium',
            description: 'Creëer en test aangepaste applicatieconfiguraties door wijzigingen bovenop een basis-app te leggen.',
            selectApp: 'Selecteer App',
            createNew: 'Nieuwe App Maken',
            baseApp: 'Basis Applicatie',
            baseAppDescription: 'De geïnstalleerde applicatie waarop uw nieuwe aangepaste app gebaseerd zal zijn.',
            selectBase: 'Selecteer een Basis App',
            customizationTitle: 'Aanpassing',
            appName: 'App Naam',
            appIcon: 'App Icoon',
            uploadIcon: 'Icoon Uploaden',
            autostartScriptLabel: 'Aangepast Autostart Script',
            permissionsTitle: 'Permissies',
            usersLabel: 'Toegestane Gebruikers',
            groupsLabel: 'Toegestane Groepen',
            launchButton: 'Opslaan & Aanpassingssessie Starten',
            closeButton: 'Sessie Sluiten & Afronden',
            savingAndLaunching: 'Opslaan & Starten...',
            placeholder: 'Het App Laboratorium stelt u in staat om de basis home directory en het startscript voor een applicatie te configureren op basis van een bestaande geïnstalleerde applicatie. Deze home directory wordt bij de eerste initialisatie voor de gebruiker gekopieerd met alle bestanden en instellingen die u in deze sessie instelt. U kunt een bestaande Laboratorium App opnieuw starten om de inhoud verder aan te passen.',
            formInvalid: 'Selecteer een basis-app en geef een naam op voor de nieuwe app.',
        },
        modals: {
            editUserTitle: 'Bewerk Gebruiker: {username}',
            saveChanges: 'Wijzigingen Opslaan',
            effectiveSettings: 'Effectieve Instellingen (met groepsoverschrijvingen)',
            editGroupTitle: 'Bewerk Groep: {groupName}',
            userConfigTitle: 'Gebruikersconfiguratie',
            warning: 'Dit is de enige keer dat deze configuratie wordt getoond. Geef deze veilig aan de gebruiker.',
            info: 'U kunt dit configuratiebestand downloaden om SealSkin eenvoudig op een ander apparaat in te stellen. Bewaar dit bestand veilig, want het bevat uw privésleutel.',
            configDataLabel: 'Configuratiegegevens (JSON)',
            copyButton: 'Tekst Kopiëren',
            downloadButton: 'Bestand Downloaden',
            manageHomeDirs: 'Beheer Home Directories',
            dirsForUser: 'Mappen voor gebruiker: {username}',
            dirsForAdmin: 'Mappen voor beheerder: {username}',
            newDirForUser: 'Nieuwe Map Maken voor Gebruiker',
            createDirButton: 'Map Aanmaken',
            confirmDeleteDir: 'Weet u zeker dat u \'{homeName}\' wilt verwijderen voor gebruiker \'{username}\'? Dit is permanent.',
            installAppTitle: 'Installeer {appName}',
            editAppTitle: 'Bewerk {appName}',
            customNameLabel: 'Aangepaste Naam',
            imageLabel: 'Container Image',
            permissions: 'Permissies',
            allowedUsersLabel: 'Toegestane Gebruikers (komma-gescheiden, \'all\' voor iedereen)',
            allowedGroupsLabel: 'Toegestane Groepen (komma-gescheiden, \'all\' voor iedereen)',
            features: 'Functies',
            gpuSupport: 'GPU-ondersteuning',
            homeMounting: 'Home Directory Mounting',
            urlSupport: 'URL Openen Ondersteuning',
            fileSupport: 'Bestand Openen Ondersteuning',
            autoUpdate: 'Image Automatisch Updaten',
            advancedSettings: 'Geavanceerde Instellingen',
            appTemplateLabel: 'Applicatiesjabloon',
            appTemplateDescription: 'Selecteer een voorgeconfigureerd sjabloon voor geavanceerde containerstartinstellingen.',
            customAutostartScriptLabel: 'Aangepast Autostart Script',
            customAutostartScriptDescription: 'Pas de logica voor automatisch starten aan, laat leeg om de standaard van de applicatieprovider te gebruiken.',
            saveInstallation: 'Installatie Opslaan',
            updateStatusTitle: 'Updatestatus voor {appName}',
            checkingUpdates: 'Controleren op updates...',
            updateAvailable: 'Er is een nieuwe imageversie beschikbaar!',
            yourVersion: 'Uw versie: {sha}',
            latestAvailable: 'De nieuwste versie is beschikbaar om te pullen uit de registry.',
            pullLatest: 'Nieuwste Image Pullen',
            upToDate: 'Uw image is up-to-date.',
            currentVersion: 'Huidige versie: {sha}',
            errorChecking: 'Fout bij het controleren op updates.',
            pullingLatest: 'Nieuwste image wordt gepulled... Dit kan even duren.',
            pullComplete: 'Pull voltooid!',
            newVersion: 'Nieuwe versie: {sha}',
            errorPulling: 'Fout bij het pullen van de image.',
            manualInstallNote: "Opmerking: Handmatig toegevoegde images moeten gebaseerd zijn op een selkies-baseimage compatibele image.",
        },
        status: {
            loggingIn: 'Inloggen...',
            configSaved: 'Configuratie succesvol opgeslagen!',
            configApplied: 'Configuratie toegepast! Gelieve In te loggen & te Testen.',
            configApplyFailed: 'Kon configuratie niet toepassen: {error}',
            fileReadError: 'Fout bij het lezen van het bestand.',
            noConfig: 'Geef een configuratiebestand of -tekst op.',
            loggedInAdmin: 'Ingelogd als beheerder: {username}',
            loggedInUser: 'Ingelogd als standaard gebruiker: {username}.',
            loginFailed: 'Inloggen mislukt: {error}',
            adminDataRefreshFailed: 'Kon beheerdersgegevens niet vernieuwen: {error}',
            logoutSuccess: 'Uitgelogd en configuratie gewist.',
            generateConfigFailed: 'Kon configuratie niet genereren, gebruikersdetails ontbreken.',
            copySuccess: 'Configuratie naar klembord gekopieerd!',
            copyFailed: 'Kon tekst niet kopiëren.',
            publicKeyCopied: 'Publieke sleutel gekopieerd!',
            keyCopyFailed: 'Kon sleutel niet kopiëren.',
            creatingAdmin: 'Beheerder aanmaken...',
            adminCreated: 'Beheerder \'{username}\' aangemaakt.',
            adminCreateFailed: 'Fout bij aanmaken beheerder: {error}',
            adminDeleted: 'Beheerder \'{username}\' succesvol verwijderd.',
            adminDeleteFailed: 'Fout bij verwijderen beheerder: {error}',
            creatingUser: 'Gebruiker aanmaken...',
            userCreated: 'Gebruiker \'{username}\' aangemaakt.',
            userCreateFailed: 'Fout bij aanmaken gebruiker: {error}',
            userDeleted: 'Gebruiker \'{username}\' succesvol verwijderd.',
            userDeleteFailed: 'Fout bij verwijderen gebruiker: {error}',
            userUpdated: 'Gebruiker \'{username}\' succesvol bijgewerkt.',
            userUpdateFailed: 'Fout bij bijwerken gebruiker: {error}',
            creatingGroup: 'Groep aanmaken...',
            groupCreated: 'Groep \'{groupName}\' aangemaakt.',
            groupCreateFailed: 'Fout bij aanmaken groep: {error}',
            groupDeleted: 'Groep \'{groupName}\' succesvol verwijderd.',
            groupDeleteFailed: 'Fout bij verwijderen groep: {error}',
            groupUpdated: 'Groep \'{groupName}\' succesvol bijgewerkt.',
            groupUpdateFailed: 'Fout bij bijwerken groep: {error}',
            homedirLoadFailed: 'Kon home directories niet laden: {error}',
            homedirCreateFailed: 'Fout bij aanmaken map: {error}',
            homedirCreated: 'Home directory \'{homeName}\' aangemaakt.',
            homedirDeleted: 'Map \'{homeName}\' verwijderd.',
            homedirDeleteFailed: 'Fout bij verwijderen map: {error}',
            homedirCreatedFor: 'Map \'{homeName}\' aangemaakt voor {username}.',
            homedirDeletedFor: 'Map \'{homeName}\' verwijderd voor {username}.',
            sessionsLoadFailed: 'Kon sessies niet laden: {error}',
            sessionStopError: 'Fout bij stoppen sessie: {error}',
            sessionStopped: 'Sessie succesvol gestopt.',
            appDataRefreshFailed: 'Kon app-gegevens niet vernieuwen: {error}',
            closingSession: 'Aanpassingssessie wordt vastgelegd...',
            sessionClosed: 'Aanpassingssessie gesloten.',
            sessionCloseFailed: 'Kon aanpassingssessie niet sluiten: {error}',
            fetchingApps: 'Apps ophalen uit store...',
            fetchAppsFailed: 'Kon apps niet ophalen uit store: {error}',
            appStoreAddFailed: 'Fout bij toevoegen store: {error}',
            appStoreAdded: 'App store \'{name}\' toegevoegd.',
            appSaved: 'App \'{name}\' succesvol {action}.',
            appSaveActions: {
                updated: 'bijgewerkt',
                installed: 'geïnstalleerd'
            },
            appSaveFailed: 'Fout bij opslaan app: {error}',
            appDeleted: 'App \'{name}\' verwijderd.',
            appDeleteFailed: 'Fout bij verwijderen app: {error}',
            templateSaved: 'Sjabloon \'{name}\' succesvol opgeslagen.',
            templateSaveFailed: 'Fout bij opslaan sjabloon: {error}',
            templateDeleted: 'Sjabloon \'{name}\' succesvol verwijderd.',
            templateDeleteFailed: 'Fout bij verwijderen sjabloon: {error}',
            pinRemoved: 'Vastgezet gedrag verwijderd.',
            keyGenerated: 'Nieuw sleutelpaar gegenereerd.',
            keyGenFailed: 'Sleutelgeneratie mislukt: {{error}}',
            pendingConfigSaved: 'Wachtende configuratie opgeslagen. U kunt nu uw publieke sleutel aan de beheerder verstrekken.',
            settingsSaved: 'Instellingen opgeslagen.',
            appCreated: 'App \'{name}\' succesvol aangemaakt.',
            launchFailed: 'Starten mislukt: {error}',
        },
        placeholders: {
            noAdmins: 'Geen beheerders gevonden.',
            noUsers: 'Geen gebruikers gevonden.',
            noGroups: 'Geen groepen gevonden.',
            noHomeDirs: 'Geen home directories gevonden.',
            noSessions: 'Geen actieve sessies gevonden.',
            noPinned: 'Geen vastgezet gedrag gevonden.',
            errorLoading: 'Fout bij het laden van de mappen.',
            noInstalledApps: 'Er zijn nog geen applicaties geïnstalleerd.',
        },
    },
    popup: {
        tabs: {
            launch: 'Nieuwe Starten',
            sessions: 'Actieve Sessies',
            manageFiles: 'Bestanden beheren',
            uploadStorage: 'Uploaden naar Opslag',
            uploadFiles: 'Bestanden Uploaden',
            uploadFilesTitle: 'Open speciale pagina voor het uploaden van bestanden'
        },
        launchView: {
            searchPlaceholder: 'Zoek applicaties...',
            uploadingFile: 'Bestand uploaden...',
            gpuLabel: 'GPU',
            storageLabel: 'Opslag',
            languageLabel: 'Taal',
            cleanroom: 'Cleanroom (Tijdelijk)',
            noGpu: 'Geen',
            saveOptions: 'Deze startopties opslaan',
            saveOptionsForUrl: 'Opties opslaan voor alle URL\'s',
            saveOptionsForFile: 'Opties opslaan voor .{extension} bestanden',
            openFile: 'Bestand openen bij start',
            launchButton: 'Starten',
            launchingButton: 'Starten...',
            uploadingButton: 'Uploaden...',
            autoHome: 'Automatisch (persistentie per app)',
            collaborationMode: 'Collaboratieve sessie',
            waylandMode: 'Wayland-modus',
        },
        sessionsView: {
            noSessions: 'Geen actieve sessies gevonden.',
        },
        uploadStorageView: {
            selectHome: 'Selecteer Home Directory',
            description: 'Hiermee wordt het bestand <strong>{filename}</strong> voor toekomstig gebruik rechtstreeks naar uw Bestanden-opslag geüpload.',
            descriptionFallback: 'Hiermee wordt het bestand <strong>{filename}</strong> voor toekomstig gebruik rechtstreeks naar uw Bestanden-opslag geüpload.',
            uploadButton: 'Bestand Uploaden',
            uploadingButton: 'Uploaden...',
            preparing: 'Bestand voorbereiden...',
            uploadingChunk: 'Chunk {current} van {total} uploaden...',
            finalizing: 'Afronden...',
            uploadComplete: 'Upload Voltooid!',
        },
        status: {
            unconfigured: 'Configureer de extensie via de optiespagina.',
            openingServerFile: "Server-side bestand openen: {filename}",
            openingFile: 'Bestand openen: {filename}',
            openingUrl: 'URL openen: {targetUrl}',
            error: 'Fout: {message}',
            preparingFile: 'Bestand voorbereiden...',
            sendingFile: 'Bestand naar sessie sturen...',
            errorSendingFile: 'Fout bij verzenden bestand: {message}',
            errorClosingSession: 'Fout bij sluiten sessie: {message}',
            preparingSession: 'Geïsoleerde sessie voorbereiden...',
            fetchingData: 'Bestandsgegevens ophalen...',
            fetchDataFailed: 'Kon bestandsgegevens niet ophalen: {statusText}',
            unknownAction: 'Onbekende startactie.',
            noAppSelected: 'Selecteer een applicatie.',
            noAppsAvailable: 'Er zijn geen applicaties beschikbaar voor uw account.',
            uploadSuccess: 'Bestand succesvol geüpload!',
            creatingAutoHome: 'Automatische home directory aanmaken...',
        },
        languages: {
            default: 'Standaard ({locale})'
        }
    },
    upload: {
        title: 'Bestand Uploaden',
        description: 'Selecteer een bestand van uw computer om het te openen in een veilige, geïsoleerde sessie.',
        dropzone: {
            title: 'Sleep hier een bestand naartoe',
            or: 'of',
            button: 'Selecteer Bestand',
        },
        confirm: {
            ready: 'Het bestand is klaar om veilig te worden geopend.',
            button: 'Doorgaan naar Starten',
        }
    },
    files: {
        title: 'SealSkin-bestanden',
        header: {
            title: 'Bestanden',
            newFolder: 'Nieuwe map',
            uploadFiles: 'Bestanden uploaden',
            uploadFolder: 'Map uploaden'
        },
        sidebar: {
            sharedFiles: 'SealSkin-bestanden',
            publicShares: 'Openbare Delingen'
        },
        shares: {
            title: 'Openbaar Gedeelde Bestanden',
            searchPlaceholder: 'Zoek op bestandsnaam of ID...'
        },
        table: {
            name: 'Naam',
            size: 'Grootte',
            lastModified: 'Laatst gewijzigd',
            created: 'Gemaakt',
            expires: 'Vervalt',
            url: 'Openbare URL',
            passwordProtected: 'Wachtwoord'
        },
        dropzone: {
            title: 'Sleep bestanden hierheen om te uploaden'
        },
        pagination: {
            previous: '« Vorige',
            next: 'Volgende »',
            pageOf: 'Pagina {page} van {totalPages}'
        },
        modals: {
            newFolder: {
                title: 'Nieuwe map maken',
                folderNameLabel: 'Mapnaam',
                nameTitle: 'Gebruik alleen letters, cijfers, underscore, koppelteken of punt.',
                createButton: 'Maken'
            },
            confirmDelete: {
                title: 'Verwijdering bevestigen',
                message: 'Weet u zeker dat u {count, plural, one {1 geselecteerd item} other {{count} geselecteerde items}} wilt verwijderen? Deze actie kan niet ongedaan worden gemaakt.',
                messageDefault: 'Weet u zeker dat u de geselecteerde items wilt verwijderen? Deze actie kan niet ongedaan worden gemaakt.'
            },
            uploadProgress: {
                title: 'Uploadvoortgang',
                doneButton: 'Klaar'
            },
            share: {
                title: 'Bestand Delen',
                sharingFile: 'Bestand delen: <strong>{filename}</strong>',
                passwordLabel: 'Wachtwoord (optioneel)',
                passwordPlaceholder: 'Laat leeg voor geen wachtwoord',
                expiryLabel: 'Vervalt over (uren, optioneel)',
                expiryPlaceholder: 'bijv., 24 voor één dag',
                shareButton: 'Deellink Maken'
            }
        },
        status: {
            homeDirLoadFailed: 'Laden van thuismap mislukt: {error}',
            filesLoadFailed: 'Fout bij het laden van bestanden: {error}',
            deleteProtectedError: 'Kan beveiligde systeemmappen niet verwijderen.',
            deletingItems: '{count, plural, one {1 item} other {{count} items}} aan het verwijderen...',
            deleteSuccess: 'Verwijderen gelukt.',
            deleteFailed: 'Verwijderen mislukt: {error}',
            preparingUpload: 'Voorbereiden om {count, plural, one {1 bestand} other {{count} bestanden}} te uploaden...',
            uploadPrepFailed: 'Fout tijdens voorbereiding van mapupload: {error}',
            notConfigured: 'Fout: SealSkin niet geconfigureerd. Stel dit in bij de opties.',
            folderCreated: 'Map \'{folderName}\' gemaakt.',
            folderCreateFailed: 'Fout bij het maken van de map: {error}',
            shareCreated: 'Deellink succesvol aangemaakt! De link is naar je klembord gekopieerd.',
            shareCreateFailed: 'Aanmaken van deellink mislukt: {error}',
            sharesLoadFailed: 'Laden van gedeelde bestanden mislukt: {error}',
            shareDeleteFailed: 'Verwijderen van deellink mislukt: {error}',
            shareDeleted: 'Deellink succesvol verwijderd.',
            urlCopied: 'Openbare URL naar klembord gekopieerd.'
        },
        placeholders: {
            errorLoading: 'Fout bij het laden van bestanden.',
            folderEmpty: 'Deze map is leeg.',
            noHomeDirs: 'Geen thuismap beschikbaar.',
            noShares: 'Je hebt nog geen bestanden gedeeld.'
        },
        uploadStatus: {
            pending: 'in afwachting',
            initiating: 'Starten...',
            uploading: 'Uploaden...',
            finalizing: 'Afronden...',
            completed: 'Voltooid',
            error: 'Fout'
        }
    }
};

// --- Arabic Translations ---
const ar = {
    background: {
        contextMenu: {
            openUrl: 'فتح الرابط في SealSkin',
            openFile: 'فتح هدف الرابط كملف في SealSkin',
            sendMedia: 'إرسال الوسائط إلى SealSkin',
            searchText: 'البحث عن "%s" في SealSkin',
            sendDownload: 'إرسال التنزيل التالي إلى SealSkin'
        }
    },
    common: {
        actions: 'الإجراءات',
        active: 'نشط',
        cancel: 'إلغاء',
        manage: 'إدارة',
        delete: 'حذف',
        edit: 'تعديل',
        save: 'حفظ',
        none: 'لا شيء',
        error: 'خطأ',
        na: 'غير متاح',
        of: 'من',
        status: 'الحالة',
        username: 'اسم المستخدم',
        group: 'مجموعة',
        groups: 'المجموعات',
        publicKey: 'المفتاح العام',
        name: 'الاسم',
        source: 'المصدر',
        imageVersion: 'إصدار الصورة',
        language: 'اللغة',
        storage: 'التخزين',
        gpu: 'وحدة معالجة الرسوميات',
        version: 'الإصدار',
        checked: 'تم التحقق',
        never: 'أبداً',
        stop: 'إيقاف',
        reopen: 'إعادة فتح',
        sendFile: 'إرسال ملف',
        share: 'مشاركة',
        search: 'بحث',
        refresh: 'تحديث',
        close: 'إغلاق',
        copy: 'نسخ',
        open: "فتح",
        copyUrl: 'نسخ الرابط',
        download: 'تنزيل',
        next: 'التالي',
        previous: 'السابق',
        page: 'صفحة',
        home: 'المجلد الرئيسي',
        homes: 'المجلدات الرئيسية',
        sessions: 'الجلسات',
        users: 'المستخدمون',
        admins: 'المسؤولون',
        yes: 'نعم',
        no: 'لا',
        daysAgo: '{count, plural, one {قبل يوم واحد} other {قبل {count} أيام}}',
        hoursAgo: '{count, plural, one {قبل ساعة واحدة} other {قبل {count} ساعات}}',
        minutesAgo: '{count, plural, one {قبل دقيقة واحدة} other {قبل {count} دقائق}}',
        justNow: 'الآن',
        bytes: 'بايت',
        kb: 'كيلوبايت',
        mb: 'ميجابايت',
        gb: 'جيجابايت',
        tb: 'تيرابايت',
        pb: 'بيتابايت',
    },
    options: {
        sidebar: {
            config: 'الإعدادات',
            home: 'المجلدات الرئيسية',
            sessions: 'الجلسات النشطة',
            pinned: 'السلوك المثبت',
            appStore: 'متجر التطبيقات',
            appTemplates: 'قوالب التطبيقات',
            appLaboratory: 'مختبر التطبيقات',
            installedApps: 'التطبيقات المثبتة',
            users: 'المستخدمون',
            groups: 'المجموعات',
            admins: 'المسؤولون',
        },
        dashboard: {
            title: 'لوحة التحكم',
            clientSettings: 'إعدادات العميل',
            exportConfig: 'تصدير الإعدادات',
            userStatus: 'حالة المستخدم',
            loggedInAs: 'تم تسجيل الدخول باسم:',
            role: 'الدور',
            roleAdmin: 'مسؤول',
            roleUser: 'مستخدم عادي',
            serverInfo: 'معلومات الخادم',
            server: 'الخادم:',
            cpuModel: 'طراز وحدة المعالجة المركزية:',
            storageUsage: 'استخدام التخزين:',
            detectedGpus: 'وحدات معالجة الرسوميات المكتشفة:',
            logout: 'تسجيل الخروج ومسح الإعدادات',
            howTo: 'كيفية استخدام SealSkin',
            howToDescription: 'يحتوي هذا القسم على وثائق أساسية حول كيفية استخدام الإضافة.',
            howToList: [
                '<strong>لفتح المحتوى في بيئة معزولة:</strong> انقر بزر الماوس الأيمن على أي رابط أو صورة أو نص محدد واختر خيارًا من قائمة السياق "SealSkin Isolation".',
                '<strong>لإرسال تنزيل إلى بيئة معزولة:</strong> انقر بزر الماوس الأيمن على الصفحة وحدد "إرسال التنزيل التالي إلى بيئة معزولة". سيتم اعتراض الملف التالي الذي تقوم بتنزيله وإرساله إلى جلسة آمنة.',
                '<strong>لتشغيل تطبيق نظيف:</strong> انقر على أيقونة SealSkin في شريط أدوات متصفحك.',
                '<strong>لإدارة التخزين الدائم:</strong> استخدم علامة التبويب "المجلدات الرئيسية" في هذه الصفحة لإنشاء وحذف وحدات تخزين يمكن استخدامها عبر جلسات متعددة.',
                '<strong>لحفظ خيارات التشغيل:</strong> حدد مربع "حفظ خيارات التشغيل هذه" في النافذة المنبثقة قبل تشغيل تطبيق لنوع ملف معين (مثل .pdf) أو لجميع عناوين URL. قم بإدارة هذه التفضيلات المحفوظة في علامة التبويب "السلوك المثبت".'
            ],
            confirmLogout: 'هل أنت متأكد أنك تريد تسجيل الخروج؟ سيؤدي هذا إلى مسح إعداداتك المحفوظة من هذا المتصفح.',
        },
        config: {
            quickSetup: 'الإعداد السريع',
            quickSetupDescription: 'قم بتحميل ملف الإعدادات (.json) المقدم من المسؤول، أو الصق محتوياته أدناه لإعداد الإضافة تلقائيًا.',
            uploadLabel: 'تحميل ملف الإعدادات',
            pasteLabel: 'أو الصق نص الإعدادات',
            pastePlaceholder: 'الصق إعدادات JSON الخاصة بك هنا...',
            applyButton: 'تطبيق الإعدادات',
            manualLink: 'الإعداد اليدوي',
            advancedTitle: 'إعدادات العميل (متقدم)',
            serverIpLabel: 'عنوان IP للخادم أو النطاق',
            serverIpPlaceholder: 'مثال: 192.168.1.100',
            apiPortLabel: 'منفذ API',
            apiPortPlaceholder: 'مثال: 8000',
            sessionPortLabel: 'منفذ الجلسة',
            sessionPortPlaceholder: 'مثال: 8443',
            usernameLabel: 'اسم المستخدم',
            usernamePlaceholder: 'اسم المستخدم الخاص بك',
            privateKeyLabel: 'مفتاحك الخاص (تنسيق PEM)',
            privateKeyPlaceholder: 'الصق محتوى مفتاحك الخاص هنا',
            serverKeyLabel: 'المفتاح العام للخادم (تنسيق PEM)',
            serverKeyPlaceholder: 'الصق محتوى server_public.pem هنا',
            searchEngineLabel: 'محرك البحث الافتراضي للنص المحدد',
            saveButton: 'حفظ الإعدادات',
            loginButton: 'تسجيل الدخول والاختبار',
            automaticLink: 'الإعداد التلقائي',
            chooseFile: 'اختر ملف',
            keyGeneration: 'إنشاء المفتاح',
            keyGenDescription: 'إذا لم يكن لديك زوج مفاتيح، يمكنك إنشاء واحد هنا. سيتم ملء المفتاح الخاص أعلاه. قدم المفتاح العام للمسؤول الخاص بك.',
            generateKeyButton: 'إنشاء زوج مفاتيح جديد',
            publicKeyForAdminLabel: 'مفتاحك العام (للمسؤول)',
        },
        home: {
            title: 'مجلداتك الرئيسية',
            description: 'أنشئ مجلدات تخزين دائمة لاستخدامها عبر الجلسات. سيتم تحميلها في تطبيقاتك كمجلد إعداداتك.',
            newTitle: 'إنشاء مجلد رئيسي جديد',
            nameLabel: 'اسم المجلد:',
            namePlaceholder: 'مثال: ملفات-مشروعي',
            nameTitle: 'استخدم فقط الحروف والأرقام والشرطة السفلية أو الواصلة.',
            createButton: 'إنشاء مجلد',
            confirmDelete: 'هل أنت متأكد أنك تريد حذف المجلد الرئيسي \'{homeName}\'؟ سيتم فقدان جميع البيانات الموجودة بداخله بشكل دائم.',
        },
        sessions: {
            title: 'الجلسات النشطة',
            application: 'التطبيق',
            started: 'بدأت في',
            noSessionsUser: 'لم يتم العثور على جلسات نشطة.',
            noSessionsAdmin: 'لم يتم العثور على جلسات نشطة لأي مستخدم.',
            sessionsFor: 'جلسات المستخدم {username} ({count})',
            confirmStop: 'هل أنت متأكد أنك تريد إيقاف هذه الجلسة؟ سيتم تدمير الحاوية.',
        },
        pinned: {
            title: 'السلوك المثبت للإضافة',
            description: 'يعرض هذا الجدول خيارات التشغيل التي حفظتها لأنواع ملفات معينة أو لجميع عناوين URL. يمكنك إزالة سلوك مثبت لتتم مطالبتك بخيارات التشغيل مرة أخرى.',
            trigger: 'المُشغِّل',
            savedApp: 'التطبيق المحفوظ',
            triggerSimple: 'تشغيل بسيط (زر شريط الأدوات)',
            triggerUrl: 'جميع عناوين URL (من قائمة السياق)',
            triggerFile: 'نوع الملف: <strong>{fileType}</strong>',
            unknownApp: 'تطبيق غير معروف ({appId}...)'
        },
        admins: {
            serverKeyTitle: 'المفتاح العام للخادم',
            serverKeyDescription: 'هذا هو المفتاح العام الذي ستحتاجه ملفات إعدادات المستخدم للاتصال بهذا الخادم.',
            title: 'إدارة المسؤولين',
            searchPlaceholder: 'بحث عن المسؤولين...',
            newTitle: 'إنشاء مسؤول جديد',
            publicKeyOptionalLabel: 'المفتاح العام (اختياري):',
            publicKeyPlaceholder: 'الصق المفتاح العام هنا، أو اتركه فارغًا لإنشاء واحد.',
            createButton: 'إنشاء مسؤول',
            confirmDelete: 'هل أنت متأكد أنك تريد حذف المسؤول \'{username}\'؟ سيؤدي هذا أيضًا إلى حذف كل مساحة التخزين الدائمة الخاصة به ولا يمكن التراجع عن هذا الإجراء.',
        },
        users: {
            title: 'إدارة المستخدمين',
            searchPlaceholder: 'بحث عن المستخدمين بالاسم أو المجموعة...',
            newTitle: 'إنشاء مستخدم جديد',
            publicKeyOptionalLabel: 'المفتاح العام (اختياري):',
            publicKeyPlaceholder: 'الصق المفتاح العام للمستخدم هنا، أو اتركه فارغًا لإنشاء واحد.',
            settingsTitle: 'إعدادات المستخدم',
            sessionLimitLabel: 'حد الجلسات',
            sessionLimitTitle: 'عدد الجلسات النشطة التي يمكن للمستخدم امتلاكها. -1 لعدد غير محدود.',
            permissionsTitle: 'الأذونات والتحصين',
            activeAccount: 'حساب نشط',
            allowStorage: 'السماح بالتخزين الدائم',
            allowGpu: 'السماح بالوصول إلى وحدة معالجة الرسوميات',
            hardenContainer: 'تحصين الحاوية',
            hardenWm: 'تحصين مدير النوافذ',
            createButton: 'إنشاء مستخدم',
            homesDisabledTooltip: 'تم تعطيل التخزين الدائم لهذا المستخدم',
            confirmDelete: 'هل أنت متأكد أنك تريد حذف المستخدم \'{username}\'؟ سيؤدي هذا أيضًا إلى حذف كل مساحة التخزين الدائمة الخاصة به ولا يمكن التراجع عن هذا الإجراء.',
            allowPublicSharing: 'السماح بمشاركة الملفات العامة',
        },
        groups: {
            title: 'إدارة المجموعات',
            searchPlaceholder: 'بحث عن المجموعات...',
            newTitle: 'إنشاء مجموعة جديدة',
            nameLabel: 'اسم المجموعة:',
            overrideTitle: 'إعدادات تجاوز المجموعة',
            permissionsTitle: 'تجاوزات الأذونات والتحصين',
            createButton: 'إنشاء مجموعة',
            confirmDelete: 'هل أنت متأكد أنك تريد حذف المجموعة \'{groupName}\'؟ سيعود المستخدمون في هذه المجموعة إلى إعداداتهم الفردية.',
        },
        installedApps: {
            title: 'التطبيقات المثبتة',
            searchPlaceholder: 'بحث في التطبيقات المثبتة...',
            noAppsFound: 'لم يتم العثور على تطبيقات مثبتة.',
            pulling: 'جاري سحب صورة جديدة...',
            notLocal: 'الصورة غير موجودة محليًا',
            isLaboratory: 'هذا تطبيق مختبر، تم بناؤه من صورة أساسية بإعدادات مخصصة.',
            laboratory: 'مختبر',
            confirmDelete: 'هل أنت متأكد أنك تريد حذف التطبيق المثبت \'{appName}\'؟'
        },
        appStore: {
            title: 'متاجر التطبيقات',
            refreshTitle: 'تحديث المتجر المحدد',
            selectLabel: 'تحديد متجر التطبيقات',
            addLabel: 'إضافة متجر تطبيقات جديد',
            namePlaceholder: 'اسم المتجر',
            urlPlaceholder: 'عنوان URL لملف YAML للمتجر',
            availableTitle: 'التطبيقات المتاحة',
            addManual: "إضافة تطبيق يدوي",
            searchPlaceholder: 'بحث في التطبيقات المتاحة...',
            noAppsFound: 'لم يتم العثور على تطبيقات.',
            availableFrom: 'التطبيقات المتاحة من {storeName}',
            couldNotLoad: 'تعذر تحميل التطبيقات من هذا المتجر.',
        },
        appTemplates: {
            title: 'محرر قوالب التطبيقات',
            loadLabel: 'تحميل قالب',
            createOption: 'إنشاء قالب جديد',
            nameLabel: 'اسم القالب',
            namePlaceholder: 'أدخل اسمًا للقالب الجديد',
            saveButton: 'حفظ الملف الشخصي',
            deleteButton: 'حذف',
            previewTitle: 'معاينة واجهة المستخدم',
            contentArea: 'منطقة محتوى التطبيق',
            confirmDelete: 'هل أنت متأكد أنك تريد حذف القالب \'{templateName}\'؟ لا يمكن التراجع عن هذا الإجراء.',
            deleteDisabled: 'لا يمكن حذف هذا القالب.',
            enterName: 'الرجاء إدخال اسم للقالب الجديد.',
            settings: {
                TITLE: { label: 'عنوان الصفحة', description: 'عنوان الصفحة المعروض في متصفح الويب.' },
                SELKIES_UI_TITLE: { label: 'عنوان الشريط الجانبي', description: 'العنوان في الزاوية العلوية اليسرى من الشريط الجانبي.' },
                SELKIES_UI_SHOW_SIDEBAR: { label: 'إظهار الشريط الجانبي', description: 'إظهار واجهة المستخدم الرئيسية للشريط الجانبي.' },
                SELKIES_UI_SHOW_LOGO: { label: 'إظهار الشعار', description: 'إظهار شعار Selkies في الشريط الجانبي.' },
                SELKIES_UI_SHOW_CORE_BUTTONS: { label: 'إظهار الأزرار الأساسية', description: 'إظهار أزرار المكونات الأساسية (عرض، صوت، إلخ).' },
                SELKIES_UI_SIDEBAR_SHOW_VIDEO_SETTINGS: { label: 'إظهار إعدادات الفيديو', description: 'إظهار قسم إعدادات الفيديو في الشريط الجانبي.' },
                SELKIES_UI_SIDEBAR_SHOW_SCREEN_SETTINGS: { label: 'إظهار إعدادات الشاشة', description: 'إظهار قسم إعدادات الشاشة في الشريط الجانبي.' },
                SELKIES_UI_SIDEBAR_SHOW_AUDIO_SETTINGS: { label: 'إظهار إعدادات الصوت', description: 'إظهار قسم إعدادات الصوت في الشريط الجانبي.' },
                SELKIES_UI_SIDEBAR_SHOW_STATS: { label: 'إظهار الإحصائيات', description: 'إظهار قسم الإحصائيات في الشريط الجانبي.' },
                SELKIES_UI_SIDEBAR_SHOW_CLIPBOARD: { label: 'إظهار الحافظة', description: 'إظهار قسم الحافظة في الشريط الجانبي.' },
                SELKIES_UI_SIDEBAR_SHOW_FILES: { label: 'إظهار قسم الملفات', description: 'إظهار قسم نقل الملفات في الشريط الجانبي.' },
                SELKIES_UI_SIDEBAR_SHOW_APPS: { label: 'إظهار قسم التطبيقات', description: 'إظهار قسم التطبيقات في الشريط الجانبي.' },
                SELKIES_UI_SIDEBAR_SHOW_SHARING: { label: 'إظهار قسم المشاركة', description: 'إظهار قسم المشاركة في الشريط الجانبي.' },
                SELKIES_UI_SIDEBAR_SHOW_GAMEPADS: { label: 'إظهار قسم أجهزة التحكم', description: 'إظهار قسم أجهزة التحكم بالألعاب في الشريط الجانبي.' },
                SELKIES_UI_SIDEBAR_SHOW_KEYBOARD_BUTTON: { label: 'إظهار زر لوحة المفاتيح', description: 'إظهار زر لوحة المفاتيح على الشاشة.' },
                SELKIES_UI_SIDEBAR_SHOW_SOFT_BUTTONS: { label: 'إظهار الأزرار اللينة', description: 'إظهار قسم الأزرار اللينة (للجوّال).' },
                WATERMARK_PNG: { label: 'مسار PNG للعلامة المائية', description: 'المسار الكامل داخل الحاوية إلى ملف PNG للعلامة المائية.' },
                WATERMARK_LOCATION: { label: 'موقع العلامة المائية', description: 'أين يتم رسم الصورة فوق البث.', options: { disabled: 'معطل', topLeft: 'أعلى اليسار', topRight: 'أعلى اليمين', bottomLeft: 'أسفل اليسار', bottomRight: 'أسفل اليمين', centered: 'في المنتصف', animated: 'متحرك' } },
                DASHBOARD: { label: 'نمط لوحة التحكم', description: 'يسمح للمستخدم بتعيين لوحة التحكم الخاصة به.', options: { default: 'افتراضي', selkiesDefault: 'Selkies (افتراضي)', zinc: 'Zinc', wish: 'Wish' } },
                SELKIES_AUDIO_ENABLED: { label: 'تمكين الصوت', description: 'تمكين بث الصوت من الخادم إلى العميل.' },
                SELKIES_MICROPHONE_ENABLED: { label: 'تمكين الميكروفون', description: 'تمكين توجيه الميكروفون من العميل إلى الخادم.' },
                SELKIES_GAMEPAD_ENABLED: { label: 'تمكين جهاز التحكم', description: 'تمكين دعم جهاز التحكم بالألعاب.' },
                SELKIES_CLIPBOARD_ENABLED: { label: 'تمكين الحافظة', description: 'تمكين مزامنة الحافظة.' },
                SELKIES_ENABLE_BINARY_CLIPBOARD: { label: 'تمكين الحافظة الثنائية', description: 'السماح بالبيانات الثنائية (الصور) في الحافظة.' },
                SELKIES_COMMAND_ENABLED: { label: 'تمكين Websocket الأوامر', description: 'تمكين تحليل رسائل websocket الأوامر.' },
                SELKIES_FILE_TRANSFERS: { label: 'نقل الملفات', description: 'الاتجاهات المسموح بها (\'upload,download\', \'upload\', \'download\', \'none\').' },
                SELKIES_ENABLE_SHARING: { label: 'تمكين جميع المشاركات', description: 'مفتاح رئيسي لجميع ميزات المشاركة.' },
                SELKIES_SECOND_SCREEN: { label: 'تمكين الشاشة الثانية', description: 'تمكين دعم شاشة/عرض ثانية.' },
                SELKIES_USE_BROWSER_CURSORS: { label: 'استخدام مؤشرات المتصفح', description: 'استخدام مؤشرات CSS للمتصفح بدلاً من العرض على اللوحة القماشية.' },
                SELKIES_USE_CSS_SCALING: { label: 'استخدام تحجيم CSS (LoDPI)', description: 'إذا كان صحيحًا، يتم إرسال دقة أقل ويتم تمديد اللوحة القماشية.' },
                SELKIES_IS_MANUAL_RESOLUTION_MODE: { label: 'وضع الدقة اليدوي', description: 'قفل الدقة على قيم العرض/الارتفاع اليدوية.' },
                SELKIES_MANUAL_WIDTH: { label: 'العرض اليدوي', description: 'قفل العرض على قيمة ثابتة. يفرض الوضع اليدوي.' },
                SELKIES_MANUAL_HEIGHT: { label: 'الارتفاع اليدوي', description: 'قفل الارتفاع على قيمة ثابتة. يفرض الوضع اليدوي.' },
                SELKIES_SCALING_DPI: { label: 'DPI لتحجيم واجهة المستخدم', description: 'الـ DPI الافتراضي لتحجيم واجهة المستخدم.' },
                SELKIES_AUDIO_BITRATE: { label: 'معدل بت الصوت', description: 'معدل بت الصوت الافتراضي.' },
                SELKIES_ENCODER: { label: 'المشفرات', description: 'قائمة بالمشفرات مفصولة بفواصل. الأول هو الافتراضي.' },
                SELKIES_USE_CPU: { label: 'فرض تشفير وحدة المعالجة المركزية', description: 'فرض التشفير المستند إلى وحدة المعالجة المركزية لـ pixelflux.' },
                SELKIES_FRAMERATE: { label: 'معدل الإطارات (نطاق أو ثابت)', description: 'مثال: \'8-120\' لنطاق أو \'60\' لثابت.' },
                SELKIES_H264_CRF: { label: 'H.264 CRF (نطاق أو ثابت)', description: 'مثال: \'5-50\' لنطاق أو \'25\' لثابت.' },
                SELKIES_JPEG_QUALITY: { label: 'جودة JPEG (نطاق أو ثابت)', description: 'مثال: \'1-100\' لنطاق أو \'60\' لثابت.' },
                SELKIES_H264_FULLCOLOR: { label: 'H.264 ألوان كاملة', description: 'تمكين نطاق الألوان الكامل H.264 لمشفرات pixelflux.' },
                SELKIES_H264_STREAMING_MODE: { label: 'وضع البث H.264 (Turbo)', description: 'تمكين وضع البث بزمن انتقال منخفض H.264.' },
                SELKIES_USE_PAINT_OVER_QUALITY: { label: 'استخدام جودة الرسم فوق', description: 'تمكين الرسم فوق عالي الجودة للمشاهد الثابتة.' },
                SELKIES_PAINT_OVER_JPEG_QUALITY: { label: 'جودة JPEG للرسم فوق', description: 'مثال: \'1-100\' لنطاق أو \'90\' لثابت.' },
                SELKIES_H264_PAINTOVER_CRF: { label: 'H.264 CRF للرسم فوق', description: 'مثال: \'5-50\' لنطاق أو \'18\' لثابت.' },
                SELKIES_H264_PAINTOVER_BURST_FRAMES: { label: 'إطارات دفعة الرسم فوق', description: 'مثال: \'1-30\' لنطاق أو \'5\' لثابت.' },
                HARDEN_DESKTOP: { label: 'تحصين سطح المكتب (إعداد مسبق)', description: 'يمكّن DISABLE_OPEN_TOOLS و DISABLE_SUDO و DISABLE_TERMINALS.' },
                HARDEN_OPENBOX: { label: 'تحصين مدير النوافذ (إعداد مسبق)', description: 'يمكّن DISABLE_CLOSE_BUTTON و DISABLE_MOUSE_BUTTONS و HARDEN_KEYBINDS. ويمكّن أيضًا RESTART_APP.' },
                DISABLE_OPEN_TOOLS: { label: 'تعطيل أدوات الفتح', description: 'يعطل ثنائيات xdg-open و exo-open.' },
                DISABLE_SUDO: { label: 'تعطيل Sudo', description: 'يعطل أمر sudo.' },
                DISABLE_TERMINALS: { label: 'تعطيل الطرفيات', description: 'يعطل محاكيات الطرفية الشائعة.' },
                DISABLE_CLOSE_BUTTON: { label: 'تعطيل زر إغلاق النافذة', description: 'يزيل زر الإغلاق من أشرطة عناوين النوافذ.' },
                DISABLE_MOUSE_BUTTONS: { label: 'تعطيل النقر الأيمن/الأوسط', description: 'يعطل قوائم السياق للنقر الأيمن والأوسط.' },
                HARDEN_KEYBINDS: { label: 'تحصين روابط المفاتيح', description: 'يعطل روابط مفاتيح Openbox الافتراضية مثل Alt+F4.' },
                RESTART_APP: { label: 'إعادة تشغيل التطبيق عند الإغلاق', description: 'يعيد تشغيل التطبيق الرئيسي تلقائيًا إذا تم إغلاقه.' },
                MAX_RES: { label: 'الدقة القصوى', description: 'الدقة القصوى للحاوية، الافتراضي هو 16k.' },
                START_DOCKER: { label: 'بدء Docker-in-Docker', description: 'إذا كان خطأ، فلن تبدأ الحاوية ذات الامتيازات DinD.' },
                DISABLE_IPV6: { label: 'تعطيل IPv6', description: 'إذا كان صحيحًا، فسيؤدي هذا إلى تعطيل IPv6.' },
                DISABLE_ZINK: { label: 'تعطيل Zink', description: 'لا تقم بتعيين متغيرات بيئة Zink إذا تم اكتشاف بطاقة فيديو.' },
                DISABLE_DRI3: { label: 'تعطيل DRI3', description: 'لا تستخدم تسريع DRI3 إذا تم اكتشاف بطاقة فيديو.' },
                NO_DECOR: { label: 'بدون زخارف للنوافذ', description: 'تشغيل التطبيق بدون حدود نافذة لاستخدام PWA.' },
                NO_FULL: { label: 'بدون ملء الشاشة', description: 'عدم تشغيل التطبيقات في وضع ملء الشاشة تلقائيًا.' },
                NO_GAMEPAD: { label: 'تعطيل حقن جهاز التحكم', description: 'تعطيل حقن مُقحِم جهاز التحكم في مساحة المستخدم.' },
                SELKIES_DEBUG: { label: 'تمكين تصحيح أخطاء Selkies', description: 'تمكين تسجيل تصحيح الأخطاء لمكونات البث.' },
            }
        },
        appLaboratory: {
            title: 'مختبر التطبيقات',
            description: 'أنشئ واختبر تكوينات التطبيقات المخصصة عن طريق إضافة طبقات من التغييرات فوق تطبيق أساسي.',
            selectApp: 'تحديد تطبيق',
            createNew: 'إنشاء تطبيق جديد',
            baseApp: 'التطبيق الأساسي',
            baseAppDescription: 'التطبيق المثبت الذي سيعتمد عليه تطبيقك المخصص الجديد.',
            selectBase: 'تحديد تطبيق أساسي',
            customizationTitle: 'تخصيص',
            appName: 'اسم التطبيق',
            appIcon: 'أيقونة التطبيق',
            uploadIcon: 'تحميل أيقونة',
            autostartScriptLabel: 'نص التشغيل التلقائي المخصص',
            permissionsTitle: 'الأذونات',
            usersLabel: 'المستخدمون المسموح لهم',
            groupsLabel: 'المجموعات المسموح لها',
            launchButton: 'حفظ وتشغيل جلسة التخصيص',
            closeButton: 'إغلاق الجلسة والانتهاء',
            savingAndLaunching: 'جاري الحفظ والتشغيل...',
            placeholder: 'يسمح لك مختبر التطبيقات بتكوين المجلد الرئيسي الأساسي ونص التشغيل لتطبيق يعتمد على تطبيق مثبت موجود. سيتم نسخ هذا المجلد الرئيسي عند التهيئة الأولى للمستخدم مع جميع الملفات والإعدادات التي قمت بإعدادها في هذه الجلسة. يمكنك إعادة تشغيل تطبيق مختبر موجود لتعديل محتوياته بشكل أكبر.',
            formInvalid: 'الرجاء تحديد تطبيق أساسي وتقديم اسم للتطبيق الجديد.',
        },
        modals: {
            editUserTitle: 'تعديل المستخدم: {username}',
            saveChanges: 'حفظ التغييرات',
            effectiveSettings: 'الإعدادات الفعالة (مع تجاوزات المجموعة)',
            editGroupTitle: 'تعديل المجموعة: {groupName}',
            userConfigTitle: 'إعدادات المستخدم',
            warning: 'هذه هي المرة الوحيدة التي سيتم فيها عرض هذه الإعدادات. قدمها للمستخدم بشكل آمن.',
            info: 'يمكنك تنزيل ملف الإعدادات هذا لإعداد SealSkin بسهولة على جهاز آخر. احتفظ بهذا الملف آمنًا لأنه يحتوي على مفتاحك الخاص.',
            configDataLabel: 'بيانات الإعدادات (JSON)',
            copyButton: 'نسخ النص',
            downloadButton: 'تنزيل الملف',
            manageHomeDirs: 'إدارة المجلدات الرئيسية',
            dirsForUser: 'مجلدات المستخدم: {username}',
            dirsForAdmin: 'مجلدات المسؤول: {username}',
            newDirForUser: 'إنشاء مجلد جديد للمستخدم',
            createDirButton: 'إنشاء مجلد',
            confirmDeleteDir: 'هل أنت متأكد أنك تريد حذف \'{homeName}\' للمستخدم \'{username}\'؟ هذا الإجراء دائم.',
            installAppTitle: 'تثبيت {appName}',
            editAppTitle: 'تعديل {appName}',
            customNameLabel: 'اسم مخصص',
            imageLabel: 'صورة الحاوية',
            permissions: 'الأذونات',
            allowedUsersLabel: 'المستخدمون المسموح لهم (مفصولة بفاصلة، \'all\' للجميع)',
            allowedGroupsLabel: 'المجموعات المسموح لها (مفصولة بفاصلة، \'all\' للجميع)',
            features: 'الميزات',
            gpuSupport: 'دعم وحدة معالجة الرسوميات',
            homeMounting: 'تحميل المجلد الرئيسي',
            urlSupport: 'دعم فتح عناوين URL',
            fileSupport: 'دعم فتح الملفات',
            autoUpdate: 'تحديث الصورة تلقائيًا',
            advancedSettings: 'إعدادات متقدمة',
            appTemplateLabel: 'قالب التطبيق',
            appTemplateDescription: 'حدد قالبًا مُعدًا مسبقًا لإعدادات تشغيل الحاوية المتقدمة.',
            customAutostartScriptLabel: 'نص التشغيل التلقائي المخصص',
            customAutostartScriptDescription: 'تخصيص منطق التشغيل التلقائي، اتركه فارغًا لاستخدام الإعداد الافتراضي من مزود التطبيق.',
            saveInstallation: 'حفظ التثبيت',
            updateStatusTitle: 'حالة التحديث لـ {appName}',
            checkingUpdates: 'جاري التحقق من وجود تحديثات...',
            updateAvailable: 'إصدار جديد من الصورة متاح!',
            yourVersion: 'إصدارك: {sha}',
            latestAvailable: 'أحدث إصدار متاح للسحب من السجل.',
            pullLatest: 'سحب أحدث صورة',
            upToDate: 'صورتك محدثة.',
            currentVersion: 'الإصدار الحالي: {sha}',
            errorChecking: 'خطأ في التحقق من التحديثات.',
            pullingLatest: 'جاري سحب أحدث صورة... قد يستغرق هذا بعض الوقت.',
            pullComplete: 'اكتمل السحب!',
            newVersion: 'الإصدار الجديد: {sha}',
            errorPulling: 'خطأ في سحب الصورة.',
            manualInstallNote: "ملاحظة: يجب أن تكون الصور المضافة يدويًا مبنية على صورة متوافقة مع selkies-baseimage.",
        },
        status: {
            loggingIn: 'جاري تسجيل الدخول...',
            configSaved: 'تم حفظ الإعدادات بنجاح!',
            configApplied: 'تم تطبيق الإعدادات! الرجاء تسجيل الدخول والاختبار.',
            configApplyFailed: 'فشل تطبيق الإعدادات: {error}',
            fileReadError: 'خطأ في قراءة الملف.',
            noConfig: 'الرجاء توفير ملف إعدادات أو نص.',
            loggedInAdmin: 'تم تسجيل الدخول كمسؤول: {username}',
            loggedInUser: 'تم تسجيل الدخول كمستخدم عادي: {username}.',
            loginFailed: 'فشل تسجيل الدخول: {error}',
            adminDataRefreshFailed: 'فشل تحديث بيانات المسؤول: {error}',
            logoutSuccess: 'تم تسجيل الخروج ومسح الإعدادات.',
            generateConfigFailed: 'تعذر إنشاء الإعدادات، تفاصيل المستخدم مفقودة.',
            copySuccess: 'تم نسخ الإعدادات إلى الحافظة!',
            copyFailed: 'فشل نسخ النص.',
            publicKeyCopied: 'تم نسخ المفتاح العام!',
            keyCopyFailed: 'فشل نسخ المفتاح.',
            creatingAdmin: 'جاري إنشاء المسؤول...',
            adminCreated: 'تم إنشاء المسؤول \'{username}\'.',
            adminCreateFailed: 'خطأ في إنشاء المسؤول: {error}',
            adminDeleted: 'تم حذف المسؤول \'{username}\' بنجاح.',
            adminDeleteFailed: 'خطأ في حذف المسؤول: {error}',
            creatingUser: 'جاري إنشاء المستخدم...',
            userCreated: 'تم إنشاء المستخدم \'{username}\'.',
            userCreateFailed: 'خطأ في إنشاء المستخدم: {error}',
            userDeleted: 'تم حذف المستخدم \'{username}\' بنجاح.',
            userDeleteFailed: 'خطأ في حذف المستخدم: {error}',
            userUpdated: 'تم تحديث المستخدم \'{username}\' بنجاح.',
            userUpdateFailed: 'خطأ في تحديث المستخدم: {error}',
            creatingGroup: 'جاري إنشاء المجموعة...',
            groupCreated: 'تم إنشاء المجموعة \'{groupName}\'.',
            groupCreateFailed: 'خطأ في إنشاء المجموعة: {error}',
            groupDeleted: 'تم حذف المجموعة \'{groupName}\' بنجاح.',
            groupDeleteFailed: 'خطأ في حذف المجموعة: {error}',
            groupUpdated: 'تم تحديث المجموعة \'{groupName}\' بنجاح.',
            groupUpdateFailed: 'خطأ في تحديث المجموعة: {error}',
            homedirLoadFailed: 'فشل تحميل المجلدات الرئيسية: {error}',
            homedirCreateFailed: 'خطأ في إنشاء المجلد: {error}',
            homedirCreated: 'تم إنشاء المجلد الرئيسي \'{homeName}\'.',
            homedirDeleted: 'تم حذف المجلد \'{homeName}\'.',
            homedirDeleteFailed: 'خطأ في حذف المجلد: {error}',
            homedirCreatedFor: 'تم إنشاء المجلد \'{homeName}\' للمستخدم {username}.',
            homedirDeletedFor: 'تم حذف المجلد \'{homeName}\' للمستخدم {username}.',
            sessionsLoadFailed: 'فشل تحميل الجلسات: {error}',
            sessionStopError: 'خطأ في إيقاف الجلسة: {error}',
            sessionStopped: 'تم إيقاف الجلسة بنجاح.',
            appDataRefreshFailed: 'فشل تحديث بيانات التطبيق: {error}',
            closingSession: 'جاري تنفيذ جلسة التخصيص...',
            sessionClosed: 'تم إغلاق جلسة التخصيص.',
            sessionCloseFailed: 'فشل إغلاق جلسة التخصيص: {error}',
            fetchingApps: 'جاري جلب التطبيقات من المتجر...',
            fetchAppsFailed: 'فشل جلب التطبيقات من المتجر: {error}',
            appStoreAddFailed: 'خطأ في إضافة المتجر: {error}',
            appStoreAdded: 'تمت إضافة متجر التطبيقات \'{name}\'.',
            appSaved: 'تم {action} التطبيق \'{name}\' بنجاح.',
            appSaveActions: {
                updated: 'تحديث',
                installed: 'تثبيت'
            },
            appSaveFailed: 'خطأ في حفظ التطبيق: {error}',
            appDeleted: 'تم حذف التطبيق \'{name}\'.',
            appDeleteFailed: 'خطأ في حذف التطبيق: {error}',
            templateSaved: 'تم حفظ القالب \'{name}\' بنجاح.',
            templateSaveFailed: 'خطأ في حفظ القالب: {error}',
            templateDeleted: 'تم حذف القالب \'{name}\' بنجاح.',
            templateDeleteFailed: 'خطأ في حذف القالب: {error}',
            pinRemoved: 'تمت إزالة السلوك المثبت.',
            keyGenerated: 'تم إنشاء زوج مفاتيح جديد.',
            keyGenFailed: 'فشل إنشاء المفتاح: {{error}}',
            pendingConfigSaved: 'تم حفظ التكوين المعلق. يمكنك الآن تقديم مفتاحك العام للمسؤول.',
            settingsSaved: 'تم حفظ الإعدادات.',
            appCreated: 'تم إنشاء التطبيق \'{name}\' بنجاح.',
            launchFailed: 'فشل التشغيل: {error}',
        },
        placeholders: {
            noAdmins: 'لم يتم العثور على مسؤولين.',
            noUsers: 'لم يتم العثور على مستخدمين.',
            noGroups: 'لم يتم العثور على مجموعات.',
            noHomeDirs: 'لم يتم العثور على مجلدات رئيسية.',
            noSessions: 'لم يتم العثور على جلسات نشطة.',
            noPinned: 'لم يتم العثور على سلوكيات مثبتة.',
            errorLoading: 'خطأ في تحميل المجلدات.',
            noInstalledApps: 'لم يتم تثبيت أي تطبيقات بعد.',
        },
    },
    popup: {
        tabs: {
            launch: 'تشغيل جديد',
            sessions: 'الجلسات النشطة',
            manageFiles: 'إدارة الملفات',
            uploadStorage: 'تحميل إلى التخزين',
            uploadFiles: 'تحميل ملفات',
            uploadFilesTitle: 'فتح صفحة تحميل الملفات المخصصة'
        },
        launchView: {
            searchPlaceholder: 'بحث في التطبيقات...',
            uploadingFile: 'جاري تحميل الملف...',
            gpuLabel: 'وحدة معالجة الرسوميات',
            storageLabel: 'التخزين',
            languageLabel: 'اللغة',
            cleanroom: 'غرفة نظيفة (مؤقتة)',
            noGpu: 'لا يوجد',
            saveOptions: 'حفظ خيارات التشغيل هذه',
            saveOptionsForUrl: 'حفظ الخيارات لجميع عناوين URL',
            saveOptionsForFile: 'حفظ الخيارات لملفات .{extension}',
            openFile: 'فتح الملف عند التشغيل',
            launchButton: 'تشغيل',
            launchingButton: 'جاري التشغيل...',
            uploadingButton: 'جاري التحميل...',
            autoHome: 'تلقائي (استمرارية لكل تطبيق)',
            collaborationMode: 'جلسة تعاونية',
            waylandMode: 'وضع Wayland',
        },
        sessionsView: {
            noSessions: 'لم يتم العثور على جلسات نشطة.',
        },
        uploadStorageView: {
            selectHome: 'تحديد المجلد الرئيسي',
            description: 'سيؤدي هذا إلى تحميل الملف <strong>{filename}</strong> مباشرة إلى مساحة تخزين الملفات الخاصة بك لاستخدامه في المستقبل.',
            descriptionFallback: 'سيؤدي هذا إلى تحميل الملف <strong>{filename}</strong> مباشرة إلى مساحة تخزين الملفات الخاصة بك لاستخدامه في المستقبل.',
            uploadButton: 'تحميل الملف',
            uploadingButton: 'جاري التحميل...',
            preparing: 'جاري تحضير الملف...',
            uploadingChunk: 'جاري تحميل الجزء {current} من {total}...',
            finalizing: 'جاري الإنهاء...',
            uploadComplete: 'اكتمل التحميل!',
        },
        status: {
            unconfigured: 'الرجاء إعداد الإضافة عبر صفحة الخيارات.',
            openingServerFile: "جاري فتح ملف من جانب الخادم: {filename}",
            openingFile: 'جاري فتح الملف: {filename}',
            openingUrl: 'جاري فتح الرابط: {targetUrl}',
            error: 'خطأ: {message}',
            preparingFile: 'جاري تحضير الملف...',
            sendingFile: 'جاري إرسال الملف إلى الجلسة...',
            errorSendingFile: 'خطأ في إرسال الملف: {message}',
            errorClosingSession: 'خطأ في إغلاق الجلسة: {message}',
            preparingSession: 'جاري تحضير الجلسة المعزولة...',
            fetchingData: 'جاري جلب بيانات الملف...',
            fetchDataFailed: 'فشل جلب بيانات الملف: {statusText}',
            unknownAction: 'إجراء تشغيل غير معروف.',
            noAppSelected: 'الرجاء تحديد تطبيق.',
            noAppsAvailable: 'لا توجد تطبيقات متاحة لحسابك.',
            uploadSuccess: 'تم تحميل الملف بنجاح!',
            creatingAutoHome: 'جاري إنشاء المجلد الرئيسي التلقائي...',
        },
        languages: {
            default: 'افتراضي ({locale})'
        }
    },
    upload: {
        title: 'تحميل ملف',
        description: 'حدد ملفًا من جهاز الكمبيوتر الخاص بك لفتحه في جلسة آمنة ومعزولة.',
        dropzone: {
            title: 'اسحب وأفلت ملفًا هنا',
            or: 'أو',
            button: 'تحديد ملف',
        },
        confirm: {
            ready: 'الملف جاهز للفتح بأمان.',
            button: 'متابعة للتشغيل',
        }
    },
    files: {
        title: 'ملفات SealSkin',
        header: {
            title: 'الملفات',
            newFolder: 'مجلد جديد',
            uploadFiles: 'رفع الملفات',
            uploadFolder: 'رفع مجلد'
        },
        sidebar: {
            sharedFiles: 'ملفات SealSkin',
            publicShares: 'المشاركات العامة'
        },
        shares: {
            title: 'الملفات المشاركة بشكل عام',
            searchPlaceholder: 'البحث باسم الملف أو المعرف...'
        },
        table: {
            name: 'الاسم',
            size: 'الحجم',
            lastModified: 'آخر تعديل',
            created: 'تم الإنشاء',
            expires: 'تنتهي الصلاحية',
            url: 'الرابط العام',
            passwordProtected: 'كلمة المرور'
        },
        dropzone: {
            title: 'أسقط الملفات هنا للرفع'
        },
        pagination: {
            previous: '« السابق',
            next: 'التالي »',
            pageOf: 'صفحة {page} من {totalPages}'
        },
        modals: {
            newFolder: {
                title: 'إنشاء مجلد جديد',
                folderNameLabel: 'اسم المجلد',
                nameTitle: 'استخدم فقط الحروف أو الأرقام أو الشرطة السفلية أو الواصلة أو النقطة.',
                createButton: 'إنشاء'
            },
            confirmDelete: {
                title: 'تأكيد الحذف',
                message: 'هل أنت متأكد أنك تريد حذف {count, plural, one {عنصر واحد محدد} other {{count} عناصر محددة}}؟ لا يمكن التراجع عن هذا الإجراء.',
                messageDefault: 'هل أنت متأكد أنك تريد حذف العناصر المحددة؟ لا يمكن التراجع عن هذا الإجراء.'
            },
            uploadProgress: {
                title: 'تقدم الرفع',
                doneButton: 'تم'
            },
            share: {
                title: 'مشاركة ملف',
                sharingFile: 'مشاركة الملف: <strong>{filename}</strong>',
                passwordLabel: 'كلمة المرور (اختياري)',
                passwordPlaceholder: 'اتركه فارغًا لعدم استخدام كلمة مرور',
                expiryLabel: 'تنتهي الصلاحية خلال (ساعات، اختياري)',
                expiryPlaceholder: 'مثال: 24 ليوم واحد',
                shareButton: 'إنشاء رابط مشاركة'
            }
        },
        status: {
            homeDirLoadFailed: 'فشل تحميل الدلائل الرئيسية: {error}',
            filesLoadFailed: 'خطأ في تحميل الملفات: {error}',
            deleteProtectedError: 'لا يمكن حذف مجلدات النظام المحمية.',
            deletingItems: 'جارٍ حذف {count, plural, one {عنصر واحد} other {{count} عناصر}}...',
            deleteSuccess: 'تم الحذف بنجاح.',
            deleteFailed: 'فشل الحذف: {error}',
            preparingUpload: 'جارٍ التحضير لرفع {count, plural, one {ملف واحد} other {{count} ملفات}}...',
            uploadPrepFailed: 'خطأ أثناء التحضير لرفع المجلد: {error}',
            notConfigured: 'خطأ: SealSkin غير مهيأ. يرجى الإعداد في الخيارات.',
            folderCreated: 'تم إنشاء المجلد \'{folderName}\'.',
            folderCreateFailed: 'خطأ في إنشاء المجلد: {error}',
            shareCreated: 'تم إنشاء المشاركة بنجاح! تم نسخ الرابط إلى الحافظة الخاصة بك.',
            shareCreateFailed: 'فشل في إنشاء المشاركة: {error}',
            sharesLoadFailed: 'فشل في تحميل الملفات المشاركة: {error}',
            shareDeleteFailed: 'فشل في حذف المشاركة: {error}',
            shareDeleted: 'تم حذف المشاركة بنجاح.',
            urlCopied: 'تم نسخ الرابط العام إلى الحافظة.'
        },
        placeholders: {
            errorLoading: 'خطأ في تحميل الملفات.',
            folderEmpty: 'هذا المجلد فارغ.',
            noHomeDirs: 'لا توجد دلائل رئيسية متاحة.',
            noShares: 'لم تقم بمشاركة أي ملفات بعد.'
        },
        uploadStatus: {
            pending: 'قيد الانتظار',
            initiating: 'جارٍ البدء...',
            uploading: 'جارٍ الرفع...',
            finalizing: 'جارٍ الإنهاء...',
            completed: 'مكتمل',
            error: 'خطأ'
        }
    }
};

// --- Korean Translations ---
const ko = {
    background: {
        contextMenu: {
            openUrl: 'SealSkin에서 링크 열기',
            openFile: 'SealSkin에서 링크 대상을 파일로 열기',
            sendMedia: 'SealSkin으로 미디어 보내기',
            searchText: 'SealSkin에서 "%s" 검색',
            sendDownload: '다음 다운로드를 SealSkin으로 보내기'
        }
    },
    common: {
        actions: '작업',
        active: '활성',
        cancel: '취소',
        manage: '관리',
        delete: '삭제',
        edit: '편집',
        save: '저장',
        none: '없음',
        error: '오류',
        na: '해당 없음',
        of: '의',
        status: '상태',
        username: '사용자 이름',
        group: '그룹',
        groups: '그룹',
        publicKey: '공개 키',
        name: '이름',
        source: '소스',
        imageVersion: '이미지 버전',
        language: '언어',
        storage: '스토리지',
        gpu: 'GPU',
        version: '버전',
        checked: '확인됨',
        never: '절대 안 함',
        stop: '중지',
        reopen: '다시 열기',
        sendFile: '파일 보내기',
        share: '공유',
        search: '검색',
        refresh: '새로고침',
        close: '닫기',
        copy: '복사',
        open: "열기",
        copyUrl: 'URL 복사',
        download: '다운로드',
        next: '다음',
        previous: '이전',
        page: '페이지',
        home: '홈',
        homes: '홈 디렉터리',
        sessions: '세션',
        users: '사용자',
        admins: '관리자',
        yes: '예',
        no: '아니요',
        daysAgo: '{count}일 전',
        hoursAgo: '{count}시간 전',
        minutesAgo: '{count}분 전',
        justNow: '방금 전',
        bytes: '바이트',
        kb: 'KB',
        mb: 'MB',
        gb: 'GB',
        tb: 'TB',
        pb: 'PB',
    },
    options: {
        sidebar: {
            config: '구성',
            home: '홈 디렉터리',
            sessions: '활성 세션',
            pinned: '고정된 동작',
            appStore: '앱 스토어',
            appTemplates: '앱 템플릿',
            appLaboratory: '앱 실험실',
            installedApps: '설치된 앱',
            users: '사용자',
            groups: '그룹',
            admins: '관리자',
        },
        dashboard: {
            title: '대시보드',
            clientSettings: '클라이언트 설정',
            exportConfig: '구성 내보내기',
            userStatus: '사용자 상태',
            loggedInAs: '로그인 계정:',
            role: '역할',
            roleAdmin: '관리자',
            roleUser: '일반 사용자',
            serverInfo: '서버 정보',
            server: '서버:',
            cpuModel: 'CPU 모델:',
            storageUsage: '스토리지 사용량:',
            detectedGpus: '감지된 GPU:',
            logout: '로그아웃 및 구성 지우기',
            howTo: 'SealSkin 사용 방법',
            howToDescription: '이 섹션에는 확장 프로그램 사용 방법에 대한 기본 설명이 포함되어 있습니다.',
            howToList: [
                '<strong>격리된 환경에서 콘텐츠 열기:</strong> 링크, 이미지 또는 선택한 텍스트를 마우스 오른쪽 버튼으로 클릭하고 "SealSkin 격리" 컨텍스트 메뉴에서 옵션을 선택하세요.',
                '<strong>격리된 환경으로 다운로드 보내기:</strong> 페이지를 마우스 오른쪽 버튼으로 클릭하고 "다음 다운로드를 격리 환경으로 보내기"를 선택하세요. 다음에 다운로드하는 파일은 가로채져 안전한 세션으로 전송됩니다.',
                '<strong>새로운 애플리케이션 시작:</strong> 브라우저 도구 모음에서 SealSkin 아이콘을 클릭하세요.',
                '<strong>영구 스토리지 관리:</strong> 이 페이지의 "홈 디렉터리" 탭을 사용하여 여러 세션에서 사용할 수 있는 스토리지 볼륨을 생성하고 삭제하세요.',
                '<strong>시작 옵션 저장:</strong> 특정 파일 유형(예: .pdf) 또는 모든 URL에 대해 애플리케이션을 시작하기 전에 팝업에서 "이 시작 옵션 저장" 확인란을 선택하세요. "고정된 동작" 탭에서 저장된 기본 설정을 관리하세요.'
            ],
            confirmLogout: '로그아웃하시겠습니까? 이 브라우저에 저장된 구성이 지워집니다.',
        },
        config: {
            quickSetup: '빠른 설정',
            quickSetupDescription: '관리자가 제공한 구성 파일(.json)을 업로드하거나 아래에 내용을 붙여넣어 확장 프로그램을 자동으로 설정하세요.',
            uploadLabel: '구성 파일 업로드',
            pasteLabel: '또는 구성 텍스트 붙여넣기',
            pastePlaceholder: '여기에 JSON 구성을 붙여넣으세요...',
            applyButton: '구성 적용',
            manualLink: '수동 구성',
            advancedTitle: '클라이언트 구성 (고급)',
            serverIpLabel: '서버 IP 또는 도메인',
            serverIpPlaceholder: '예: 192.168.1.100',
            apiPortLabel: 'API 포트',
            apiPortPlaceholder: '예: 8000',
            sessionPortLabel: '세션 포트',
            sessionPortPlaceholder: '예: 8443',
            usernameLabel: '사용자 이름',
            usernamePlaceholder: '사용자 이름',
            privateKeyLabel: '개인 키 (PEM 형식)',
            privateKeyPlaceholder: '여기에 개인 키 내용을 붙여넣으세요',
            serverKeyLabel: '서버 공개 키 (PEM 형식)',
            serverKeyPlaceholder: '여기에 server_public.pem 내용을 붙여넣으세요',
            searchEngineLabel: '선택한 텍스트의 기본 검색 엔진',
            saveButton: '구성 저장',
            loginButton: '로그인 및 테스트',
            automaticLink: '자동 구성',
            chooseFile: '파일 선택',
            keyGeneration: '키 생성',
            keyGenDescription: '키 쌍이 없는 경우 여기에서 생성할 수 있습니다. 개인 키는 위에 채워집니다. 관리자에게 공개 키를 제공하세요.',
            generateKeyButton: '새 키 쌍 생성',
            publicKeyForAdminLabel: '공개 키 (관리자용)',
        },
        home: {
            title: '내 홈 디렉터리',
            description: '세션 간에 사용할 영구 스토리지 디렉터리를 만드세요. 이 디렉터리는 애플리케이션에 구성 디렉터리로 마운트됩니다.',
            newTitle: '새 홈 디렉터리 만들기',
            nameLabel: '디렉터리 이름:',
            namePlaceholder: '예: my-project-files',
            nameTitle: '문자, 숫자, 밑줄 또는 하이픈만 사용하세요.',
            createButton: '디렉터리 만들기',
            confirmDelete: '홈 디렉터리 \'{homeName}\'을(를) 삭제하시겠습니까? 내부의 모든 데이터가 영구적으로 손실됩니다.',
        },
        sessions: {
            title: '활성 세션',
            application: '애플리케이션',
            started: '시작 시간',
            noSessionsUser: '활성 세션이 없습니다.',
            noSessionsAdmin: '어떤 사용자의 활성 세션도 찾을 수 없습니다.',
            sessionsFor: '{username}의 세션 ({count})',
            confirmStop: '이 세션을 중지하시겠습니까? 컨테이너가 파괴됩니다.',
        },
        pinned: {
            title: '고정된 확장 프로그램 동작',
            description: '이 표는 특정 파일 유형 또는 모든 URL에 대해 저장한 시작 옵션을 보여줍니다. 고정된 동작을 제거하면 시작 옵션을 다시 묻게 됩니다.',
            trigger: '트리거',
            savedApp: '저장된 애플리케이션',
            triggerSimple: '단순 실행 (도구 모음 버튼)',
            triggerUrl: '모든 URL (컨텍스트 메뉴에서)',
            triggerFile: '파일 유형: <strong>{fileType}</strong>',
            unknownApp: '알 수 없는 앱 ({appId}...)'
        },
        admins: {
            serverKeyTitle: '서버 공개 키',
            serverKeyDescription: '사용자 구성 파일이 이 서버에 연결하는 데 필요한 공개 키입니다.',
            title: '관리자 관리',
            searchPlaceholder: '관리자 검색...',
            newTitle: '새 관리자 만들기',
            publicKeyOptionalLabel: '공개 키 (선택 사항):',
            publicKeyPlaceholder: '공개 키를 여기에 붙여넣거나, 비워두면 새로 생성됩니다.',
            createButton: '관리자 만들기',
            confirmDelete: '관리자 \'{username}\'을(를) 삭제하시겠습니까? 모든 영구 스토리지도 함께 삭제되며 되돌릴 수 없습니다.',
        },
        users: {
            title: '사용자 관리',
            searchPlaceholder: '이름 또는 그룹으로 사용자 검색...',
            newTitle: '새 사용자 만들기',
            publicKeyOptionalLabel: '공개 키 (선택 사항):',
            publicKeyPlaceholder: '사용자의 공개 키를 여기에 붙여넣거나, 비워두면 새로 생성됩니다.',
            settingsTitle: '사용자 설정',
            sessionLimitLabel: '세션 제한',
            sessionLimitTitle: '사용자가 가질 수 있는 활성 세션의 수. -1은 무제한입니다.',
            permissionsTitle: '권한 및 보안 강화',
            activeAccount: '활성 계정',
            allowStorage: '영구 스토리지 허용',
            allowGpu: 'GPU 접근 허용',
            hardenContainer: '컨테이너 보안 강화',
            hardenWm: '창 관리자 보안 강화',
            createButton: '사용자 만들기',
            homesDisabledTooltip: '이 사용자는 영구 스토리지가 비활성화되었습니다',
            confirmDelete: '사용자 \'{username}\'을(를) 삭제하시겠습니까? 모든 영구 스토리지도 함께 삭제되며 되돌릴 수 없습니다.',
            allowPublicSharing: '공개 파일 공유 허용',
        },
        groups: {
            title: '그룹 관리',
            searchPlaceholder: '그룹 검색...',
            newTitle: '새 그룹 만들기',
            nameLabel: '그룹 이름:',
            overrideTitle: '그룹 재정의 설정',
            permissionsTitle: '권한 및 보안 강화 재정의',
            createButton: '그룹 만들기',
            confirmDelete: '그룹 \'{groupName}\'을(를) 삭제하시겠습니까? 이 그룹의 사용자들은 개별 설정으로 돌아갑니다.',
        },
        installedApps: {
            title: '설치된 애플리케이션',
            searchPlaceholder: '설치된 앱 검색...',
            noAppsFound: '설치된 앱이 없습니다.',
            pulling: '새 이미지 가져오는 중...',
            notLocal: '로컬에서 이미지를 찾을 수 없음',
            isLaboratory: '이것은 기본 이미지에 사용자 정의 설정을 더해 빌드된 실험실 앱입니다.',
            laboratory: '실험실',
            confirmDelete: '설치된 앱 \'{appName}\'을(를) 삭제하시겠습니까?'
        },
        appStore: {
            title: '앱 스토어',
            refreshTitle: '선택한 스토어 새로고침',
            selectLabel: '앱 스토어 선택',
            addLabel: '새 앱 스토어 추가',
            namePlaceholder: '스토어 이름',
            urlPlaceholder: '스토어 YAML URL',
            availableTitle: '사용 가능한 앱',
            addManual: "수동 앱 추가",
            searchPlaceholder: '사용 가능한 앱 검색...',
            noAppsFound: '애플리케이션을 찾을 수 없습니다.',
            availableFrom: '{storeName}에서 사용 가능한 앱',
            couldNotLoad: '이 스토어에서 앱을 로드할 수 없습니다.',
        },
        appTemplates: {
            title: '애플리케이션 템플릿 편집기',
            loadLabel: '템플릿 로드',
            createOption: '새 템플릿 만들기',
            nameLabel: '템플릿 이름',
            namePlaceholder: '새 템플릿의 이름을 입력하세요',
            saveButton: '프로필 저장',
            deleteButton: '삭제',
            previewTitle: 'UI 미리보기',
            contentArea: '애플리케이션 콘텐츠 영역',
            confirmDelete: '템플릿 \'{templateName}\'을(를) 삭제하시겠습니까? 이 작업은 되돌릴 수 없습니다.',
            deleteDisabled: '이 템플릿은 삭제할 수 없습니다.',
            enterName: '새 템플릿의 이름을 입력하세요.',
            settings: {
                TITLE: { label: "페이지 제목", description: "웹 브라우저에 표시되는 페이지 제목입니다." },
                SELKIES_UI_TITLE: { label: "사이드바 제목", description: "사이드바 왼쪽 상단의 제목입니다." },
                SELKIES_UI_SHOW_SIDEBAR: { label: "사이드바 표시", description: "메인 사이드바 UI를 표시합니다." },
                SELKIES_UI_SHOW_LOGO: { label: "로고 표시", description: "사이드바에 Selkies 로고를 표시합니다." },
                SELKIES_UI_SHOW_CORE_BUTTONS: { label: "핵심 버튼 표시", description: "핵심 구성 요소 버튼(디스플레이, 오디오 등)을 표시합니다." },
                SELKIES_UI_SIDEBAR_SHOW_VIDEO_SETTINGS: { label: "비디오 설정 표시", description: "사이드바에 비디오 설정 섹션을 표시합니다." },
                SELKIES_UI_SIDEBAR_SHOW_SCREEN_SETTINGS: { label: "화면 설정 표시", description: "사이드바에 화면 설정 섹션을 표시합니다." },
                SELKIES_UI_SIDEBAR_SHOW_AUDIO_SETTINGS: { label: "오디오 설정 표시", description: "사이드바에 오디오 설정 섹션을 표시합니다." },
                SELKIES_UI_SIDEBAR_SHOW_STATS: { label: "통계 표시", description: "사이드바에 통계 섹션을 표시합니다." },
                SELKIES_UI_SIDEBAR_SHOW_CLIPBOARD: { label: "클립보드 표시", description: "사이드바에 클립보드 섹션을 표시합니다." },
                SELKIES_UI_SIDEBAR_SHOW_FILES: { label: "파일 섹션 표시", description: "사이드바에 파일 전송 섹션을 표시합니다." },
                SELKIES_UI_SIDEBAR_SHOW_APPS: { label: "앱 섹션 표시", description: "사이드바에 애플리케이션 섹션을 표시합니다." },
                SELKIES_UI_SIDEBAR_SHOW_SHARING: { label: "공유 섹션 표시", description: "사이드바에 공유 섹션을 표시합니다." },
                SELKIES_UI_SIDEBAR_SHOW_GAMEPADS: { label: "게임패드 섹션 표시", description: "사이드바에 게임패드 섹션을 표시합니다." },
                SELKIES_UI_SIDEBAR_SHOW_KEYBOARD_BUTTON: { label: "키보드 버튼 표시", description: "화상 키보드 버튼을 표시합니다." },
                SELKIES_UI_SIDEBAR_SHOW_SOFT_BUTTONS: { label: "소프트 버튼 표시", description: "소프트 버튼 섹션(모바일용)을 표시합니다." },
                WATERMARK_PNG: { label: "워터마크 PNG 경로", description: "컨테이너 내부의 워터마크 PNG 파일의 전체 경로입니다." },
                WATERMARK_LOCATION: { label: "워터마크 위치", description: "스트림 위에 이미지를 그릴 위치입니다.", options: { disabled: "비활성화", topLeft: "상단-왼쪽", topRight: "상단-오른쪽", bottomLeft: "하단-왼쪽", bottomRight: "하단-오른쪽", centered: "중앙", animated: "애니메이션" } },
                DASHBOARD: { label: "대시보드 스타일", description: "사용자가 자신의 대시보드를 설정할 수 있습니다.", options: { default: "기본값", selkiesDefault: "Selkies (기본값)", zinc: "Zinc", wish: "Wish" } },
                SELKIES_AUDIO_ENABLED: { label: "오디오 활성화", description: "서버에서 클라이언트로의 오디오 스트리밍을 활성화합니다." },
                SELKIES_MICROPHONE_ENABLED: { label: "마이크 활성화", description: "클라이언트에서 서버로의 마이크 전달을 활성화합니다." },
                SELKIES_GAMEPAD_ENABLED: { label: "게임패드 활성화", description: "게임패드 지원을 활성화합니다." },
                SELKIES_CLIPBOARD_ENABLED: { label: "클립보드 활성화", description: "클립보드 동기화를 활성화합니다." },
                SELKIES_ENABLE_BINARY_CLIPBOARD: { label: "바이너리 클립보드 활성화", description: "클립보드에 바이너리 데이터(이미지)를 허용합니다." },
                SELKIES_COMMAND_ENABLED: { label: "명령 웹소켓 활성화", description: "명령 웹소켓 메시지 파싱을 활성화합니다." },
                SELKIES_FILE_TRANSFERS: { label: "파일 전송", description: "허용된 방향 ('upload,download', 'upload', 'download', 'none')." },
                SELKIES_ENABLE_SHARING: { label: "모든 공유 활성화", description: "모든 공유 기능에 대한 마스터 토글입니다." },
                SELKIES_SECOND_SCREEN: { label: "두 번째 화면 활성화", description: "두 번째 모니터/디스플레이 지원을 활성화합니다." },
                SELKIES_USE_BROWSER_CURSORS: { label: "브라우저 커서 사용", description: "캔버스에 렌더링하는 대신 브라우저 CSS 커서를 사용합니다." },
                SELKIES_USE_CSS_SCALING: { label: "CSS 스케일링 사용 (LoDPI)", description: "true인 경우, 낮은 해상도가 전송되고 캔버스가 늘어납니다." },
                SELKIES_IS_MANUAL_RESOLUTION_MODE: { label: "수동 해상도 모드", description: "해상도를 수동 너비/높이 값으로 고정합니다." },
                SELKIES_MANUAL_WIDTH: { label: "수동 너비", description: "너비를 고정 값으로 잠급니다. 수동 모드를 강제합니다." },
                SELKIES_MANUAL_HEIGHT: { label: "수동 높이", description: "높이를 고정 값으로 잠급니다. 수동 모드를 강제합니다." },
                SELKIES_SCALING_DPI: { label: "UI 스케일링 DPI", description: "UI 스케일링의 기본 DPI입니다." },
                SELKIES_AUDIO_BITRATE: { label: "오디오 비트레이트", description: "기본 오디오 비트레이트입니다." },
                SELKIES_ENCODER: { label: "인코더", description: "쉼표로 구분된 인코더 목록. 첫 번째가 기본값입니다." },
                SELKIES_USE_CPU: { label: "CPU 인코딩 강제", description: "pixelflux에 대해 CPU 기반 인코딩을 강제합니다." },
                SELKIES_FRAMERATE: { label: "프레임레이트 (범위 또는 고정)", description: "예: 범위는 '8-120', 고정은 '60'." },
                SELKIES_H264_CRF: { label: "H.264 CRF (범위 또는 고정)", description: "예: 범위는 '5-50', 고정은 '25'." },
                SELKIES_JPEG_QUALITY: { label: "JPEG 품질 (범위 또는 고정)", description: "예: 범위는 '1-100', 고정은 '60'." },
                SELKIES_H264_FULLCOLOR: { label: "H.264 풀 컬러", description: "pixelflux 인코더에 대해 H.264 풀 컬러 범위를 활성화합니다." },
                SELKIES_H264_STREAMING_MODE: { label: "H.264 스트리밍 (터보) 모드", description: "H.264 저지연 스트리밍 모드를 활성화합니다." },
                SELKIES_USE_PAINT_OVER_QUALITY: { label: "페인트 오버 품질 사용", description: "정적 장면에 대해 고품질 페인트 오버를 활성화합니다." },
                SELKIES_PAINT_OVER_JPEG_QUALITY: { label: "페인트 오버 JPEG 품질", description: "예: 범위는 '1-100', 고정은 '90'." },
                SELKIES_H264_PAINTOVER_CRF: { label: "페인트 오버 H.264 CRF", description: "예: 범위는 '5-50', 고정은 '18'." },
                SELKIES_H264_PAINTOVER_BURST_FRAMES: { label: "페인트 오버 버스트 프레임", description: "예: 범위는 '1-30', 고정은 '5'." },
                HARDEN_DESKTOP: { label: "데스크톱 강화 (프리셋)", description: "DISABLE_OPEN_TOOLS, DISABLE_SUDO, DISABLE_TERMINALS를 활성화합니다." },
                HARDEN_OPENBOX: { label: "창 관리자 강화 (프리셋)", description: "DISABLE_CLOSE_BUTTON, DISABLE_MOUSE_BUTTONS, HARDEN_KEYBINDS를 활성화합니다. 또한 RESTART_APP도 활성화합니다." },
                DISABLE_OPEN_TOOLS: { label: "열기 도구 비활성화", description: "xdg-open 및 exo-open 바이너리를 비활성화합니다." },
                DISABLE_SUDO: { label: "Sudo 비활성화", description: "sudo 명령을 비활성화합니다." },
                DISABLE_TERMINALS: { label: "터미널 비활성화", description: "일반적인 터미널 에뮬레이터를 비활성화합니다." },
                DISABLE_CLOSE_BUTTON: { label: "창 닫기 버튼 비활성화", description: "창 제목 표시줄에서 닫기 버튼을 제거합니다." },
                DISABLE_MOUSE_BUTTONS: { label: "오른쪽/가운데 클릭 비활성화", description: "오른쪽 클릭 및 가운데 클릭 컨텍스트 메뉴를 비활성화합니다." },
                HARDEN_KEYBINDS: { label: "키 바인딩 강화", description: "Alt+F4와 같은 기본 Openbox 키 바인딩을 비활성화합니다." },
                RESTART_APP: { label: "닫을 때 앱 다시 시작", description: "메인 애플리케이션이 닫히면 자동으로 다시 시작합니다." },
                MAX_RES: { label: "최대 해상도", description: "컨테이너의 최대 해상도, 기본값은 16k입니다." },
                START_DOCKER: { label: "Docker-in-Docker 시작", description: "false인 경우, 권한 있는 컨테이너는 DinD를 시작하지 않습니다." },
                DISABLE_IPV6: { label: "IPv6 비활성화", description: "true인 경우, IPv6를 비활성화합니다." },
                DISABLE_ZINK: { label: "Zink 비활성화", description: "비디오 카드가 감지되면 Zink 환경 변수를 설정하지 않습니다." },
                DISABLE_DRI3: { label: "DRI3 비활성화", description: "비디오 카드가 감지되면 DRI3 가속을 사용하지 않습니다." },
                NO_DECOR: { label: "창 장식 없음", description: "PWA 사용을 위해 창 테두리 없이 애플리케이션을 실행합니다." },
                NO_FULL: { label: "전체 화면 없음", description: "애플리케이션을 자동으로 전체 화면으로 만들지 않습니다." },
                NO_GAMEPAD: { label: "게임패드 주입 비활성화", description: "사용자 공간 게임패드 인터포저 주입을 비활성화합니다." },
                SELKIES_DEBUG: { label: "Selkies 디버깅 활성화", description: "스트리밍 구성 요소에 대한 디버그 로깅을 활성화합니다." },
            }
        },
        appLaboratory: {
            title: '앱 실험실',
            description: '기본 앱 위에 변경 사항을 레이어링하여 사용자 지정 애플리케이션 구성을 만들고 테스트합니다.',
            selectApp: '앱 선택',
            createNew: '새 앱 만들기',
            baseApp: '기본 애플리케이션',
            baseAppDescription: '새로운 사용자 지정 앱의 기반이 될 설치된 애플리케이션입니다.',
            selectBase: '기본 앱 선택',
            customizationTitle: '사용자 지정',
            appName: '앱 이름',
            appIcon: '앱 아이콘',
            uploadIcon: '아이콘 업로드',
            autostartScriptLabel: '사용자 지정 자동 시작 스크립트',
            permissionsTitle: '권한',
            usersLabel: '허용된 사용자',
            groupsLabel: '허용된 그룹',
            launchButton: '저장 및 사용자 지정 세션 시작',
            closeButton: '세션 닫기 및 최종 확정',
            savingAndLaunching: '저장 및 시작 중...',
            placeholder: '앱 실험실을 사용하면 기존에 설치된 애플리케이션을 기반으로 애플리케이션의 기본 홈 디렉터리와 시작 스크립트를 구성할 수 있습니다. 이 홈 디렉터리는 이 세션에서 설정한 모든 파일 및 설정과 함께 사용자를 위해 처음 초기화될 때 복사됩니다. 기존 실험실 앱을 다시 시작하여 내용을 추가로 수정할 수 있습니다.',
            formInvalid: '기본 앱을 선택하고 새 앱의 이름을 입력하세요.',
        },
        modals: {
            editUserTitle: '사용자 편집: {username}',
            saveChanges: '변경 사항 저장',
            effectiveSettings: '유효 설정 (그룹 재정의 포함)',
            editGroupTitle: '그룹 편집: {groupName}',
            userConfigTitle: '사용자 구성',
            warning: '이 구성은 이번에만 표시됩니다. 사용자에게 안전하게 전달하세요.',
            info: '이 구성 파일을 다운로드하여 다른 장치에서 SealSkin을 쉽게 설정할 수 있습니다. 이 파일에는 개인 키가 포함되어 있으니 안전하게 보관하세요.',
            configDataLabel: '구성 데이터 (JSON)',
            copyButton: '텍스트 복사',
            downloadButton: '파일 다운로드',
            manageHomeDirs: '홈 디렉터리 관리',
            dirsForUser: '사용자 디렉터리: {username}',
            dirsForAdmin: '관리자 디렉터리: {username}',
            newDirForUser: '사용자를 위한 새 디렉터리 만들기',
            createDirButton: '디렉터리 만들기',
            confirmDeleteDir: '사용자 \'{username}\'의 \'{homeName}\'을(를) 삭제하시겠습니까? 이 작업은 영구적입니다.',
            installAppTitle: '{appName} 설치',
            editAppTitle: '{appName} 편집',
            customNameLabel: '사용자 정의 이름',
            imageLabel: '컨테이너 이미지',
            permissions: '권한',
            allowedUsersLabel: '허용된 사용자 (쉼표로 구분, 모두는 \'all\')',
            allowedGroupsLabel: '허용된 그룹 (쉼표로 구분, 모두는 \'all\')',
            features: '기능',
            gpuSupport: 'GPU 지원',
            homeMounting: '홈 디렉터리 마운트',
            urlSupport: 'URL 열기 지원',
            fileSupport: '파일 열기 지원',
            autoUpdate: '이미지 자동 업데이트',
            advancedSettings: '고급 설정',
            appTemplateLabel: '애플리케이션 템플릿',
            appTemplateDescription: '고급 컨테이너 시작 설정을 위해 미리 구성된 템플릿을 선택하세요.',
            customAutostartScriptLabel: '사용자 지정 자동 시작 스크립트',
            customAutostartScriptDescription: '자동 시작 로직을 사용자 지정하고, 비워두면 애플리케이션 제공업체의 기본값을 사용합니다.',
            saveInstallation: '설치 저장',
            updateStatusTitle: '{appName} 업데이트 상태',
            checkingUpdates: '업데이트 확인 중...',
            updateAvailable: '새 이미지 버전을 사용할 수 있습니다!',
            yourVersion: '현재 버전: {sha}',
            latestAvailable: '레지스트리에서 최신 버전을 가져올 수 있습니다.',
            pullLatest: '최신 이미지 가져오기',
            upToDate: '이미지가 최신 버전입니다.',
            currentVersion: '현재 버전: {sha}',
            errorChecking: '업데이트 확인 중 오류 발생.',
            pullingLatest: '최신 이미지를 가져오는 중... 잠시 기다려주세요.',
            pullComplete: '가져오기 완료!',
            newVersion: '새 버전: {sha}',
            errorPulling: '이미지를 가져오는 중 오류 발생.',
            manualInstallNote: "참고: 수동으로 추가된 이미지는 selkies-baseimage 호환 이미지에 기반해야 합니다.",
        },
        status: {
            loggingIn: '로그인 중...',
            configSaved: '구성이 성공적으로 저장되었습니다!',
            configApplied: '구성이 적용되었습니다! 로그인하여 테스트하세요.',
            configApplyFailed: '구성 적용 실패: {error}',
            fileReadError: '파일 읽기 오류.',
            noConfig: '구성 파일 또는 텍스트를 제공하세요.',
            loggedInAdmin: '관리자로 로그인됨: {username}',
            loggedInUser: '일반 사용자로 로그인됨: {username}.',
            loginFailed: '로그인 실패: {error}',
            adminDataRefreshFailed: '관리자 데이터 새로고침 실패: {error}',
            logoutSuccess: '로그아웃되었고 구성이 지워졌습니다.',
            generateConfigFailed: '사용자 정보가 누락되어 구성을 생성할 수 없습니다.',
            copySuccess: '구성이 클립보드에 복사되었습니다!',
            copyFailed: '텍스트 복사에 실패했습니다.',
            publicKeyCopied: '공개 키가 복사되었습니다!',
            keyCopyFailed: '키 복사에 실패했습니다.',
            creatingAdmin: '관리자 생성 중...',
            adminCreated: '관리자 \'{username}\'이(가) 생성되었습니다.',
            adminCreateFailed: '관리자 생성 오류: {error}',
            adminDeleted: '관리자 \'{username}\'이(가) 성공적으로 삭제되었습니다.',
            adminDeleteFailed: '관리자 삭제 오류: {error}',
            creatingUser: '사용자 생성 중...',
            userCreated: '사용자 \'{username}\'이(가) 생성되었습니다.',
            userCreateFailed: '사용자 생성 오류: {error}',
            userDeleted: '사용자 \'{username}\'이(가) 성공적으로 삭제되었습니다.',
            userDeleteFailed: '사용자 삭제 오류: {error}',
            userUpdated: '사용자 \'{username}\'이(가) 성공적으로 업데이트되었습니다.',
            userUpdateFailed: '사용자 업데이트 오류: {error}',
            creatingGroup: '그룹 생성 중...',
            groupCreated: '그룹 \'{groupName}\'이(가) 생성되었습니다.',
            groupCreateFailed: '그룹 생성 오류: {error}',
            groupDeleted: '그룹 \'{groupName}\'이(가) 성공적으로 삭제되었습니다.',
            groupDeleteFailed: '그룹 삭제 오류: {error}',
            groupUpdated: '그룹 \'{groupName}\'이(가) 성공적으로 업데이트되었습니다.',
            groupUpdateFailed: '그룹 업데이트 오류: {error}',
            homedirLoadFailed: '홈 디렉터리 로드 실패: {error}',
            homedirCreateFailed: '디렉터리 생성 오류: {error}',
            homedirCreated: '홈 디렉터리 \'{homeName}\'이(가) 생성되었습니다.',
            homedirDeleted: '디렉터리 \'{homeName}\'이(가) 삭제되었습니다.',
            homedirDeleteFailed: '디렉터리 삭제 오류: {error}',
            homedirCreatedFor: '{username}을(를) 위한 디렉터리 \'{homeName}\'이(가) 생성되었습니다.',
            homedirDeletedFor: '{username}의 디렉터리 \'{homeName}\'이(가) 삭제되었습니다.',
            sessionsLoadFailed: '세션 로드 실패: {error}',
            sessionStopError: '세션 중지 오류: {error}',
            sessionStopped: '세션이 성공적으로 중지되었습니다.',
            appDataRefreshFailed: '앱 데이터 새로고침 실패: {error}',
            closingSession: '사용자 지정 세션을 커밋하는 중...',
            sessionClosed: '사용자 지정 세션이 닫혔습니다.',
            sessionCloseFailed: '사용자 지정 세션을 닫지 못했습니다: {error}',
            fetchingApps: '스토어에서 앱 가져오는 중...',
            fetchAppsFailed: '스토어에서 앱 가져오기 실패: {error}',
            appStoreAddFailed: '스토어 추가 오류: {error}',
            appStoreAdded: '앱 스토어 \'{name}\'이(가) 추가되었습니다.',
            appSaved: '앱 \'{name}\'이(가) 성공적으로 {action}되었습니다.',
            appSaveActions: {
                updated: '업데이트',
                installed: '설치'
            },
            appSaveFailed: '앱 저장 오류: {error}',
            appDeleted: '앱 \'{name}\'이(가) 삭제되었습니다.',
            appDeleteFailed: '앱 삭제 오류: {error}',
            templateSaved: '템플릿 \'{name}\'이(가) 성공적으로 저장되었습니다.',
            templateSaveFailed: '템플릿 저장 오류: {error}',
            templateDeleted: '템플릿 \'{name}\'이(가) 성공적으로 삭제되었습니다.',
            templateDeleteFailed: '템플릿 삭제 오류: {error}',
            pinRemoved: '고정된 동작이 제거되었습니다.',
            keyGenerated: '새 키 쌍이 생성되었습니다.',
            keyGenFailed: '키 생성 실패: {{error}}',
            pendingConfigSaved: '보류 중인 구성이 저장되었습니다. 이제 관리자에게 공개 키를 제공할 수 있습니다.',
            settingsSaved: '설정이 저장되었습니다.',
            appCreated: '앱 \'{name}\'이(가) 성공적으로 생성되었습니다.',
            launchFailed: '시작 실패: {error}',
        },
        placeholders: {
            noAdmins: '관리자를 찾을 수 없습니다.',
            noUsers: '사용자를 찾을 수 없습니다.',
            noGroups: '그룹을 찾을 수 없습니다.',
            noHomeDirs: '홈 디렉터리를 찾을 수 없습니다.',
            noSessions: '활성 세션을 찾을 수 없습니다.',
            noPinned: '고정된 동작을 찾을 수 없습니다.',
            errorLoading: '디렉터리 로딩 중 오류 발생.',
            noInstalledApps: '아직 설치된 애플리케이션이 없습니다.',
        },
    },
    popup: {
        tabs: {
            launch: '새로 시작',
            sessions: '활성 세션',
            manageFiles: '파일 관리',
            uploadStorage: '스토리지에 업로드',
            uploadFiles: '파일 업로드',
            uploadFilesTitle: '전용 파일 업로드 페이지 열기'
        },
        launchView: {
            searchPlaceholder: '애플리케이션 검색...',
            uploadingFile: '파일 업로드 중...',
            gpuLabel: 'GPU',
            storageLabel: '스토리지',
            languageLabel: '언어',
            cleanroom: '클린룸 (임시)',
            noGpu: '없음',
            saveOptions: '이 시작 옵션 저장',
            saveOptionsForUrl: '모든 URL에 대해 옵션 저장',
            saveOptionsForFile: '.{extension} 파일에 대해 옵션 저장',
            openFile: '시작 시 파일 열기',
            launchButton: '시작',
            launchingButton: '시작 중...',
            uploadingButton: '업로드 중...',
            autoHome: '자동 (앱별 영속성)',
            collaborationMode: '공동 작업 세션',
            waylandMode: 'Wayland 모드',
        },
        sessionsView: {
            noSessions: '활성 세션이 없습니다.',
        },
        uploadStorageView: {
            selectHome: '홈 디렉터리 선택',
            description: '이 작업은 파일 <strong>{filename}</strong>을(를) 나중에 사용할 수 있도록 파일 저장소에 직접 업로드합니다.',
            descriptionFallback: '이 작업은 파일 <strong>{filename}</strong>을(를) 나중에 사용할 수 있도록 파일 저장소에 직접 업로드합니다.',
            uploadButton: '파일 업로드',
            uploadingButton: '업로드 중...',
            preparing: '파일 준비 중...',
            uploadingChunk: '{total} 중 {current}번째 청크 업로드 중...',
            finalizing: '마무리 중...',
            uploadComplete: '업로드 완료!',
        },
        status: {
            unconfigured: '옵션 페이지를 통해 확장 프로그램을 구성하세요.',
            openingServerFile: "서버 측 파일 여는 중: {filename}",
            openingFile: '파일 여는 중: {filename}',
            openingUrl: 'URL 여는 중: {targetUrl}',
            error: '오류: {message}',
            preparingFile: '파일 준비 중...',
            sendingFile: '세션으로 파일 보내는 중...',
            errorSendingFile: '파일 전송 오류: {message}',
            errorClosingSession: '세션 닫기 오류: {message}',
            preparingSession: '격리된 세션 준비 중...',
            fetchingData: '파일 데이터 가져오는 중...',
            fetchDataFailed: '파일 데이터 가져오기 실패: {statusText}',
            unknownAction: '알 수 없는 시작 작업입니다.',
            noAppSelected: '애플리케이션을 선택하세요.',
            noAppsAvailable: '계정에서 사용할 수 있는 애플리케이션이 없습니다.',
            uploadSuccess: '파일이 성공적으로 업로드되었습니다!',
            creatingAutoHome: '자동 홈 디렉터리 생성 중...',
        },
        languages: {
            default: '기본값 ({locale})'
        }
    },
    upload: {
        title: '파일 업로드',
        description: '컴퓨터에서 파일을 선택하여 안전하고 격리된 세션에서 여세요.',
        dropzone: {
            title: '여기에 파일을 드래그 앤 드롭하세요',
            or: '또는',
            button: '파일 선택',
        },
        confirm: {
            ready: '파일을 안전하게 열 준비가 되었습니다.',
            button: '계속해서 시작',
        }
    },
    files: {
        title: 'SealSkin 파일',
        header: {
            title: '파일',
            newFolder: '새 폴더',
            uploadFiles: '파일 업로드',
            uploadFolder: '폴더 업로드'
        },
        sidebar: {
            sharedFiles: 'SealSkin 파일',
            publicShares: '공개 공유'
        },
        shares: {
            title: '공개적으로 공유된 파일',
            searchPlaceholder: '파일 이름 또는 ID로 검색...'
        },
        table: {
            name: '이름',
            size: '크기',
            lastModified: '마지막 수정',
            created: '생성됨',
            expires: '만료',
            url: '공개 URL',
            passwordProtected: '비밀번호'
        },
        dropzone: {
            title: '업로드할 파일을 여기에 놓으세요'
        },
        pagination: {
            previous: '« 이전',
            next: '다음 »',
            pageOf: '페이지 {page} / {totalPages}'
        },
        modals: {
            newFolder: {
                title: '새 폴더 만들기',
                folderNameLabel: '폴더 이름',
                nameTitle: '문자, 숫자, 밑줄, 하이픈 또는 마침표만 사용하세요.',
                createButton: '만들기'
            },
            confirmDelete: {
                title: '삭제 확인',
                message: '선택한 {count, plural, one {1개 항목을} other {{count}개 항목을}} 정말 삭제하시겠습니까? 이 작업은 되돌릴 수 없습니다.',
                messageDefault: '선택한 항목을 정말 삭제하시겠습니까? 이 작업은 되돌릴 수 없습니다.'
            },
            uploadProgress: {
                title: '업로드 진행률',
                doneButton: '완료'
            },
            share: {
                title: '파일 공유',
                sharingFile: '파일 공유 중: <strong>{filename}</strong>',
                passwordLabel: '비밀번호 (선택 사항)',
                passwordPlaceholder: '비밀번호 없이 공유하려면 비워두세요',
                expiryLabel: '만료 시간 (시간, 선택 사항)',
                expiryPlaceholder: '예: 하루는 24',
                shareButton: '공유 링크 만들기'
            }
        },
        status: {
            homeDirLoadFailed: '홈 디렉터리 로드 실패: {error}',
            filesLoadFailed: '파일 로드 오류: {error}',
            deleteProtectedError: '보호된 시스템 폴더는 삭제할 수 없습니다.',
            deletingItems: '{count, plural, one {1개 항목} other {{count}개 항목}} 삭제 중...',
            deleteSuccess: '삭제 성공.',
            deleteFailed: '삭제 실패: {error}',
            preparingUpload: '{count, plural, one {1개 파일} other {{count}개 파일}} 업로드 준비 중...',
            uploadPrepFailed: '폴더 업로드 준비 중 오류 발생: {error}',
            notConfigured: '오류: SealSkin이 구성되지 않았습니다. 옵션에서 설정하십시오.',
            folderCreated: '\'{folderName}\' 폴더가 생성되었습니다.',
            folderCreateFailed: '폴더 생성 오류: {error}',
            shareCreated: '공유가 성공적으로 생성되었습니다! 링크가 클립보드에 복사되었습니다.',
            shareCreateFailed: '공유 생성 실패: {error}',
            sharesLoadFailed: '공유된 파일을 불러오지 못했습니다: {error}',
            shareDeleteFailed: '공유 삭제 실패: {error}',
            shareDeleted: '공유가 성공적으로 삭제되었습니다.',
            urlCopied: '공개 URL이 클립보드에 복사되었습니다.'
        },
        placeholders: {
            errorLoading: '파일 로드 오류.',
            folderEmpty: '이 폴더는 비어 있습니다.',
            noHomeDirs: '사용 가능한 홈 디렉터리가 없습니다.',
            noShares: '아직 공유한 파일이 없습니다.'
        },
        uploadStatus: {
            pending: '대기 중',
            initiating: '시작 중...',
            uploading: '업로드 중...',
            finalizing: '마무리 중...',
            completed: '완료됨',
            error: '오류'
        }
    }
};

// --- Japanese Translations ---
const ja = {
    background: {
        contextMenu: {
            openUrl: 'SealSkinでリンクを開く',
            openFile: 'リンク先をファイルとしてSealSkinで開く',
            sendMedia: 'メディアをSealSkinに送信',
            searchText: 'SealSkinで「{selection}」を検索',
            sendDownload: '次のダウンロードをSealSkinに送信'
        }
    },
    common: {
        actions: 'アクション',
        active: 'アクティブ',
        cancel: 'キャンセル',
        manage: '管理',
        delete: '削除',
        edit: '編集',
        save: '保存',
        none: 'なし',
        error: 'エラー',
        na: 'N/A',
        of: '/',
        status: 'ステータス',
        username: 'ユーザー名',
        group: 'グループ',
        groups: 'グループ',
        publicKey: '公開鍵',
        name: '名前',
        source: 'ソース',
        imageVersion: 'イメージバージョン',
        language: '言語',
        storage: 'ストレージ',
        gpu: 'GPU',
        version: 'バージョン',
        checked: 'チェック済み',
        never: 'なし',
        stop: '停止',
        reopen: '再開',
        sendFile: 'ファイルを送信',
        share: '共有',
        search: '検索',
        refresh: '更新',
        close: '閉じる',
        copy: 'コピー',
        open: "開く",
        copyUrl: 'URLをコピー',
        download: 'ダウンロード',
        next: '次へ',
        previous: '前へ',
        page: 'ページ',
        home: 'ホーム',
        homes: 'ホーム',
        sessions: 'セッション',
        users: 'ユーザー',
        admins: '管理者',
        yes: 'はい',
        no: 'いいえ',
        daysAgo: '{count}日前',
        hoursAgo: '{count}時間前',
        minutesAgo: '{count}分前',
        justNow: 'たった今',
        bytes: 'バイト',
        kb: 'KB',
        mb: 'MB',
        gb: 'GB',
        tb: 'TB',
        pb: 'PB',
    },
    options: {
        sidebar: {
            config: '設定',
            home: 'ホームディレクトリ',
            sessions: 'アクティブなセッション',
            pinned: 'ピン留めされた動作',
            appStore: 'アプリストア',
            appTemplates: 'アプリテンプレート',
            appLaboratory: 'アプリラボ',
            installedApps: 'インストール済みアプリ',
            users: 'ユーザー',
            groups: 'グループ',
            admins: '管理者',
        },
        dashboard: {
            title: 'ダッシュボード',
            clientSettings: 'クライアント設定',
            exportConfig: '設定をエクスポート',
            userStatus: 'ユーザーステータス',
            loggedInAs: 'ログイン中のユーザー:',
            role: '役割',
            roleAdmin: '管理者',
            roleUser: '標準ユーザー',
            serverInfo: 'サーバー情報',
            server: 'サーバー:',
            cpuModel: 'CPUモデル:',
            storageUsage: 'ストレージ使用量:',
            detectedGpus: '検出されたGPU:',
            logout: 'ログアウトして設定をクリア',
            howTo: 'SealSkinの使い方',
            howToDescription: 'このセクションには、拡張機能の基本的な使い方に関するドキュメントが含まれています。',
            howToList: [
                '<strong>隔離環境でコンテンツを開くには:</strong> リンク、画像、または選択したテキストを右クリックし、「SealSkin Isolation」コンテキストメニューからオプションを選択します。',
                '<strong>ダウンロードを隔離環境に送信するには:</strong> ページを右クリックし、「次のダウンロードを隔離環境に送信」を選択します。次にダウンロードするファイルが傍受され、安全なセッションに送信されます。',
                '<strong>クリーンなアプリケーションを起動するには:</strong> ブラウザのツールバーにあるSealSkinアイコンをクリックします。',
                '<strong>永続ストレージを管理するには:</strong> このページの「ホームディレクトリ」タブを使用して、複数のセッションで使用できるストレージボリュームを作成および削除します。',
                '<strong>起動オプションを保存するには:</strong> 特定のファイルタイプ（例：.pdf）またはすべてのURLに対してアプリケーションを起動する前に、ポップアップの「これらの起動オプションを保存する」チェックボックスをオンにします。これらの保存された設定は、「ピン留めされた動作」タブで管理します。'
            ],
            confirmLogout: '本当にログアウトしますか？このブラウザに保存されている設定がすべてクリアされます。',
        },
        config: {
            quickSetup: 'クイックセットアップ',
            quickSetupDescription: '管理者から提供された設定ファイル（.json）をアップロードするか、以下の内容を貼り付けて拡張機能を自動的に設定します。',
            uploadLabel: '設定ファイルをアップロード',
            pasteLabel: 'または設定テキストを貼り付け',
            pastePlaceholder: 'ここにJSON設定を貼り付けてください...',
            applyButton: '設定を適用',
            manualLink: '手動設定',
            advancedTitle: 'クライアント設定（詳細）',
            serverIpLabel: 'サーバーIPまたはドメイン',
            serverIpPlaceholder: '例: 192.168.1.100',
            apiPortLabel: 'APIポート',
            apiPortPlaceholder: '例: 8000',
            sessionPortLabel: 'セッションポート',
            sessionPortPlaceholder: '例: 8443',
            usernameLabel: 'ユーザー名',
            usernamePlaceholder: 'あなたのユーザー名',
            privateKeyLabel: 'あなたの秘密鍵（PEM形式）',
            privateKeyPlaceholder: 'ここに秘密鍵の内容を貼り付けてください',
            serverKeyLabel: 'サーバー公開鍵（PEM形式）',
            serverKeyPlaceholder: 'ここにserver_public.pemの内容を貼り付けてください',
            searchEngineLabel: '選択したテキストのデフォルト検索エンジン',
            saveButton: '設定を保存',
            loginButton: 'ログインしてテスト',
            automaticLink: '自動設定',
            chooseFile: 'ファイルを選択',
            keyGeneration: 'キー生成',
            keyGenDescription: 'キーペアがない場合は、ここで生成できます。秘密鍵は上に記入されます。公開鍵を管理者に提供してください。',
            generateKeyButton: '新しいキーペアを生成',
            publicKeyForAdminLabel: 'あなたの公開鍵（管理者向け）',
        },
        home: {
            title: 'あなたのホームディレクトリ',
            description: 'セッション間で利用できる永続ストレージディレクトリを作成します。これらは設定ディレクトリとしてアプリケーションにマウントされます。',
            newTitle: '新しいホームディレクトリを作成',
            nameLabel: 'ディレクトリ名:',
            namePlaceholder: '例: my-project-files',
            nameTitle: '文字、数字、アンダースコア、ハイフンのみを使用してください。',
            createButton: 'ディレクトリを作成',
            confirmDelete: 'ホームディレクトリ \'{homeName}\' を本当に削除しますか？内部のすべてのデータは完全に失われます。',
        },
        sessions: {
            title: 'アクティブなセッション',
            application: 'アプリケーション',
            started: '開始日時',
            noSessionsUser: 'アクティブなセッションが見つかりません。',
            noSessionsAdmin: 'どのユーザーにもアクティブなセッションが見つかりません。',
            sessionsFor: '{username}のセッション ({count})',
            confirmStop: 'このセッションを本当に停止しますか？コンテナは破棄されます。',
        },
        pinned: {
            title: 'ピン留めされた拡張機能の動作',
            description: 'この表は、特定のファイルタイプまたはすべてのURLに対して保存した起動オプションを示しています。ピン留めされた動作を削除すると、再度起動オプションを尋ねられるようになります。',
            trigger: 'トリガー',
            savedApp: '保存されたアプリケーション',
            triggerSimple: 'シンプル起動（ツールバーボタン）',
            triggerUrl: 'すべてのURL（コンテキストメニューから）',
            triggerFile: 'ファイルタイプ: <strong>{fileType}</strong>',
            unknownApp: '不明なアプリ ({appId}...)'
        },
        admins: {
            serverKeyTitle: 'サーバー公開鍵',
            serverKeyDescription: 'これは、ユーザー設定ファイルがこのサーバーに接続するために必要な公開鍵です。',
            title: '管理者管理',
            searchPlaceholder: '管理者で検索...',
            newTitle: '新しい管理者を作成',
            publicKeyOptionalLabel: '公開鍵（オプション）:',
            publicKeyPlaceholder: 'ここに公開鍵を貼り付けるか、空欄にして生成します。',
            createButton: '管理者を作成',
            confirmDelete: '管理者 \'{username}\' を本当に削除しますか？これを行うと、その管理者の永続ストレージもすべて削除され、元に戻すことはできません。',
        },
        users: {
            title: 'ユーザー管理',
            searchPlaceholder: '名前またはグループでユーザーを検索...',
            newTitle: '新しいユーザーを作成',
            publicKeyOptionalLabel: '公開鍵（オプション）:',
            publicKeyPlaceholder: 'ここにユーザーの公開鍵を貼り付けるか、空欄にして生成します。',
            settingsTitle: 'ユーザー設定',
            sessionLimitLabel: 'セッション制限',
            sessionLimitTitle: 'ユーザーが持つことができるアクティブなセッションの数。-1で無制限。',
            permissionsTitle: '権限と強化',
            activeAccount: 'アクティブなアカウント',
            allowStorage: '永続ストレージを許可',
            allowGpu: 'GPUアクセスを許可',
            hardenContainer: 'コンテナを強化',
            hardenWm: 'ウィンドウマネージャを強化',
            createButton: 'ユーザーを作成',
            homesDisabledTooltip: 'このユーザーの永続ストレージは無効です',
            confirmDelete: 'ユーザー \'{username}\' を本当に削除しますか？これを行うと、そのユーザーの永続ストレージもすべて削除され、元に戻すことはできません。',
            allowPublicSharing: '公開ファイル共有を許可する',
        },
        groups: {
            title: 'グループ管理',
            searchPlaceholder: 'グループで検索...',
            newTitle: '新しいグループを作成',
            nameLabel: 'グループ名:',
            overrideTitle: 'グループの上書き設定',
            permissionsTitle: '権限と強化の上書き',
            createButton: 'グループを作成',
            confirmDelete: 'グループ \'{groupName}\' を本当に削除しますか？このグループのユーザーは個々の設定に戻ります。',
        },
        installedApps: {
            title: 'インストール済みアプリケーション',
            searchPlaceholder: 'インストール済みアプリを検索...',
            noAppsFound: 'インストール済みのアプリが見つかりません。',
            pulling: '新しいイメージをプルしています...',
            notLocal: 'イメージがローカルに見つかりません',
            isLaboratory: 'これは、基本イメージにカスタム設定を加えて構築されたラボアプリです。',
            laboratory: 'ラボ',
            confirmDelete: 'インストール済みのアプリ \'{appName}\' を本当に削除しますか？'
        },
        appStore: {
            title: 'アプリストア',
            refreshTitle: '選択したストアを更新',
            selectLabel: 'アプリストアを選択',
            addLabel: '新しいアプリストアを追加',
            namePlaceholder: 'ストア名',
            urlPlaceholder: 'ストアのYAML URL',
            availableTitle: '利用可能なアプリ',
            addManual: "手動アプリを追加",
            searchPlaceholder: '利用可能なアプリを検索...',
            noAppsFound: 'アプリケーションが見つかりません。',
            availableFrom: '{storeName} から利用可能なアプリ',
            couldNotLoad: 'このストアからアプリを読み込めませんでした。',
        },
        appTemplates: {
            title: 'アプリケーションテンプレートエディタ',
            loadLabel: 'テンプレートを読み込む',
            createOption: '新しいテンプレートを作成',
            nameLabel: 'テンプレート名',
            namePlaceholder: '新しいテンプレートの名前を入力してください',
            saveButton: 'プロファイルを保存',
            deleteButton: '削除',
            previewTitle: 'UIプレビュー',
            contentArea: 'アプリケーションコンテンツエリア',
            confirmDelete: 'テンプレート \'{templateName}\' を本当に削除しますか？この操作は元に戻せません。',
            deleteDisabled: 'このテンプレートは削除できません。',
            enterName: '新しいテンプレートの名前を入力してください。',
            settings: {
                TITLE: { label: "ページタイトル", description: "ウェブブラウザに表示されるページタイトルです。" },
                SELKIES_UI_TITLE: { label: "サイドバータイトル", description: "サイドバーの左上に表示されるタイトルです。" },
                SELKIES_UI_SHOW_SIDEBAR: { label: "サイドバーを表示", description: "メインのサイドバーUIを表示します。" },
                SELKIES_UI_SHOW_LOGO: { label: "ロゴを表示", description: "サイドバーにSelkiesのロゴを表示します。" },
                SELKIES_UI_SHOW_CORE_BUTTONS: { label: "コアボタンを表示", description: "コアコンポーネントのボタン（ディスプレイ、オーディオなど）を表示します。" },
                SELKIES_UI_SIDEBAR_SHOW_VIDEO_SETTINGS: { label: "ビデオ設定を表示", description: "サイドバーにビデオ設定セクションを表示します。" },
                SELKIES_UI_SIDEBAR_SHOW_SCREEN_SETTINGS: { label: "画面設定を表示", description: "サイドバーに画面設定セクションを表示します。" },
                SELKIES_UI_SIDEBAR_SHOW_AUDIO_SETTINGS: { label: "オーディオ設定を表示", description: "サイドバーにオーディオ設定セクションを表示します。" },
                SELKIES_UI_SIDEBAR_SHOW_STATS: { label: "統計情報を表示", description: "サイドバーに統計情報セクションを表示します。" },
                SELKIES_UI_SIDEBAR_SHOW_CLIPBOARD: { label: "クリップボードを表示", description: "サイドバーにクリップボードセクションを表示します。" },
                SELKIES_UI_SIDEBAR_SHOW_FILES: { label: "ファイルセクションを表示", description: "サイドバーにファイル転送セクションを表示します。" },
                SELKIES_UI_SIDEBAR_SHOW_APPS: { label: "アプリセクションを表示", description: "サイドバーにアプリケーションセクションを表示します。" },
                SELKIES_UI_SIDEBAR_SHOW_SHARING: { label: "共有セクションを表示", description: "サイドバーに共有セクションを表示します。" },
                SELKIES_UI_SIDEBAR_SHOW_GAMEPADS: { label: "ゲームパッドセクションを表示", description: "サイドバーにゲームパッドセクションを表示します。" },
                SELKIES_UI_SIDEBAR_SHOW_KEYBOARD_BUTTON: { label: "キーボードボタンを表示", description: "オンスクリーンキーボードボタンを表示します。" },
                SELKIES_UI_SIDEBAR_SHOW_SOFT_BUTTONS: { label: "ソフトボタンを表示", description: "ソフトボタンセクション（モバイル用）を表示します。" },
                WATERMARK_PNG: { label: "ウォーターマークPNGパス", description: "コンテナ内のウォーターマークpngへのフルパス。" },
                WATERMARK_LOCATION: { label: "ウォーターマークの位置", description: "ストリーム上に画像をどこに描画するか。", options: { disabled: "無効", topLeft: "左上", topRight: "右上", bottomLeft: "左下", bottomRight: "右下", centered: "中央", animated: "アニメーション" } },
                DASHBOARD: { label: "ダッシュボードスタイル", description: "ユーザーがダッシュボードを設定できます。", options: { default: "デフォルト", selkiesDefault: "Selkies（デフォルト）", zinc: "Zinc", wish: "Wish" } },
                SELKIES_AUDIO_ENABLED: { label: "オーディオを有効化", description: "サーバーからクライアントへのオーディオストリーミングを有効にします。" },
                SELKIES_MICROPHONE_ENABLED: { label: "マイクを有効化", description: "クライアントからサーバーへのマイク転送を有効にします。" },
                SELKIES_GAMEPAD_ENABLED: { label: "ゲームパッドを有効化", description: "ゲームパッドのサポートを有効にします。" },
                SELKIES_CLIPBOARD_ENABLED: { label: "クリップボードを有効化", description: "クリップボードの同期を有効にします。" },
                SELKIES_ENABLE_BINARY_CLIPBOARD: { label: "バイナリクリップボードを有効化", description: "クリップボード上のバイナリデータ（画像）を許可します。" },
                SELKIES_COMMAND_ENABLED: { label: "コマンドWebsocketを有効化", description: "コマンドWebsocketメッセージの解析を有効にします。" },
                SELKIES_FILE_TRANSFERS: { label: "ファイル転送", description: "許可される方向（'upload,download', 'upload', 'download', 'none'）。" },
                SELKIES_ENABLE_SHARING: { label: "すべての共有を有効化", description: "すべての共有機能のマスター切り替え。" },
                SELKIES_SECOND_SCREEN: { label: "セカンドスクリーンを有効化", description: "2番目のモニター/ディスプレイのサポートを有効にします。" },
                SELKIES_USE_BROWSER_CURSORS: { label: "ブラウザカーソルを使用", description: "キャンバスにレンダリングする代わりにブラウザのCSSカーソルを使用します。" },
                SELKIES_USE_CSS_SCALING: { label: "CSSスケーリングを使用（LoDPI）", description: "trueの場合、低解像度が送信され、キャンバスが引き伸ばされます。" },
                SELKIES_IS_MANUAL_RESOLUTION_MODE: { label: "手動解像度モード", description: "解像度を手動の幅/高さの値に固定します。" },
                SELKIES_MANUAL_WIDTH: { label: "手動幅", description: "幅を固定値にロックします。手動モードを強制します。" },
                SELKIES_MANUAL_HEIGHT: { label: "手動高さ", description: "高さを固定値にロックします。手動モードを強制します。" },
                SELKIES_SCALING_DPI: { label: "UIスケーリングDPI", description: "UIスケーリングのデフォルトDPI。" },
                SELKIES_AUDIO_BITRATE: { label: "オーディオビットレート", description: "デフォルトのオーディオビットレート。" },
                SELKIES_ENCODER: { label: "エンコーダー", description: "エンコーダーのカンマ区切りリスト。最初のものがデフォルトです。" },
                SELKIES_USE_CPU: { label: "CPUエンコーディングを強制", description: "pixelfluxのCPUベースのエンコーディングを強制します。" },
                SELKIES_FRAMERATE: { label: "フレームレート（範囲または固定）", description: "例: 範囲の場合は'8-120'、固定の場合は'60'。" },
                SELKIES_H264_CRF: { label: "H.264 CRF（範囲または固定）", description: "例: 範囲の場合は'5-50'、固定の場合は'25'。" },
                SELKIES_JPEG_QUALITY: { label: "JPEG品質（範囲または固定）", description: "例: 範囲の場合は'1-100'、固定の場合は'60'。" },
                SELKIES_H264_FULLCOLOR: { label: "H.264フルカラー", description: "pixelfluxエンコーダーのH.264フルカラーレンジを有効にします。" },
                SELKIES_H264_STREAMING_MODE: { label: "H.264ストリーミング（ターボ）モード", description: "H.264低遅延ストリーミングモードを有効にします。" },
                SELKIES_USE_PAINT_OVER_QUALITY: { label: "ペイントオーバー品質を使用", description: "静的なシーンに対して高品質のペイントオーバーを有効にします。" },
                SELKIES_PAINT_OVER_JPEG_QUALITY: { label: "ペイントオーバーJPEG品質", description: "例: 範囲の場合は'1-100'、固定の場合は'90'。" },
                SELKIES_H264_PAINTOVER_CRF: { label: "ペイントオーバーH.264 CRF", description: "例: 範囲の場合は'5-50'、固定の場合は'18'。" },
                SELKIES_H264_PAINTOVER_BURST_FRAMES: { label: "ペイントオーバーバーストフレーム", description: "例: 範囲の場合は'1-30'、固定の場合は'5'。" },
                HARDEN_DESKTOP: { label: "デスクトップを強化（プリセット）", description: "DISABLE_OPEN_TOOLS、DISABLE_SUDO、DISABLE_TERMINALSを有効にします。" },
                HARDEN_OPENBOX: { label: "ウィンドウマネージャを強化（プリセット）", description: "DISABLE_CLOSE_BUTTON、DISABLE_MOUSE_BUTTONS、HARDEN_KEYBINDSを有効にします。RESTART_APPも有効にします。" },
                DISABLE_OPEN_TOOLS: { label: "オープンツールを無効化", description: "xdg-openおよびexo-openバイナリを無効にします。" },
                DISABLE_SUDO: { label: "Sudoを無効化", description: "sudoコマンドを無効にします。" },
                DISABLE_TERMINALS: { label: "ターミナルを無効化", description: "一般的なターミナルエミュレータを無効にします。" },
                DISABLE_CLOSE_BUTTON: { label: "ウィンドウ閉じるボタンを無効化", description: "ウィンドウのタイトルバーから閉じるボタンを削除します。" },
                DISABLE_MOUSE_BUTTONS: { label: "右/中クリックを無効化", description: "右クリックおよび中クリックのコンテキストメニューを無効にします。" },
                HARDEN_KEYBINDS: { label: "キーバインドを強化", description: "Alt+F4などのデフォルトのOpenboxキーバインドを無効にします。" },
                RESTART_APP: { label: "終了時にアプリを再起動", description: "メインアプリケーションが閉じられた場合に自動的に再起動します。" },
                MAX_RES: { label: "最大解像度", description: "コンテナの最大解像度、デフォルトは16kです。" },
                START_DOCKER: { label: "Docker-in-Dockerを開始", description: "falseの場合、特権コンテナはDinDを開始しません。" },
                DISABLE_IPV6: { label: "IPv6を無効化", description: "trueの場合、IPv6を無効にします。" },
                DISABLE_ZINK: { label: "Zinkを無効化", description: "ビデオカードが検出された場合、Zink環境変数を設定しません。" },
                DISABLE_DRI3: { label: "DRI3を無効化", description: "ビデオカードが検出された場合、DRI3アクセラレーションを使用しません。" },
                NO_DECOR: { label: "ウィンドウ装飾なし", description: "PWA用途のためにウィンドウボーダーなしでアプリケーションを実行します。" },
                NO_FULL: { label: "フルスクリーンなし", description: "アプリケーションを自動的にフルスクリーンにしません。" },
                NO_GAMEPAD: { label: "ゲームパッドインジェクションを無効化", description: "ユーザースペースのゲームパッドインターポーザーインジェクションを無効にします。" },
                SELKIES_DEBUG: { label: "Selkiesデバッグを有効化", description: "ストリーミングコンポーネントのデバッグロギングを有効にします。" },
            }
        },
        appLaboratory: {
            title: 'アプリラボ',
            description: '基本アプリの上に変更を重ねて、カスタムアプリケーション設定を作成およびテストします。',
            selectApp: 'アプリを選択',
            createNew: '新しいアプリを作成',
            baseApp: '基本アプリケーション',
            baseAppDescription: '新しいカスタムアプリの基になるインストール済みアプリケーション。',
            selectBase: '基本アプリを選択',
            customizationTitle: 'カスタマイズ',
            appName: 'アプリ名',
            appIcon: 'アプリアイコン',
            uploadIcon: 'アイコンをアップロード',
            autostartScriptLabel: 'カスタム自動起動スクリプト',
            permissionsTitle: '権限',
            usersLabel: '許可されたユーザー',
            groupsLabel: '許可されたグループ',
            launchButton: '保存してカスタマイズセッションを開始',
            closeButton: 'セッションを閉じて確定',
            savingAndLaunching: '保存して起動中...',
            placeholder: 'アプリラボでは、既存のインストール済みアプリケーションに基づいて、アプリケーションの基本ホームディレクトリと起動スクリプトを設定できます。このホームディレクトリは、このセッションで設定したすべてのファイルと設定とともに、ユーザーの初回初期化時にコピーされます。既存のラボアプリを再起動して、その内容をさらに変更することができます。',
            formInvalid: '基本アプリを選択し、新しいアプリの名前を入力してください。',
        },
        modals: {
            editUserTitle: 'ユーザー編集: {username}',
            saveChanges: '変更を保存',
            effectiveSettings: '有効な設定（グループの上書きを含む）',
            editGroupTitle: 'グループ編集: {groupName}',
            userConfigTitle: 'ユーザー設定',
            warning: 'この設定が表示されるのはこの一度きりです。ユーザーに安全に提供してください。',
            info: 'この設定ファイルをダウンロードすると、他のデバイスでSealSkinを簡単にセットアップできます。このファイルには秘密鍵が含まれているため、安全に保管してください。',
            configDataLabel: '設定データ（JSON）',
            copyButton: 'テキストをコピー',
            downloadButton: 'ファイルをダウンロード',
            manageHomeDirs: 'ホームディレクトリを管理',
            dirsForUser: 'ユーザーのディレクトリ: {username}',
            dirsForAdmin: '管理者のディレクトリ: {username}',
            newDirForUser: 'ユーザー用の新しいディレクトリを作成',
            createDirButton: 'ディレクトリを作成',
            confirmDeleteDir: 'ユーザー \'{username}\' の \'{homeName}\' を本当に削除しますか？この操作は永続的です。',
            installAppTitle: '{appName} をインストール',
            editAppTitle: '{appName} を編集',
            customNameLabel: 'カスタム名',
            imageLabel: 'コンテナイメージ',
            permissions: '権限',
            allowedUsersLabel: '許可されたユーザー（カンマ区切り、\'all\'で全員）',
            allowedGroupsLabel: '許可されたグループ（カンマ区切り、\'all\'で全員）',
            features: '機能',
            gpuSupport: 'GPUサポート',
            homeMounting: 'ホームディレクトリのマウント',
            urlSupport: 'URLを開くサポート',
            fileSupport: 'ファイルを開くサポート',
            autoUpdate: 'イメージを自動更新',
            advancedSettings: '詳細設定',
            appTemplateLabel: 'アプリケーションテンプレート',
            appTemplateDescription: '詳細なコンテナ起動設定のために、事前設定されたテンプレートを選択します。',
            customAutostartScriptLabel: 'カスタム自動起動スクリプト',
            customAutostartScriptDescription: '自動起動ロジックをカスタマイズします。空白のままにすると、アプリケーションプロバイダーのデフォルトが使用されます。',
            saveInstallation: 'インストールを保存',
            updateStatusTitle: '{appName} の更新ステータス',
            checkingUpdates: '更新を確認中...',
            updateAvailable: '新しいイメージバージョンが利用可能です！',
            yourVersion: 'あなたのバージョン: {sha}',
            latestAvailable: '最新バージョンがレジストリからプル可能です。',
            pullLatest: '最新イメージをプル',
            upToDate: 'あなたのイメージは最新です。',
            currentVersion: '現在のバージョン: {sha}',
            errorChecking: '更新の確認中にエラーが発生しました。',
            pullingLatest: '最新イメージをプルしています... しばらくお待ちください。',
            pullComplete: 'プルが完了しました！',
            newVersion: '新しいバージョン: {sha}',
            errorPulling: 'イメージのプル中にエラーが発生しました。',
            manualInstallNote: "注意：手動で追加されたイメージは、selkies-baseimage互換のイメージに基づいている必要があります。",
        },
        status: {
            loggingIn: 'ログイン中...',
            configSaved: '設定が正常に保存されました！',
            configApplied: '設定が適用されました！ログインしてテストしてください。',
            configApplyFailed: '設定の適用に失敗しました: {error}',
            fileReadError: 'ファイルの読み取り中にエラーが発生しました。',
            noConfig: '設定ファイルまたはテキストを提供してください。',
            loggedInAdmin: '管理者としてログインしました: {username}',
            loggedInUser: '標準ユーザーとしてログインしました: {username}。',
            loginFailed: 'ログインに失敗しました: {error}',
            adminDataRefreshFailed: '管理者データの更新に失敗しました: {error}',
            logoutSuccess: 'ログアウトし、設定がクリアされました。',
            generateConfigFailed: 'ユーザーの詳細が不足しているため、設定を生成できませんでした。',
            copySuccess: '設定がクリップボードにコピーされました！',
            copyFailed: 'テキストのコピーに失敗しました。',
            publicKeyCopied: '公開鍵がコピーされました！',
            keyCopyFailed: '鍵のコピーに失敗しました。',
            creatingAdmin: '管理者を作成中...',
            adminCreated: '管理者 \'{username}\' が作成されました。',
            adminCreateFailed: '管理者の作成中にエラーが発生しました: {error}',
            adminDeleted: '管理者 \'{username}\' が正常に削除されました。',
            adminDeleteFailed: '管理者の削除中にエラーが発生しました: {error}',
            creatingUser: 'ユーザーを作成中...',
            userCreated: 'ユーザー \'{username}\' が作成されました。',
            userCreateFailed: 'ユーザーの作成中にエラーが発生しました: {error}',
            userDeleted: 'ユーザー \'{username}\' が正常に削除されました。',
            userDeleteFailed: 'ユーザーの削除中にエラーが発生しました: {error}',
            userUpdated: 'ユーザー \'{username}\' が正常に更新されました。',
            userUpdateFailed: 'ユーザーの更新中にエラーが発生しました: {error}',
            creatingGroup: 'グループを作成中...',
            groupCreated: 'グループ \'{groupName}\' が作成されました。',
            groupCreateFailed: 'グループの作成中にエラーが発生しました: {error}',
            groupDeleted: 'グループ \'{groupName}\' が正常に削除されました。',
            groupDeleteFailed: 'グループの削除中にエラーが発生しました: {error}',
            groupUpdated: 'グループ \'{groupName}\' が正常に更新されました。',
            groupUpdateFailed: 'グループの更新中にエラーが発生しました: {error}',
            homedirLoadFailed: 'ホームディレクトリの読み込みに失敗しました: {error}',
            homedirCreateFailed: 'ディレクトリの作成中にエラーが発生しました: {error}',
            homedirCreated: 'ホームディレクトリ \'{homeName}\' が作成されました。',
            homedirDeleted: 'ディレクトリ \'{homeName}\' が削除されました。',
            homedirDeleteFailed: 'ディレクトリの削除中にエラーが発生しました: {error}',
            homedirCreatedFor: '{username} のためにディレクトリ \'{homeName}\' が作成されました。',
            homedirDeletedFor: '{username} のためにディレクトリ \'{homeName}\' が削除されました。',
            sessionsLoadFailed: 'セッションの読み込みに失敗しました: {error}',
            sessionStopError: 'セッションの停止中にエラーが発生しました: {error}',
            sessionStopped: 'セッションが正常に停止しました。',
            appDataRefreshFailed: 'アプリデータの更新に失敗しました: {error}',
            closingSession: 'カスタマイズセッションをコミットしています...',
            sessionClosed: 'カスタマイズセッションが閉じられました。',
            sessionCloseFailed: 'カスタマイズセッションのクローズに失敗しました: {error}',
            fetchingApps: 'ストアからアプリを取得中...',
            fetchAppsFailed: 'ストアからのアプリの取得に失敗しました: {error}',
            appStoreAddFailed: 'ストアの追加中にエラーが発生しました: {error}',
            appStoreAdded: 'アプリストア \'{name}\' が追加されました。',
            appSaved: 'アプリ \'{name}\' が正常に{action}されました。',
            appSaveActions: {
                updated: '更新',
                installed: 'インストール'
            },
            appSaveFailed: 'アプリの保存中にエラーが発生しました: {error}',
            appDeleted: 'アプリ \'{name}\' が削除されました。',
            appDeleteFailed: 'アプリの削除中にエラーが発生しました: {error}',
            templateSaved: 'テンプレート \'{name}\' が正常に保存されました。',
            templateSaveFailed: 'テンプレートの保存中にエラーが発生しました: {error}',
            templateDeleted: 'テンプレート \'{name}\' が正常に削除されました。',
            templateDeleteFailed: 'テンプレートの削除中にエラーが発生しました: {error}',
            pinRemoved: 'ピン留めされた動作が削除されました。',
            keyGenerated: '新しいキーペアが生成されました。',
            keyGenFailed: 'キー生成に失敗しました: {{error}}',
            pendingConfigSaved: '保留中の設定が保存されました。管理者に公開鍵を提供できます。',
            settingsSaved: '設定が保存されました。',
            appCreated: 'アプリ「{name}」が正常に作成されました。',
            launchFailed: '起動に失敗しました: {error}',
        },
        placeholders: {
            noAdmins: '管理が見つかりません。',
            noUsers: 'ユーザーが見つかりません。',
            noGroups: 'グループが見つかりません。',
            noHomeDirs: 'ホームディレクトリが見つかりません。',
            noSessions: 'アクティブなセッションが見つかりません。',
            noPinned: 'ピン留めされた動作が見つかりません。',
            errorLoading: 'ディレクトリの読み込み中にエラーが発生しました。',
            noInstalledApps: 'まだアプリケーションがインストールされていません。',
        },
    },
    popup: {
        tabs: {
            launch: '新規起動',
            sessions: 'アクティブなセッション',
            manageFiles: 'ファイル管理',
            uploadStorage: 'ストレージにアップロード',
            uploadFiles: 'ファイルをアップロード',
            uploadFilesTitle: '専用のファイルアップロードページを開く'
        },
        launchView: {
            searchPlaceholder: 'アプリケーションを検索...',
            uploadingFile: 'ファイルをアップロード中...',
            gpuLabel: 'GPU',
            storageLabel: 'ストレージ',
            languageLabel: '言語',
            cleanroom: 'クリーンルーム（一時的）',
            noGpu: 'なし',
            saveOptions: 'これらの起動オプションを保存',
            saveOptionsForUrl: 'すべてのURLのオプションを保存',
            saveOptionsForFile: '.{extension} ファイルのオプションを保存',
            openFile: '起動時にファイルを開く',
            launchButton: '起動',
            launchingButton: '起動中...',
            uploadingButton: 'アップロード中...',
            autoHome: '自動 (アプリごとの永続化)',
            collaborationMode: '共同セッション',
            waylandMode: 'Waylandモード',
        },
        sessionsView: {
            noSessions: 'アクティブなセッションが見つかりません。',
        },
        uploadStorageView: {
            selectHome: 'ホームディレクトリを選択',
            description: 'これにより、ファイル <strong>{filename}</strong> がファイルストレージに直接アップロードされ、後で使用できるようになります。',
            descriptionFallback: 'これにより、ファイル <strong>{filename}</strong> がファイルストレージに直接アップロードされ、後で使用できるようになります。',
            uploadButton: 'ファイルをアップロード',
            uploadingButton: 'アップロード中...',
            preparing: 'ファイルを準備中...',
            uploadingChunk: 'チャンク {current} / {total} をアップロード中...',
            finalizing: '最終処理中...',
            uploadComplete: 'アップロード完了！',
        },
        status: {
            unconfigured: 'オプションページで拡張機能の設定を行ってください。',
            openingServerFile: "サーバー側のファイルを開いています: {filename}",
            openingFile: 'ファイルを開いています: {filename}',
            openingUrl: 'URLを開いています: {targetUrl}',
            error: 'エラー: {message}',
            preparingFile: 'ファイルを準備中...',
            sendingFile: 'セッションにファイルを送信中...',
            errorSendingFile: 'ファイルの送信中にエラーが発生しました: {message}',
            errorClosingSession: 'セッションの終了中にエラーが発生しました: {message}',
            preparingSession: '隔離セッションを準備中...',
            fetchingData: 'ファイルデータを取得中...',
            fetchDataFailed: 'ファイルデータの取得に失敗しました: {statusText}',
            unknownAction: '不明な起動アクションです。',
            noAppSelected: 'アプリケーションを選択してください。',
            noAppsAvailable: 'あなたのアカウントで利用可能なアプリケーションはありません。',
            uploadSuccess: 'ファイルが正常にアップロードされました！',
            creatingAutoHome: '自動ホームディレクトリを作成中...',
        },
        languages: {
            default: 'デフォルト ({locale})'
        }
    },
    upload: {
        title: 'ファイルアップロード',
        description: 'コンピュータからファイルを選択して、安全な隔離セッションで開きます。',
        dropzone: {
            title: 'ここにファイルをドラッグ＆ドロップ',
            or: 'または',
            button: 'ファイルを選択',
        },
        confirm: {
            ready: 'ファイルは安全に開く準備ができました。',
            button: '起動に進む',
        }
    },
    files: {
        title: 'SealSkin ファイル',
        header: {
            title: 'ファイル',
            newFolder: '新しいフォルダー',
            uploadFiles: 'ファイルをアップロード',
            uploadFolder: 'フォルダーをアップロード'
        },
        sidebar: {
            sharedFiles: 'SealSkin ファイル',
            publicShares: '公開共有'
        },
        shares: {
            title: '公開共有ファイル',
            searchPlaceholder: 'ファイル名またはIDで検索...'
        },
        table: {
            name: '名前',
            size: 'サイズ',
            lastModified: '最終更新日',
            created: '作成日時',
            expires: '有効期限',
            url: '公開URL',
            passwordProtected: 'パスワード'
        },
        dropzone: {
            title: 'ファイルをドロップしてアップロード'
        },
        pagination: {
            previous: '« 前へ',
            next: '次へ »',
            pageOf: 'ページ {page} / {totalPages}'
        },
        modals: {
            newFolder: {
                title: '新しいフォルダーを作成',
                folderNameLabel: 'フォルダー名',
                nameTitle: '文字、数字、アンダースコア、ハイフン、またはピリオドのみを使用してください。',
                createButton: '作成'
            },
            confirmDelete: {
                title: '削除の確認',
                message: '選択した{count, plural, one {1個のアイテム} other {{count}個のアイテム}}を本当に削除しますか？この操作は元に戻せません。',
                messageDefault: '選択したアイテムを本当に削除しますか？この操作は元に戻せません。'
            },
            uploadProgress: {
                title: 'アップロードの進捗',
                doneButton: '完了'
            },
            share: {
                title: 'ファイルを共有',
                sharingFile: 'ファイルを共有中: <strong>{filename}</strong>',
                passwordLabel: 'パスワード（任意）',
                passwordPlaceholder: 'パスワードなしの場合は空欄',
                expiryLabel: '有効期限（時間、任意）',
                expiryPlaceholder: '例：1日の場合は24',
                shareButton: '共有リンクを作成'
            }
        },
        status: {
            homeDirLoadFailed: 'ホームディレクトリの読み込みに失敗しました：{error}',
            filesLoadFailed: 'ファイルの読み込み中にエラーが発生しました：{error}',
            deleteProtectedError: '保護されたシステムフォルダーは削除できません。',
            deletingItems: '{count, plural, one {1個のアイテム} other {{count}個のアイテム}}を削除しています...',
            deleteSuccess: '削除に成功しました。',
            deleteFailed: '削除に失敗しました：{error}',
            preparingUpload: '{count, plural, one {1個のファイル} other {{count}個のファイル}}のアップロードを準備しています...',
            uploadPrepFailed: 'フォルダーのアップロード準備中にエラーが発生しました：{error}',
            notConfigured: 'エラー：SealSkinが設定されていません。オプションで設定してください。',
            folderCreated: 'フォルダー「{folderName}」が作成されました。',
            folderCreateFailed: 'フォルダーの作成中にエラーが発生しました：{error}',
            shareCreated: '共有が正常に作成されました！リンクがクリップボードにコピーされました。',
            shareCreateFailed: '共有の作成に失敗しました: {error}',
            sharesLoadFailed: '共有ファイルの読み込みに失敗しました: {error}',
            shareDeleteFailed: '共有の削除に失敗しました: {error}',
            shareDeleted: '共有が正常に削除されました。',
            urlCopied: '公開URLがクリップボードにコピーされました。'
        },
        placeholders: {
            errorLoading: 'ファイルの読み込み中にエラーが発生しました。',
            folderEmpty: 'このフォルダーは空です。',
            noHomeDirs: '利用可能なホームディレクトリがありません。',
            noShares: 'まだファイルを共有していません。'
        },
        uploadStatus: {
            pending: '保留中',
            initiating: '開始中...',
            uploading: 'アップロード中...',
            finalizing: '最終処理中...',
            completed: '完了',
            error: 'エラー'
        }
    }
};

// --- Vietnamese Translations ---
const vi = {
    background: {
        contextMenu: {
            openUrl: 'Mở liên kết trong SealSkin',
            openFile: 'Mở đích liên kết dưới dạng tệp trong SealSkin',
            sendMedia: 'Gửi phương tiện đến SealSkin',
            searchText: 'Tìm kiếm "%s" trong SealSkin',
            sendDownload: 'Gửi lượt tải xuống tiếp theo đến SealSkin'
        }
    },
    common: {
        actions: 'Hành động',
        active: 'Hoạt động',
        cancel: 'Hủy',
        manage: 'Quản lý',
        delete: 'Xóa',
        edit: 'Chỉnh sửa',
        save: 'Lưu',
        none: 'không có',
        error: 'Lỗi',
        na: 'K/C',
        of: 'của',
        status: 'Trạng thái',
        username: 'Tên người dùng',
        group: 'Nhóm',
        groups: 'Các nhóm',
        publicKey: 'Khóa công khai',
        name: 'Tên',
        source: 'Nguồn',
        imageVersion: 'Phiên bản Image',
        language: 'Ngôn ngữ',
        storage: 'Lưu trữ',
        gpu: 'GPU',
        version: 'Phiên bản',
        checked: 'Đã kiểm tra',
        never: 'Không bao giờ',
        stop: 'Dừng',
        reopen: 'Mở lại',
        sendFile: 'Gửi tệp',
        share: 'Chia sẻ',
        search: 'Tìm kiếm',
        refresh: 'Làm mới',
        close: 'Đóng',
        copy: 'Sao chép',
        open: "Mở",
        copyUrl: 'Sao chép URL',
        download: 'Tải xuống',
        next: 'Tiếp theo',
        previous: 'Trước đó',
        page: 'Trang',
        home: 'Thư mục chính',
        homes: 'Các thư mục chính',
        sessions: 'Phiên hoạt động',
        users: 'Người dùng',
        admins: 'Quản trị viên',
        yes: 'Có',
        no: 'Không',
        daysAgo: '{count, plural, one {1 ngày trước} other {{count} ngày trước}}',
        hoursAgo: '{count, plural, one {1 giờ trước} other {{count} giờ trước}}',
        minutesAgo: '{count, plural, one {1 phút trước} other {{count} phút trước}}',
        justNow: 'vừa xong',
        bytes: 'Bytes',
        kb: 'KB',
        mb: 'MB',
        gb: 'GB',
        tb: 'TB',
        pb: 'PB',
    },
    options: {
        sidebar: {
            config: 'Cấu hình',
            home: 'Thư mục chính',
            sessions: 'Phiên hoạt động',
            pinned: 'Hành vi đã ghim',
            appStore: 'Cửa hàng ứng dụng',
            appTemplates: 'Mẫu ứng dụng',
            appLaboratory: 'Phòng thí nghiệm ứng dụng',
            installedApps: 'Ứng dụng đã cài đặt',
            users: 'Người dùng',
            groups: 'Nhóm',
            admins: 'Quản trị viên',
        },
        dashboard: {
            title: 'Bảng điều khiển',
            clientSettings: 'Cài đặt máy khách',
            exportConfig: 'Xuất cấu hình',
            userStatus: 'Trạng thái người dùng',
            loggedInAs: 'Đăng nhập với tư cách:',
            role: 'Vai trò',
            roleAdmin: 'Quản trị viên',
            roleUser: 'Người dùng tiêu chuẩn',
            serverInfo: 'Thông tin máy chủ',
            server: 'Máy chủ:',
            cpuModel: 'Model CPU:',
            storageUsage: 'Sử dụng lưu trữ:',
            detectedGpus: 'GPU được phát hiện:',
            logout: 'Đăng xuất & Xóa cấu hình',
            howTo: 'Cách sử dụng SealSkin',
            howToDescription: 'Phần này chứa tài liệu cơ bản về cách sử dụng tiện ích mở rộng.',
            howToList: [
                '<strong>Để mở nội dung trong môi trường cách ly:</strong> Nhấp chuột phải vào bất kỳ liên kết, hình ảnh hoặc văn bản đã chọn nào và chọn một tùy chọn từ menu ngữ cảnh "SealSkin Isolation".',
                '<strong>Để gửi một tệp tải xuống vào môi trường cách ly:</strong> Nhấp chuột phải vào trang và chọn "Gửi tệp tải xuống tiếp theo vào môi trường cách ly". Tệp tiếp theo bạn tải xuống sẽ được chặn và gửi đến một phiên an toàn.',
                '<strong>Để khởi chạy một ứng dụng sạch:</strong> Nhấp vào biểu tượng SealSkin trên thanh công cụ của trình duyệt.',
                '<strong>Để quản lý lưu trữ lâu dài:</strong> Sử dụng tab "Thư mục chính" trên trang này để tạo và xóa các ổ đĩa lưu trữ có thể được sử dụng trên nhiều phiên.',
                '<strong>Để lưu các tùy chọn khởi chạy:</strong> Đánh dấu vào hộp "Lưu các tùy chọn khởi chạy này" trong cửa sổ bật lên trước khi khởi chạy ứng dụng cho một loại tệp cụ thể (ví dụ: .pdf) hoặc cho tất cả các URL. Quản lý các tùy chọn đã lưu này trong tab "Hành vi đã ghim".'
            ],
            confirmLogout: 'Bạn có chắc chắn muốn đăng xuất không? Thao tác này sẽ xóa cấu hình đã lưu của bạn khỏi trình duyệt này.',
        },
        config: {
            quickSetup: 'Thiết lập nhanh',
            quickSetupDescription: 'Tải lên tệp cấu hình (.json) do quản trị viên của bạn cung cấp hoặc dán nội dung của nó vào bên dưới để tự động thiết lập tiện ích mở rộng.',
            uploadLabel: 'Tải lên tệp cấu hình',
            pasteLabel: 'Hoặc dán văn bản cấu hình',
            pastePlaceholder: 'Dán cấu hình JSON của bạn vào đây...',
            applyButton: 'Áp dụng cấu hình',
            manualLink: 'Cấu hình thủ công',
            advancedTitle: 'Cấu hình máy khách (Nâng cao)',
            serverIpLabel: 'IP hoặc tên miền máy chủ',
            serverIpPlaceholder: 'ví dụ: 192.168.1.100',
            apiPortLabel: 'Cổng API',
            apiPortPlaceholder: 'ví dụ: 8000',
            sessionPortLabel: 'Cổng phiên',
            sessionPortPlaceholder: 'ví dụ: 8443',
            usernameLabel: 'Tên người dùng',
            usernamePlaceholder: 'Tên người dùng của bạn',
            privateKeyLabel: 'Khóa riêng của bạn (Định dạng PEM)',
            privateKeyPlaceholder: 'Dán nội dung khóa riêng của bạn vào đây',
            serverKeyLabel: 'Khóa công khai của máy chủ (Định dạng PEM)',
            serverKeyPlaceholder: 'Dán nội dung của server_public.pem vào đây',
            searchEngineLabel: 'Công cụ tìm kiếm mặc định cho văn bản đã chọn',
            saveButton: 'Lưu cấu hình',
            loginButton: 'Đăng nhập & Kiểm tra',
            automaticLink: 'Cấu hình tự động',
            chooseFile: 'Chọn tập tin',
            keyGeneration: 'Tạo khóa',
            keyGenDescription: 'Nếu bạn không có cặp khóa, bạn có thể tạo một cặp ở đây. Khóa riêng sẽ được điền vào ở trên. Cung cấp khóa công khai cho quản trị viên của bạn.',
            generateKeyButton: 'Tạo cặp khóa mới',
            publicKeyForAdminLabel: 'Khóa công khai của bạn (cho quản trị viên)',
        },
        home: {
            title: 'Các thư mục chính của bạn',
            description: 'Tạo các thư mục lưu trữ lâu dài để sử dụng trên các phiên. Chúng sẽ được gắn vào các ứng dụng của bạn dưới dạng thư mục cấu hình.',
            newTitle: 'Tạo thư mục chính mới',
            nameLabel: 'Tên thư mục:',
            namePlaceholder: 'ví dụ: my-project-files',
            nameTitle: 'Chỉ sử dụng chữ cái, số, dấu gạch dưới hoặc dấu gạch ngang.',
            createButton: 'Tạo thư mục',
            isLaboratory: 'Đây là một ứng dụng Phòng thí nghiệm, được xây dựng từ một image cơ sở với các cài đặt tùy chỉnh.',
            laboratory: 'Phòng thí nghiệm',
            confirmDelete: 'Bạn có chắc chắn muốn xóa ứng dụng đã cài đặt \'{appName}\' không?'
        },
        sessions: {
            title: 'Phiên hoạt động',
            application: 'Ứng dụng',
            started: 'Đã bắt đầu',
            noSessionsUser: 'Không tìm thấy phiên hoạt động nào.',
            noSessionsAdmin: 'Không tìm thấy phiên hoạt động nào cho bất kỳ người dùng nào.',
            sessionsFor: 'Phiên cho {username} ({count})',
            confirmStop: 'Bạn có chắc chắn muốn dừng phiên này không? Container sẽ bị hủy.',
        },
        pinned: {
            title: 'Hành vi tiện ích mở rộng đã ghim',
            description: 'Bảng này hiển thị các tùy chọn khởi chạy bạn đã lưu cho các loại tệp cụ thể hoặc cho tất cả các URL. Bạn có thể xóa một hành vi đã ghim để được nhắc lại các tùy chọn khởi chạy.',
            trigger: 'Kích hoạt',
            savedApp: 'Ứng dụng đã lưu',
            triggerSimple: 'Khởi chạy đơn giản (Nút thanh công cụ)',
            triggerUrl: 'Tất cả các URL (từ menu ngữ cảnh)',
            triggerFile: 'Loại tệp: <strong>{fileType}</strong>',
            unknownApp: 'Ứng dụng không xác định ({appId}...)'
        },
        admins: {
            serverKeyTitle: 'Khóa công khai của máy chủ',
            serverKeyDescription: 'Đây là khóa công khai mà các tệp cấu hình người dùng sẽ cần để kết nối với máy chủ này.',
            title: 'Quản lý quản trị viên',
            searchPlaceholder: 'Tìm kiếm quản trị viên...',
            newTitle: 'Tạo quản trị viên mới',
            publicKeyOptionalLabel: 'Khóa công khai (Tùy chọn):',
            publicKeyPlaceholder: 'Dán khóa công khai vào đây, hoặc để trống để tạo một khóa mới.',
            createButton: 'Tạo quản trị viên',
            confirmDelete: 'Bạn có chắc chắn muốn xóa quản trị viên \'{username}\' không? Thao tác này cũng sẽ xóa tất cả bộ nhớ lâu dài của họ và không thể hoàn tác.',
        },
        users: {
            title: 'Quản lý người dùng',
            searchPlaceholder: 'Tìm kiếm người dùng theo tên hoặc nhóm...',
            newTitle: 'Tạo người dùng mới',
            publicKeyOptionalLabel: 'Khóa công khai (Tùy chọn):',
            publicKeyPlaceholder: 'Dán khóa công khai của người dùng vào đây, hoặc để trống để tạo một khóa mới.',
            settingsTitle: 'Cài đặt người dùng',
            sessionLimitLabel: 'Giới hạn phiên',
            sessionLimitTitle: 'Số phiên hoạt động mà người dùng có thể có. -1 cho không giới hạn.',
            permissionsTitle: 'Quyền & Tăng cường bảo mật',
            activeAccount: 'Tài khoản hoạt động',
            allowStorage: 'Cho phép lưu trữ lâu dài',
            allowGpu: 'Cho phép truy cập GPU',
            hardenContainer: 'Tăng cường bảo mật Container',
            hardenWm: 'Tăng cường bảo mật trình quản lý cửa sổ',
            createButton: 'Tạo người dùng',
            homesDisabledTooltip: 'Lưu trữ lâu dài bị vô hiệu hóa cho người dùng này',
            confirmDelete: 'Bạn có chắc chắn muốn xóa người dùng \'{username}\' không? Thao tác này cũng sẽ xóa tất cả bộ nhớ lâu dài của họ và không thể hoàn tác.',
            allowPublicSharing: 'Cho phép chia sẻ tệp công khai',
        },
        groups: {
            title: 'Quản lý nhóm',
            searchPlaceholder: 'Tìm kiếm nhóm...',
            newTitle: 'Tạo nhóm mới',
            nameLabel: 'Tên nhóm:',
            overrideTitle: 'Cài đặt ghi đè nhóm',
            permissionsTitle: 'Ghi đè quyền & Tăng cường bảo mật',
            createButton: 'Tạo nhóm',
            confirmDelete: 'Bạn có chắc chắn muốn xóa nhóm \'{groupName}\' không? Người dùng trong nhóm này sẽ trở về cài đặt cá nhân của họ.',
        },
        installedApps: {
            title: 'Ứng dụng đã cài đặt',
            searchPlaceholder: 'Tìm kiếm ứng dụng đã cài đặt...',
            noAppsFound: 'Không tìm thấy ứng dụng đã cài đặt nào.',
            pulling: 'Đang kéo image mới...',
            notLocal: 'Không tìm thấy image cục bộ',
            confirmDelete: 'Bạn có chắc chắn muốn xóa ứng dụng đã cài đặt \'{appName}\' không?',
        },
        appStore: {
            title: 'Cửa hàng ứng dụng',
            refreshTitle: 'Làm mới cửa hàng đã chọn',
            selectLabel: 'Chọn cửa hàng ứng dụng',
            addLabel: 'Thêm cửa hàng ứng dụng mới',
            namePlaceholder: 'Tên cửa hàng',
            urlPlaceholder: 'URL YAML của cửa hàng',
            availableTitle: 'Ứng dụng có sẵn',
            addManual: "Thêm ứng dụng thủ công",
            searchPlaceholder: 'Tìm kiếm ứng dụng có sẵn...',
            noAppsFound: 'Không tìm thấy ứng dụng nào.',
            availableFrom: 'Ứng dụng có sẵn từ {storeName}',
            couldNotLoad: 'Không thể tải ứng dụng từ cửa hàng này.',
        },
        appTemplates: {
            title: 'Trình chỉnh sửa mẫu ứng dụng',
            loadLabel: 'Tải mẫu',
            createOption: 'Tạo mẫu mới',
            nameLabel: 'Tên mẫu',
            namePlaceholder: 'Nhập tên cho mẫu mới',
            saveButton: 'Lưu hồ sơ',
            deleteButton: 'Xóa',
            previewTitle: 'Xem trước giao diện người dùng',
            contentArea: 'Khu vực nội dung ứng dụng',
            confirmDelete: 'Bạn có chắc chắn muốn xóa mẫu \'{templateName}\' không? Hành động này không thể được hoàn tác.',
            deleteDisabled: 'Mẫu này không thể bị xóa.',
            enterName: 'Vui lòng nhập tên cho mẫu mới.',
            settings: {
                TITLE: { label: "Tiêu đề trang", description: "Tiêu đề trang được hiển thị trên trình duyệt web." },
                SELKIES_UI_TITLE: { label: "Tiêu đề thanh bên", description: "Tiêu đề ở góc trên cùng bên trái của thanh bên." },
                SELKIES_UI_SHOW_SIDEBAR: { label: "Hiển thị thanh bên", description: "Hiển thị giao diện người dùng chính của thanh bên." },
                SELKIES_UI_SHOW_LOGO: { label: "Hiển thị logo", description: "Hiển thị logo Selkies trong thanh bên." },
                SELKIES_UI_SHOW_CORE_BUTTONS: { label: "Hiển thị các nút cốt lõi", description: "Hiển thị các nút thành phần cốt lõi (hiển thị, âm thanh, v.v.)." },
                SELKIES_UI_SIDEBAR_SHOW_VIDEO_SETTINGS: { label: "Hiển thị cài đặt video", description: "Hiển thị phần cài đặt video trong thanh bên." },
                SELKIES_UI_SIDEBAR_SHOW_SCREEN_SETTINGS: { label: "Hiển thị cài đặt màn hình", description: "Hiển thị phần cài đặt màn hình trong thanh bên." },
                SELKIES_UI_SIDEBAR_SHOW_AUDIO_SETTINGS: { label: "Hiển thị cài đặt âm thanh", description: "Hiển thị phần cài đặt âm thanh trong thanh bên." },
                SELKIES_UI_SIDEBAR_SHOW_STATS: { label: "Hiển thị thống kê", description: "Hiển thị phần thống kê trong thanh bên." },
                SELKIES_UI_SIDEBAR_SHOW_CLIPBOARD: { label: "Hiển thị clipboard", description: "Hiển thị phần clipboard trong thanh bên." },
                SELKIES_UI_SIDEBAR_SHOW_FILES: { label: "Hiển thị phần tệp", description: "Hiển thị phần truyền tệp trong thanh bên." },
                SELKIES_UI_SIDEBAR_SHOW_APPS: { label: "Hiển thị phần ứng dụng", description: "Hiển thị phần ứng dụng trong thanh bên." },
                SELKIES_UI_SIDEBAR_SHOW_SHARING: { label: "Hiển thị phần chia sẻ", description: "Hiển thị phần chia sẻ trong thanh bên." },
                SELKIES_UI_SIDEBAR_SHOW_GAMEPADS: { label: "Hiển thị phần Gamepads", description: "Hiển thị phần gamepads trong thanh bên." },
                SELKIES_UI_SIDEBAR_SHOW_KEYBOARD_BUTTON: { label: "Hiển thị nút bàn phím", description: "Hiển thị nút bàn phím trên màn hình." },
                SELKIES_UI_SIDEBAR_SHOW_SOFT_BUTTONS: { label: "Hiển thị các nút mềm", description: "Hiển thị phần các nút mềm (dành cho thiết bị di động)." },
                WATERMARK_PNG: { label: "Đường dẫn PNG Watermark", description: "Đường dẫn đầy đủ bên trong container đến một tệp png watermark." },
                WATERMARK_LOCATION: { label: "Vị trí Watermark", description: "Nơi vẽ hình ảnh lên luồng.", options: { disabled: "Vô hiệu hóa", topLeft: "Trên-Trái", topRight: "Trên-Phải", bottomLeft: "Dưới-Trái", bottomRight: "Dưới-Phải", centered: "Chính giữa", animated: "Hoạt ảnh" } },
                DASHBOARD: { label: "Kiểu bảng điều khiển", description: "Cho phép người dùng thiết lập bảng điều khiển của họ.", options: { default: "Mặc định", selkiesDefault: "Selkies (Mặc định)", zinc: "Zinc", wish: "Wish" } },
                SELKIES_AUDIO_ENABLED: { label: "Bật âm thanh", description: "Bật truyền phát âm thanh từ máy chủ đến máy khách." },
                SELKIES_MICROPHONE_ENABLED: { label: "Bật micro", description: "Bật chuyển tiếp micro từ máy khách đến máy chủ." },
                SELKIES_GAMEPAD_ENABLED: { label: "Bật gamepad", description: "Bật hỗ trợ gamepad." },
                SELKIES_CLIPBOARD_ENABLED: { label: "Bật clipboard", description: "Bật đồng bộ hóa clipboard." },
                SELKIES_ENABLE_BINARY_CLIPBOARD: { label: "Bật clipboard nhị phân", description: "Cho phép dữ liệu nhị phân (hình ảnh) trên clipboard." },
                SELKIES_COMMAND_ENABLED: { label: "Bật websocket lệnh", description: "Bật phân tích cú pháp các thông điệp websocket lệnh." },
                SELKIES_FILE_TRANSFERS: { label: "Truyền tệp", description: "Các hướng được phép ('upload,download', 'upload', 'download', 'none')." },
                SELKIES_ENABLE_SHARING: { label: "Bật tất cả chia sẻ", description: "Công tắc chính cho tất cả các tính năng chia sẻ." },
                SELKIES_SECOND_SCREEN: { label: "Bật màn hình thứ hai", description: "Bật hỗ trợ cho một màn hình/hiển thị thứ hai." },
                SELKIES_USE_BROWSER_CURSORS: { label: "Sử dụng con trỏ trình duyệt", description: "Sử dụng con trỏ CSS của trình duyệt thay vì hiển thị trên canvas." },
                SELKIES_USE_CSS_SCALING: { label: "Sử dụng tỷ lệ CSS (LoDPI)", description: "Nếu đúng, một độ phân giải thấp hơn sẽ được gửi và canvas sẽ được kéo dài." },
                SELKIES_IS_MANUAL_RESOLUTION_MODE: { label: "Chế độ độ phân giải thủ công", description: "Khóa độ phân giải theo các giá trị chiều rộng/chiều cao thủ công." },
                SELKIES_MANUAL_WIDTH: { label: "Chiều rộng thủ công", description: "Khóa chiều rộng ở một giá trị cố định. Buộc chế độ thủ công." },
                SELKIES_MANUAL_HEIGHT: { label: "Chiều cao thủ công", description: "Khóa chiều cao ở một giá trị cố định. Buộc chế độ thủ công." },
                SELKIES_SCALING_DPI: { label: "DPI tỷ lệ giao diện người dùng", description: "DPI mặc định cho tỷ lệ giao diện người dùng." },
                SELKIES_AUDIO_BITRATE: { label: "Bitrate âm thanh", description: "Bitrate âm thanh mặc định." },
                SELKIES_ENCODER: { label: "Các bộ mã hóa", description: "Danh sách các bộ mã hóa được phân tách bằng dấu phẩy. Đầu tiên là mặc định." },
                SELKIES_USE_CPU: { label: "Buộc mã hóa bằng CPU", description: "Buộc mã hóa dựa trên CPU cho pixelflux." },
                SELKIES_FRAMERATE: { label: "Tốc độ khung hình (Phạm vi hoặc Cố định)", description: "ví dụ: '8-120' cho một phạm vi hoặc '60' cho cố định." },
                SELKIES_H264_CRF: { label: "CRF H.264 (Phạm vi hoặc Cố định)", description: "ví dụ: '5-50' cho một phạm vi hoặc '25' cho cố định." },
                SELKIES_JPEG_QUALITY: { label: "Chất lượng JPEG (Phạm vi hoặc Cố định)", description: "ví dụ: '1-100' cho một phạm vi hoặc '60' cho cố định." },
                SELKIES_H264_FULLCOLOR: { label: "Màu đầy đủ H.264", description: "Bật dải màu đầy đủ H.264 cho các bộ mã hóa pixelflux." },
                SELKIES_H264_STREAMING_MODE: { label: "Chế độ truyền phát H.264 (Turbo)", description: "Bật chế độ truyền phát độ trễ thấp H.264." },
                SELKIES_USE_PAINT_OVER_QUALITY: { label: "Sử dụng chất lượng vẽ đè", description: "Bật vẽ đè chất lượng cao cho các cảnh tĩnh." },
                SELKIES_PAINT_OVER_JPEG_QUALITY: { label: "Chất lượng JPEG vẽ đè", description: "ví dụ: '1-100' cho một phạm vi hoặc '90' cho cố định." },
                SELKIES_H264_PAINTOVER_CRF: { label: "CRF H.264 vẽ đè", description: "ví dụ: '5-50' cho một phạm vi hoặc '18' cho cố định." },
                SELKIES_H264_PAINTOVER_BURST_FRAMES: { label: "Khung hình Burst vẽ đè", description: "ví dụ: '1-30' cho một phạm vi hoặc '5' cho cố định." },
                HARDEN_DESKTOP: { label: "Tăng cường bảo mật Desktop (Cài đặt sẵn)", description: "Bật DISABLE_OPEN_TOOLS, DISABLE_SUDO và DISABLE_TERMINALS." },
                HARDEN_OPENBOX: { label: "Tăng cường bảo mật Trình quản lý cửa sổ (Cài đặt sẵn)", description: "Bật DISABLE_CLOSE_BUTTON, DISABLE_MOUSE_BUTTONS và HARDEN_KEYBINDS. Cũng bật RESTART_APP." },
                DISABLE_OPEN_TOOLS: { label: "Vô hiệu hóa các công cụ mở", description: "Vô hiệu hóa các tệp nhị phân xdg-open và exo-open." },
                DISABLE_SUDO: { label: "Vô hiệu hóa Sudo", description: "Vô hiệu hóa lệnh sudo." },
                DISABLE_TERMINALS: { label: "Vô hiệu hóa Terminals", description: "Vô hiệu hóa các trình giả lập terminal phổ biến." },
                DISABLE_CLOSE_BUTTON: { label: "Vô hiệu hóa nút đóng cửa sổ", description: "Xóa nút đóng khỏi thanh tiêu đề cửa sổ." },
                DISABLE_MOUSE_BUTTONS: { label: "Vô hiệu hóa nhấp chuột phải/giữa", description: "Vô hiệu hóa các menu ngữ cảnh nhấp chuột phải và giữa." },
                HARDEN_KEYBINDS: { label: "Tăng cường bảo mật các phím tắt", description: "Vô hiệu hóa các phím tắt mặc định của Openbox như Alt+F4." },
                RESTART_APP: { label: "Khởi động lại ứng dụng khi đóng", description: "Tự động khởi động lại ứng dụng chính nếu nó bị đóng." },
                MAX_RES: { label: "Độ phân giải tối đa", description: "Độ phân giải tối đa cho container, mặc định là 16k." },
                START_DOCKER: { label: "Khởi động Docker-in-Docker", description: "Nếu sai, một container đặc quyền sẽ không khởi động DinD." },
                DISABLE_IPV6: { label: "Vô hiệu hóa IPv6", description: "Nếu đúng, điều này sẽ vô hiệu hóa IPv6." },
                DISABLE_ZINK: { label: "Vô hiệu hóa Zink", description: "Không đặt các biến môi trường Zink nếu phát hiện có card màn hình." },
                DISABLE_DRI3: { label: "Vô hiệu hóa DRI3", description: "Không sử dụng tăng tốc DRI3 nếu phát hiện có card màn hình." },
                NO_DECOR: { label: "Không có trang trí cửa sổ", description: "Chạy ứng dụng không có viền cửa sổ để sử dụng PWA." },
                NO_FULL: { label: "Không toàn màn hình", description: "Không tự động toàn màn hình các ứng dụng." },
                NO_GAMEPAD: { label: "Vô hiệu hóa tiêm Gamepad", description: "Vô hiệu hóa tiêm trình xen kẽ gamepad không gian người dùng." },
                SELKIES_DEBUG: { label: "Bật gỡ lỗi Selkies", description: "Bật ghi nhật ký gỡ lỗi cho các thành phần truyền phát." },
            }
        },
        appLaboratory: {
            title: 'Phòng thí nghiệm ứng dụng',
            description: 'Tạo và thử nghiệm các cấu hình ứng dụng tùy chỉnh bằng cách xếp lớp các thay đổi lên trên một ứng dụng cơ sở.',
            selectApp: 'Chọn ứng dụng',
            createNew: 'Tạo ứng dụng mới',
            baseApp: 'Ứng dụng cơ sở',
            baseAppDescription: 'Ứng dụng đã cài đặt mà ứng dụng tùy chỉnh mới của bạn sẽ dựa trên.',
            selectBase: 'Chọn một ứng dụng cơ sở',
            customizationTitle: 'Tùy chỉnh',
            appName: 'Tên ứng dụng',
            appIcon: 'Biểu tượng ứng dụng',
            uploadIcon: 'Tải lên biểu tượng',
            autostartScriptLabel: 'Tập lệnh Tự khởi động Tùy chỉnh',
            permissionsTitle: 'Quyền',
            usersLabel: 'Người dùng được phép',
            groupsLabel: 'Nhóm được phép',
            launchButton: 'Lưu & Khởi chạy Phiên tùy chỉnh',
            closeButton: 'Đóng Phiên & Hoàn tất',
            savingAndLaunching: 'Đang lưu & Khởi chạy...',
            placeholder: 'Phòng thí nghiệm ứng dụng cho phép bạn cấu hình thư mục chính cơ sở và tập lệnh khởi chạy cho một ứng dụng dựa trên một ứng dụng đã cài đặt hiện có. Thư mục chính này sẽ được sao chép khi khởi tạo lần đầu cho người dùng với tất cả các tệp và cài đặt bạn đã thiết lập trong phiên này. Bạn có thể khởi chạy lại một ứng dụng Phòng thí nghiệm hiện có để sửa đổi thêm nội dung của nó.',
            formInvalid: 'Vui lòng chọn một ứng dụng cơ sở và cung cấp tên cho ứng dụng mới.',
        },
        modals: {
            editUserTitle: 'Chỉnh sửa Người dùng: {username}',
            saveChanges: 'Lưu thay đổi',
            effectiveSettings: 'Cài đặt hiệu quả (với ghi đè nhóm)',
            editGroupTitle: 'Chỉnh sửa Nhóm: {groupName}',
            userConfigTitle: 'Cấu hình người dùng',
            warning: 'Đây là lần duy nhất cấu hình này sẽ được hiển thị. Cung cấp nó cho người dùng một cách an toàn.',
            info: 'Bạn có thể tải xuống tệp cấu hình này để dễ dàng thiết lập SealSkin trên một thiết bị khác. Giữ tệp này an toàn vì nó chứa khóa riêng của bạn.',
            configDataLabel: 'Dữ liệu cấu hình (JSON)',
            copyButton: 'Sao chép văn bản',
            downloadButton: 'Tải xuống tệp',
            manageHomeDirs: 'Quản lý thư mục chính',
            dirsForUser: 'Thư mục cho người dùng: {username}',
            dirsForAdmin: 'Thư mục cho quản trị viên: {username}',
            newDirForUser: 'Tạo thư mục mới cho người dùng',
            createDirButton: 'Tạo thư mục',
            confirmDeleteDir: 'Bạn có chắc chắn muốn xóa \'{homeName}\' cho người dùng \'{username}\' không? Thao tác này là vĩnh viễn.',
            installAppTitle: 'Cài đặt {appName}',
            editAppTitle: 'Chỉnh sửa {appName}',
            customNameLabel: 'Tên tùy chỉnh',
            imageLabel: 'Image Container',
            permissions: 'Quyền',
            allowedUsersLabel: 'Người dùng được phép (phân tách bằng dấu phẩy, \'all\' cho tất cả mọi người)',
            allowedGroupsLabel: 'Nhóm được phép (phân tách bằng dấu phẩy, \'all\' cho tất cả mọi người)',
            features: 'Tính năng',
            gpuSupport: 'Hỗ trợ GPU',
            homeMounting: 'Gắn thư mục chính',
            urlSupport: 'Hỗ trợ mở URL',
            fileSupport: 'Hỗ trợ mở tệp',
            autoUpdate: 'Tự động cập nhật Image',
            advancedSettings: 'Cài đặt nâng cao',
            appTemplateLabel: 'Mẫu ứng dụng',
            appTemplateDescription: 'Chọn một mẫu được cấu hình sẵn cho các cài đặt khởi chạy container nâng cao.',
            customAutostartScriptLabel: 'Tập lệnh Tự khởi động Tùy chỉnh',
            customAutostartScriptDescription: 'Tùy chỉnh logic tự khởi động, để trống để sử dụng mặc định từ nhà cung cấp ứng dụng.',
            saveInstallation: 'Lưu cài đặt',
            updateStatusTitle: 'Trạng thái cập nhật cho {appName}',
            checkingUpdates: 'Đang kiểm tra cập nhật...',
            updateAvailable: 'Một phiên bản image mới đã có sẵn!',
            yourVersion: 'Phiên bản của bạn: {sha}',
            latestAvailable: 'Phiên bản mới nhất có sẵn để kéo từ registry.',
            pullLatest: 'Kéo Image mới nhất',
            upToDate: 'Image của bạn đã được cập nhật.',
            currentVersion: 'Phiên bản hiện tại: {sha}',
            errorChecking: 'Lỗi khi kiểm tra cập nhật.',
            pullingLatest: 'Đang kéo image mới nhất... Việc này có thể mất một chút thời gian.',
            pullComplete: 'Kéo hoàn tất!',
            newVersion: 'Phiên bản mới: {sha}',
            errorPulling: 'Lỗi khi kéo image.',
            manualInstallNote: "Lưu ý: Các hình ảnh được thêm thủ công phải dựa trên một hình ảnh tương thích với selkies-baseimage.",
        },
        status: {
            loggingIn: 'Đang đăng nhập...',
            configSaved: 'Đã lưu cấu hình thành công!',
            configApplied: 'Đã áp dụng cấu hình! Vui lòng Đăng nhập & Kiểm tra.',
            configApplyFailed: 'Không thể áp dụng cấu hình: {error}',
            fileReadError: 'Lỗi khi đọc tệp.',
            noConfig: 'Vui lòng cung cấp một tệp cấu hình hoặc văn bản.',
            loggedInAdmin: 'Đã đăng nhập với tư cách quản trị viên: {username}',
            loggedInUser: 'Đã đăng nhập với tư cách người dùng tiêu chuẩn: {username}.',
            loginFailed: 'Đăng nhập thất bại: {error}',
            adminDataRefreshFailed: 'Không thể làm mới dữ liệu quản trị viên: {error}',
            logoutSuccess: 'Đã đăng xuất và xóa cấu hình.',
            generateConfigFailed: 'Không thể tạo cấu hình, thiếu chi tiết người dùng.',
            copySuccess: 'Đã sao chép cấu hình vào clipboard!',
            copyFailed: 'Không thể sao chép văn bản.',
            publicKeyCopied: 'Đã sao chép khóa công khai!',
            keyCopyFailed: 'Không thể sao chép khóa.',
            creatingAdmin: 'Đang tạo quản trị viên...',
            adminCreated: 'Đã tạo quản trị viên \'{username}\'.',
            adminCreateFailed: 'Lỗi khi tạo quản trị viên: {error}',
            adminDeleted: 'Đã xóa quản trị viên \'{username}\' thành công.',
            adminDeleteFailed: 'Lỗi khi xóa quản trị viên: {error}',
            creatingUser: 'Đang tạo người dùng...',
            userCreated: 'Đã tạo người dùng \'{username}\'.',
            userCreateFailed: 'Lỗi khi tạo người dùng: {error}',
            userDeleted: 'Đã xóa người dùng \'{username}\' thành công.',
            userDeleteFailed: 'Lỗi khi xóa người dùng: {error}',
            userUpdated: 'Đã cập nhật người dùng \'{username}\' thành công.',
            userUpdateFailed: 'Lỗi khi cập nhật người dùng: {error}',
            creatingGroup: 'Đang tạo nhóm...',
            groupCreated: 'Đã tạo nhóm \'{groupName}\'.',
            groupCreateFailed: 'Lỗi khi tạo nhóm: {error}',
            groupDeleted: 'Đã xóa nhóm \'{groupName}\' thành công.',
            groupDeleteFailed: 'Lỗi khi xóa nhóm: {error}',
            groupUpdated: 'Đã cập nhật nhóm \'{groupName}\' thành công.',
            groupUpdateFailed: 'Lỗi khi cập nhật nhóm: {error}',
            homedirLoadFailed: 'Không thể tải thư mục chính: {error}',
            homedirCreateFailed: 'Lỗi khi tạo thư mục: {error}',
            homedirCreated: 'Đã tạo thư mục chính \'{homeName}\'.',
            homedirDeleted: 'Đã xóa thư mục \'{homeName}\'.',
            homedirDeleteFailed: 'Lỗi khi xóa thư mục: {error}',
            homedirCreatedFor: 'Đã tạo thư mục \'{homeName}\' cho {username}.',
            homedirDeletedFor: 'Đã xóa thư mục \'{homeName}\' cho {username}.',
            sessionsLoadFailed: 'Không thể tải các phiên: {error}',
            sessionStopError: 'Lỗi khi dừng phiên: {error}',
            sessionStopped: 'Đã dừng phiên thành công.',
            appDataRefreshFailed: 'Không thể làm mới dữ liệu ứng dụng: {error}',
            closingSession: 'Đang cam kết phiên tùy chỉnh...',
            sessionClosed: 'Đã đóng phiên tùy chỉnh.',
            sessionCloseFailed: 'Không thể đóng phiên tùy chỉnh: {error}',
            fetchingApps: 'Đang lấy ứng dụng từ cửa hàng...',
            fetchAppsFailed: 'Không thể lấy ứng dụng từ cửa hàng: {error}',
            appStoreAddFailed: 'Lỗi khi thêm cửa hàng: {error}',
            appStoreAdded: 'Đã thêm cửa hàng ứng dụng \'{name}\'.',
            appSaved: 'Ứng dụng \'{name}\' đã được {action} thành công.',
            appSaveActions: {
                updated: 'cập nhật',
                installed: 'cài đặt'
            },
            appSaveFailed: 'Lỗi khi lưu ứng dụng: {error}',
            appDeleted: 'Đã xóa ứng dụng \'{name}\'.',
            appDeleteFailed: 'Lỗi khi xóa ứng dụng: {error}',
            templateSaved: 'Đã lưu mẫu \'{name}\' thành công.',
            templateSaveFailed: 'Lỗi khi lưu mẫu: {error}',
            templateDeleted: 'Đã xóa mẫu \'{name}\' thành công.',
            templateDeleteFailed: 'Lỗi khi xóa mẫu: {error}',
            pinRemoved: 'Đã xóa hành vi đã ghim.',
            keyGenerated: 'Đã tạo cặp khóa mới.',
            keyGenFailed: 'Tạo khóa thất bại: {{error}}',
            pendingConfigSaved: 'Đã lưu cấu hình đang chờ xử lý. Bây giờ bạn có thể cung cấp khóa công khai của mình cho quản trị viên.',
            settingsSaved: 'Đã lưu cài đặt.',
            appCreated: 'Đã tạo ứng dụng \'{name}\' thành công.',
            launchFailed: 'Khởi chạy thất bại: {error}',
        },
        placeholders: {
            noAdmins: 'Không tìm thấy quản trị viên nào.',
            noUsers: 'Không tìm thấy người dùng nào.',
            noGroups: 'Không tìm thấy nhóm nào.',
            noHomeDirs: 'Không tìm thấy thư mục chính nào.',
            noSessions: 'Không tìm thấy phiên hoạt động nào.',
            noPinned: 'Không tìm thấy hành vi đã ghim nào.',
            errorLoading: 'Lỗi khi tải thư mục.',
            noInstalledApps: 'Chưa có ứng dụng nào được cài đặt.',
        },
    },
    popup: {
        tabs: {
            launch: 'Khởi chạy mới',
            sessions: 'Phiên hoạt động',
            manageFiles: 'Quản lý tệp',
            uploadStorage: 'Tải lên bộ nhớ',
            uploadFiles: 'Tải lên tệp',
            uploadFilesTitle: 'Mở trang tải lên tệp chuyên dụng'
        },
        launchView: {
            searchPlaceholder: 'Tìm kiếm ứng dụng...',
            uploadingFile: 'Đang tải lên tệp...',
            gpuLabel: 'GPU',
            storageLabel: 'Lưu trữ',
            languageLabel: 'Ngôn ngữ',
            cleanroom: 'Phòng sạch (Tạm thời)',
            noGpu: 'Không có',
            saveOptions: 'Lưu các tùy chọn khởi chạy này',
            saveOptionsForUrl: 'Lưu tùy chọn cho tất cả các URL',
            saveOptionsForFile: 'Lưu tùy chọn cho các tệp .{extension}',
            openFile: 'Mở tệp khi khởi chạy',
            launchButton: 'Khởi chạy',
            launchingButton: 'Đang khởi chạy...',
            uploadingButton: 'Đang tải lên...',
            autoHome: 'Tự động (lưu trữ theo ứng dụng)',
            collaborationMode: 'Phiên cộng tác',
            waylandMode: 'Chế độ Wayland',
        },
        sessionsView: {
            noSessions: 'Không tìm thấy phiên hoạt động nào.',
        },
        uploadStorageView: {
            selectHome: 'Chọn thư mục chính',
            description: 'Thao tác này sẽ tải tệp <strong>{filename}</strong> trực tiếp lên bộ nhớ Tệp của bạn để sử dụng trong tương lai.',
            descriptionFallback: 'Thao tác này sẽ tải tệp <strong>{filename}</strong> trực tiếp lên bộ nhớ Tệp của bạn để sử dụng trong tương lai.',
            uploadButton: 'Tải lên tệp',
            uploadingButton: 'Đang tải lên...',
            preparing: 'Đang chuẩn bị tệp...',
            uploadingChunk: 'Đang tải lên phần {current} của {total}...',
            finalizing: 'Đang hoàn tất...',
            uploadComplete: 'Tải lên hoàn tất!',
        },
        status: {
            unconfigured: 'Vui lòng cấu hình tiện ích mở rộng qua trang tùy chọn.',
            openingServerFile: "Đang mở tệp phía máy chủ: {filename}",
            openingFile: 'Đang mở tệp: {filename}',
            openingUrl: 'Đang mở URL: {targetUrl}',
            error: 'Lỗi: {message}',
            preparingFile: 'Đang chuẩn bị tệp...',
            sendingFile: 'Đang gửi tệp đến phiên...',
            errorSendingFile: 'Lỗi khi gửi tệp: {message}',
            errorClosingSession: 'Lỗi khi đóng phiên: {message}',
            preparingSession: 'Đang chuẩn bị phiên cách ly...',
            fetchingData: 'Đang lấy dữ liệu tệp...',
            fetchDataFailed: 'Không thể lấy dữ liệu tệp: {statusText}',
            unknownAction: 'Hành động khởi chạy không xác định.',
            noAppSelected: 'Vui lòng chọn một ứng dụng.',
            noAppsAvailable: 'Không có ứng dụng nào có sẵn cho tài khoản của bạn.',
            uploadSuccess: 'Tệp đã được tải lên thành công!',
            creatingAutoHome: 'Đang tạo thư mục chính tự động...',
        },
        languages: {
            default: 'Mặc định ({locale})'
        }
    },
    upload: {
        title: 'Tải lên tệp',
        description: 'Chọn một tệp từ máy tính của bạn để mở nó trong một phiên an toàn, cách ly.',
        dropzone: {
            title: 'Kéo và thả tệp vào đây',
            or: 'hoặc',
            button: 'Chọn tệp',
        },
        confirm: {
            ready: 'Tệp đã sẵn sàng để được mở một cách an toàn.',
            button: 'Tiếp tục để khởi chạy',
        }
    },
    files: {
        title: 'Tệp SealSkin',
        header: {
            title: 'Tệp',
            newFolder: 'Thư mục mới',
            uploadFiles: 'Tải lên tệp',
            uploadFolder: 'Tải lên thư mục'
        },
        sidebar: {
            sharedFiles: 'Tệp SealSkin',
            publicShares: 'Chia sẻ công khai'
        },
        shares: {
            title: 'Các tệp được chia sẻ công khai',
            searchPlaceholder: 'Tìm kiếm theo tên tệp hoặc ID...'
        },
        table: {
            name: 'Tên',
            size: 'Kích thước',
            lastModified: 'Sửa đổi lần cuối',
            created: 'Đã tạo',
            expires: 'Hết hạn',
            url: 'URL công khai',
            passwordProtected: 'Mật khẩu'
        },
        dropzone: {
            title: 'Thả tệp vào đây để tải lên'
        },
        pagination: {
            previous: '« Trước',
            next: 'Tiếp »',
            pageOf: 'Trang {page} của {totalPages}'
        },
        modals: {
            newFolder: {
                title: 'Tạo thư mục mới',
                folderNameLabel: 'Tên thư mục',
                nameTitle: 'Chỉ sử dụng chữ cái, số, dấu gạch dưới, dấu gạch ngang hoặc dấu chấm.',
                createButton: 'Tạo'
            },
            confirmDelete: {
                title: 'Xác nhận xóa',
                message: 'Bạn có chắc chắn muốn xóa {count, plural, one {1 mục đã chọn} other {{count} mục đã chọn}} không? Hành động này không thể hoàn tác.',
                messageDefault: 'Bạn có chắc chắn muốn xóa các mục đã chọn không? Hành động này không thể hoàn tác.'
            },
            uploadProgress: {
                title: 'Tiến trình tải lên',
                doneButton: 'Xong'
            },
            share: {
                title: 'Chia sẻ tệp',
                sharingFile: 'Đang chia sẻ tệp: <strong>{filename}</strong>',
                passwordLabel: 'Mật khẩu (tùy chọn)',
                passwordPlaceholder: 'Để trống nếu không có mật khẩu',
                expiryLabel: 'Hết hạn sau (giờ, tùy chọn)',
                expiryPlaceholder: 'ví dụ: 24 cho một ngày',
                shareButton: 'Tạo liên kết chia sẻ'
            }
        },
        status: {
            homeDirLoadFailed: 'Không thể tải thư mục chính: {error}',
            filesLoadFailed: 'Lỗi khi tải tệp: {error}',
            deleteProtectedError: 'Không thể xóa các thư mục hệ thống được bảo vệ.',
            deletingItems: 'Đang xóa {count, plural, one {1 mục} other {{count} mục}}...',
            deleteSuccess: 'Xóa thành công.',
            deleteFailed: 'Xóa thất bại: {error}',
            preparingUpload: 'Đang chuẩn bị tải lên {count, plural, one {1 tệp} other {{count} tệp}}...',
            uploadPrepFailed: 'Lỗi trong quá trình chuẩn bị tải lên thư mục: {error}',
            notConfigured: 'Lỗi: SealSkin chưa được cấu hình. Vui lòng thiết lập trong tùy chọn.',
            folderCreated: 'Đã tạo thư mục \'{folderName}\'.',
            folderCreateFailed: 'Lỗi khi tạo thư mục: {error}',
            shareCreated: 'Chia sẻ đã được tạo thành công! Liên kết đã được sao chép vào clipboard của bạn.',
            shareCreateFailed: 'Không thể tạo chia sẻ: {error}',
            sharesLoadFailed: 'Không thể tải các tệp đã chia sẻ: {error}',
            shareDeleteFailed: 'Không thể xóa chia sẻ: {error}',
            shareDeleted: 'Đã xóa chia sẻ thành công.',
            urlCopied: 'Đã sao chép URL công khai vào clipboard.'
        },
        placeholders: {
            errorLoading: 'Lỗi khi tải tệp.',
            folderEmpty: 'Thư mục này trống.',
            noHomeDirs: 'Không có thư mục chính nào.',
            noShares: 'Bạn chưa chia sẻ tệp nào.'
        },
        uploadStatus: {
            pending: 'đang chờ',
            initiating: 'Đang bắt đầu...',
            uploading: 'Đang tải lên...',
            finalizing: 'Đang hoàn tất...',
            completed: 'Hoàn thành',
            error: 'Lỗi'
        }
    }
};

// --- Thai Translations ---
const th = {
    background: {
        contextMenu: {
            openUrl: 'เปิดลิงก์ใน SealSkin',
            openFile: 'เปิดเป้าหมายลิงก์เป็นไฟล์ใน SealSkin',
            sendMedia: 'ส่งสื่อไปยัง SealSkin',
            searchText: 'ค้นหา "%s" ใน SealSkin',
            sendDownload: 'ส่งการดาวน์โหลดถัดไปไปยัง SealSkin'
        }
    },
    common: {
        actions: 'การดำเนินการ',
        active: 'ใช้งานอยู่',
        cancel: 'ยกเลิก',
        manage: 'จัดการ',
        delete: 'ลบ',
        edit: 'แก้ไข',
        save: 'บันทึก',
        none: 'ไม่มี',
        error: 'ข้อผิดพลาด',
        na: 'ไม่มีข้อมูล',
        of: 'ของ',
        status: 'สถานะ',
        username: 'ชื่อผู้ใช้',
        group: 'กลุ่ม',
        groups: 'กลุ่ม',
        publicKey: 'คีย์สาธารณะ',
        name: 'ชื่อ',
        source: 'แหล่งที่มา',
        imageVersion: 'เวอร์ชันอิมเมจ',
        language: 'ภาษา',
        storage: 'พื้นที่จัดเก็บ',
        gpu: 'GPU',
        version: 'เวอร์ชัน',
        checked: 'ตรวจสอบแล้ว',
        never: 'ไม่เคย',
        stop: 'หยุด',
        reopen: 'เปิดใหม่',
        sendFile: 'ส่งไฟล์',
        share: 'แชร์',
        search: 'ค้นหา',
        refresh: 'รีเฟรช',
        close: 'ปิด',
        copy: 'คัดลอก',
        open: "เปิด",
        copyUrl: 'คัดลอก URL',
        download: 'ดาวน์โหลด',
        next: 'ถัดไป',
        previous: 'ก่อนหน้า',
        page: 'หน้า',
        home: 'โฮมไดเรกทอรี',
        homes: 'โฮมไดเรกทอรี',
        sessions: 'เซสชัน',
        users: 'ผู้ใช้',
        admins: 'ผู้ดูแลระบบ',
        yes: 'ใช่',
        no: 'ไม่',
        daysAgo: '{count, plural, one {1 วันที่แล้ว} other {{count} วันที่แล้ว}}',
        hoursAgo: '{count, plural, one {1 ชั่วโมงที่แล้ว} other {{count} ชั่วโมงที่แล้ว}}',
        minutesAgo: '{count, plural, one {1 นาทีที่แล้ว} other {{count} นาทีที่แล้ว}}',
        justNow: 'เมื่อสักครู่',
        bytes: 'ไบต์',
        kb: 'KB',
        mb: 'MB',
        gb: 'GB',
        tb: 'TB',
        pb: 'PB',
    },
    options: {
        sidebar: {
            config: 'การกำหนดค่า',
            home: 'โฮมไดเรกทอรี',
            sessions: 'เซสชันที่ใช้งานอยู่',
            pinned: 'พฤติกรรมที่ปักหมุด',
            appStore: 'ร้านค้าแอป',
            appTemplates: 'เทมเพลตแอป',
            appLaboratory: 'ห้องปฏิบัติการแอป',
            installedApps: 'แอปที่ติดตั้งแล้ว',
            users: 'ผู้ใช้',
            groups: 'กลุ่ม',
            admins: 'ผู้ดูแลระบบ',
        },
        dashboard: {
            title: 'แดชบอร์ด',
            clientSettings: 'การตั้งค่าไคลเอ็นต์',
            exportConfig: 'ส่งออกการกำหนดค่า',
            userStatus: 'สถานะผู้ใช้',
            loggedInAs: 'เข้าสู่ระบบในชื่อ:',
            role: 'บทบาท',
            roleAdmin: 'ผู้ดูแลระบบ',
            roleUser: 'ผู้ใช้มาตรฐาน',
            serverInfo: 'ข้อมูลเซิร์ฟเวอร์',
            server: 'เซิร์ฟเวอร์:',
            cpuModel: 'รุ่น CPU:',
            storageUsage: 'การใช้งานพื้นที่จัดเก็บ:',
            detectedGpus: 'GPU ที่ตรวจพบ:',
            logout: 'ออกจากระบบและล้างการกำหนดค่า',
            howTo: 'วิธีใช้ SealSkin',
            howToDescription: 'ส่วนนี้ประกอบด้วยเอกสารพื้นฐานเกี่ยวกับวิธีใช้ส่วนขยาย',
            howToList: [
                '<strong>วิธีเปิดเนื้อหาแบบแยก:</strong> คลิกขวาที่ลิงก์ รูปภาพ หรือข้อความที่เลือก แล้วเลือกตัวเลือกจากเมนูบริบท "SealSkin Isolation"',
                '<strong>วิธีส่งการดาวน์โหลดไปยังการแยก:</strong> คลิกขวาที่หน้าและเลือก "ส่งการดาวน์โหลดครั้งต่อไปไปยังการแยก" ไฟล์ถัดไปที่คุณดาวน์โหลดจะถูกดักจับและส่งไปยังเซสชันที่ปลอดภัย',
                '<strong>วิธีเปิดแอปพลิเคชันใหม่:</strong> คลิกไอคอน SealSkin ในแถบเครื่องมือของเบราว์เซอร์ของคุณ',
                '<strong>วิธีจัดการพื้นที่จัดเก็บถาวร:</strong> ใช้แท็บ "โฮมไดเรกทอรี" ในหน้านี้เพื่อสร้างและลบวอลุ่มพื้นที่จัดเก็บที่สามารถใช้ได้หลายเซสชัน',
                '<strong>วิธีบันทึกตัวเลือกการเปิด:</strong> เลือกช่อง "บันทึกตัวเลือกการเปิดเหล่านี้" ในป๊อปอัปก่อนเปิดแอปพลิเคชันสำหรับประเภทไฟล์เฉพาะ (เช่น .pdf) หรือสำหรับ URL ทั้งหมด จัดการการตั้งค่าที่บันทึกไว้เหล่านี้ในแท็บ "พฤติกรรมที่ปักหมุด"'
            ],
            confirmLogout: 'คุณแน่ใจหรือไม่ว่าต้องการออกจากระบบ? การดำเนินการนี้จะล้างการกำหนดค่าที่บันทึกไว้ของคุณจากเบราว์เซอร์นี้',
        },
        config: {
            quickSetup: 'ตั้งค่าด่วน',
            quickSetupDescription: 'อัปโหลดไฟล์กำหนดค่า (.json) ที่ผู้ดูแลระบบของคุณให้มา หรือวางเนื้อหาด้านล่างเพื่อตั้งค่าส่วนขยายโดยอัตโนมัติ',
            uploadLabel: 'อัปโหลดไฟล์กำหนดค่า',
            pasteLabel: 'หรือวางข้อความกำหนดค่า',
            pastePlaceholder: 'วางการกำหนดค่า JSON ของคุณที่นี่...',
            applyButton: 'ใช้การกำหนดค่า',
            manualLink: 'การกำหนดค่าด้วยตนเอง',
            advancedTitle: 'การกำหนดค่าไคลเอนต์ (ขั้นสูง)',
            serverIpLabel: 'IP หรือโดเมนของเซิร์ฟเวอร์',
            serverIpPlaceholder: 'เช่น 192.168.1.100',
            apiPortLabel: 'พอร์ต API',
            apiPortPlaceholder: 'เช่น 8000',
            sessionPortLabel: 'พอร์ตเซสชัน',
            sessionPortPlaceholder: 'เช่น 8443',
            usernameLabel: 'ชื่อผู้ใช้',
            usernamePlaceholder: 'ชื่อผู้ใช้ของคุณ',
            privateKeyLabel: 'คีย์ส่วนตัวของคุณ (รูปแบบ PEM)',
            privateKeyPlaceholder: 'วางเนื้อหาคีย์ส่วนตัวของคุณที่นี่',
            serverKeyLabel: 'คีย์สาธารณะของเซิร์ฟเวอร์ (รูปแบบ PEM)',
            serverKeyPlaceholder: 'วางเนื้อหา server_public.pem ที่นี่',
            searchEngineLabel: 'เครื่องมือค้นหาเริ่มต้นสำหรับข้อความที่เลือก',
            saveButton: 'บันทึกการกำหนดค่า',
            loginButton: 'เข้าสู่ระบบและทดสอบ',
            automaticLink: 'การกำหนดค่าอัตโนมัติ',
            chooseFile: 'เลือกไฟล์',
            keyGeneration: 'การสร้างคีย์',
            keyGenDescription: 'หากคุณไม่มีคู่คีย์ คุณสามารถสร้างได้ที่นี่ คีย์ส่วนตัวจะถูกกรอกไว้ด้านบน โปรดให้คีย์สาธารณะแก่ผู้ดูแลระบบของคุณ',
            generateKeyButton: 'สร้างคู่คีย์ใหม่',
            publicKeyForAdminLabel: 'คีย์สาธารณะของคุณ (สำหรับผู้ดูแลระบบ)',
        },
        home: {
            title: 'โฮมไดเรกทอรีของคุณ',
            description: 'สร้างไดเรกทอรีพื้นที่จัดเก็บถาวรเพื่อใช้ในเซสชันต่างๆ ไดเรกทอรีเหล่านี้จะถูกเมาท์เข้ากับแอปพลิเคชันของคุณเป็นไดเรกทอรีการกำหนดค่าของคุณ',
            newTitle: 'สร้างโฮมไดเรกทอรีใหม่',
            nameLabel: 'ชื่อไดเรกทอรี:',
            namePlaceholder: 'เช่น my-project-files',
            nameTitle: 'ใช้เฉพาะตัวอักษร ตัวเลข ขีดล่าง หรือขีดกลางเท่านั้น',
            createButton: 'สร้างไดเรกทอรี',
            isLaboratory: 'นี่คือแอปห้องปฏิบัติการ สร้างจากอิมเมจพื้นฐานพร้อมการตั้งค่าแบบกำหนดเอง',
            laboratory: 'ห้องปฏิบัติการ',
            confirmDelete: 'คุณแน่ใจหรือไม่ว่าต้องการลบแอปที่ติดตั้งแล้ว \'{appName}\'?'
        },
        sessions: {
            title: 'เซสชันที่ใช้งานอยู่',
            application: 'แอปพลิเคชัน',
            started: 'เริ่มเมื่อ',
            noSessionsUser: 'ไม่พบเซสชันที่ใช้งานอยู่',
            noSessionsAdmin: 'ไม่พบเซสชันที่ใช้งานอยู่สำหรับผู้ใช้ใดๆ',
            sessionsFor: 'เซสชันสำหรับ {username} ({count})',
            confirmStop: 'คุณแน่ใจหรือไม่ว่าต้องการหยุดเซสชันนี้? คอนเทนเนอร์จะถูกทำลาย',
        },
        pinned: {
            title: 'พฤติกรรมส่วนขยายที่ปักหมุด',
            description: 'ตารางนี้แสดงตัวเลือกการเปิดที่คุณบันทึกไว้สำหรับประเภทไฟล์เฉพาะหรือสำหรับ URL ทั้งหมด คุณสามารถลบพฤติกรรมที่ปักหมุดเพื่อรับการแจ้งเตือนสำหรับตัวเลือกการเปิดอีกครั้ง',
            trigger: 'ทริกเกอร์',
            savedApp: 'แอปพลิเคชันที่บันทึกไว้',
            triggerSimple: 'การเปิดแบบง่าย (ปุ่มแถบเครื่องมือ)',
            triggerUrl: 'URL ทั้งหมด (จากเมนูบริบท)',
            triggerFile: 'ประเภทไฟล์: <strong>{fileType}</strong>',
            unknownApp: 'แอปที่ไม่รู้จัก ({appId}...)'
        },
        admins: {
            serverKeyTitle: 'คีย์สาธารณะของเซิร์ฟเวอร์',
            serverKeyDescription: 'นี่คือคีย์สาธารณะที่ไฟล์กำหนดค่าของผู้ใช้จะต้องใช้เพื่อเชื่อมต่อกับเซิร์ฟเวอร์นี้',
            title: 'การจัดการผู้ดูแลระบบ',
            searchPlaceholder: 'ค้นหาผู้ดูแลระบบ...',
            newTitle: 'สร้างผู้ดูแลระบบใหม่',
            publicKeyOptionalLabel: 'คีย์สาธารณะ (ไม่บังคับ):',
            publicKeyPlaceholder: 'วางคีย์สาธารณะที่นี่ หรือเว้นว่างไว้เพื่อสร้างใหม่',
            createButton: 'สร้างผู้ดูแลระบบ',
            confirmDelete: 'คุณแน่ใจหรือไม่ว่าต้องการลบผู้ดูแลระบบ \'{username}\'? การดำเนินการนี้จะลบพื้นที่จัดเก็บถาวรทั้งหมดของพวกเขาด้วยและไม่สามารถยกเลิกได้',
        },
        users: {
            title: 'การจัดการผู้ใช้',
            searchPlaceholder: 'ค้นหาผู้ใช้ตามชื่อหรือกลุ่ม...',
            newTitle: 'สร้างผู้ใช้ใหม่',
            publicKeyOptionalLabel: 'คีย์สาธารณะ (ไม่บังคับ):',
            publicKeyPlaceholder: 'วางคีย์สาธารณะของผู้ใช้ที่นี่ หรือเว้นว่างไว้เพื่อสร้างใหม่',
            settingsTitle: 'การตั้งค่าผู้ใช้',
            sessionLimitLabel: 'จำกัดเซสชัน',
            sessionLimitTitle: 'จำนวนเซสชันที่ใช้งานอยู่ที่ผู้ใช้สามารถมีได้ -1 สำหรับไม่จำกัด',
            permissionsTitle: 'สิทธิ์และการเพิ่มความปลอดภัย',
            activeAccount: 'บัญชีที่ใช้งานอยู่',
            allowStorage: 'อนุญาตพื้นที่จัดเก็บถาวร',
            allowGpu: 'อนุญาตการเข้าถึง GPU',
            hardenContainer: 'เพิ่มความปลอดภัยคอนเทนเนอร์',
            hardenWm: 'เพิ่มความปลอดภัยตัวจัดการหน้าต่าง',
            createButton: 'สร้างผู้ใช้',
            homesDisabledTooltip: 'พื้นที่จัดเก็บถาวรถูกปิดใช้งานสำหรับผู้ใช้นี้',
            confirmDelete: 'คุณแน่ใจหรือไม่ว่าต้องการลบผู้ใช้ \'{username}\'? การดำเนินการนี้จะลบพื้นที่จัดเก็บถาวรทั้งหมดของพวกเขาด้วยและไม่สามารถยกเลิกได้',
            allowPublicSharing: 'อนุญาตให้แชร์ไฟล์สาธารณะ',
        },
        groups: {
            title: 'การจัดการกลุ่ม',
            searchPlaceholder: 'ค้นหากลุ่ม...',
            newTitle: 'สร้างกลุ่มใหม่',
            nameLabel: 'ชื่อกลุ่ม:',
            overrideTitle: 'การตั้งค่าการแทนที่ของกลุ่ม',
            permissionsTitle: 'การแทนที่สิทธิ์และการเพิ่มความปลอดภัย',
            createButton: 'สร้างกลุ่ม',
            confirmDelete: 'คุณแน่ใจหรือไม่ว่าต้องการลบกลุ่ม \'{groupName}\'? ผู้ใช้ในกลุ่มนี้จะกลับไปใช้การตั้งค่าส่วนบุคคลของตนเอง',
        },
        installedApps: {
            title: 'แอปพลิเคชันที่ติดตั้งแล้ว',
            searchPlaceholder: 'ค้นหาแอปที่ติดตั้งแล้ว...',
            noAppsFound: 'ไม่พบแอปที่ติดตั้งแล้ว',
            pulling: 'กำลังดึงอิมเมจใหม่...',
            notLocal: 'ไม่พบอิมเมจในเครื่อง',
            confirmDelete: 'คุณแน่ใจหรือไม่ว่าต้องการลบแอปที่ติดตั้งแล้ว \'{appName}\'?',
        },
        appStore: {
            title: 'ร้านค้าแอป',
            refreshTitle: 'รีเฟรชร้านค้าที่เลือก',
            selectLabel: 'เลือกร้านค้าแอป',
            addLabel: 'เพิ่มร้านค้าแอปใหม่',
            namePlaceholder: 'ชื่อร้านค้า',
            urlPlaceholder: 'URL YAML ของร้านค้า',
            availableTitle: 'แอปที่มีให้',
            addManual: "เพิ่มแอปด้วยตนเอง",
            searchPlaceholder: 'ค้นหาแอปที่มีให้...',
            noAppsFound: 'ไม่พบแอปพลิเคชัน',
            availableFrom: 'แอปที่มีให้จาก {storeName}',
            couldNotLoad: 'ไม่สามารถโหลดแอปจากร้านค้านี้ได้',
        },
        appTemplates: {
            title: 'ตัวแก้ไขเทมเพลตแอปพลิเคชัน',
            loadLabel: 'โหลดเทมเพลต',
            createOption: 'สร้างเทมเพลตใหม่',
            nameLabel: 'ชื่อเทมเพลต',
            namePlaceholder: 'ป้อนชื่อสำหรับเทมเพลตใหม่',
            saveButton: 'บันทึกโปรไฟล์',
            deleteButton: 'ลบ',
            previewTitle: 'ตัวอย่าง UI',
            contentArea: 'พื้นที่เนื้อหาแอปพลิเคชัน',
            confirmDelete: 'คุณแน่ใจหรือไม่ว่าต้องการลบเทมเพลต \'{templateName}\'? การกระทำนี้ไม่สามารถยกเลิกได้',
            deleteDisabled: 'เทมเพลตนี้ไม่สามารถลบได้',
            enterName: 'กรุณาป้อนชื่อสำหรับเทมเพลตใหม่',
            settings: {
                TITLE: { label: "ชื่อหน้า", description: "ชื่อหน้าที่แสดงบนเว็บเบราว์เซอร์" },
                SELKIES_UI_TITLE: { label: "ชื่อแถบด้านข้าง", description: "ชื่อที่มุมบนซ้ายของแถบด้านข้าง" },
                SELKIES_UI_SHOW_SIDEBAR: { label: "แสดงแถบด้านข้าง", description: "แสดง UI หลักของแถบด้านข้าง" },
                SELKIES_UI_SHOW_LOGO: { label: "แสดงโลโก้", description: "แสดงโลโก้ Selkies ในแถบด้านข้าง" },
                SELKIES_UI_SHOW_CORE_BUTTONS: { label: "แสดงปุ่มหลัก", description: "แสดงปุ่มส่วนประกอบหลัก (จอแสดงผล, เสียง, ฯลฯ)" },
                SELKIES_UI_SIDEBAR_SHOW_VIDEO_SETTINGS: { label: "แสดงการตั้งค่าวิดีโอ", description: "แสดงส่วนการตั้งค่าวิดีโอในแถบด้านข้าง" },
                SELKIES_UI_SIDEBAR_SHOW_SCREEN_SETTINGS: { label: "แสดงการตั้งค่าหน้าจอ", description: "แสดงส่วนการตั้งค่าหน้าจอในแถบด้านข้าง" },
                SELKIES_UI_SIDEBAR_SHOW_AUDIO_SETTINGS: { label: "แสดงการตั้งค่าเสียง", description: "แสดงส่วนการตั้งค่าเสียงในแถบด้านข้าง" },
                SELKIES_UI_SIDEBAR_SHOW_STATS: { label: "แสดงสถิติ", description: "แสดงส่วนสถิติในแถบด้านข้าง" },
                SELKIES_UI_SIDEBAR_SHOW_CLIPBOARD: { label: "แสดงคลิปบอร์ด", description: "แสดงส่วนคลิปบอร์ดในแถบด้านข้าง" },
                SELKIES_UI_SIDEBAR_SHOW_FILES: { label: "แสดงส่วนไฟล์", description: "แสดงส่วนการถ่ายโอนไฟล์ในแถบด้านข้าง" },
                SELKIES_UI_SIDEBAR_SHOW_APPS: { label: "แสดงส่วนแอป", description: "แสดงส่วนแอปพลิเคชันในแถบด้านข้าง" },
                SELKIES_UI_SIDEBAR_SHOW_SHARING: { label: "แสดงส่วนการแชร์", description: "แสดงส่วนการแชร์ในแถบด้านข้าง" },
                SELKIES_UI_SIDEBAR_SHOW_GAMEPADS: { label: "แสดงส่วนเกมแพด", description: "แสดงส่วนเกมแพดในแถบด้านข้าง" },
                SELKIES_UI_SIDEBAR_SHOW_KEYBOARD_BUTTON: { label: "แสดงปุ่มคีย์บอร์ด", description: "แสดงปุ่มคีย์บอร์ดบนหน้าจอ" },
                SELKIES_UI_SIDEBAR_SHOW_SOFT_BUTTONS: { label: "แสดงปุ่มซอฟต์", description: "แสดงส่วนปุ่มซอฟต์ (สำหรับมือถือ)" },
                WATERMARK_PNG: { label: "เส้นทาง PNG ลายน้ำ", description: "เส้นทางเต็มภายในคอนเทนเนอร์ไปยังไฟล์ png ลายน้ำ" },
                WATERMARK_LOCATION: { label: "ตำแหน่งลายน้ำ", description: "ตำแหน่งที่จะวาดภาพทับสตรีม", options: { disabled: "ปิดใช้งาน", topLeft: "บนซ้าย", topRight: "บนขวา", bottomLeft: "ล่างซ้าย", bottomRight: "ล่างขวา", centered: "ตรงกลาง", animated: "เคลื่อนไหว" } },
                DASHBOARD: { label: "สไตล์แดชบอร์ด", description: "อนุญาตให้ผู้ใช้ตั้งค่าแดชบอร์ดของตนเอง", options: { default: "ค่าเริ่มต้น", selkiesDefault: "Selkies (ค่าเริ่มต้น)", zinc: "Zinc", wish: "Wish" } },
                SELKIES_AUDIO_ENABLED: { label: "เปิดใช้งานเสียง", description: "เปิดใช้งานการสตรีมเสียงจากเซิร์ฟเวอร์ไปยังไคลเอนต์" },
                SELKIES_MICROPHONE_ENABLED: { label: "เปิดใช้งานไมโครโฟน", description: "เปิดใช้งานการส่งต่อไมโครโฟนจากไคลเอนต์ไปยังเซิร์ฟเวอร์" },
                SELKIES_GAMEPAD_ENABLED: { label: "เปิดใช้งานเกมแพด", description: "เปิดใช้งานการรองรับเกมแพด" },
                SELKIES_CLIPBOARD_ENABLED: { label: "เปิดใช้งานคลิปบอร์ด", description: "เปิดใช้งานการซิงโครไนซ์คลิปบอร์ด" },
                SELKIES_ENABLE_BINARY_CLIPBOARD: { label: "เปิดใช้งานคลิปบอร์ดไบนารี", description: "อนุญาตข้อมูลไบนารี (รูปภาพ) บนคลิปบอร์ด" },
                SELKIES_COMMAND_ENABLED: { label: "เปิดใช้งาน Command Websocket", description: "เปิดใช้งานการแยกวิเคราะห์ข้อความ command websocket" },
                SELKIES_FILE_TRANSFERS: { label: "การถ่ายโอนไฟล์", description: "ทิศทางที่อนุญาต ('upload,download', 'upload', 'download', 'none')" },
                SELKIES_ENABLE_SHARING: { label: "เปิดใช้งานการแชร์ทั้งหมด", description: "สวิตช์หลักสำหรับคุณสมบัติการแชร์ทั้งหมด" },
                SELKIES_SECOND_SCREEN: { label: "เปิดใช้งานหน้าจอที่สอง", description: "เปิดใช้งานการรองรับจอภาพ/จอแสดงผลที่สอง" },
                SELKIES_USE_BROWSER_CURSORS: { label: "ใช้เคอร์เซอร์ของเบราว์เซอร์", description: "ใช้เคอร์เซอร์ CSS ของเบราว์เซอร์แทนการเรนเดอร์ลงบน canvas" },
                SELKIES_USE_CSS_SCALING: { label: "ใช้การปรับขนาด CSS (LoDPI)", description: "หากเป็นจริง จะส่งความละเอียดที่ต่ำกว่าและยืด canvas" },
                SELKIES_IS_MANUAL_RESOLUTION_MODE: { label: "โหมดความละเอียดด้วยตนเอง", description: "ล็อกความละเอียดไว้ที่ค่าความกว้าง/ความสูงด้วยตนเอง" },
                SELKIES_MANUAL_WIDTH: { label: "ความกว้างด้วยตนเอง", description: "ล็อกความกว้างไว้ที่ค่าคงที่ บังคับใช้โหมดด้วยตนเอง" },
                SELKIES_MANUAL_HEIGHT: { label: "ความสูงด้วยตนเอง", description: "ล็อกความสูงไว้ที่ค่าคงที่ บังคับใช้โหมดด้วยตนเอง" },
                SELKIES_SCALING_DPI: { label: "DPI การปรับขนาด UI", description: "DPI เริ่มต้นสำหรับการปรับขนาด UI" },
                SELKIES_AUDIO_BITRATE: { label: "บิตเรตเสียง", description: "บิตเรตเสียงเริ่มต้น" },
                SELKIES_ENCODER: { label: "ตัวเข้ารหัส", description: "รายการตัวเข้ารหัสที่คั่นด้วยจุลภาค ตัวแรกคือค่าเริ่มต้น" },
                SELKIES_USE_CPU: { label: "บังคับใช้การเข้ารหัส CPU", description: "บังคับใช้การเข้ารหัสโดยใช้ CPU สำหรับ pixelflux" },
                SELKIES_FRAMERATE: { label: "เฟรมเรต (ช่วงหรือค่าคงที่)", description: "เช่น '8-120' สำหรับช่วง หรือ '60' สำหรับค่าคงที่" },
                SELKIES_H264_CRF: { label: "H.264 CRF (ช่วงหรือค่าคงที่)", description: "เช่น '5-50' สำหรับช่วง หรือ '25' สำหรับค่าคงที่" },
                SELKIES_JPEG_QUALITY: { label: "คุณภาพ JPEG (ช่วงหรือค่าคงที่)", description: "เช่น '1-100' สำหรับช่วง หรือ '60' สำหรับค่าคงที่" },
                SELKIES_H264_FULLCOLOR: { label: "H.264 สีเต็ม", description: "เปิดใช้งานช่วงสีเต็ม H.264 สำหรับตัวเข้ารหัส pixelflux" },
                SELKIES_H264_STREAMING_MODE: { label: "โหมดสตรีมมิ่ง H.264 (Turbo)", description: "เปิดใช้งานโหมดสตรีมมิ่ง H.264 ที่มีความหน่วงต่ำ" },
                SELKIES_USE_PAINT_OVER_QUALITY: { label: "ใช้คุณภาพ Paint-Over", description: "เปิดใช้งานการวาดทับคุณภาพสูงสำหรับฉากที่คงที่" },
                SELKIES_PAINT_OVER_JPEG_QUALITY: { label: "คุณภาพ JPEG ของ Paint-Over", description: "เช่น '1-100' สำหรับช่วง หรือ '90' สำหรับค่าคงที่" },
                SELKIES_H264_PAINTOVER_CRF: { label: "Paint-Over H.264 CRF", description: "เช่น '5-50' สำหรับช่วง หรือ '18' สำหรับค่าคงที่" },
                SELKIES_H264_PAINTOVER_BURST_FRAMES: { label: "Paint-Over Burst Frames", description: "เช่น '1-30' สำหรับช่วง หรือ '5' สำหรับค่าคงที่" },
                HARDEN_DESKTOP: { label: "เพิ่มความปลอดภัยเดสก์ท็อป (ค่าที่ตั้งไว้ล่วงหน้า)", description: "เปิดใช้งาน DISABLE_OPEN_TOOLS, DISABLE_SUDO, และ DISABLE_TERMINALS" },
                HARDEN_OPENBOX: { label: "เพิ่มความปลอดภัยตัวจัดการหน้าต่าง (ค่าที่ตั้งไว้ล่วงหน้า)", description: "เปิดใช้งาน DISABLE_CLOSE_BUTTON, DISABLE_MOUSE_BUTTONS, และ HARDEN_KEYBINDS และยังเปิดใช้งาน RESTART_APP ด้วย" },
                DISABLE_OPEN_TOOLS: { label: "ปิดใช้งานเครื่องมือเปิด", description: "ปิดใช้งานไบนารี xdg-open และ exo-open" },
                DISABLE_SUDO: { label: "ปิดใช้งาน Sudo", description: "ปิดใช้งานคำสั่ง sudo" },
                DISABLE_TERMINALS: { label: "ปิดใช้งานเทอร์มินัล", description: "ปิดใช้งานเทอร์มินัลอีมูเลเตอร์ทั่วไป" },
                DISABLE_CLOSE_BUTTON: { label: "ปิดใช้งานปุ่มปิดหน้าต่าง", description: "ลบปุ่มปิดออกจากแถบชื่อเรื่องของหน้าต่าง" },
                DISABLE_MOUSE_BUTTONS: { label: "ปิดใช้งานคลิกขวา/กลาง", description: "ปิดใช้งานเมนูบริบทของคลิกขวาและคลิกกลาง" },
                HARDEN_KEYBINDS: { label: "เพิ่มความปลอดภัยคีย์ลัด", description: "ปิดใช้งานคีย์ลัดเริ่มต้นของ Openbox เช่น Alt+F4" },
                RESTART_APP: { label: "รีสตาร์ทแอปเมื่อปิด", description: "รีสตาร์ทแอปพลิเคชันหลักโดยอัตโนมัติหากถูกปิด" },
                MAX_RES: { label: "ความละเอียดสูงสุด", description: "ความละเอียดสูงสุดสำหรับคอนเทนเนอร์ ค่าเริ่มต้นคือ 16k" },
                START_DOCKER: { label: "เริ่ม Docker-in-Docker", description: "หากเป็นเท็จ คอนเทนเนอร์ที่มีสิทธิ์พิเศษจะไม่เริ่ม DinD" },
                DISABLE_IPV6: { label: "ปิดใช้งาน IPv6", description: "หากเป็นจริง จะปิดใช้งาน IPv6" },
                DISABLE_ZINK: { label: "ปิดใช้งาน Zink", description: "ไม่ตั้งค่าตัวแปรสภาพแวดล้อม Zink หากตรวจพบการ์ดวิดีโอ" },
                DISABLE_DRI3: { label: "ปิดใช้งาน DRI3", description: "ไม่ใช้การเร่งความเร็ว DRI3 หากตรวจพบการ์ดวิดีโอ" },
                NO_DECOR: { label: "ไม่มีการตกแต่งหน้าต่าง", description: "เรียกใช้แอปพลิเคชันโดยไม่มีขอบหน้าต่างสำหรับการใช้งาน PWA" },
                NO_FULL: { label: "ไม่มีโหมดเต็มหน้าจอ", description: "ไม่ทำให้แอปพลิเคชันเต็มหน้าจอโดยอัตโนมัติ" },
                NO_GAMEPAD: { label: "ปิดใช้งานการฉีดเกมแพด", description: "ปิดใช้งานการฉีดตัวสอดแทรกเกมแพดในพื้นที่ผู้ใช้" },
                SELKIES_DEBUG: { label: "เปิดใช้งานการดีบัก Selkies", description: "เปิดใช้งานการบันทึกการดีบักสำหรับส่วนประกอบการสตรีม" },
            }
        },
        appLaboratory: {
            title: 'ห้องปฏิบัติการแอป',
            description: 'สร้างและทดสอบการกำหนดค่าแอปพลิเคชันแบบกำหนดเองโดยการวางชั้นการเปลี่ยนแปลงทับแอปพื้นฐาน',
            selectApp: 'เลือกแอป',
            createNew: 'สร้างแอปใหม่',
            baseApp: 'แอปพลิเคชันพื้นฐาน',
            baseAppDescription: 'แอปพลิเคชันที่ติดตั้งแล้วซึ่งแอปแบบกำหนดเองใหม่ของคุณจะใช้เป็นฐาน',
            selectBase: 'เลือกแอปพื้นฐาน',
            customizationTitle: 'การปรับแต่ง',
            appName: 'ชื่อแอป',
            appIcon: 'ไอคอนแอป',
            uploadIcon: 'อัปโหลดไอคอน',
            autostartScriptLabel: 'สคริปต์เริ่มทำงานอัตโนมัติแบบกำหนดเอง',
            permissionsTitle: 'สิทธิ์',
            usersLabel: 'ผู้ใช้ที่ได้รับอนุญาต',
            groupsLabel: 'กลุ่มที่ได้รับอนุญาต',
            launchButton: 'บันทึกและเริ่มเซสชันการปรับแต่ง',
            closeButton: 'ปิดเซสชันและสิ้นสุด',
            savingAndLaunching: 'กำลังบันทึกและเริ่ม...',
            placeholder: 'ห้องปฏิบัติการแอปช่วยให้คุณสามารถกำหนดค่าโฮมไดเรกทอรีพื้นฐานและสคริปต์เริ่มต้นสำหรับแอปพลิเคชันที่สร้างจากแอปพลิเคชันที่ติดตั้งไว้แล้ว โฮมไดเรกทอรีนี้จะถูกคัดลอกเมื่อเริ่มต้นครั้งแรกสำหรับผู้ใช้พร้อมกับไฟล์และการตั้งค่าทั้งหมดที่คุณตั้งค่าในเซสชันนี้ คุณสามารถเริ่มแอปห้องปฏิบัติการที่มีอยู่ใหม่เพื่อแก้ไขเนื้อหาเพิ่มเติมได้',
            formInvalid: 'โปรดเลือกแอปพื้นฐานและระบุชื่อสำหรับแอปใหม่',
        },
        modals: {
            editUserTitle: 'แก้ไขผู้ใช้: {username}',
            saveChanges: 'บันทึกการเปลี่ยนแปลง',
            effectiveSettings: 'การตั้งค่าที่มีผล (พร้อมการแทนที่ของกลุ่ม)',
            editGroupTitle: 'แก้ไขกลุ่ม: {groupName}',
            userConfigTitle: 'การกำหนดค่าผู้ใช้',
            warning: 'นี่เป็นครั้งเดียวที่จะแสดงการกำหนดค่านี้ โปรดส่งให้ผู้ใช้อย่างปลอดภัย',
            info: 'คุณสามารถดาวน์โหลดไฟล์กำหนดค่านี้เพื่อตั้งค่า SealSkin บนอุปกรณ์อื่นได้อย่างง่ายดาย เก็บไฟล์นี้ให้ปลอดภัยเนื่องจากมีคีย์ส่วนตัวของคุณอยู่',
            configDataLabel: 'ข้อมูลการกำหนดค่า (JSON)',
            copyButton: 'คัดลอกข้อความ',
            downloadButton: 'ดาวน์โหลดไฟล์',
            manageHomeDirs: 'จัดการโฮมไดเรกทอรี',
            dirsForUser: 'ไดเรกทอรีสำหรับผู้ใช้: {username}',
            dirsForAdmin: 'ไดเรกทอรีสำหรับผู้ดูแลระบบ: {username}',
            newDirForUser: 'สร้างไดเรกทอรีใหม่สำหรับผู้ใช้',
            createDirButton: 'สร้างไดเรกทอรี',
            confirmDeleteDir: 'คุณแน่ใจหรือไม่ว่าต้องการลบ \'{homeName}\' สำหรับผู้ใช้ \'{username}\'? การกระทำนี้เป็นการกระทำถาวร',
            installAppTitle: 'ติดตั้ง {appName}',
            editAppTitle: 'แก้ไข {appName}',
            customNameLabel: 'ชื่อที่กำหนดเอง',
            imageLabel: 'อิมเมจคอนเทนเนอร์',
            permissions: 'สิทธิ์',
            allowedUsersLabel: 'ผู้ใช้ที่ได้รับอนุญาต (คั่นด้วยจุลภาค, \'all\' สำหรับทุกคน)',
            allowedGroupsLabel: 'กลุ่มที่ได้รับอนุญาต (คั่นด้วยจุลภาค, \'all\' สำหรับทุกคน)',
            features: 'คุณสมบัติ',
            gpuSupport: 'รองรับ GPU',
            homeMounting: 'การเมาท์โฮมไดเรกทอรี',
            urlSupport: 'รองรับการเปิด URL',
            fileSupport: 'รองรับการเปิดไฟล์',
            autoUpdate: 'อัปเดตอิมเมจอัตโนมัติ',
            advancedSettings: 'การตั้งค่าขั้นสูง',
            appTemplateLabel: 'เทมเพลตแอปพลิเคชัน',
            appTemplateDescription: 'เลือกเทมเพลตที่กำหนดค่าไว้ล่วงหน้าสำหรับการตั้งค่าการเปิดคอนเทนเนอร์ขั้นสูง',
            customAutostartScriptLabel: 'สคริปต์เริ่มทำงานอัตโนมัติแบบกำหนดเอง',
            customAutostartScriptDescription: 'ปรับแต่งตรรกะการเริ่มทำงานอัตโนมัติ เว้นว่างไว้เพื่อใช้ค่าเริ่มต้นจากผู้ให้บริการแอปพลิเคชัน',
            saveInstallation: 'บันทึกการติดตั้ง',
            updateStatusTitle: 'สถานะการอัปเดตสำหรับ {appName}',
            checkingUpdates: 'กำลังตรวจสอบการอัปเดต...',
            updateAvailable: 'มีเวอร์ชันอิมเมจใหม่พร้อมใช้งาน!',
            yourVersion: 'เวอร์ชันของคุณ: {sha}',
            latestAvailable: 'เวอร์ชันล่าสุดพร้อมให้ดึงจากรีจิสทรีแล้ว',
            pullLatest: 'ดึงอิมเมจล่าสุด',
            upToDate: 'อิมเมจของคุณเป็นเวอร์ชันล่าสุด',
            currentVersion: 'เวอร์ชันปัจจุบัน: {sha}',
            errorChecking: 'เกิดข้อผิดพลาดในการตรวจสอบการอัปเดต',
            pullingLatest: 'กำลังดึงอิมเมจล่าสุด... อาจใช้เวลาสักครู่',
            pullComplete: 'ดึงข้อมูลเสร็จสมบูรณ์!',
            newVersion: 'เวอร์ชันใหม่: {sha}',
            errorPulling: 'เกิดข้อผิดพลาดในการดึงอิมเมจ',
            manualInstallNote: "หมายเหตุ: อิมเมจที่เพิ่มด้วยตนเองควรเป็นอิมเมจที่เข้ากันได้กับ selkies-baseimage",
        },
        status: {
            loggingIn: 'กำลังเข้าสู่ระบบ...',
            configSaved: 'บันทึกการกำหนดค่าสำเร็จ!',
            configApplied: 'ใช้การกำหนดค่าแล้ว! กรุณาเข้าสู่ระบบและทดสอบ',
            configApplyFailed: 'ไม่สามารถใช้การกำหนดค่าได้: {error}',
            fileReadError: 'เกิดข้อผิดพลาดในการอ่านไฟล์',
            noConfig: 'กรุณาให้ไฟล์กำหนดค่าหรือข้อความ',
            loggedInAdmin: 'เข้าสู่ระบบในฐานะผู้ดูแลระบบ: {username}',
            loggedInUser: 'เข้าสู่ระบบในฐานะผู้ใช้มาตรฐาน: {username}',
            loginFailed: 'การเข้าสู่ระบบล้มเหลว: {error}',
            adminDataRefreshFailed: 'ไม่สามารถรีเฟรชข้อมูลผู้ดูแลระบบได้: {error}',
            logoutSuccess: 'ออกจากระบบและล้างการกำหนดค่าแล้ว',
            generateConfigFailed: 'ไม่สามารถสร้างการกำหนดค่าได้ ขาดรายละเอียดผู้ใช้',
            copySuccess: 'คัดลอกการกำหนดค่าไปยังคลิปบอร์ดแล้ว!',
            copyFailed: 'ไม่สามารถคัดลอกข้อความได้',
            publicKeyCopied: 'คัดลอกคีย์สาธารณะแล้ว!',
            keyCopyFailed: 'ไม่สามารถคัดลอกคีย์ได้',
            creatingAdmin: 'กำลังสร้างผู้ดูแลระบบ...',
            adminCreated: 'สร้างผู้ดูแลระบบ \'{username}\' แล้ว',
            adminCreateFailed: 'เกิดข้อผิดพลาดในการสร้างผู้ดูแลระบบ: {error}',
            adminDeleted: 'ลบผู้ดูแลระบบ \'{username}\' สำเร็จ',
            adminDeleteFailed: 'เกิดข้อผิดพลาดในการลบผู้ดูแลระบบ: {error}',
            creatingUser: 'กำลังสร้างผู้ใช้...',
            userCreated: 'สร้างผู้ใช้ \'{username}\' แล้ว',
            userCreateFailed: 'เกิดข้อผิดพลาดในการสร้างผู้ใช้: {error}',
            userDeleted: 'ลบผู้ใช้ \'{username}\' สำเร็จ',
            userDeleteFailed: 'เกิดข้อผิดพลาดในการลบผู้ใช้: {error}',
            userUpdated: 'อัปเดตผู้ใช้ \'{username}\' สำเร็จ',
            userUpdateFailed: 'เกิดข้อผิดพลาดในการอัปเดตผู้ใช้: {error}',
            creatingGroup: 'กำลังสร้างกลุ่ม...',
            groupCreated: 'สร้างกลุ่ม \'{groupName}\' แล้ว',
            groupCreateFailed: 'เกิดข้อผิดพลาดในการสร้างกลุ่ม: {error}',
            groupDeleted: 'ลบกลุ่ม \'{groupName}\' สำเร็จ',
            groupDeleteFailed: 'เกิดข้อผิดพลาดในการลบกลุ่ม: {error}',
            groupUpdated: 'อัปเดตกลุ่ม \'{groupName}\' สำเร็จ',
            groupUpdateFailed: 'เกิดข้อผิดพลาดในการอัปเดตกลุ่ม: {error}',
            homedirLoadFailed: 'ไม่สามารถโหลดโฮมไดเรกทอรีได้: {error}',
            homedirCreateFailed: 'เกิดข้อผิดพลาดในการสร้างไดเรกทอรี: {error}',
            homedirCreated: 'สร้างโฮมไดเรกทอรี \'{homeName}\' แล้ว',
            homedirDeleted: 'ลบไดเรกทอรี \'{homeName}\' แล้ว',
            homedirDeleteFailed: 'เกิดข้อผิดพลาดในการลบไดเรกทอรี: {error}',
            homedirCreatedFor: 'สร้างไดเรกทอรี \'{homeName}\' สำหรับ {username} แล้ว',
            homedirDeletedFor: 'ลบไดเรกทอรี \'{homeName}\' สำหรับ {username} แล้ว',
            sessionsLoadFailed: 'ไม่สามารถโหลดเซสชันได้: {error}',
            sessionStopError: 'เกิดข้อผิดพลาดในการหยุดเซสชัน: {error}',
            sessionStopped: 'หยุดเซสชันสำเร็จ',
            appDataRefreshFailed: 'ไม่สามารถรีเฟรชข้อมูลแอปได้: {error}',
            closingSession: 'กำลังส่งการเปลี่ยนแปลงเซสชันการปรับแต่ง...',
            sessionClosed: 'ปิดเซสชันการปรับแต่งแล้ว',
            sessionCloseFailed: 'ไม่สามารถปิดเซสชันการปรับแต่งได้: {error}',
            fetchingApps: 'กำลังดึงแอปจากร้านค้า...',
            fetchAppsFailed: 'ไม่สามารถดึงแอปจากร้านค้าได้: {error}',
            appStoreAddFailed: 'เกิดข้อผิดพลาดในการเพิ่มร้านค้า: {error}',
            appStoreAdded: 'เพิ่มร้านค้าแอป \'{name}\' แล้ว',
            appSaved: 'แอป \'{name}\' {action} สำเร็จ',
            appSaveActions: {
                updated: 'อัปเดต',
                installed: 'ติดตั้ง'
            },
            appSaveFailed: 'เกิดข้อผิดพลาดในการบันทึกแอป: {error}',
            appDeleted: 'ลบแอป \'{name}\' แล้ว',
            appDeleteFailed: 'เกิดข้อผิดพลาดในการลบแอป: {error}',
            templateSaved: 'บันทึกเทมเพลต \'{name}\' สำเร็จ',
            templateSaveFailed: 'เกิดข้อผิดพลาดในการบันทึกเทมเพลต: {error}',
            templateDeleted: 'ลบเทมเพลต \'{name}\' สำเร็จ',
            templateDeleteFailed: 'เกิดข้อผิดพลาดในการลบเทมเพลต: {error}',
            pinRemoved: 'ลบพฤติกรรมที่ปักหมุดแล้ว',
            keyGenerated: 'สร้างคู่คีย์ใหม่แล้ว',
            keyGenFailed: 'การสร้างคีย์ล้มเหลว: {{error}}',
            pendingConfigSaved: 'บันทึกการกำหนดค่าที่รอดำเนินการแล้ว ตอนนี้คุณสามารถให้คีย์สาธารณะของคุณแก่ผู้ดูแลระบบได้',
            settingsSaved: 'บันทึกการตั้งค่าแล้ว',
            appCreated: 'สร้างแอป \'{name}\' สำเร็จ',
            launchFailed: 'การเปิดใช้งานล้มเหลว: {error}',
        },
        placeholders: {
            noAdmins: 'ไม่พบผู้ดูแลระบบ',
            noUsers: 'ไม่พบผู้ใช้',
            noGroups: 'ไม่พบกลุ่ม',
            noHomeDirs: 'ไม่พบโฮมไดเรกทอรี',
            noSessions: 'ไม่พบเซสชันที่ใช้งานอยู่',
            noPinned: 'ไม่พบพฤติกรรมที่ปักหมุด',
            errorLoading: 'เกิดข้อผิดพลาดในการโหลดไดเรกทอรี',
            noInstalledApps: 'ยังไม่มีแอปพลิเคชันใดติดตั้ง',
        },
    },
    popup: {
        tabs: {
            launch: 'เปิดใหม่',
            sessions: 'เซสชันที่ใช้งานอยู่',
            manageFiles: 'จัดการไฟล์',
            uploadStorage: 'อัปโหลดไปยังที่เก็บข้อมูล',
            uploadFiles: 'อัปโหลดไฟล์',
            uploadFilesTitle: 'เปิดหน้าอัปโหลดไฟล์โดยเฉพาะ'
        },
        launchView: {
            searchPlaceholder: 'ค้นหาแอปพลิเคชัน...',
            uploadingFile: 'กำลังอัปโหลดไฟล์...',
            gpuLabel: 'GPU',
            storageLabel: 'พื้นที่จัดเก็บ',
            languageLabel: 'ภาษา',
            cleanroom: 'ห้องปลอดเชื้อ (ชั่วคราว)',
            noGpu: 'ไม่มี',
            saveOptions: 'บันทึกตัวเลือกการเปิดเหล่านี้',
            saveOptionsForUrl: 'บันทึกตัวเลือกสำหรับ URL ทั้งหมด',
            saveOptionsForFile: 'บันทึกตัวเลือกสำหรับไฟล์ .{extension}',
            openFile: 'เปิดไฟล์เมื่อเปิด',
            launchButton: 'เปิด',
            launchingButton: 'กำลังเปิด...',
            uploadingButton: 'กำลังอัปโหลด...',
            autoHome: 'อัตโนมัติ (คงอยู่ตามแอป)',
            collaborationMode: 'เซสชันการทำงานร่วมกัน',
            waylandMode: 'โหมด Wayland',
        },
        sessionsView: {
            noSessions: 'ไม่พบเซสชันที่ใช้งานอยู่',
        },
        uploadStorageView: {
            selectHome: 'เลือกโฮมไดเรกทอรี',
            description: 'การดำเนินการนี้จะอัปโหลดไฟล์ <strong>{filename}</strong> ไปยังที่เก็บไฟล์ของคุณโดยตรงเพื่อใช้ในอนาคต',
            descriptionFallback: 'การดำเนินการนี้จะอัปโหลดไฟล์ <strong>{filename}</strong> ไปยังที่เก็บไฟล์ของคุณโดยตรงเพื่อใช้ในอนาคต',
            uploadButton: 'อัปโหลดไฟล์',
            uploadingButton: 'กำลังอัปโหลด...',
            preparing: 'กำลังเตรียมไฟล์...',
            uploadingChunk: 'กำลังอัปโหลดส่วนที่ {current} จาก {total}...',
            finalizing: 'กำลังสิ้นสุด...',
            uploadComplete: 'อัปโหลดเสร็จสมบูรณ์!',
        },
        status: {
            unconfigured: 'กรุณากำหนดค่าส่วนขยายผ่านหน้าตัวเลือก',
            openingServerFile: "กำลังเปิดไฟล์ฝั่งเซิร์ฟเวอร์: {filename}",
            openingFile: 'กำลังเปิดไฟล์: {filename}',
            openingUrl: 'กำลังเปิด URL: {targetUrl}',
            error: 'ข้อผิดพลาด: {message}',
            preparingFile: 'กำลังเตรียมไฟล์...',
            sendingFile: 'กำลังส่งไฟล์ไปยังเซสชัน...',
            errorSendingFile: 'เกิดข้อผิดพลาดในการส่งไฟล์: {message}',
            errorClosingSession: 'เกิดข้อผิดพลาดในการปิดเซสชัน: {message}',
            preparingSession: 'กำลังเตรียมเซสชันแยก...',
            fetchingData: 'กำลังดึงข้อมูลไฟล์...',
            fetchDataFailed: 'ไม่สามารถดึงข้อมูลไฟล์ได้: {statusText}',
            unknownAction: 'การกระทำในการเปิดที่ไม่รู้จัก',
            noAppSelected: 'กรุณาเลือกแอปพลิเคชัน',
            noAppsAvailable: 'ไม่มีแอปพลิเคชันสำหรับบัญชีของคุณ',
            uploadSuccess: 'อัปโหลดไฟล์สำเร็จ!',
            creatingAutoHome: 'กำลังสร้างโฮมไดเรกทอรีอัตโนมัติ...',
        },
        languages: {
            default: 'ค่าเริ่มต้น ({locale})'
        }
    },
    upload: {
        title: 'อัปโหลดไฟล์',
        description: 'เลือกไฟล์จากคอมพิวเตอร์ของคุณเพื่อเปิดในเซสชันที่ปลอดภัยและแยกต่างหาก',
        dropzone: {
            title: 'ลากและวางไฟล์ที่นี่',
            or: 'หรือ',
            button: 'เลือกไฟล์',
        },
        confirm: {
            ready: 'ไฟล์พร้อมที่จะเปิดอย่างปลอดภัยแล้ว',
            button: 'ดำเนินการต่อเพื่อเปิด',
        }
    },
    files: {
        title: 'ไฟล์ SealSkin',
        header: {
            title: 'ไฟล์',
            newFolder: 'โฟลเดอร์ใหม่',
            uploadFiles: 'อัปโหลดไฟล์',
            uploadFolder: 'อัปโหลดโฟลเดอร์'
        },
        sidebar: {
            sharedFiles: 'ไฟล์ SealSkin',
            publicShares: 'การแชร์สาธารณะ'
        },
        shares: {
            title: 'ไฟล์ที่แชร์สาธารณะ',
            searchPlaceholder: 'ค้นหาตามชื่อไฟล์หรือ ID...'
        },
        table: {
            name: 'ชื่อ',
            size: 'ขนาด',
            lastModified: 'แก้ไขล่าสุด',
            created: 'สร้างเมื่อ',
            expires: 'หมดอายุ',
            url: 'URL สาธารณะ',
            passwordProtected: 'รหัสผ่าน'
        },
        dropzone: {
            title: 'วางไฟล์เพื่ออัปโหลด'
        },
        pagination: {
            previous: '« ก่อนหน้า',
            next: 'ถัดไป »',
            pageOf: 'หน้า {page} จาก {totalPages}'
        },
        modals: {
            newFolder: {
                title: 'สร้างโฟลเดอร์ใหม่',
                folderNameLabel: 'ชื่อโฟลเดอร์',
                nameTitle: 'ใช้เฉพาะตัวอักษร, ตัวเลข, ขีดล่าง, ยัติภังค์, หรือจุดเท่านั้น',
                createButton: 'สร้าง'
            },
            confirmDelete: {
                title: 'ยืนยันการลบ',
                message: 'คุณแน่ใจหรือไม่ว่าต้องการลบ {count, plural, one {1 รายการที่เลือก} other {{count} รายการที่เลือก}}? การกระทำนี้ไม่สามารถยกเลิกได้',
                messageDefault: 'คุณแน่ใจหรือไม่ว่าต้องการลบรายการที่เลือก? การกระทำนี้ไม่สามารถยกเลิกได้'
            },
            uploadProgress: {
                title: 'ความคืบหน้าการอัปโหลด',
                doneButton: 'เสร็จสิ้น'
            },
            share: {
                title: 'แชร์ไฟล์',
                sharingFile: 'กำลังแชร์ไฟล์: <strong>{filename}</strong>',
                passwordLabel: 'รหัสผ่าน (ไม่บังคับ)',
                passwordPlaceholder: 'เว้นว่างไว้หากไม่ต้องการรหัสผ่าน',
                expiryLabel: 'หมดอายุใน (ชั่วโมง, ไม่บังคับ)',
                expiryPlaceholder: 'เช่น 24 สำหรับหนึ่งวัน',
                shareButton: 'สร้างลิงก์แชร์'
            }
        },
        status: {
            homeDirLoadFailed: 'ไม่สามารถโหลดโฮมไดเรกทอรี: {error}',
            filesLoadFailed: 'เกิดข้อผิดพลาดในการโหลดไฟล์: {error}',
            deleteProtectedError: 'ไม่สามารถลบโฟลเดอร์ระบบที่ได้รับการป้องกัน',
            deletingItems: 'กำลังลบ {count, plural, one {1 รายการ} other {{count} รายการ}}...',
            deleteSuccess: 'ลบสำเร็จ',
            deleteFailed: 'การลบล้มเหลว: {error}',
            preparingUpload: 'กำลังเตรียมอัปโหลด {count, plural, one {1 ไฟล์} other {{count} ไฟล์}}...',
            uploadPrepFailed: 'เกิดข้อผิดพลาดระหว่างการเตรียมอัปโหลดโฟลเดอร์: {error}',
            notConfigured: 'ข้อผิดพลาด: SealSkin ยังไม่ได้กำหนดค่า โปรดตั้งค่าในตัวเลือก',
            folderCreated: 'สร้างโฟลเดอร์ \'{folderName}\' แล้ว',
            folderCreateFailed: 'เกิดข้อผิดพลาดในการสร้างโฟลเดอร์: {error}',
            shareCreated: 'สร้างการแชร์สำเร็จ! ลิงก์ถูกคัดลอกไปยังคลิปบอร์ดของคุณแล้ว',
            shareCreateFailed: 'ไม่สามารถสร้างการแชร์ได้: {error}',
            sharesLoadFailed: 'ไม่สามารถโหลดไฟล์ที่แชร์ได้: {error}',
            shareDeleteFailed: 'ไม่สามารถลบการแชร์ได้: {error}',
            shareDeleted: 'ลบการแชร์สำเร็จแล้ว',
            urlCopied: 'คัดลอก URL สาธารณะไปยังคลิปบอร์ดแล้ว'
        },
        placeholders: {
            errorLoading: 'เกิดข้อผิดพลาดในการโหลดไฟล์',
            folderEmpty: 'โฟลเดอร์นี้ว่างเปล่า',
            noHomeDirs: 'ไม่มีโฮมไดเรกทอรีที่ใช้ได้',
            noShares: 'คุณยังไม่ได้แชร์ไฟล์ใดๆ'
        },
        uploadStatus: {
            pending: 'รอดำเนินการ',
            initiating: 'กำลังเริ่มต้น...',
            uploading: 'กำลังอัปโหลด...',
            finalizing: 'กำลังสิ้นสุด...',
            completed: 'เสร็จสมบูรณ์',
            error: 'ข้อผิดพลาด'
        }
    }
};

// --- Filipino Translations ---
const fil = {
    background: {
        contextMenu: {
            openUrl: 'Buksan ang Link sa SealSkin',
            openFile: 'Buksan ang Target ng Link bilang File sa SealSkin',
            sendMedia: 'Ipadala ang Media sa SealSkin',
            searchText: 'Hanapin ang "%s" sa SealSkin',
            sendDownload: 'Ipadala ang Susunod na Download sa SealSkin'
        }
    },
    common: {
        actions: 'Mga Aksyon',
        active: 'Aktibo',
        cancel: 'Kanselahin',
        manage: 'Pamahalaan',
        delete: 'Burahin',
        edit: 'I-edit',
        save: 'I-save',
        none: 'wala',
        error: 'Error',
        na: 'N/A',
        of: 'ng',
        status: 'Katayuan',
        username: 'Username',
        group: 'Grupo',
        groups: 'Mga Grupo',
        publicKey: 'Pampublikong Key',
        name: 'Pangalan',
        source: 'Pinagmulan',
        imageVersion: 'Bersyon ng Imahe',
        language: 'Wika',
        storage: 'Imbakan',
        gpu: 'GPU',
        version: 'Bersyon',
        checked: 'Nasuri',
        never: 'Hindi Kailanman',
        stop: 'Itigil',
        reopen: 'Buksan Muli',
        sendFile: 'Ipadala ang File',
        share: 'Ibahagi',
        search: 'Maghanap',
        refresh: 'I-refresh',
        close: 'Isara',
        copy: 'Kopyahin',
        open: "Buksan",
        copyUrl: 'Kopyahin ang URL',
        download: 'I-download',
        next: 'Susunod',
        previous: 'Nakaraan',
        page: 'Pahina',
        home: 'Home',
        homes: 'Mga Home',
        sessions: 'Mga Sesyon',
        users: 'Mga User',
        admins: 'Mga Admin',
        yes: 'Oo',
        no: 'Hindi',
        daysAgo: '{count, plural, one {1 araw ang nakalipas} other {{count} na araw ang nakalipas}}',
        hoursAgo: '{count, plural, one {1 oras ang nakalipas} other {{count} na oras ang nakalipas}}',
        minutesAgo: '{count, plural, one {1 minuto ang nakalipas} other {{count} na minuto ang nakalipas}}',
        justNow: 'ngayon lang',
        bytes: 'Bytes',
        kb: 'KB',
        mb: 'MB',
        gb: 'GB',
        tb: 'TB',
        pb: 'PB',
    },
    options: {
        sidebar: {
            config: 'Konfigurasyon',
            home: 'Mga Home Directory',
            sessions: 'Mga Aktibong Sesyon',
            pinned: 'Naka-pin na Gawi',
            appStore: 'Tindahan ng App',
            appTemplates: 'Mga Template ng App',
            appLaboratory: 'Laboratoryo ng App',
            installedApps: 'Mga Naka-install na App',
            users: 'Mga User',
            groups: 'Mga Grupo',
            admins: 'Mga Admin',
        },
        dashboard: {
            title: 'Dashboard',
            clientSettings: 'Mga Setting ng Kliyente',
            exportConfig: 'I-export ang Konfigurasyon',
            userStatus: 'Katayuan ng User',
            loggedInAs: 'Naka-log in bilang:',
            role: 'Papel',
            roleAdmin: 'Administrator',
            roleUser: 'Standard na User',
            serverInfo: 'Impormasyon ng Server',
            server: 'Server:',
            cpuModel: 'Modelo ng CPU:',
            storageUsage: 'Paggamit ng Imbakan:',
            detectedGpus: 'Mga Natukoy na GPU:',
            logout: 'Mag-logout at Linisin ang Konfigurasyon',
            howTo: 'Paano Gamitin ang SealSkin',
            howToDescription: 'Ang seksyon na ito ay naglalaman ng pangunahing dokumentasyon kung paano gamitin ang extension.',
            howToList: [
                '<strong>Upang buksan ang nilalaman sa isolation:</strong> Mag-right-click sa anumang link, imahe, o napiling teksto at pumili ng opsyon mula sa "SealSkin Isolation" context menu.',
                '<strong>Upang magpadala ng download sa isolation:</strong> Mag-right-click sa pahina at piliin ang "Ipadala ang Susunod na Download sa Isolation". Ang susunod na file na iyong ida-download ay mahaharang at ipapadala sa isang ligtas na sesyon.',
                '<strong>Upang maglunsad ng malinis na aplikasyon:</strong> I-click ang icon ng SealSkin sa toolbar ng iyong browser.',
                '<strong>Upang pamahalaan ang persistenteng imbakan:</strong> Gamitin ang tab na "Mga Home Directory" sa pahinang ito upang lumikha at magbura ng mga volume ng imbakan na maaaring gamitin sa maraming sesyon.',
                '<strong>Upang i-save ang mga opsyon sa paglunsad:</strong> Lagyan ng tsek ang kahon na "I-save ang mga opsyon sa paglunsad na ito" sa popup bago maglunsad ng aplikasyon para sa isang partikular na uri ng file (hal., .pdf) o para sa lahat ng URL. Pamahalaan ang mga naka-save na kagustuhan na ito sa tab na "Naka-pin na Gawi".'
            ],
            confirmLogout: 'Sigurado ka bang gusto mong mag-logout? Ito ay maglilinis ng iyong naka-save na konfigurasyon mula sa browser na ito.',
        },
        config: {
            quickSetup: 'Mabilis na Setup',
            quickSetupDescription: 'I-upload ang configuration file (.json) na ibinigay ng iyong administrator, o i-paste ang nilalaman nito sa ibaba upang awtomatikong i-set up ang extension.',
            uploadLabel: 'I-upload ang Config File',
            pasteLabel: 'O I-paste ang Config Text',
            pastePlaceholder: 'I-paste ang iyong JSON configuration dito...',
            applyButton: 'Ilapat ang Konfigurasyon',
            manualLink: 'Manu-manong Konfigurasyon',
            advancedTitle: 'Konfigurasyon ng Kliyente (Advanced)',
            serverIpLabel: 'Server IP o Domain',
            serverIpPlaceholder: 'hal., 192.168.1.100',
            apiPortLabel: 'API Port',
            apiPortPlaceholder: 'hal., 8000',
            sessionPortLabel: 'Session Port',
            sessionPortPlaceholder: 'hal., 8443',
            usernameLabel: 'Username',
            usernamePlaceholder: 'Iyong username',
            privateKeyLabel: 'Iyong Pribadong Key (PEM Format)',
            privateKeyPlaceholder: 'I-paste ang nilalaman ng iyong pribadong key dito',
            serverKeyLabel: 'Pampublikong Key ng Server (PEM Format)',
            serverKeyPlaceholder: 'I-paste ang nilalaman ng server_public.pem dito',
            searchEngineLabel: 'Default na Search Engine para sa Napiling Teksto',
            saveButton: 'I-save ang Konfigurasyon',
            loginButton: 'Mag-login at Subukan',
            automaticLink: 'Awtomatikong Konfigurasyon',
            chooseFile: 'Pumili ng File',
            keyGeneration: 'Pagbuo ng Key',
            keyGenDescription: 'Kung wala kang key pair, maaari kang bumuo ng isa dito. Ang pribadong key ay pupunan sa itaas. Ibigay ang pampublikong key sa iyong administrator.',
            generateKeyButton: 'Bumuo ng Bagong Key Pair',
            publicKeyForAdminLabel: 'Iyong Pampublikong Key (para sa admin)',
        },
        home: {
            title: 'Iyong mga Home Directory',
            description: 'Lumikha ng mga persistenteng direktoryo ng imbakan upang gamitin sa iba\'t ibang sesyon. Ang mga ito ay ikakabit sa iyong mga aplikasyon bilang iyong direktoryo ng konfigurasyon.',
            newTitle: 'Gumawa ng Bagong Home Directory',
            nameLabel: 'Pangalan ng Directory:',
            namePlaceholder: 'hal., aking-mga-file-ng-proyekto',
            nameTitle: 'Gumamit lamang ng mga letra, numero, underscore, o gitling.',
            createButton: 'Gumawa ng Directory',
            isLaboratory: 'Ito ay isang Laboratory app, na binuo mula sa isang base image na may mga custom na setting.',
            laboratory: 'Laboratoryo',
            confirmDelete: 'Sigurado ka bang gusto mong burahin ang naka-install na app na \'{appName}\'?'
        },
        sessions: {
            title: 'Mga Aktibong Sesyon',
            application: 'Aplikasyon',
            started: 'Sinimulan',
            noSessionsUser: 'Walang nahanap na aktibong sesyon.',
            noSessionsAdmin: 'Walang nahanap na aktibong sesyon para sa sinumang user.',
            sessionsFor: 'Mga sesyon para kay {username} ({count})',
            confirmStop: 'Sigurado ka bang gusto mong itigil ang sesyon na ito? Ang container ay masisira.',
        },
        pinned: {
            title: 'Naka-pin na Gawi ng Extension',
            description: 'Ipinapakita ng talahanayang ito ang mga opsyon sa paglunsad na iyong na-save para sa mga partikular na uri ng file o para sa lahat ng URL. Maaari mong alisin ang isang naka-pin na gawi upang muling hilingin sa iyo ang mga opsyon sa paglunsad.',
            trigger: 'Trigger',
            savedApp: 'Naka-save na Aplikasyon',
            triggerSimple: 'Simpleng Paglunsad (Toolbar Button)',
            triggerUrl: 'Lahat ng URL (mula sa context menu)',
            triggerFile: 'Uri ng File: <strong>{fileType}</strong>',
            unknownApp: 'Hindi Kilalang App ({appId}...)'
        },
        admins: {
            serverKeyTitle: 'Pampublikong Key ng Server',
            serverKeyDescription: 'Ito ang pampublikong key na kakailanganin ng mga configuration file ng user upang kumonekta sa server na ito.',
            title: 'Pamamahala ng Admin',
            searchPlaceholder: 'Maghanap ng mga admin...',
            newTitle: 'Gumawa ng Bagong Admin',
            publicKeyOptionalLabel: 'Pampublikong Key (Opsyonal):',
            publicKeyPlaceholder: 'I-paste ang pampublikong key dito, o iwanang blangko upang bumuo ng isa.',
            createButton: 'Gumawa ng Admin',
            confirmDelete: 'Sigurado ka bang gusto mong burahin ang admin na si \'{username}\'? Mabubura rin nito ang lahat ng kanilang persistenteng imbakan at hindi na maibabalik.',
        },
        users: {
            title: 'Pamamahala ng User',
            searchPlaceholder: 'Maghanap ng mga user ayon sa pangalan o grupo...',
            newTitle: 'Gumawa ng Bagong User',
            publicKeyOptionalLabel: 'Pampublikong Key (Opsyonal):',
            publicKeyPlaceholder: 'I-paste ang pampublikong key ng user dito, o iwanang blangko upang bumuo ng isa.',
            settingsTitle: 'Mga Setting ng User',
            sessionLimitLabel: 'Limitasyon ng Sesyon',
            sessionLimitTitle: 'Bilang ng aktibong sesyon na maaaring magkaroon ang isang user. -1 para sa walang limitasyon.',
            permissionsTitle: 'Mga Pahintulot at Pagpapatibay',
            activeAccount: 'Aktibong Account',
            allowStorage: 'Pahintulutan ang Persistenteng Imbakan',
            allowGpu: 'Pahintulutan ang Pag-access sa GPU',
            hardenContainer: 'Patibayin ang Container',
            hardenWm: 'Patibayin ang Window Manager',
            createButton: 'Gumawa ng User',
            homesDisabledTooltip: 'Ang persistenteng imbakan ay hindi pinagana para sa user na ito',
            confirmDelete: 'Sigurado ka bang gusto mong burahin ang user na si \'{username}\'? Mabubura rin nito ang lahat ng kanilang persistenteng imbakan at hindi na maibabalik.',
            allowPublicSharing: 'Pahintulutan ang Pampublikong Pagbabahagi ng File',
        },
        groups: {
            title: 'Pamamahala ng Grupo',
            searchPlaceholder: 'Maghanap ng mga grupo...',
            newTitle: 'Gumawa ng Bagong Grupo',
            nameLabel: 'Pangalan ng Grupo:',
            overrideTitle: 'Mga Setting ng Pag-override ng Grupo',
            permissionsTitle: 'Mga Pag-override sa Pahintulot at Pagpapatibay',
            createButton: 'Gumawa ng Grupo',
            confirmDelete: 'Sigurado ka bang gusto mong burahin ang grupong \'{groupName}\'? Ang mga user sa grupong ito ay babalik sa kanilang indibidwal na mga setting.',
        },
        installedApps: {
            title: 'Mga Naka-install na Aplikasyon',
            searchPlaceholder: 'Maghanap ng mga naka-install na app...',
            noAppsFound: 'Walang nahanap na naka-install na app.',
            pulling: 'Hinihila ang bagong imahe...',
            notLocal: 'Hindi nahanap ang imahe nang lokal',
            confirmDelete: 'Sigurado ka bang gusto mong burahin ang naka-install na app na \'{appName}\'?',
        },
        appStore: {
            title: 'Mga Tindahan ng App',
            refreshTitle: 'I-refresh ang napiling tindahan',
            selectLabel: 'Pumili ng Tindahan ng App',
            addLabel: 'Magdagdag ng Bagong Tindahan ng App',
            namePlaceholder: 'Pangalan ng Tindahan',
            urlPlaceholder: 'URL ng YAML ng Tindahan',
            availableTitle: 'Mga Magagamit na App',
            addManual: "Magdagdag ng Manu-manong App",
            searchPlaceholder: 'Maghanap ng mga magagamit na app...',
            noAppsFound: 'Walang nahanap na aplikasyon.',
            availableFrom: 'Mga Magagamit na App mula sa {storeName}',
            couldNotLoad: 'Hindi ma-load ang mga app mula sa tindahang ito.',
        },
        appTemplates: {
            title: 'Editor ng Template ng Aplikasyon',
            loadLabel: 'I-load ang Template',
            createOption: 'Gumawa ng Bagong Template',
            nameLabel: 'Pangalan ng Template',
            namePlaceholder: 'Maglagay ng pangalan para sa bagong template',
            saveButton: 'I-save ang Profile',
            deleteButton: 'Burahin',
            previewTitle: 'Preview ng UI',
            contentArea: 'Lugar ng Nilalaman ng Aplikasyon',
            confirmDelete: 'Sigurado ka bang gusto mong burahin ang template na \'{templateName}\'? Hindi na maibabalik ang aksyon na ito.',
            deleteDisabled: 'Hindi maaaring burahin ang template na ito.',
            enterName: 'Mangyaring maglagay ng pangalan para sa bagong template.',
            settings: {
                TITLE: { label: "Pamagat ng Pahina", description: "Ang pamagat ng pahina na ipinapakita sa web browser." },
                SELKIES_UI_TITLE: { label: "Pamagat ng Sidebar", description: "Pamagat sa itaas na kaliwang sulok ng sidebar." },
                SELKIES_UI_SHOW_SIDEBAR: { label: "Ipakita ang Sidebar", description: "Ipakita ang pangunahing UI ng sidebar." },
                SELKIES_UI_SHOW_LOGO: { label: "Ipakita ang Logo", description: "Ipakita ang logo ng Selkies sa sidebar." },
                SELKIES_UI_SHOW_CORE_BUTTONS: { label: "Ipakita ang mga Pangunahing Pindutan", description: "Ipakita ang mga pindutan ng pangunahing bahagi (display, audio, atbp)." },
                SELKIES_UI_SIDEBAR_SHOW_VIDEO_SETTINGS: { label: "Ipakita ang Mga Setting ng Video", description: "Ipakita ang seksyon ng mga setting ng video sa sidebar." },
                SELKIES_UI_SIDEBAR_SHOW_SCREEN_SETTINGS: { label: "Ipakita ang Mga Setting ng Screen", description: "Ipakita ang seksyon ng mga setting ng screen sa sidebar." },
                SELKIES_UI_SIDEBAR_SHOW_AUDIO_SETTINGS: { label: "Ipakita ang Mga Setting ng Audio", description: "Ipakita ang seksyon ng mga setting ng audio sa sidebar." },
                SELKIES_UI_SIDEBAR_SHOW_STATS: { label: "Ipakita ang Stats", description: "Ipakita ang seksyon ng stats sa sidebar." },
                SELKIES_UI_SIDEBAR_SHOW_CLIPBOARD: { label: "Ipakita ang Clipboard", description: "Ipakita ang seksyon ng clipboard sa sidebar." },
                SELKIES_UI_SIDEBAR_SHOW_FILES: { label: "Ipakita ang Seksyon ng mga File", description: "Ipakita ang seksyon ng paglilipat ng file sa sidebar." },
                SELKIES_UI_SIDEBAR_SHOW_APPS: { label: "Ipakita ang Seksyon ng mga App", description: "Ipakita ang seksyon ng mga aplikasyon sa sidebar." },
                SELKIES_UI_SIDEBAR_SHOW_SHARING: { label: "Ipakita ang Seksyon ng Pagbabahagi", description: "Ipakita ang seksyon ng pagbabahagi sa sidebar." },
                SELKIES_UI_SIDEBAR_SHOW_GAMEPADS: { label: "Ipakita ang Seksyon ng mga Gamepad", description: "Ipakita ang seksyon ng mga gamepad sa sidebar." },
                SELKIES_UI_SIDEBAR_SHOW_KEYBOARD_BUTTON: { label: "Ipakita ang Pindutan ng Keyboard", description: "Ipakita ang pindutan ng on-screen na keyboard." },
                SELKIES_UI_SIDEBAR_SHOW_SOFT_BUTTONS: { label: "Ipakita ang mga Soft Button", description: "Ipakita ang seksyon ng mga soft button (para sa mobile)." },
                WATERMARK_PNG: { label: "Path ng Watermark PNG", description: "Buong path sa loob ng container patungo sa isang watermark png." },
                WATERMARK_LOCATION: { label: "Lokasyon ng Watermark", description: "Saan ipipinta ang imahe sa ibabaw ng stream.", options: { disabled: "Hindi Pinagana", topLeft: "Itaas-Kaliwa", topRight: "Itaas-Kanan", bottomLeft: "Ibaba-Kaliwa", bottomRight: "Ibaba-Kanan", centered: "Nakagitna", animated: "Animado" } },
                DASHBOARD: { label: "Estilo ng Dashboard", description: "Pinapayagan ang user na itakda ang kanilang dashboard.", options: { default: "Default", selkiesDefault: "Selkies (Default)", zinc: "Zinc", wish: "Wish" } },
                SELKIES_AUDIO_ENABLED: { label: "Paganahin ang Audio", description: "Paganahin ang streaming ng audio mula sa server patungo sa kliyente." },
                SELKIES_MICROPHONE_ENABLED: { label: "Paganahin ang Mikropono", description: "Paganahin ang pagpapasa ng mikropono mula sa kliyente patungo sa server." },
                SELKIES_GAMEPAD_ENABLED: { label: "Paganahin ang Gamepad", description: "Paganahin ang suporta para sa gamepad." },
                SELKIES_CLIPBOARD_ENABLED: { label: "Paganahin ang Clipboard", description: "Paganahin ang pag-synchronize ng clipboard." },
                SELKIES_ENABLE_BINARY_CLIPBOARD: { label: "Paganahin ang Binary Clipboard", description: "Payagan ang binary data (mga imahe) sa clipboard." },
                SELKIES_COMMAND_ENABLED: { label: "Paganahin ang Command Websocket", description: "Paganahin ang pag-parse ng mga mensahe ng command websocket." },
                SELKIES_FILE_TRANSFERS: { label: "Paglilipat ng File", description: "Pinapayagang mga direksyon ('upload,download', 'upload', 'download', 'none')." },
                SELKIES_ENABLE_SHARING: { label: "Paganahin ang Lahat ng Pagbabahagi", description: "Pangunahing toggle para sa lahat ng mga tampok ng pagbabahagi." },
                SELKIES_SECOND_SCREEN: { label: "Paganahin ang Ikalawang Screen", description: "Paganahin ang suporta para sa isang pangalawang monitor/display." },
                SELKIES_USE_BROWSER_CURSORS: { label: "Gamitin ang mga Cursor ng Browser", description: "Gamitin ang mga CSS cursor ng browser sa halip na i-render sa canvas." },
                SELKIES_USE_CSS_SCALING: { label: "Gamitin ang CSS Scaling (LoDPI)", description: "Kung totoo, isang mas mababang resolusyon ang ipapadala at ang canvas ay i-uunat." },
                SELKIES_IS_MANUAL_RESOLUTION_MODE: { label: "Mode ng Manu-manong Resolusyon", description: "I-lock ang resolusyon sa mga manu-manong halaga ng lapad/taas." },
                SELKIES_MANUAL_WIDTH: { label: "Manu-manong Lapad", description: "I-lock ang lapad sa isang nakapirming halaga. Pinipilit ang manu-manong mode." },
                SELKIES_MANUAL_HEIGHT: { label: "Manu-manong Taas", description: "I-lock ang taas sa isang nakapirming halaga. Pinipilit ang manu-manong mode." },
                SELKIES_SCALING_DPI: { label: "UI Scaling DPI", description: "Ang default na DPI para sa pag-scale ng UI." },
                SELKIES_AUDIO_BITRATE: { label: "Bitrate ng Audio", description: "Ang default na bitrate ng audio." },
                SELKIES_ENCODER: { label: "Mga Encoder", description: "Listahan ng mga encoder na pinaghihiwalay ng kuwit. Ang una ay default." },
                SELKIES_USE_CPU: { label: "Pilitin ang CPU Encoding", description: "Pilitin ang encoding na nakabase sa CPU para sa pixelflux." },
                SELKIES_FRAMERATE: { label: "Framerate (Saklaw o Nakapirmi)", description: "hal., '8-120' para sa isang saklaw o '60' para sa nakapirmi." },
                SELKIES_H264_CRF: { label: "H.264 CRF (Saklaw o Nakapirmi)", description: "hal., '5-50' para sa isang saklaw o '25' para sa nakapirmi." },
                SELKIES_JPEG_QUALITY: { label: "Kalidad ng JPEG (Saklaw o Nakapirmi)", description: "hal., '1-100' para sa isang saklaw o '60' para sa nakapirmi." },
                SELKIES_H264_FULLCOLOR: { label: "H.264 Buong Kulay", description: "Paganahin ang buong saklaw ng kulay ng H.264 para sa mga pixelflux encoder." },
                SELKIES_H264_STREAMING_MODE: { label: "H.264 Streaming (Turbo) Mode", description: "Paganahin ang H.264 low-latency streaming mode." },
                SELKIES_USE_PAINT_OVER_QUALITY: { label: "Gamitin ang Kalidad ng Paint-Over", description: "Paganahin ang mataas na kalidad na paint-over para sa mga static na eksena." },
                SELKIES_PAINT_OVER_JPEG_QUALITY: { label: "Kalidad ng JPEG ng Paint-Over", description: "hal., '1-100' para sa isang saklaw o '90' para sa nakapirmi." },
                SELKIES_H264_PAINTOVER_CRF: { label: "CRF ng H.264 Paint-Over", description: "hal., '5-50' para sa isang saklaw o '18' para sa nakapirmi." },
                SELKIES_H264_PAINTOVER_BURST_FRAMES: { label: "Mga Burst Frame ng Paint-Over", description: "hal., '1-30' para sa isang saklaw o '5' para sa nakapirmi." },
                HARDEN_DESKTOP: { label: "Patibayin ang Desktop (Preset)", description: "Pinapagana ang DISABLE_OPEN_TOOLS, DISABLE_SUDO, at DISABLE_TERMINALS." },
                HARDEN_OPENBOX: { label: "Patibayin ang Window Manager (Preset)", description: "Pinapagana ang DISABLE_CLOSE_BUTTON, DISABLE_MOUSE_BUTTONS, at HARDEN_KEYBINDS. Pinapagana rin ang RESTART_APP." },
                DISABLE_OPEN_TOOLS: { label: "Huwag Paganahin ang mga Open Tool", description: "Hindi pinapagana ang mga xdg-open at exo-open binary." },
                DISABLE_SUDO: { label: "Huwag Paganahin ang Sudo", description: "Hindi pinapagana ang sudo command." },
                DISABLE_TERMINALS: { label: "Huwag Paganahin ang mga Terminal", description: "Hindi pinapagana ang mga karaniwang terminal emulator." },
                DISABLE_CLOSE_BUTTON: { label: "Huwag Paganahin ang Pindutan ng Pagsara ng Window", description: "Inaalis ang pindutan ng pagsara mula sa mga title bar ng window." },
                DISABLE_MOUSE_BUTTONS: { label: "Huwag Paganahin ang Right/Middle Click", description: "Hindi pinapagana ang mga context menu ng right-click at middle-click." },
                HARDEN_KEYBINDS: { label: "Patibayin ang mga Keybind", description: "Hindi pinapagana ang mga default na keybind ng Openbox tulad ng Alt+F4." },
                RESTART_APP: { label: "I-restart ang App sa Pagsara", description: "Awtomatikong i-restart ang pangunahing aplikasyon kung ito ay isinara." },
                MAX_RES: { label: "Pinakamataas na Resolusyon", description: "Pinakamataas na resolusyon para sa container, default ay 16k." },
                START_DOCKER: { label: "Simulan ang Docker-in-Docker", description: "Kung false, hindi magsisimula ng DinD ang isang privileged container." },
                DISABLE_IPV6: { label: "Huwag Paganahin ang IPv6", description: "Kung true, hindi nito papaganahin ang IPv6." },
                DISABLE_ZINK: { label: "Huwag Paganahin ang Zink", description: "Huwag itakda ang mga Zink env var kung may natukoy na video card." },
                DISABLE_DRI3: { label: "Huwag Paganahin ang DRI3", description: "Huwag gamitin ang DRI3 acceleration kung may natukoy na video card." },
                NO_DECOR: { label: "Walang mga Dekorasyon ng Window", description: "Patakbuhin ang aplikasyon nang walang mga border ng window para sa paggamit ng PWA." },
                NO_FULL: { label: "Walang Fullscreen", description: "Huwag awtomatikong i-fullscreen ang mga aplikasyon." },
                NO_GAMEPAD: { label: "Huwag Paganahin ang Gamepad Injection", description: "Huwag paganahin ang userspace gamepad interposer injection." },
                SELKIES_DEBUG: { label: "Paganahin ang Selkies Debugging", description: "Paganahin ang debug logging para sa mga streaming component." },
            }
        },
        appLaboratory: {
            title: 'Laboratoryo ng App',
            description: 'Lumikha at subukan ang mga pasadyang configuration ng application sa pamamagitan ng pagpapatong ng mga pagbabago sa ibabaw ng isang base app.',
            selectApp: 'Pumili ng App',
            createNew: 'Gumawa ng Bagong App',
            baseApp: 'Base na Aplikasyon',
            baseAppDescription: 'Ang naka-install na aplikasyon kung saan ibabatay ang iyong bagong pasadyang app.',
            selectBase: 'Pumili ng Base App',
            customizationTitle: 'Pagpapasadya',
            appName: 'Pangalan ng App',
            appIcon: 'Icon ng App',
            uploadIcon: 'Mag-upload ng Icon',
            autostartScriptLabel: 'Pasadyang Autostart Script',
            permissionsTitle: 'Mga Pahintulot',
            usersLabel: 'Mga Pinapayagang User',
            groupsLabel: 'Mga Pinapayagang Grupo',
            launchButton: 'I-save at Ilunsad ang Sesyon ng Pagpapasadya',
            closeButton: 'Isara ang Sesyon at I-finalize',
            savingAndLaunching: 'Nagse-save at Naglulunsad...',
            placeholder: 'Pinapayagan ka ng App Laboratory na i-configure ang base home directory at launch script para sa isang aplikasyon batay sa isang umiiral na naka-install na aplikasyon. Ang home directory na ito ay kokopyahin sa unang pag-init para sa user kasama ang lahat ng mga file at setting na iyong inayos sa sesyon na ito. Maaari mong muling ilunsad ang isang umiiral na Laboratory App upang higit pang baguhin ang mga nilalaman nito.',
            formInvalid: 'Mangyaring pumili ng isang base app at magbigay ng pangalan para sa bagong app.',
        },
        modals: {
            editUserTitle: 'I-edit ang User: {username}',
            saveChanges: 'I-save ang mga Pagbabago',
            effectiveSettings: 'Epektibong mga Setting (na may mga pag-override ng grupo)',
            editGroupTitle: 'I-edit ang Grupo: {groupName}',
            userConfigTitle: 'Konfigurasyon ng User',
            warning: 'Ito lamang ang pagkakataon na ipapakita ang konfigurasyong ito. Ibigay ito sa user nang ligtas.',
            info: 'Maaari mong i-download ang configuration file na ito upang madaling i-set up ang SealSkin sa ibang device. Itago ang file na ito nang ligtas dahil naglalaman ito ng iyong pribadong key.',
            configDataLabel: 'Data ng Konfigurasyon (JSON)',
            copyButton: 'Kopyahin ang Teksto',
            downloadButton: 'I-download ang File',
            manageHomeDirs: 'Pamahalaan ang mga Home Directory',
            dirsForUser: 'Mga direktoryo para sa user: {username}',
            dirsForAdmin: 'Mga direktoryo para sa admin: {username}',
            newDirForUser: 'Gumawa ng Bagong Directory para sa User',
            createDirButton: 'Gumawa ng Directory',
            confirmDeleteDir: 'Sigurado ka bang gusto mong burahin ang \'{homeName}\' para sa user na si \'{username}\'? Ito ay permanente.',
            installAppTitle: 'I-install ang {appName}',
            editAppTitle: 'I-edit ang {appName}',
            customNameLabel: 'Pasadyang Pangalan',
            imageLabel: 'Imahe ng Container',
            permissions: 'Mga Pahintulot',
            allowedUsersLabel: 'Mga Pinapayagang User (pinaghihiwalay ng kuwit, \'all\' para sa lahat)',
            allowedGroupsLabel: 'Mga Pinapayagang Grupo (pinaghihiwalay ng kuwit, \'all\' para sa lahat)',
            features: 'Mga Tampok',
            gpuSupport: 'Suporta sa GPU',
            homeMounting: 'Pag-mount ng Home Directory',
            urlSupport: 'Suporta sa Pagbubukas ng URL',
            fileSupport: 'Suporta sa Pagbubukas ng File',
            autoUpdate: 'Awtomatikong I-update ang Imahe',
            advancedSettings: 'Mga Advanced na Setting',
            appTemplateLabel: 'Template ng Aplikasyon',
            appTemplateDescription: 'Pumili ng isang pre-configured na template para sa mga advanced na setting ng paglunsad ng container.',
            customAutostartScriptLabel: 'Pasadyang Autostart Script',
            customAutostartScriptDescription: 'I-customize ang lohika ng autostart, iwanang blangko upang gamitin ang default mula sa provider ng application.',
            saveInstallation: 'I-save ang Pag-install',
            updateStatusTitle: 'Katayuan ng Update para sa {appName}',
            checkingUpdates: 'Sinusuri ang mga update...',
            updateAvailable: 'May bagong bersyon ng imahe na magagamit!',
            yourVersion: 'Iyong bersyon: {sha}',
            latestAvailable: 'Ang pinakabagong bersyon ay magagamit upang hilahin mula sa registry.',
            pullLatest: 'Hilahin ang Pinakabagong Imahe',
            upToDate: 'Ang iyong imahe ay napapanahon.',
            currentVersion: 'Kasalukuyang bersyon: {sha}',
            errorChecking: 'Error sa pagsusuri ng mga update.',
            pullingLatest: 'Hinihila ang pinakabagong imahe... Maaaring tumagal ito sandali.',
            pullComplete: 'Kumpleto na ang paghila!',
            newVersion: 'Bagong bersyon: {sha}',
            errorPulling: 'Error sa paghila ng imahe.',
            manualInstallNote: "Tandaan: Ang mga imaheng idinagdag nang manu-mano ay dapat batay sa isang imaheng tugma sa selkies-baseimage.",
        },
        status: {
            loggingIn: 'Nagla-log in...',
            configSaved: 'Matagumpay na na-save ang konfigurasyon!',
            configApplied: 'Nailapat ang konfigurasyon! Mangyaring Mag-login at Subukan.',
            configApplyFailed: 'Nabigong ilapat ang konfigurasyon: {error}',
            fileReadError: 'Error sa pagbasa ng file.',
            noConfig: 'Mangyaring magbigay ng isang config file o teksto.',
            loggedInAdmin: 'Naka-log in bilang admin: {username}',
            loggedInUser: 'Naka-log in bilang standard na user: {username}.',
            loginFailed: 'Nabigo ang pag-login: {error}',
            adminDataRefreshFailed: 'Nabigong i-refresh ang data ng admin: {error}',
            logoutSuccess: 'Nag-logout at nalinis ang konfigurasyon.',
            generateConfigFailed: 'Hindi makabuo ng config, nawawala ang mga detalye ng user.',
            copySuccess: 'Nakopya ang konfigurasyon sa clipboard!',
            copyFailed: 'Nabigong kopyahin ang teksto.',
            publicKeyCopied: 'Nakopya ang pampublikong key!',
            keyCopyFailed: 'Nabigong kopyahin ang key.',
            creatingAdmin: 'Gumagawa ng admin...',
            adminCreated: 'Nilikha ang admin na si \'{username}\'.',
            adminCreateFailed: 'Error sa paggawa ng admin: {error}',
            adminDeleted: 'Matagumpay na nabura ang admin na si \'{username}\'.',
            adminDeleteFailed: 'Error sa pagbura ng admin: {error}',
            creatingUser: 'Gumagawa ng user...',
            userCreated: 'Nilikha ang user na si \'{username}\'.',
            userCreateFailed: 'Error sa paggawa ng user: {error}',
            userDeleted: 'Matagumpay na nabura ang user na si \'{username}\'.',
            userDeleteFailed: 'Error sa pagbura ng user: {error}',
            userUpdated: 'Matagumpay na na-update ang user na si \'{username}\'.',
            userUpdateFailed: 'Error sa pag-update ng user: {error}',
            creatingGroup: 'Gumagawa ng grupo...',
            groupCreated: 'Nilikha ang grupong \'{groupName}\'.',
            groupCreateFailed: 'Error sa paggawa ng grupo: {error}',
            groupDeleted: 'Matagumpay na nabura ang grupong \'{groupName}\'.',
            groupDeleteFailed: 'Error sa pagbura ng grupo: {error}',
            groupUpdated: 'Matagumpay na na-update ang grupong \'{groupName}\'.',
            groupUpdateFailed: 'Error sa pag-update ng grupo: {error}',
            homedirLoadFailed: 'Nabigong i-load ang mga home directory: {error}',
            homedirCreateFailed: 'Error sa paggawa ng directory: {error}',
            homedirCreated: 'Nilikha ang home directory na \'{homeName}\'.',
            homedirDeleted: 'Nabura ang directory na \'{homeName}\'.',
            homedirDeleteFailed: 'Error sa pagbura ng directory: {error}',
            homedirCreatedFor: 'Nilikha ang directory na \'{homeName}\' para kay {username}.',
            homedirDeletedFor: 'Nabura ang directory na \'{homeName}\' para kay {username}.',
            sessionsLoadFailed: 'Nabigong i-load ang mga sesyon: {error}',
            sessionStopError: 'Error sa pagtigil ng sesyon: {error}',
            sessionStopped: 'Matagumpay na natigil ang sesyon.',
            appDataRefreshFailed: 'Nabigong i-refresh ang data ng app: {error}',
            closingSession: 'Ikinokomit ang sesyon ng pagpapasadya...',
            sessionClosed: 'Naisara ang sesyon ng pagpapasadya.',
            sessionCloseFailed: 'Nabigong isara ang sesyon ng pagpapasadya: {error}',
            fetchingApps: 'Kinukuha ang mga app mula sa tindahan...',
            fetchAppsFailed: 'Nabigong kunin ang mga app mula sa tindahan: {error}',
            appStoreAddFailed: 'Error sa pagdagdag ng tindahan: {error}',
            appStoreAdded: 'Naidagdag ang tindahan ng app na \'{name}\'.',
            appSaved: 'Matagumpay na {action} ang app na \'{name}\'.',
            appSaveActions: {
                updated: 'na-update',
                installed: 'na-install'
            },
            appSaveFailed: 'Error sa pag-save ng app: {error}',
            appDeleted: 'Nabura ang app na \'{name}\'.',
            appDeleteFailed: 'Error sa pagbura ng app: {error}',
            templateSaved: 'Matagumpay na na-save ang template na \'{name}\'.',
            templateSaveFailed: 'Error sa pag-save ng template: {error}',
            templateDeleted: 'Matagumpay na nabura ang template na \'{name}\'.',
            templateDeleteFailed: 'Error sa pagbura ng template: {error}',
            pinRemoved: 'Inalis ang naka-pin na gawi.',
            keyGenerated: 'Bagong key pair na binuo.',
            keyGenFailed: 'Nabigo ang pagbuo ng key: {{error}}',
            pendingConfigSaved: 'Nai-save ang nakabinbing konfigurasyon. Maaari mo nang ibigay ang iyong pampublikong key sa administrator.',
            settingsSaved: 'Nai-save ang mga setting.',
            appCreated: 'Matagumpay na nagawa ang app na \'{name}\'.',
            launchFailed: 'Nabigo ang paglunsad: {error}',
        },
        placeholders: {
            noAdmins: 'Walang nahanap na admin.',
            noUsers: 'Walang nahanap na user.',
            noGroups: 'Walang nahanap na grupo.',
            noHomeDirs: 'Walang nahanap na home directory.',
            noSessions: 'Walang nahanap na aktibong sesyon.',
            noPinned: 'Walang nahanap na naka-pin na gawi.',
            errorLoading: 'Error sa pag-load ng mga directory.',
            noInstalledApps: 'Wala pang naka-install na mga application.',
        },
    },
    popup: {
        tabs: {
            launch: 'Ilunsad ang Bago',
            sessions: 'Mga Aktibong Sesyon',
            manageFiles: 'Pamahalaan ang mga File',
            uploadStorage: 'I-upload sa Imbakan',
            uploadFiles: 'Mag-upload ng mga File',
            uploadFilesTitle: 'Buksan ang dedikadong pahina para sa pag-upload ng file'
        },
        launchView: {
            searchPlaceholder: 'Maghanap ng mga aplikasyon...',
            uploadingFile: 'Nag-a-upload ng file...',
            gpuLabel: 'GPU',
            storageLabel: 'Imbakan',
            languageLabel: 'Wika',
            cleanroom: 'Cleanroom (Ephemeral)',
            noGpu: 'Wala',
            saveOptions: 'I-save ang mga opsyon sa paglunsad na ito',
            saveOptionsForUrl: 'I-save ang mga opsyon para sa lahat ng URL',
            saveOptionsForFile: 'I-save ang mga opsyon para sa mga .{extension} file',
            openFile: 'Buksan ang file sa paglunsad',
            launchButton: 'Ilunsad',
            launchingButton: 'Inilulunsad...',
            uploadingButton: 'Nag-a-upload...',
            autoHome: 'Awtomatiko (pananatili bawat app)',
            collaborationMode: 'Sesyon ng Pakikipagtulungan',
            waylandMode: 'Wayland Mode',
        },
        sessionsView: {
            noSessions: 'Walang nahanap na aktibong sesyon.',
        },
        uploadStorageView: {
            selectHome: 'Pumili ng Home Directory',
            description: 'Ia-upload nito ang file na <strong>{filename}</strong> direkta sa iyong imbakan ng mga File para sa paggamit sa hinaharap.',
            descriptionFallback: 'Ia-upload nito ang file na <strong>{filename}</strong> direkta sa iyong imbakan ng mga File para sa paggamit sa hinaharap.',
            uploadButton: 'I-upload ang File',
            uploadingButton: 'Nag-a-upload...',
            preparing: 'Inihahanda ang file...',
            uploadingChunk: 'Nag-a-upload ng bahagi {current} ng {total}...',
            finalizing: 'Tinutuloy...',
            uploadComplete: 'Kumpleto na ang Pag-upload!',
        },
        status: {
            unconfigured: 'Mangyaring i-configure ang extension sa pamamagitan ng pahina ng mga opsyon.',
            openingServerFile: "Binubuksan ang file sa panig ng server: {filename}",
            openingFile: 'Binubuksan ang file: {filename}',
            openingUrl: 'Binubuksan ang URL: {targetUrl}',
            error: 'Error: {message}',
            preparingFile: 'Inihahanda ang file...',
            sendingFile: 'Ipinapadala ang file sa sesyon...',
            errorSendingFile: 'Error sa pagpapadala ng file: {message}',
            errorClosingSession: 'Error sa pagsasara ng sesyon: {message}',
            preparingSession: 'Inihahanda ang isolated na sesyon...',
            fetchingData: 'Kinukuha ang data ng file...',
            fetchDataFailed: 'Nabigong kunin ang data ng file: {statusText}',
            unknownAction: 'Hindi kilalang aksyon sa paglunsad.',
            noAppSelected: 'Mangyaring pumili ng isang aplikasyon.',
            noAppsAvailable: 'Walang magagamit na aplikasyon para sa iyong account.',
            uploadSuccess: 'Matagumpay na na-upload ang file!',
            creatingAutoHome: 'Gumagawa ng awtomatikong home directory...',
        },
        languages: {
            default: 'Default ({locale})'
        }
    },
    upload: {
        title: 'Pag-upload ng File',
        description: 'Pumili ng isang file mula sa iyong computer upang buksan ito sa isang ligtas at isolated na sesyon.',
        dropzone: {
            title: 'I-drag at i-drop ang isang file dito',
            or: 'o',
            button: 'Pumili ng File',
        },
        confirm: {
            ready: 'Handa nang buksan nang ligtas ang file.',
            button: 'Magpatuloy sa Paglunsad',
        }
    },
    files: {
        title: 'Mga File ng SealSkin',
        header: {
            title: 'Mga File',
            newFolder: 'Bagong Folder',
            uploadFiles: 'Mag-upload ng mga File',
            uploadFolder: 'Mag-upload ng Folder'
        },
        sidebar: {
            sharedFiles: 'Mga File ng SealSkin',
            publicShares: 'Mga Pampublikong Pagbabahagi'
        },
        shares: {
            title: 'Mga File na Pampublikong Ibinahagi',
            searchPlaceholder: 'Maghanap ayon sa pangalan ng file o ID...'
        },
        table: {
            name: 'Pangalan',
            size: 'Sukat',
            lastModified: 'Huling Binago',
            created: 'Nilikha',
            expires: 'Mag-e-expire',
            url: 'Pampublikong URL',
            passwordProtected: 'Password'
        },
        dropzone: {
            title: 'I-drop ang mga file para i-upload'
        },
        pagination: {
            previous: '« Nakaraan',
            next: 'Susunod »',
            pageOf: 'Pahina {page} ng {totalPages}'
        },
        modals: {
            newFolder: {
                title: 'Gumawa ng Bagong Folder',
                folderNameLabel: 'Pangalan ng Folder',
                nameTitle: 'Gumamit lamang ng mga letra, numero, underscore, hyphen, o tuldok.',
                createButton: 'Gawin'
            },
            confirmDelete: {
                title: 'Kumpirmahin ang Pagbura',
                message: 'Sigurado ka bang gusto mong burahin ang {count, plural, one {1 napiling item} other {{count} napiling item}}? Hindi na maibabalik ang aksyon na ito.',
                messageDefault: 'Sigurado ka bang gusto mong burahin ang mga napiling item? Hindi na maibabalik ang aksyon na ito.'
            },
            uploadProgress: {
                title: 'Progreso ng Pag-upload',
                doneButton: 'Tapos na'
            },
            share: {
                title: 'Ibahagi ang File',
                sharingFile: 'Ibinabahagi ang file: <strong>{filename}</strong>',
                passwordLabel: 'Password (opsyonal)',
                passwordPlaceholder: 'Iwanang blangko para walang password',
                expiryLabel: 'Mag-e-expire sa (oras, opsyonal)',
                expiryPlaceholder: 'hal., 24 para sa isang araw',
                shareButton: 'Gumawa ng Link ng Pagbabahagi'
            }
        },
        status: {
            homeDirLoadFailed: 'Nabigo ang pag-load ng mga home directory: {error}',
            filesLoadFailed: 'Error sa pag-load ng mga file: {error}',
            deleteProtectedError: 'Hindi maaaring burahin ang mga protektadong system folder.',
            deletingItems: 'Binubura ang {count, plural, one {1 item} other {{count} item}}...',
            deleteSuccess: 'Matagumpay ang pagbura.',
            deleteFailed: 'Nabigo ang pagbura: {error}',
            preparingUpload: 'Naghahanda para i-upload ang {count, plural, one {1 file} other {{count} file}}...',
            uploadPrepFailed: 'Error sa paghahanda ng pag-upload ng folder: {error}',
            notConfigured: 'Error: Hindi naka-configure ang SealSkin. Paki-set up sa mga opsyon.',
            folderCreated: 'Nagawa ang folder na \'{folderName}\'.',
            folderCreateFailed: 'Error sa paggawa ng folder: {error}',
            shareCreated: 'Matagumpay na nagawa ang pagbabahagi! Ang link ay nakopya sa iyong clipboard.',
            shareCreateFailed: 'Nabigong gumawa ng pagbabahagi: {error}',
            sharesLoadFailed: 'Nabigong i-load ang mga ibinahaging file: {error}',
            shareDeleteFailed: 'Nabigong burahin ang pagbabahagi: {error}',
            shareDeleted: 'Matagumpay na nabura ang pagbabahagi.',
            urlCopied: 'Nakopya ang pampublikong URL sa clipboard.'
        },
        placeholders: {
            errorLoading: 'Error sa pag-load ng mga file.',
            folderEmpty: 'Walang laman ang folder na ito.',
            noHomeDirs: 'Walang available na home directory.',
            noShares: 'Wala ka pang ibinabahaging anumang file.'
        },
        uploadStatus: {
            pending: 'nakabinbin',
            initiating: 'Sinisimulan...',
            uploading: 'Nag-a-upload...',
            finalizing: 'Tinatapos...',
            completed: 'Kumpleto',
            error: 'Error'
        }
    }
};

// --- Danish Translations ---
const da = {
    background: {
        contextMenu: {
            openUrl: 'Åbn link i SealSkin',
            openFile: 'Åbn linkmål som fil i SealSkin',
            sendMedia: 'Send medie til SealSkin',
            searchText: 'Søg efter "%s" i SealSkin',
            sendDownload: 'Send næste download til SealSkin'
        }
    },
    common: {
        actions: 'Handlinger',
        active: 'Aktiv',
        cancel: 'Annuller',
        manage: 'Administrer',
        delete: 'Slet',
        edit: 'Rediger',
        save: 'Gem',
        none: 'ingen',
        error: 'Fejl',
        na: 'I/T',
        of: 'af',
        status: 'Status',
        username: 'Brugernavn',
        group: 'Gruppe',
        groups: 'Grupper',
        publicKey: 'Offentlig Nøgle',
        name: 'Navn',
        source: 'Kilde',
        imageVersion: 'Image Version',
        language: 'Sprog',
        storage: 'Lager',
        gpu: 'GPU',
        version: 'Version',
        checked: 'Afkrydset',
        never: 'Aldrig',
        stop: 'Stop',
        reopen: 'Genåbn',
        sendFile: 'Send Fil',
        share: 'Del',
        search: 'Søg',
        refresh: 'Opdater',
        close: 'Luk',
        copy: 'Kopier',
        open: "Åbn",
        copyUrl: 'Kopier URL',
        download: 'Download',
        next: 'Næste',
        previous: 'Forrige',
        page: 'Side',
        home: 'Hjemmemappe',
        homes: 'Hjemmemapper',
        sessions: 'Sessioner',
        users: 'Brugere',
        admins: 'Administratorer',
        yes: 'Ja',
        no: 'Nej',
        daysAgo: '{count, plural, one {for 1 dag siden} other {for {count} dage siden}}',
        hoursAgo: '{count, plural, one {for 1 time siden} other {for {count} timer siden}}',
        minutesAgo: '{count, plural, one {for 1 minut siden} other {for {count} minutter siden}}',
        justNow: 'lige nu',
        bytes: 'Bytes',
        kb: 'KB',
        mb: 'MB',
        gb: 'GB',
        tb: 'TB',
        pb: 'PB',
    },
    options: {
        sidebar: {
            config: 'Konfiguration',
            home: 'Hjemmemapper',
            sessions: 'Aktive Sessioner',
            pinned: 'Fastgjort Adfærd',
            appStore: 'App Store',
            appTemplates: 'App-skabeloner',
            appLaboratory: 'App-laboratorium',
            installedApps: 'Installerede Apps',
            users: 'Brugere',
            groups: 'Grupper',
            admins: 'Administratorer',
        },
        dashboard: {
            title: 'Kontrolpanel',
            clientSettings: 'Klientindstillinger',
            exportConfig: 'Eksporter Konfiguration',
            userStatus: 'Brugerstatus',
            loggedInAs: 'Logget ind som:',
            role: 'Rolle',
            roleAdmin: 'Administrator',
            roleUser: 'Standardbruger',
            serverInfo: 'Serverinformation',
            server: 'Server:',
            cpuModel: 'CPU Model:',
            storageUsage: 'Lagerbrug:',
            detectedGpus: 'Registrerede GPU\'er:',
            logout: 'Log ud & Ryd Konfiguration',
            howTo: 'Sådan bruges SealSkin',
            howToDescription: 'Dette afsnit indeholder grundlæggende dokumentation om, hvordan du bruger udvidelsen.',
            howToList: [
                '<strong>For at åbne indhold i isolation:</strong> Højreklik på et link, billede eller markeret tekst og vælg en mulighed fra "SealSkin Isolation" kontekstmenuen.',
                '<strong>For at sende en download til isolation:</strong> Højreklik på siden og vælg "Send Næste Download til Isolation". Den næste fil, du downloader, vil blive opsnappet og sendt til en sikker session.',
                '<strong>For at starte en ren applikation:</strong> Klik på SealSkin-ikonet i din browsers værktøjslinje.',
                '<strong>For at administrere vedvarende lager:</strong> Brug fanen "Hjemmemapper" på denne side til at oprette og slette lagervolumener, der kan bruges på tværs af flere sessioner.',
                '<strong>For at gemme startindstillinger:</strong> Marker afkrydsningsfeltet "Gem disse startindstillinger" i pop op-vinduet, før du starter en applikation for en bestemt filtype (f.eks. .pdf) eller for alle URL\'er. Administrer disse gemte præferencer i fanen "Fastgjort Adfærd".'
            ],
            confirmLogout: 'Er du sikker på, at du vil logge ud? Dette vil rydde din gemte konfiguration fra denne browser.',
        },
        config: {
            quickSetup: 'Hurtig Opsætning',
            quickSetupDescription: 'Upload konfigurationsfilen (.json) fra din administrator, eller indsæt dens indhold nedenfor for automatisk at opsætte udvidelsen.',
            uploadLabel: 'Upload Konfigurationsfil',
            pasteLabel: 'Eller Indsæt Konfigurationstekst',
            pastePlaceholder: 'Indsæt din JSON-konfiguration her...',
            applyButton: 'Anvend Konfiguration',
            manualLink: 'Manuel Konfiguration',
            advancedTitle: 'Klientkonfiguration (Avanceret)',
            serverIpLabel: 'Server IP eller Domæne',
            serverIpPlaceholder: 'f.eks., 192.168.1.100',
            apiPortLabel: 'API Port',
            apiPortPlaceholder: 'f.eks., 8000',
            sessionPortLabel: 'Sessionsport',
            sessionPortPlaceholder: 'f.eks., 8443',
            usernameLabel: 'Brugernavn',
            usernamePlaceholder: 'Dit brugernavn',
            privateKeyLabel: 'Din Private Nøgle (PEM Format)',
            privateKeyPlaceholder: 'Indsæt indholdet af din private nøgle her',
            serverKeyLabel: 'Serverens Offentlige Nøgle (PEM Format)',
            serverKeyPlaceholder: 'Indsæt indholdet af server_public.pem her',
            searchEngineLabel: 'Standard Søgemaskine for markeret tekst',
            saveButton: 'Gem Konfiguration',
            loginButton: 'Log ind & Test',
            automaticLink: 'Automatisk Konfiguration',
            chooseFile: 'Vælg Fil',
            keyGeneration: 'Nøglegenerering',
            keyGenDescription: 'Hvis du ikke har et nøglepar, kan du generere et her. Den private nøgle vil blive udfyldt ovenfor. Giv den offentlige nøgle til din administrator.',
            generateKeyButton: 'Generer Nyt Nøglepar',
            publicKeyForAdminLabel: 'Din Offentlige Nøgle (til admin)',
        },
        home: {
            title: 'Dine Hjemmemapper',
            description: 'Opret vedvarende lagermapper til brug på tværs af sessioner. Disse vil blive monteret i dine applikationer som din konfigurationsmappe.',
            newTitle: 'Opret Ny Hjemmemappe',
            nameLabel: 'Mappenavn:',
            namePlaceholder: 'f.eks., mine-projekt-filer',
            nameTitle: 'Brug kun bogstaver, tal, understregning eller bindestreg.',
            createButton: 'Opret Mappe',
            isLaboratory: 'Dette er en Laboratorie-app, bygget fra et basis-image med brugerdefinerede indstillinger.',
            laboratory: 'Laboratorium',
            confirmDelete: 'Er du sikker på, at du vil slette den installerede app \'{appName}\'?'
        },
        sessions: {
            title: 'Aktive Sessioner',
            application: 'Applikation',
            started: 'Startet',
            noSessionsUser: 'Ingen aktive sessioner fundet.',
            noSessionsAdmin: 'Ingen aktive sessioner fundet for nogen bruger.',
            sessionsFor: 'Sessioner for {username} ({count})',
            confirmStop: 'Er du sikker på, at du vil stoppe denne session? Containeren vil blive ødelagt.',
        },
        pinned: {
            title: 'Fastgjort Udvidelsesadfærd',
            description: 'Denne tabel viser de startindstillinger, du har gemt for specifikke filtyper eller for alle URL\'er. Du kan fjerne en fastgjort adfærd for at blive spurgt om startindstillinger igen.',
            trigger: 'Udløser',
            savedApp: 'Gemt Applikation',
            triggerSimple: 'Simpel Start (Værktøjslinjeknap)',
            triggerUrl: 'Alle URL\'er (fra kontekstmenu)',
            triggerFile: 'Filtype: <strong>{fileType}</strong>',
            unknownApp: 'Ukendt App ({appId}...)'
        },
        admins: {
            serverKeyTitle: 'Serverens Offentlige Nøgle',
            serverKeyDescription: 'Dette er den offentlige nøgle, som brugerkonfigurationsfiler skal bruge for at oprette forbindelse til denne server.',
            title: 'Admin-administration',
            searchPlaceholder: 'Søg efter administratorer...',
            newTitle: 'Opret Ny Administrator',
            publicKeyOptionalLabel: 'Offentlig Nøgle (Valgfri):',
            publicKeyPlaceholder: 'Indsæt offentlig nøgle her, eller lad feltet være tomt for at generere en.',
            createButton: 'Opret Administrator',
            confirmDelete: 'Er du sikker på, at du vil slette administratoren \'{username}\'? Dette vil også slette alt deres vedvarende lager og kan ikke fortrydes.',
        },
        users: {
            title: 'Brugeradministration',
            searchPlaceholder: 'Søg efter brugere via navn eller gruppe...',
            newTitle: 'Opret Ny Bruger',
            publicKeyOptionalLabel: 'Offentlig Nøgle (Valgfri):',
            publicKeyPlaceholder: 'Indsæt brugerens offentlige nøgle her, eller lad feltet være tomt for at generere en.',
            settingsTitle: 'Brugerindstillinger',
            sessionLimitLabel: 'Sessionsgrænse',
            sessionLimitTitle: 'Antal aktive sessioner en bruger kan have. -1 for ubegrænset.',
            permissionsTitle: 'Tilladelser & Hærdning',
            activeAccount: 'Aktiv Konto',
            allowStorage: 'Tillad Vedvarende Lager',
            allowGpu: 'Tillad GPU-adgang',
            hardenContainer: 'Hærd Container',
            hardenWm: 'Hærd Vindueshåndtering',
            createButton: 'Opret Bruger',
            homesDisabledTooltip: 'Vedvarende lager deaktiveret for denne bruger',
            confirmDelete: 'Er du sikker på, at du vil slette brugeren \'{username}\'? Dette vil også slette alt deres vedvarende lager og kan ikke fortrydes.',
            allowPublicSharing: 'Tillad offentlig fildeling',
        },
        groups: {
            title: 'Gruppeadministration',
            searchPlaceholder: 'Søg efter grupper...',
            newTitle: 'Opret Ny Gruppe',
            nameLabel: 'Gruppenavn:',
            overrideTitle: 'Gruppe Tilsidesættelsesindstillinger',
            permissionsTitle: 'Tilsidesættelser for Tilladelser & Hærdning',
            createButton: 'Opret Gruppe',
            confirmDelete: 'Er du sikker på, at du vil slette gruppen \'{groupName}\'? Brugere i denne gruppe vil vende tilbage til deres individuelle indstillinger.',
        },
        installedApps: {
            title: 'Installerede Applikationer',
            searchPlaceholder: 'Søg efter installerede apps...',
            noAppsFound: 'Ingen installerede apps fundet.',
            pulling: 'Henter nyt image...',
            notLocal: 'Image ikke fundet lokalt',
            confirmDelete: 'Er du sikker på, at du vil slette den installerede app \'{appName}\'?',
        },
        appStore: {
            title: 'App Stores',
            refreshTitle: 'Opdater valgt store',
            selectLabel: 'Vælg App Store',
            addLabel: 'Tilføj Ny App Store',
            namePlaceholder: 'Store-navn',
            urlPlaceholder: 'Store YAML URL',
            availableTitle: 'Tilgængelige Apps',
            addManual: "Tilføj Manuel App",
            searchPlaceholder: 'Søg efter tilgængelige apps...',
            noAppsFound: 'Ingen applikationer fundet.',
            availableFrom: 'Tilgængelige Apps fra {storeName}',
            couldNotLoad: 'Kunne ikke indlæse apps fra denne store.',
        },
        appTemplates: {
            title: 'Applikationsskabelon-editor',
            loadLabel: 'Indlæs Skabelon',
            createOption: 'Opret Ny Skabelon',
            nameLabel: 'Skabelonnavn',
            namePlaceholder: 'Indtast et navn til den nye skabelon',
            saveButton: 'Gem Profil',
            deleteButton: 'Slet',
            previewTitle: 'UI-forhåndsvisning',
            contentArea: 'Applikationsindholdsområde',
            confirmDelete: 'Er du sikker på, at du vil slette skabelonen \'{templateName}\'? Handlingen kan ikke fortrydes.',
            deleteDisabled: 'Denne skabelon kan ikke slettes.',
            enterName: 'Indtast venligst et navn til den nye skabelon.',
            settings: {
                TITLE: { label: "Sidetitel", description: "Sidetitlen, der vises i webbrowseren." },
                SELKIES_UI_TITLE: { label: "Sidepanel Titel", description: "Titel i øverste venstre hjørne af sidepanelet." },
                SELKIES_UI_SHOW_SIDEBAR: { label: "Vis Sidepanel", description: "Vis hovedbrugerfladen for sidepanelet." },
                SELKIES_UI_SHOW_LOGO: { label: "Vis Logo", description: "Vis Selkies-logoet i sidepanelet." },
                SELKIES_UI_SHOW_CORE_BUTTONS: { label: "Vis Kerneknapper", description: "Vis knapperne for kernekomponenter (skærm, lyd, osv.)." },
                SELKIES_UI_SIDEBAR_SHOW_VIDEO_SETTINGS: { label: "Vis Videoindstillinger", description: "Vis sektionen for videoindstillinger i sidepanelet." },
                SELKIES_UI_SIDEBAR_SHOW_SCREEN_SETTINGS: { label: "Vis Skærmindstillinger", description: "Vis sektionen for skærmindstillinger i sidepanelet." },
                SELKIES_UI_SIDEBAR_SHOW_AUDIO_SETTINGS: { label: "Vis Lydindstillinger", description: "Vis sektionen for lydindstillinger i sidepanelet." },
                SELKIES_UI_SIDEBAR_SHOW_STATS: { label: "Vis Statistik", description: "Vis statistiksektionen i sidepanelet." },
                SELKIES_UI_SIDEBAR_SHOW_CLIPBOARD: { label: "Vis Udklipsholder", description: "Vis sektionen for udklipsholder i sidepanelet." },
                SELKIES_UI_SIDEBAR_SHOW_FILES: { label: "Vis Filsektion", description: "Vis sektionen for filoverførsel i sidepanelet." },
                SELKIES_UI_SIDEBAR_SHOW_APPS: { label: "Vis App-sektion", description: "Vis applikationssektionen i sidepanelet." },
                SELKIES_UI_SIDEBAR_SHOW_SHARING: { label: "Vis Delingssektion", description: "Vis delingssektionen i sidepanelet." },
                SELKIES_UI_SIDEBAR_SHOW_GAMEPADS: { label: "Vis Gamepad-sektion", description: "Vis gamepad-sektionen i sidepanelet." },
                SELKIES_UI_SIDEBAR_SHOW_KEYBOARD_BUTTON: { label: "Vis Tastaturknap", description: "Vis knappen for skærmtastatur." },
                SELKIES_UI_SIDEBAR_SHOW_SOFT_BUTTONS: { label: "Vis Soft-knapper", description: "Vis sektionen for soft-knapper (til mobil)." },
                WATERMARK_PNG: { label: "Vandmærke PNG-sti", description: "Fuld sti inde i containeren til en vandmærke-png." },
                WATERMARK_LOCATION: { label: "Vandmærke Placering", description: "Hvor billedet skal tegnes over streamen.", options: { disabled: "Deaktiveret", topLeft: "Øverst-Venstre", topRight: "Øverst-Højre", bottomLeft: "Nederst-Venstre", bottomRight: "Nederst-Højre", centered: "Centreret", animated: "Animeret" } },
                DASHBOARD: { label: "Dashboard Stil", description: "Tillader brugeren at indstille sit dashboard.", options: { default: "Standard", selkiesDefault: "Selkies (Standard)", zinc: "Zinc", wish: "Wish" } },
                SELKIES_AUDIO_ENABLED: { label: "Aktiver Lyd", description: "Aktiver lydstreaming fra server til klient." },
                SELKIES_MICROPHONE_ENABLED: { label: "Aktiver Mikrofon", description: "Aktiver mikrofon-forwarding fra klient til server." },
                SELKIES_GAMEPAD_ENABLED: { label: "Aktiver Gamepad", description: "Aktiver gamepad-understøttelse." },
                SELKIES_CLIPBOARD_ENABLED: { label: "Aktiver Udklipsholder", description: "Aktiver synkronisering af udklipsholder." },
                SELKIES_ENABLE_BINARY_CLIPBOARD: { label: "Aktiver Binær Udklipsholder", description: "Tillad binære data (billeder) i udklipsholderen." },
                SELKIES_COMMAND_ENABLED: { label: "Aktiver Kommando Websocket", description: "Aktiver parsing af kommando-websocket-meddelelser." },
                SELKIES_FILE_TRANSFERS: { label: "Filoverførsler", description: "Tilladte retninger ('upload,download', 'upload', 'download', 'none')." },
                SELKIES_ENABLE_SHARING: { label: "Aktiver al Deling", description: "Hovedafbryder for alle delingsfunktioner." },
                SELKIES_SECOND_SCREEN: { label: "Aktiver Anden Skærm", description: "Aktiver understøttelse for en ekstra skærm/monitor." },
                SELKIES_USE_BROWSER_CURSORS: { label: "Brug Browser-markører", description: "Brug browserens CSS-markører i stedet for at rendere til canvas." },
                SELKIES_USE_CSS_SCALING: { label: "Brug CSS-skalering (LoDPI)", description: "Hvis sand, sendes en lavere opløsning, og canvas strækkes." },
                SELKIES_IS_MANUAL_RESOLUTION_MODE: { label: "Manuel Opløsningstilstand", description: "Lås opløsningen til de manuelle bredde/højde-værdier." },
                SELKIES_MANUAL_WIDTH: { label: "Manuel Bredde", description: "Lås bredden til en fast værdi. Tvinger manuel tilstand." },
                SELKIES_MANUAL_HEIGHT: { label: "Manuel Højde", description: "Lås højden til en fast værdi. Tvinger manuel tilstand." },
                SELKIES_SCALING_DPI: { label: "UI Skalering DPI", description: "Standard DPI for UI-skalering." },
                SELKIES_AUDIO_BITRATE: { label: "Lyd Bitrate", description: "Standard lyd-bitrate." },
                SELKIES_ENCODER: { label: "Encodere", description: "Kommasepareret liste af encodere. Den første er standard." },
                SELKIES_USE_CPU: { label: "Tving CPU Encoding", description: "Tving CPU-baseret encoding for pixelflux." },
                SELKIES_FRAMERATE: { label: "Billedfrekvens (Område eller Fast)", description: "f.eks., '8-120' for et område eller '60' for fast." },
                SELKIES_H264_CRF: { label: "H.264 CRF (Område eller Fast)", description: "f.eks., '5-50' for et område eller '25' for fast." },
                SELKIES_JPEG_QUALITY: { label: "JPEG Kvalitet (Område eller Fast)", description: "f.eks., '1-100' for et område eller '60' for fast." },
                SELKIES_H264_FULLCOLOR: { label: "H.264 Fuld Farve", description: "Aktiver H.264 fuld farveområde for pixelflux-encodere." },
                SELKIES_H264_STREAMING_MODE: { label: "H.264 Streaming (Turbo) Tilstand", description: "Aktiver H.264 lav-latens streamingtilstand." },
                SELKIES_USE_PAINT_OVER_QUALITY: { label: "Brug Overmaling Kvalitet", description: "Aktiver høj-kvalitets overmaling for statiske scener." },
                SELKIES_PAINT_OVER_JPEG_QUALITY: { label: "Overmaling JPEG Kvalitet", description: "f.eks., '1-100' for et område eller '90' for fast." },
                SELKIES_H264_PAINTOVER_CRF: { label: "Overmaling H.264 CRF", description: "f.eks., '5-50' for et område eller '18' for fast." },
                SELKIES_H264_PAINTOVER_BURST_FRAMES: { label: "Overmaling Burst Frames", description: "f.eks., '1-30' for et område eller '5' for fast." },
                HARDEN_DESKTOP: { label: "Hærd Desktop (Forudindstilling)", description: "Aktiverer DISABLE_OPEN_TOOLS, DISABLE_SUDO, og DISABLE_TERMINALS." },
                HARDEN_OPENBOX: { label: "Hærd Vindueshåndtering (Forudindstilling)", description: "Aktiverer DISABLE_CLOSE_BUTTON, DISABLE_MOUSE_BUTTONS, og HARDEN_KEYBINDS. Aktiverer også RESTART_APP." },
                DISABLE_OPEN_TOOLS: { label: "Deaktiver Åbn-værktøjer", description: "Deaktiverer xdg-open og exo-open binære filer." },
                DISABLE_SUDO: { label: "Deaktiver Sudo", description: "Deaktiverer sudo-kommandoen." },
                DISABLE_TERMINALS: { label: "Deaktiver Terminaler", description: "Deaktiverer almindelige terminalemulatorer." },
                DISABLE_CLOSE_BUTTON: { label: "Deaktiver vindues luk-knap", description: "Fjerner luk-knappen fra vinduestitelbjælker." },
                DISABLE_MOUSE_BUTTONS: { label: "Deaktiver Højre-/Midterklik", description: "Deaktiverer højreklik og midterklik kontekstmenu." },
                HARDEN_KEYBINDS: { label: "Hærd Tastaturgenveje", description: "Deaktiverer standard Openbox tastaturgenveje som Alt+F4." },
                RESTART_APP: { label: "Genstart App ved Lukning", description: "Genstarter automatisk hovedapplikationen, hvis den lukkes." },
                MAX_RES: { label: "Maksimal Opløsning", description: "Maksimal opløsning for containeren, standard er 16k." },
                START_DOCKER: { label: "Start Docker-i-Docker", description: "Hvis falsk, vil en privilegeret container ikke starte DinD." },
                DISABLE_IPV6: { label: "Deaktiver IPv6", description: "Hvis sand, vil dette deaktivere IPv6." },
                DISABLE_ZINK: { label: "Deaktiver Zink", description: "Indstil ikke Zink-miljøvariabler, hvis et grafikkort registreres." },
                DISABLE_DRI3: { label: "Deaktiver DRI3", description: "Brug ikke DRI3-acceleration, hvis et grafikkort registreres." },
                NO_DECOR: { label: "Ingen Vinduesdekorationer", description: "Kør applikation uden vinduesrammer til PWA-brug." },
                NO_FULL: { label: "Ingen Fuldskærm", description: "Sæt ikke applikationer automatisk i fuldskærm." },
                NO_GAMEPAD: { label: "Deaktiver Gamepad Injektion", description: "Deaktiver injektion af userspace gamepad interposer." },
                SELKIES_DEBUG: { label: "Aktiver Selkies Debugging", description: "Aktiver debug-logning for streamingkomponenter." },
            }
        },
        appLaboratory: {
            title: 'App-laboratorium',
            description: 'Opret og test brugerdefinerede applikationskonfigurationer ved at lægge ændringer oven på en basis-app.',
            selectApp: 'Vælg App',
            createNew: 'Opret Ny App',
            baseApp: 'Basisapplikation',
            baseAppDescription: 'Den installerede applikation, som din nye brugerdefinerede app vil være baseret på.',
            selectBase: 'Vælg en Basis-app',
            customizationTitle: 'Tilpasning',
            appName: 'App-navn',
            appIcon: 'App-ikon',
            uploadIcon: 'Upload Ikon',
            autostartScriptLabel: 'Brugerdefineret Autostart Script',
            permissionsTitle: 'Tilladelser',
            usersLabel: 'Tilladte Brugere',
            groupsLabel: 'Tilladte Grupper',
            launchButton: 'Gem & Start Tilpasningssession',
            closeButton: 'Luk Session & Afslut',
            savingAndLaunching: 'Gemmer & Starter...',
            placeholder: 'App-laboratoriet giver dig mulighed for at konfigurere basis-hjemmemappen og start-scriptet for en applikation baseret på en eksisterende installeret applikation. Denne hjemmemappe vil blive kopieret ved første initialisering for brugeren med alle de filer og indstillinger, du opsætter i denne session. Du kan genstarte en eksisterende Laboratorie-app for yderligere at ændre dens indhold.',
            formInvalid: 'Vælg venligst en basis-app og angiv et navn til den nye app.',
        },
        modals: {
            editUserTitle: 'Rediger Bruger: {username}',
            saveChanges: 'Gem Ændringer',
            effectiveSettings: 'Effektive Indstillinger (med gruppetilsidesættelser)',
            editGroupTitle: 'Rediger Gruppe: {groupName}',
            userConfigTitle: 'Brugerkonfiguration',
            warning: 'Dette er den eneste gang, denne konfiguration vil blive vist. Giv den sikkert til brugeren.',
            info: 'Du kan downloade denne konfigurationsfil for nemt at opsætte SealSkin på en anden enhed. Opbevar denne fil sikkert, da den indeholder din private nøgle.',
            configDataLabel: 'Konfigurationsdata (JSON)',
            copyButton: 'Kopier Tekst',
            downloadButton: 'Download Fil',
            manageHomeDirs: 'Administrer Hjemmemapper',
            dirsForUser: 'Mapper for bruger: {username}',
            dirsForAdmin: 'Mapper for admin: {username}',
            newDirForUser: 'Opret Ny Mappe for Bruger',
            createDirButton: 'Opret Mappe',
            confirmDeleteDir: 'Er du sikker på, at du vil slette \'{homeName}\' for bruger \'{username}\'? Dette er permanent.',
            installAppTitle: 'Installer {appName}',
            editAppTitle: 'Rediger {appName}',
            customNameLabel: 'Brugerdefineret Navn',
            imageLabel: 'Container Image',
            permissions: 'Tilladelser',
            allowedUsersLabel: 'Tilladte Brugere (kommasepareret, \'all\' for alle)',
            allowedGroupsLabel: 'Tilladte Grupper (kommasepareret, \'all\' for alle)',
            features: 'Funktioner',
            gpuSupport: 'GPU-understøttelse',
            homeMounting: 'Montering af Hjemmemappe',
            urlSupport: 'URL-åbningsunderstøttelse',
            fileSupport: 'Filåbningsunderstøttelse',
            autoUpdate: 'Auto-opdater Image',
            advancedSettings: 'Avancerede Indstillinger',
            appTemplateLabel: 'Applikationsskabelon',
            appTemplateDescription: 'Vælg en forudkonfigureret skabelon for avancerede container-startindstillinger.',
            customAutostartScriptLabel: 'Brugerdefineret Autostart Script',
            customAutostartScriptDescription: 'Tilpas autostart-logik, lad feltet være tomt for at bruge standard fra applikationsudbyderen.',
            saveInstallation: 'Gem Installation',
            updateStatusTitle: 'Opdateringsstatus for {appName}',
            checkingUpdates: 'Søger efter opdateringer...',
            updateAvailable: 'En ny image-version er tilgængelig!',
            yourVersion: 'Din version: {sha}',
            latestAvailable: 'Den seneste version er tilgængelig til at hente fra registreringsdatabasen.',
            pullLatest: 'Hent Seneste Image',
            upToDate: 'Dit image er opdateret.',
            currentVersion: 'Nuværende version: {sha}',
            errorChecking: 'Fejl under søgning efter opdateringer.',
            pullingLatest: 'Henter seneste image... Dette kan tage et øjeblik.',
            pullComplete: 'Hentning fuldført!',
            newVersion: 'Ny version: {sha}',
            errorPulling: 'Fejl under hentning af image.',
            manualInstallNote: "Bemærk: Manuelt tilføjede billeder skal være baseret på et selkies-baseimage-kompatibelt billede.",
        },
        status: {
            loggingIn: 'Logger ind...',
            configSaved: 'Konfiguration gemt med succes!',
            configApplied: 'Konfiguration anvendt! Log venligst ind & test.',
            configApplyFailed: 'Kunne ikke anvende konfiguration: {error}',
            fileReadError: 'Fejl ved læsning af fil.',
            noConfig: 'Angiv venligst en konfigurationsfil eller tekst.',
            loggedInAdmin: 'Logget ind som admin: {username}',
            loggedInUser: 'Logget ind som standardbruger: {username}.',
            loginFailed: 'Login mislykkedes: {error}',
            adminDataRefreshFailed: 'Kunne ikke opdatere admin-data: {error}',
            logoutSuccess: 'Logget ud og konfiguration ryddet.',
            generateConfigFailed: 'Kunne ikke generere konfiguration, brugeroplysninger mangler.',
            copySuccess: 'Konfiguration kopieret til udklipsholder!',
            copyFailed: 'Kunne ikke kopiere tekst.',
            publicKeyCopied: 'Offentlig nøgle kopieret!',
            keyCopyFailed: 'Kunne ikke kopiere nøgle.',
            creatingAdmin: 'Opretter administrator...',
            adminCreated: 'Administrator \'{username}\' oprettet.',
            adminCreateFailed: 'Fejl ved oprettelse af administrator: {error}',
            adminDeleted: 'Administrator \'{username}\' slettet med succes.',
            adminDeleteFailed: 'Fejl ved sletning af administrator: {error}',
            creatingUser: 'Opretter bruger...',
            userCreated: 'Bruger \'{username}\' oprettet.',
            userCreateFailed: 'Fejl ved oprettelse af bruger: {error}',
            userDeleted: 'Bruger \'{username}\' slettet med succes.',
            userDeleteFailed: 'Fejl ved sletning af bruger: {error}',
            userUpdated: 'Bruger \'{username}\' opdateret med succes.',
            userUpdateFailed: 'Fejl ved opdatering af bruger: {error}',
            creatingGroup: 'Opretter gruppe...',
            groupCreated: 'Gruppe \'{groupName}\' oprettet.',
            groupCreateFailed: 'Fejl ved oprettelse af gruppe: {error}',
            groupDeleted: 'Gruppe \'{groupName}\' slettet med succes.',
            groupDeleteFailed: 'Fejl ved sletning af gruppe: {error}',
            groupUpdated: 'Gruppe \'{groupName}\' opdateret med succes.',
            groupUpdateFailed: 'Fejl ved opdatering af gruppe: {error}',
            homedirLoadFailed: 'Kunne ikke indlæse hjemmemapper: {error}',
            homedirCreateFailed: 'Fejl ved oprettelse af mappe: {error}',
            homedirCreated: 'Hjemmemappe \'{homeName}\' oprettet.',
            homedirDeleted: 'Mappe \'{homeName}\' slettet.',
            homedirDeleteFailed: 'Fejl ved sletning af mappe: {error}',
            homedirCreatedFor: 'Mappe \'{homeName}\' oprettet for {username}.',
            homedirDeletedFor: 'Mappe \'{homeName}\' slettet for {username}.',
            sessionsLoadFailed: 'Kunne ikke indlæse sessioner: {error}',
            sessionStopError: 'Fejl ved stop af session: {error}',
            sessionStopped: 'Session stoppet med succes.',
            appDataRefreshFailed: 'Kunne ikke opdatere app-data: {error}',
            closingSession: 'Gemmer tilpasningssession...',
            sessionClosed: 'Tilpasningssession lukket.',
            sessionCloseFailed: 'Kunne ikke lukke tilpasningssession: {error}',
            fetchingApps: 'Henter apps fra store...',
            fetchAppsFailed: 'Kunne ikke hente apps fra store: {error}',
            appStoreAddFailed: 'Fejl ved tilføjelse af store: {error}',
            appStoreAdded: 'App store \'{name}\' tilføjet.',
            appSaved: 'Appen \'{name}\' blev {action} med succes.',
            appSaveActions: {
                updated: 'opdateret',
                installed: 'installeret'
            },
            appSaveFailed: 'Fejl ved gemning af app: {error}',
            appDeleted: 'App \'{name}\' slettet.',
            appDeleteFailed: 'Fejl ved sletning af app: {error}',
            templateSaved: 'Skabelon \'{name}\' gemt med succes.',
            templateSaveFailed: 'Fejl ved gemning af skabelon: {error}',
            templateDeleted: 'Skabelon \'{name}\' slettet med succes.',
            templateDeleteFailed: 'Fejl ved sletning af skabelon: {error}',
            pinRemoved: 'Fastgjort adfærd fjernet.',
            keyGenerated: 'Nyt nøglepar genereret.',
            keyGenFailed: 'Nøglegenerering mislykkedes: {{error}}',
            pendingConfigSaved: 'Ventende konfiguration gemt. Du kan nu give din offentlige nøgle til administratoren.',
            settingsSaved: 'Indstillinger gemt.',
            appCreated: 'Appen \'{name}\' blev oprettet med succes.',
            launchFailed: 'Start mislykkedes: {error}',
        },
        placeholders: {
            noAdmins: 'Ingen administratorer fundet.',
            noUsers: 'Ingen brugere fundet.',
            noGroups: 'Ingen grupper fundet.',
            noHomeDirs: 'Ingen hjemmemapper fundet.',
            noSessions: 'Ingen aktive sessioner fundet.',
            noPinned: 'Ingen fastgjorte adfærd fundet.',
            errorLoading: 'Fejl ved indlæsning af mapper.',
            noInstalledApps: 'Ingen applikationer er installeret endnu.',
        },
    },
    popup: {
        tabs: {
            launch: 'Start Ny',
            sessions: 'Aktive Sessioner',
            manageFiles: 'Administrer filer',
            uploadStorage: 'Upload til Lager',
            uploadFiles: 'Upload Filer',
            uploadFilesTitle: 'Åbn dedikeret side for filupload'
        },
        launchView: {
            searchPlaceholder: 'Søg efter applikationer...',
            uploadingFile: 'Uploader fil...',
            gpuLabel: 'GPU',
            storageLabel: 'Lager',
            languageLabel: 'Sprog',
            cleanroom: 'Cleanroom (Midlertidig)',
            noGpu: 'Ingen',
            saveOptions: 'Gem disse startindstillinger',
            saveOptionsForUrl: 'Gem indstillinger for alle URL\'er',
            saveOptionsForFile: 'Gem indstillinger for .{extension} filer',
            openFile: 'Åbn fil ved start',
            launchButton: 'Start',
            launchingButton: 'Starter...',
            uploadingButton: 'Uploader...',
            autoHome: 'Automatisk (vedvarende pr. app)',
            collaborationMode: 'Samarbejdssession',
            waylandMode: 'Wayland-tilstand',
        },
        sessionsView: {
            noSessions: 'Ingen aktive sessioner fundet.',
        },
        uploadStorageView: {
            selectHome: 'Vælg Hjemmemappe',
            description: 'Dette vil uploade filen <strong>{filename}</strong> direkte til dit Fillager til fremtidig brug.',
            descriptionFallback: 'Dette vil uploade filen <strong>{filename}</strong> direkte til dit Fillager til fremtidig brug.',
            uploadButton: 'Upload Fil',
            uploadingButton: 'Uploader...',
            preparing: 'Forbereder fil...',
            uploadingChunk: 'Uploader del {current} af {total}...',
            finalizing: 'Afslutter...',
            uploadComplete: 'Upload Fuldført!',
        },
        status: {
            unconfigured: 'Konfigurer venligst udvidelsen via indstillingssiden.',
            openingServerFile: "Åbner server-side fil: {filename}",
            openingFile: 'Åbner fil: {filename}',
            openingUrl: 'Åbner URL: {targetUrl}',
            error: 'Fejl: {message}',
            preparingFile: 'Forbereder fil...',
            sendingFile: 'Sender fil til session...',
            errorSendingFile: 'Fejl ved afsendelse af fil: {message}',
            errorClosingSession: 'Fejl ved lukning af session: {message}',
            preparingSession: 'Forbereder isoleret session...',
            fetchingData: 'Henter fildata...',
            fetchDataFailed: 'Kunne ikke hente fildata: {statusText}',
            unknownAction: 'Ukendt starthandling.',
            noAppSelected: 'Vælg venligst en applikation.',
            noAppsAvailable: 'Ingen applikationer er tilgængelige for din konto.',
            uploadSuccess: 'Fil uploadet med succes!',
            creatingAutoHome: 'Opretter automatisk hjemmemappe...',
        },
        languages: {
            default: 'Standard ({locale})'
        }
    },
    upload: {
        title: 'Filupload',
        description: 'Vælg en fil fra din computer for at åbne den i en sikker, isoleret session.',
        dropzone: {
            title: 'Træk & slip en fil her',
            or: 'eller',
            button: 'Vælg Fil',
        },
        confirm: {
            ready: 'Filen er klar til at blive åbnet sikkert.',
            button: 'Fortsæt til Start',
        }
    },
    files: {
        title: 'SealSkin-filer',
        header: {
            title: 'Filer',
            newFolder: 'Ny mappe',
            uploadFiles: 'Upload filer',
            uploadFolder: 'Upload mappe'
        },
        sidebar: {
            sharedFiles: 'SealSkin-filer',
            publicShares: 'Offentlige Delinger'
        },
        shares: {
            title: 'Offentligt Delte Filer',
            searchPlaceholder: 'Søg efter filnavn eller ID...'
        },
        table: {
            name: 'Navn',
            size: 'Størrelse',
            lastModified: 'Sidst ændret',
            created: 'Oprettet',
            expires: 'Udløber',
            url: 'Offentlig URL',
            passwordProtected: 'Adgangskode'
        },
        dropzone: {
            title: 'Træk filer hertil for at uploade'
        },
        pagination: {
            previous: '« Forrige',
            next: 'Næste »',
            pageOf: 'Side {page} af {totalPages}'
        },
        modals: {
            newFolder: {
                title: 'Opret ny mappe',
                folderNameLabel: 'Mappenavn',
                nameTitle: 'Brug kun bogstaver, tal, understregning, bindestreg eller punktum.',
                createButton: 'Opret'
            },
            confirmDelete: {
                title: 'Bekræft sletning',
                message: 'Er du sikker på, at du vil slette {count, plural, one {1 valgt element} other {{count} valgte elementer}}? Handlingen kan ikke fortrydes.',
                messageDefault: 'Er du sikker på, at du vil slette de valgte elementer? Handlingen kan ikke fortrydes.'
            },
            uploadProgress: {
                title: 'Upload-status',
                doneButton: 'Færdig'
            },
            share: {
                title: 'Del Fil',
                sharingFile: 'Deler fil: <strong>{filename}</strong>',
                passwordLabel: 'Adgangskode (valgfri)',
                passwordPlaceholder: 'Lad være blank for ingen adgangskode',
                expiryLabel: 'Udløber om (timer, valgfri)',
                expiryPlaceholder: 'f.eks. 24 for en dag',
                shareButton: 'Opret Delingslink'
            }
        },
        status: {
            homeDirLoadFailed: 'Kunne ikke indlæse hjemmebiblioteker: {error}',
            filesLoadFailed: 'Fejl ved indlæsning af filer: {error}',
            deleteProtectedError: 'Kan ikke slette beskyttede systemmapper.',
            deletingItems: 'Sletter {count, plural, one {1 element} other {{count} elementer}}...',
            deleteSuccess: 'Sletning lykkedes.',
            deleteFailed: 'Sletning mislykkedes: {error}',
            preparingUpload: 'Forbereder upload af {count, plural, one {1 fil} other {{count} filer}}...',
            uploadPrepFailed: 'Fejl under forberedelse af mappe-upload: {error}',
            notConfigured: 'Fejl: SealSkin er ikke konfigureret. Konfigurer venligst i indstillinger.',
            folderCreated: 'Mappen \'{folderName}\' blev oprettet.',
            folderCreateFailed: 'Fejl ved oprettelse af mappe: {error}',
            shareCreated: 'Deling oprettet med succes! Linket er blevet kopieret til din udklipsholder.',
            shareCreateFailed: 'Kunne ikke oprette deling: {error}',
            sharesLoadFailed: 'Kunne ikke indlæse delte filer: {error}',
            shareDeleteFailed: 'Kunne ikke slette deling: {error}',
            shareDeleted: 'Deling slettet med succes.',
            urlCopied: 'Offentlig URL kopieret til udklipsholder.'
        },
        placeholders: {
            errorLoading: 'Fejl ved indlæsning af filer.',
            folderEmpty: 'Denne mappe er tom.',
            noHomeDirs: 'Ingen hjemmebiblioteker tilgængelige.',
            noShares: 'Du har endnu ikke delt nogen filer.'
        },
        uploadStatus: {
            pending: 'afventer',
            initiating: 'Starter...',
            uploading: 'Uploader...',
            finalizing: 'Afslutter...',
            completed: 'Fuldført',
            error: 'Fejl'
        }
    }
};

const translations = {
    en,             
    es,
    zh,
    hi,
    pt,
    fr,
    ru,
    de,         
    tr,
    it,
    nl,
    ar,
    ko,     
    ja,         
    vi,         
    th,         
    fil,
    da,
};

const getTranslator = (langCode = 'en') => {
    const baseLang = langCode.split('-')[0].toLowerCase();
    const langDict = translations[baseLang] || translations.en;
    const fallbackDict = translations.en;

    const t = (key, variables = {}) => {
        const keys = key.split('.');
        let value = keys.reduce((obj, k) => (obj && obj[k] !== undefined) ? obj[k] : undefined, langDict);

        if (value === undefined) {
            value = keys.reduce((obj, k) => (obj && obj[k] !== undefined) ? obj[k] : undefined, fallbackDict);
        }

        if (value === undefined) {
            console.warn(`Translation key not found: ${key}`);
            return key;
        }

        if (typeof value !== 'string') {
            return value;
        }
        
        let processedText = value.replace(/\{(\w+),\s*plural,\s*(.*)\}/g, (match, varName, rulesStr) => {
            if (!variables.hasOwnProperty(varName)) return match;
            const count = variables[varName];
            const rules = {};
            const ruleRegex = /(\w+)\s*\{((?:[^{}]|{[^{}]*})*)\}/g;
            let ruleMatch;
            while ((ruleMatch = ruleRegex.exec(rulesStr)) !== null) {
                rules[ruleMatch[1]] = ruleMatch[2];
            }
            let resultText;
            if (count === 1 && rules.one) resultText = rules.one;
            else if (rules.other) resultText = rules.other;
            else return match;
            return resultText;
        });

        for (const placeholder in variables) {
            const regex = new RegExp(`\\{${placeholder}\\}`, 'g');
            processedText = processedText.replace(regex, variables[placeholder]);
        }
        
        return processedText;
    };

    return { t };
};
